/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import org.netlib.blas.BLAS;
import r.Utils;
import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.internal.DoubleImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;

public abstract class MatrixOperation
extends BaseR {
    @RNode.Child
    RNode left;
    @RNode.Child
    RNode right;
    private static final boolean USE_PRIMITIVE_ACCESS = false;

    public MatrixOperation(ASTNode ast, RNode left, RNode right) {
        super(ast);
        this.left = this.adoptChild(left);
        this.right = this.adoptChild(right);
    }

    @Override
    public Object execute(Frame frame) {
        RAny l = (RAny)this.left.execute(frame);
        RAny r = (RAny)this.right.execute(frame);
        return this.execute(l, r);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.left == oldNode) {
            this.left = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.right == oldNode) {
            this.right = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public abstract Object execute(RAny var1, RAny var2);

    public static RDouble dotProduct(ASTNode ast, RDouble l, RDouble r) {
        int m = l.size();
        if (m != r.size()) {
            throw RError.getNonConformableArgs(ast);
        }
        double res = 0.0;
        for (int i = 0; i < m; ++i) {
            res += l.getDouble(i) * r.getDouble(i);
        }
        return RDouble.RDoubleFactory.getMatrixFor(new double[]{res}, 1, 1);
    }

    public static RDouble dotProduct(RDouble x) {
        int m = x.size();
        double res = 0.0;
        for (int i = 0; i < m; ++i) {
            double d = x.getDouble(i);
            res += d * d;
        }
        return RDouble.RDoubleFactory.getMatrixFor(new double[]{res}, 1, 1);
    }

    public static void checkNumeric(RAny l, RAny r, ASTNode ast) {
        MatrixOperation.checkNumeric(l, ast);
        MatrixOperation.checkNumeric(r, ast);
    }

    public static void checkNumeric(RAny x, ASTNode ast) {
        if (!(x instanceof RDouble || x instanceof RInt || x instanceof RLogical)) {
            throw RError.getNumericComplexMatrixVector(ast);
        }
    }

    public static class OuterProduct
    extends MatrixOperation {
        public OuterProduct(ASTNode ast, RNode left, RNode right) {
            super(ast, left, right);
        }

        @Override
        public Object execute(RAny l, RAny r) {
            if (!(l instanceof RDouble) && !(l instanceof RInt) && !(l instanceof RLogical) || !(r instanceof RDouble) && !(r instanceof RInt) && !(r instanceof RLogical)) {
                throw RError.getNumericComplexMatrixVector(this.ast);
            }
            RDouble ld = l.asDouble().materialize();
            RDouble rd = r.asDouble().materialize();
            int m = ld.size();
            int n = rd.size();
            double[] content = new double[m * n];
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < n; ++j) {
                    content[j * m + i] = ld.getDouble(i) * rd.getDouble(j);
                }
            }
            int[] ldims = ld.dimensions();
            int[] rdims = rd.dimensions();
            if (ldims == null && rdims == null) {
                return RDouble.RDoubleFactory.getFor(content, new int[]{m, n}, null);
            }
            Utils.nyi("unsupported case");
            return null;
        }
    }

    public static class MatrixProduct
    extends MatrixOperation {
        public MatrixProduct(ASTNode ast, RNode left, RNode right) {
            super(ast, left, right);
        }

        public static RDouble vectorTimesMatrix(ASTNode ast, RDouble vector, RDouble matrix) {
            int[] dim = matrix.dimensions();
            int m = dim[0];
            int n = dim[1];
            int s = vector.size();
            if (s == m) {
                double[] content = new double[n];
                for (int j = 0; j < n; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < m; ++k) {
                        d += vector.getDouble(k) * matrix.getDouble(j * m + k);
                    }
                    content[j] = d;
                }
                return RDouble.RDoubleFactory.getFor(content, new int[]{1, n}, null);
            }
            if (m == 1) {
                double[] content = new double[s * n];
                for (int i = 0; i < s; ++i) {
                    for (int j = 0; j < n; ++j) {
                        content[j * s + i] = vector.getDouble(i) * matrix.getDouble(j);
                    }
                }
                return RDouble.RDoubleFactory.getFor(content, new int[]{s, n}, null);
            }
            throw RError.getNonConformableArgs(ast);
        }

        public static RDouble matrixTimesVector(ASTNode ast, RDouble matrix, RDouble vector) {
            int[] dim = matrix.dimensions();
            int m = dim[0];
            int n = dim[1];
            int s = vector.size();
            if (s == n) {
                double[] content = new double[m];
                for (int i = 0; i < m; ++i) {
                    double d = 0.0;
                    for (int k = 0; k < n; ++k) {
                        d += matrix.getDouble(k * m + i) * vector.getDouble(k);
                    }
                    content[i] = d;
                }
                return RDouble.RDoubleFactory.getFor(content, new int[]{m, 1}, null);
            }
            if (n == 1) {
                double[] content = new double[m * s];
                for (int i = 0; i < m; ++i) {
                    for (int j = 0; j < s; ++j) {
                        content[j * m + i] = matrix.getDouble(i) * vector.getDouble(j);
                    }
                }
                return RDouble.RDoubleFactory.getFor(content, new int[]{m, s}, null);
            }
            throw RError.getNonConformableArgs(ast);
        }

        public static RDouble matrixTimesMatrix(ASTNode ast, RDouble a, RDouble b) {
            int[] dima = a.dimensions();
            int[] dimb = b.dimensions();
            int m = dima[0];
            int n = dima[1];
            if (n != dimb[0]) {
                throw RError.getNonConformableArgs(ast);
            }
            int p = dimb[1];
            double[] res = RDouble.RDoubleUtils.hasNAorNaN(a) || RDouble.RDoubleUtils.hasNAorNaN(b) || m == 0 || n == 0 || p == 0 ? MatrixProduct.matrixTimesMatrixGetters(a, b, m, n, p) : MatrixProduct.matrixTimesMatrixNative(((DoubleImpl)a.materialize()).getContent(), ((DoubleImpl)b.materialize()).getContent(), m, n, p);
            return RDouble.RDoubleFactory.getFor(res, new int[]{m, p}, null);
        }

        public static double[] matrixTimesMatrixGetters(RDouble a, RDouble b, int m, int n, int p) {
            double[] content = new double[m * p];
            for (int j = 0; j < p; ++j) {
                for (int i = 0; i < m; ++i) {
                    double d = 0.0;
                    for (int k = 0; k < n; ++k) {
                        d += a.getDouble(k * m + i) * b.getDouble(j * n + k);
                    }
                    content[j * m + i] = d;
                }
            }
            return content;
        }

        public static double[] matrixTimesMatrixPrimitive(double[] a, double[] b, int m, int n, int p) {
            double[] content = new double[m * p];
            for (int j = 0; j < p; ++j) {
                for (int i = 0; i < m; ++i) {
                    double d = 0.0;
                    for (int k = 0; k < n; ++k) {
                        d += a[k * m + i] * b[j * n + k];
                    }
                    content[j * m + i] = d;
                }
            }
            return content;
        }

        public static double[] matrixTimesMatrixNative(double[] a, double[] b, int m, int n, int p) {
            double[] res = new double[m * p];
            BLAS.getInstance().dgemm("N", "N", m, p, n, 1.0, a, m, b, n, 0.0, res, m);
            return res;
        }

        @Override
        public Object execute(RAny l, RAny r) {
            int nrdims;
            MatrixProduct.checkNumeric(l, r, this.ast);
            RDouble ld = l.asDouble().materialize();
            RDouble rd = r.asDouble().materialize();
            int[] ldims = ld.dimensions();
            int nldims = ldims == null ? 0 : ldims.length;
            int[] rdims = rd.dimensions();
            int n = nrdims = rdims == null ? 0 : rdims.length;
            if (nldims != 2) {
                if (nrdims != 2) {
                    return MatrixProduct.dotProduct(this.ast, ld, rd);
                }
                return MatrixProduct.vectorTimesMatrix(this.ast, ld, rd);
            }
            if (nrdims != 2) {
                return MatrixProduct.matrixTimesVector(this.ast, ld, rd);
            }
            return MatrixProduct.matrixTimesMatrix(this.ast, ld, rd);
        }
    }
}

