/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.data.RAny;
import r.data.RArray;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RRaw;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.View;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class Not
extends BaseR {
    @RNode.Child
    RNode lhs;

    Not(ASTNode ast, RNode lhs) {
        super(ast);
        this.lhs = this.adoptChild(lhs);
    }

    @Override
    public final Object execute(Frame frame) {
        RAny value = (RAny)this.lhs.execute(frame);
        return this.execute(value);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.lhs == oldNode) {
            this.lhs = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    abstract RAny execute(RAny var1);

    public static class Generic
    extends Not {
        public Generic(ASTNode ast, RNode lhs) {
            super(ast, lhs);
        }

        @Override
        RAny execute(RAny value) {
            if (value instanceof RLogical || value instanceof RDouble || value instanceof RInt) {
                final RLogical lvalue = value.asLogical();
                return new View.RLogicalProxy<RLogical>(lvalue){

                    @Override
                    public int getLogical(int i) {
                        int l = lvalue.getLogical(i);
                        if (l == 1) {
                            return 0;
                        }
                        if (l == 0) {
                            return 1;
                        }
                        return Integer.MIN_VALUE;
                    }

                    @Override
                    public RAny.Attributes attributes() {
                        return null;
                    }
                };
            }
            if (value instanceof RRaw) {
                final RRaw rvalue = (RRaw)value;
                return new View.RRawProxy<RRaw>(rvalue){

                    @Override
                    public byte getRaw(int i) {
                        byte v = rvalue.getRaw(i);
                        return ~v;
                    }

                    @Override
                    public RAny.Attributes attributes() {
                        return null;
                    }
                };
            }
            if (value instanceof RArray && ((RArray)value).size() == 0) {
                return RLogical.EMPTY;
            }
            throw RError.getInvalidArgType(this.ast);
        }
    }

    public static class RawScalar
    extends Not {
        public RawScalar(ASTNode ast, RNode lhs) {
            super(ast, lhs);
        }

        @Override
        RAny execute(RAny value) {
            try {
                if (!(value instanceof RRaw)) {
                    throw new SpecializationException((Object)null);
                }
                RRaw rvalue = (RRaw)value;
                if (rvalue.size() != 1 || rvalue.dimensions() != null || rvalue.names() != null || rvalue.attributes() != null) {
                    throw new SpecializationException((Object)null);
                }
                byte b = rvalue.getRaw(0);
                return RRaw.RRawFactory.getScalar(~b);
            }
            catch (SpecializationException e) {
                Generic gn = new Generic(this.ast, this.lhs);
                this.replace(gn, "install Generic from LogicalScalar");
                return gn.execute(value);
            }
        }
    }

    public static class LogicalScalar
    extends Not {
        public LogicalScalar(ASTNode ast, RNode lhs) {
            super(ast, lhs);
        }

        @Override
        RAny execute(RAny value) {
            try {
                if (value instanceof ScalarLogicalImpl) {
                    switch (((ScalarLogicalImpl)value).getLogical()) {
                        case 1: {
                            return RLogical.BOXED_FALSE;
                        }
                        case 0: {
                            return RLogical.BOXED_TRUE;
                        }
                    }
                    return RLogical.BOXED_NA;
                }
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                RawScalar n = new RawScalar(this.ast, this.lhs);
                this.replace(n, "install RawScalar from LogicalScalar");
                return n.execute(value);
            }
        }
    }
}

