/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import r.RValueConversion;
import r.Utils;
import r.data.RAny;
import r.data.RNull;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.tools.PrettyPrinter;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class RNode {
    public static final boolean CLEAR_PARENT_POINTERS = true;
    public static final boolean CLEAR_CHILD_POINTERS = true;
    public static final boolean CHECKED_REPLACE_CHILD = true;
    public static final boolean CHECKED_REPLACE = true;
    public static final boolean DEBUG_REWRITING = false;
    protected RNode parent;
    protected RNode replacedByNode;
    private static HashSet<Class> suggestedForClass = new HashSet();
    private static HashMap<String, String> knownConstructors = new HashMap();

    public RNode() {
        assert (Utils.check(RNode.checkReplaceChild(this.getClass())));
    }

    public ASTNode getAST() {
        return this.getParent().getAST();
    }

    public RNode getParent() {
        return this.parent;
    }

    public RNode getNewNode() {
        return this.replacedByNode;
    }

    public boolean inTree() {
        return this.parent != null;
    }

    public abstract Object execute(Frame var1);

    public int executeScalarLogical(Frame frame) throws SpecializationException {
        return RValueConversion.expectScalarLogical((RAny)this.execute(frame));
    }

    public int executeScalarInteger(Frame frame) throws SpecializationException {
        return RValueConversion.expectScalarInteger((RAny)this.execute(frame));
    }

    public int executeScalarNonNALogical(Frame frame) throws SpecializationException {
        return RValueConversion.expectScalarNonNALogical((RAny)this.execute(frame));
    }

    public Object executeVoid(Frame frame) {
        this.execute(frame);
        return RNull.getNull();
    }

    public <T extends RNode> void pushBack(T childNode, Object value) {
        new PushbackNode(childNode.getAST(), childNode, value);
    }

    public <T extends RNode> Object replace(T childNode, Object childValue, RNode newNode, Frame frame) {
        this.pushBack(childNode, childValue);
        return this.replace(newNode).execute(frame);
    }

    private static void unlinkChildNode(RNode childNode) {
        RNode parentNode = childNode.getParent();
        if (parentNode != null) {
            parentNode.replaceChild(childNode, null);
            childNode.parent = null;
        }
    }

    private static void unlinkArrayElementChildNode(RNode childNode) {
        RNode parentNode = childNode.getParent();
        if (parentNode != null) {
            childNode.parent = null;
        }
    }

    public final <N extends RNode> N replace(N newNode, String msg) {
        assert (Utils.check(newNode != this, "replacing a node by itself.. why?"));
        this.replacedByNode = newNode;
        RNode.unlinkChildNode(newNode);
        RNode oldParent = this.getParent();
        if (oldParent == null) {
            return newNode;
        }
        newNode.replacedByNode = null;
        N res = oldParent.replaceChild(this, newNode);
        this.parent = null;
        assert (Utils.check(newNode.getParent() == oldParent));
        return res;
    }

    public final <N extends RNode> N insert(N childNode, String msg) {
        assert (Utils.check(childNode != this));
        RNode parentNode = childNode.getParent();
        assert (Utils.check(parentNode != this));
        assert (Utils.check(parentNode != childNode));
        assert (Utils.check(parentNode != null));
        assert (Utils.check(childNode != null));
        parentNode.replaceChild(childNode, this);
        this.parent = parentNode;
        childNode.parent = this;
        return childNode;
    }

    public final <N extends RNode> N replace(N newNode) {
        return this.replace(newNode, "");
    }

    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        this.suggestReplaceChild(oldNode, newNode);
        assert (Utils.check(false, "missing/incomplete replaceChild method in " + this.getClass()));
        return null;
    }

    public final <N extends RNode> N adoptChild(N childNode) {
        if (childNode != null) {
            RNode.unlinkChildNode(childNode);
            childNode.parent = this;
            assert (Utils.check(this.replacedByNode == null));
            childNode.replacedByNode = null;
        }
        return childNode;
    }

    public final <N extends RNode> N[] adoptChildren(N[] childNodes) {
        boolean detectedArraySharing = false;
        for (int i = 0; i < childNodes.length; ++i) {
            N n = childNodes[i];
            if (n == null) continue;
            RNode pn = ((RNode)n).getParent();
            if (pn != null && !detectedArraySharing) {
                pn.replaceChild((RNode)n, null);
                if (childNodes[i] == null) {
                    childNodes[i] = n;
                    detectedArraySharing = true;
                }
            }
            ((RNode)n).parent = this;
        }
        return childNodes;
    }

    public final <N extends RNode> N adoptInternal(N childNode) {
        if (childNode != null) {
            assert (Utils.check(childNode.parent == null));
            childNode.replacedByNode = null;
            childNode.parent = this;
        }
        return childNode;
    }

    private void suggestReplaceChild(RNode oldNode, RNode newNode) {
        this.suggestReplaceChild(this.getClass(), oldNode, newNode);
    }

    private void suggestReplaceChild(Class nodeClass, RNode oldNode, RNode newNode) {
        Field[] fields = nodeClass.getDeclaredFields();
        int nchildren = 0;
        boolean sawOldNode = false;
        for (Field f : fields) {
            Class<?> componentClass;
            if (f.isSynthetic()) continue;
            Class<?> fieldClass = f.getType();
            if (RNode.class.isAssignableFrom(fieldClass)) {
                ++nchildren;
                try {
                    f.setAccessible(true);
                    Object n = f.get(this);
                    if (n != oldNode) continue;
                    assert (!sawOldNode);
                    sawOldNode = true;
                    continue;
                }
                catch (IllegalAccessException e) {
                    System.err.println("can't read a node field" + e);
                    assert (Utils.check(false, "can't read a node field"));
                    continue;
                }
            }
            if (!fieldClass.isArray() || !RNode.class.isAssignableFrom(componentClass = fieldClass.getComponentType())) continue;
            try {
                f.setAccessible(true);
                Object nodesArray = f.get(this);
                int length = Array.getLength(nodesArray);
                for (int i = 0; i < length; ++i) {
                    Object n = Array.get(nodesArray, i);
                    ++nchildren;
                    if (n != oldNode) continue;
                    assert (!sawOldNode);
                    sawOldNode = true;
                }
            }
            catch (IllegalAccessException e) {
                System.err.println("can't read a node field (array field)" + e);
                assert (Utils.check(false, "can't read a node field (array field)"));
            }
        }
        if (nchildren > 0) {
            RNode.suggestReplaceChildForClass(nodeClass);
        }
        if (!sawOldNode) {
            Class nodeSuperClass = nodeClass.getSuperclass();
            if (nodeSuperClass != RNode.class) {
                this.suggestReplaceChild(nodeSuperClass, oldNode, newNode);
            } else {
                System.err.println("Cannot suggest a missing replaceChild - did not find the node to replace, but there is no super-class - something is wrong");
                Thread.dumpStack();
            }
        }
    }

    private static boolean suggestReplaceChildForClass(Class nodeClass) {
        if (!suggestedForClass.contains(nodeClass)) {
            suggestedForClass.add(nodeClass);
            Field[] fields = nodeClass.getDeclaredFields();
            System.err.println("Suggested missing replaceChild for " + nodeClass);
            System.err.println();
            System.err.println("@Override");
            System.err.println("protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {");
            System.err.println("\tassert oldNode != null;");
            for (Field f : fields) {
                Class<?> componentClass;
                if (f.isSynthetic()) continue;
                Class<?> fieldClass = f.getType();
                if (RNode.class.isAssignableFrom(fieldClass)) {
                    System.err.println("\tif (" + f.getName() + " == oldNode) {");
                    System.err.print("\t\t" + f.getName() + " = ");
                    if (fieldClass != RNode.class) {
                        System.err.print("(" + fieldClass.getCanonicalName() + ") ");
                    }
                    System.err.println("newNode;");
                    System.err.println("\t\treturn adoptInternal(newNode);");
                    System.err.println("\t}");
                }
                if (!fieldClass.isArray() || !RNode.class.isAssignableFrom(componentClass = fieldClass.getComponentType())) continue;
                System.err.println("\tif (" + f.getName() + " != null) {");
                System.err.println("\t\tfor(int i = 0; i < " + f.getName() + ".length; i++) {");
                System.err.println("\t\t\tif (" + f.getName() + "[i] == oldNode) {");
                System.err.print("\t\t\t\t" + f.getName() + "[i] = ");
                if (componentClass != RNode.class) {
                    System.err.print("(" + componentClass.getCanonicalName() + ") ");
                }
                System.err.println("newNode;");
                System.err.println("\t\t\t\treturn adoptInternal(newNode);");
                System.err.println("\t\t\t}");
                System.err.println("\t\t}");
                System.err.println("\t}");
            }
            System.err.println("\treturn super.replaceChild(oldNode, newNode);");
            System.err.println("}");
            return true;
        }
        return false;
    }

    public static boolean checkReplaceChild(Class nodeClass) {
        Field[] fields = nodeClass.getDeclaredFields();
        ArrayList<Field> childNodes = new ArrayList<Field>();
        for (Field f : fields) {
            Class<?> componentClass;
            if (f.isSynthetic()) continue;
            Class<?> fieldClass = f.getType();
            if (RNode.class.isAssignableFrom(fieldClass)) {
                childNodes.add(f);
                continue;
            }
            if (!fieldClass.isArray() || !RNode.class.isAssignableFrom(componentClass = fieldClass.getComponentType())) continue;
            childNodes.add(f);
        }
        if (childNodes.size() > 0) {
            try {
                nodeClass.getDeclaredMethod("replaceChild", RNode.class, RNode.class);
                return true;
            }
            catch (NoSuchMethodException e) {
                if (RNode.suggestReplaceChildForClass(nodeClass)) {
                    System.err.println("ERROR: Missing replaceChild in class (suggestion above)");
                    System.err.print("Child nodes may be in fields:");
                    for (Field f : childNodes) {
                        System.err.print(" " + f.getName());
                    }
                    System.err.println();
                }
                return false;
            }
        }
        Class superClass = nodeClass.getSuperclass();
        if (superClass != RNode.class) {
            return RNode.checkReplaceChild(superClass);
        }
        return true;
    }

    private RNode currentRoot() {
        assert (Utils.check(this.getNewNode() == null));
        RNode n = this;
        while (n.getParent() != null) {
            n = n.getParent();
        }
        return n;
    }

    private void printCurrentTree() {
        RNode root = this.currentRoot();
        RNode.printTree(root, 0, System.err);
    }

    private static void printIndent(int indent, PrintStream ps) {
        for (int i = 0; i < indent; ++i) {
            ps.print(" ");
        }
    }

    private static Field[] getAllFields(Class cls) {
        ArrayList<Field> res = new ArrayList<Field>();
        for (Class c = cls; c != RNode.class; c = c.getSuperclass()) {
            assert (Utils.check(c != null));
            res.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return res.toArray(new Field[res.size()]);
    }

    private static void printTree(RNode root, int indent, PrintStream ps) {
        Field[] fields;
        if (root == null) {
            ps.println(".");
            return;
        }
        Class<?> nodeClass = root.getClass();
        String className = nodeClass.getName();
        ps.print("->" + className);
        String info = knownConstructors.get(className);
        if (info != null) {
            ps.print(" (" + info + ") ");
        }
        ps.println(" [" + PrettyPrinter.prettyPrint(root.getAST()) + "]");
        for (Field f : fields = RNode.getAllFields(nodeClass)) {
            Class<?> componentClass;
            Class<?> fieldClass;
            block10: {
                if (f.isSynthetic()) continue;
                fieldClass = f.getType();
                if (RNode.class.isAssignableFrom(fieldClass)) {
                    RNode.printIndent(indent + 2, ps);
                    ps.print(f.getName());
                    try {
                        f.setAccessible(true);
                        RNode child = (RNode)f.get(root);
                        RNode.printTree(child, indent + 4, ps);
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled || Utils.check(false, "can't read a node field " + e)) break block10;
                        throw new AssertionError();
                    }
                }
            }
            if (!fieldClass.isArray() || !RNode.class.isAssignableFrom(componentClass = fieldClass.getComponentType())) continue;
            try {
                f.setAccessible(true);
                Object nodesArray = f.get(root);
                int length = Array.getLength(nodesArray);
                for (int i = 0; i < length; ++i) {
                    RNode child = (RNode)Array.get(nodesArray, i);
                    RNode.printIndent(indent + 2, ps);
                    ps.print(f.getName() + "[" + i + "]");
                    RNode.printTree(child, indent + 4, ps);
                }
            }
            catch (IllegalAccessException e) {
                assert (Utils.check(false, "can't read a node field (array field) " + e));
            }
        }
    }

    private static void registerConstructors() {
        StackTraceElement[] traces;
        for (StackTraceElement e : traces = Thread.currentThread().getStackTrace()) {
            String className;
            if (!"<init>".equals(e.getMethodName()) || knownConstructors.containsKey(className = e.getClassName())) continue;
            String info = e.getFileName() + ":" + e.getLineNumber();
            knownConstructors.put(className, info);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Child {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Children {
    }

    public static class PushbackNode
    extends BaseR {
        @Child
        RNode realChildNode;
        final Object nextValue;

        public PushbackNode(ASTNode ast, RNode realChildNode, Object nextValue) {
            super(ast);
            realChildNode.replace(this);
            this.realChildNode = this.adoptChild(realChildNode);
            this.nextValue = nextValue;
        }

        @Override
        public Object execute(Frame frame) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                this.replace(this.realChildNode);
                return this.nextValue;
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.realChildNode == oldNode) {
                this.realChildNode = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }
}

