/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Convert;
import r.Utils;
import r.builtins.Builtin;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RArray;
import r.data.RList;
import r.data.RSymbol;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.nodes.exec.Selector;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class ReadArray
extends BaseR {
    final boolean subset;
    @RNode.Child
    RNode lhs;
    @RNode.Child
    Selector.OptionNode dropExpr;
    @RNode.Child
    Selector.OptionNode exactExpr;

    public ReadArray(ASTNode ast, boolean subset, RNode lhs, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
        super(ast);
        this.subset = subset;
        this.lhs = this.adoptChild(lhs);
        this.dropExpr = this.adoptChild(dropExpr);
        this.exactExpr = this.adoptChild(exactExpr);
    }

    public ReadArray(ReadArray other) {
        this(other.ast, other.subset, other.lhs, other.dropExpr, other.exactExpr);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.lhs == oldNode) {
            this.lhs = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.dropExpr == oldNode) {
            this.dropExpr = (Selector.OptionNode)newNode;
            return this.adoptInternal(newNode);
        }
        if (this.exactExpr == oldNode) {
            this.exactExpr = (Selector.OptionNode)newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static class MatrixSequenceSubset
    extends ReadArray {
        @RNode.Child
        RNode rowFromExpr;
        @RNode.Child
        RNode rowToExpr;
        @RNode.Child
        RNode colFromExpr;
        @RNode.Child
        RNode colToExpr;

        public MatrixSequenceSubset(ASTNode ast, RNode lhs, RNode rowFromExpr, RNode rowToExpr, RNode colFromExpr, RNode colToExpr, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, true, lhs, dropExpr, exactExpr);
            this.rowFromExpr = this.adoptChild(rowFromExpr);
            this.rowToExpr = this.adoptChild(rowToExpr);
            this.colFromExpr = this.adoptChild(colFromExpr);
            this.colToExpr = this.adoptChild(colToExpr);
        }

        private static int extractLimit(Object value) throws SpecializationException {
            int i;
            if (value instanceof ScalarDoubleImpl) {
                double d = ((ScalarDoubleImpl)value).getDouble();
                if (d > 0.0 && d <= 2.147483647E9) {
                    return (int)d - 1;
                }
            } else if (value instanceof ScalarIntImpl && (i = ((ScalarIntImpl)value).getInt()) > 0) {
                return i - 1;
            }
            throw new SpecializationException((Object)null);
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsVal = (RAny)this.lhs.execute(frame);
            Object rowFromVal = this.rowFromExpr.execute(frame);
            Object rowToVal = this.rowToExpr.execute(frame);
            Object colFromVal = this.colFromExpr.execute(frame);
            Object colToVal = this.colToExpr.execute(frame);
            boolean dropVal = this.dropExpr.executeLogical(frame) != 0;
            int exactVal = this.exactExpr.executeLogical(frame);
            if (!(lhsVal instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, lhsVal.typeOf());
            }
            RArray array = (RArray)lhsVal;
            try {
                int colSize;
                int colStep;
                int rowSize;
                int rowStep;
                int rowFrom = MatrixSequenceSubset.extractLimit(rowFromVal);
                int rowTo = MatrixSequenceSubset.extractLimit(rowToVal);
                int colFrom = MatrixSequenceSubset.extractLimit(colFromVal);
                int colTo = MatrixSequenceSubset.extractLimit(colToVal);
                int[] dim = array.dimensions();
                if (dim == null || dim.length != 2) {
                    throw RError.getIncorrectDimensions(this.getAST());
                }
                int m = dim[0];
                int n = dim[1];
                if (rowFrom <= rowTo) {
                    rowStep = 1;
                    if (rowTo > m) {
                        throw new SpecializationException((Object)null);
                    }
                    rowSize = rowTo - rowFrom + 1;
                } else {
                    rowStep = -1;
                    if (rowFrom > m) {
                        throw new SpecializationException((Object)null);
                    }
                    rowSize = rowFrom - rowTo + 1;
                }
                if (colFrom <= colTo) {
                    colStep = 1;
                    if (colTo > n) {
                        throw new SpecializationException((Object)null);
                    }
                    colSize = colTo - colFrom + 1;
                } else {
                    colStep = -1;
                    if (colFrom > n) {
                        throw new SpecializationException((Object)null);
                    }
                    colSize = colFrom - colTo + 1;
                }
                int[] ndim = !dropVal || rowSize > 1 && colSize > 1 ? new int[]{rowSize, colSize} : null;
                int size = rowSize * colSize;
                RArray res = Utils.createArray(array, size, ndim, null, null);
                if (colStep == 1 && rowStep == 1) {
                    int j = colFrom * m + rowFrom;
                    int jmax = j + rowSize;
                    int jadvance = m - rowSize;
                    for (int i = 0; i < size; ++i) {
                        res.set(i, array.getRef(j++));
                        if (j != jmax) continue;
                        j += jadvance;
                        jmax += m;
                    }
                } else {
                    int i = 0;
                    for (int col = colFrom; col != colTo + colStep; col += colStep) {
                        for (int row = rowFrom; row != rowTo + rowStep; row += rowStep) {
                            res.set(i++, array.getRef(col * m + row));
                        }
                    }
                }
                return res;
            }
            catch (SpecializationException e) {
                ASTNode rowAST = this.rowFromExpr.getAST().getParent();
                Builtin rowColon = (Builtin)Primitives.getCallFactory(RSymbol.getSymbol(":"), null).create(rowAST, this.rowFromExpr, this.rowToExpr);
                Selector.SelectorNode selIExpr = Selector.createSelectorNode(rowAST, true, rowColon);
                ASTNode colAST = this.colFromExpr.getAST().getParent();
                Builtin colColon = (Builtin)Primitives.getCallFactory(RSymbol.getSymbol(":"), null).create(colAST, this.colFromExpr, this.colToExpr);
                Selector.SelectorNode selJExpr = Selector.createSelectorNode(this.ast, true, colColon);
                MatrixRead nn = new MatrixRead(this.ast, true, this.lhs, selIExpr, selJExpr, this.dropExpr, this.exactExpr);
                this.replace(nn, "install MatrixRead from MatrixSequenceSubset");
                Selector selI = selIExpr.executeSelector(rowColon.doBuiltIn(frame, new RAny[]{(RAny)rowFromVal, (RAny)rowToVal}));
                Selector selJ = selJExpr.executeSelector(colColon.doBuiltIn(frame, new RAny[]{(RAny)colFromVal, (RAny)colToVal}));
                return nn.executeLoop(array, selI, selJ, dropVal, exactVal);
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.rowFromExpr == oldNode) {
                this.rowFromExpr = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.rowToExpr == oldNode) {
                this.rowToExpr = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.colFromExpr == oldNode) {
                this.colFromExpr = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.colToExpr == oldNode) {
                this.colToExpr = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static class MatrixRowSubset
    extends MatrixRead {
        @RNode.Child
        RNode rowExpr;

        public MatrixRowSubset(ASTNode ast, RNode lhs, RNode rowExpr, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, true, lhs, null, null, dropExpr, exactExpr);
            this.rowExpr = this.adoptChild(rowExpr);
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsVal = (RAny)this.lhs.execute(frame);
            RAny rowVal = (RAny)this.rowExpr.execute(frame);
            boolean dropVal = this.dropExpr.executeLogical(frame) != 0;
            int exactVal = this.exactExpr.executeLogical(frame);
            if (!(lhsVal instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, lhsVal.typeOf());
            }
            RArray array = (RArray)lhsVal;
            int[] dim = array.dimensions();
            if (dim == null || dim.length != 2) {
                throw RError.getIncorrectDimensions(this.getAST());
            }
            int m = dim[0];
            int n = dim[1];
            try {
                int row;
                if (rowVal instanceof ScalarIntImpl) {
                    row = ((ScalarIntImpl)rowVal).getInt();
                } else if (rowVal instanceof ScalarDoubleImpl) {
                    row = Convert.double2int(((ScalarDoubleImpl)rowVal).getDouble());
                } else {
                    throw new SpecializationException((Object)null);
                }
                if (row > n || row <= 0) {
                    throw new SpecializationException((Object)null);
                }
                int[] ndim = dropVal ? null : new int[]{1, n};
                RArray res = Utils.createArray(array, n, ndim, null, null);
                int offset = row - 1;
                for (int i = 0; i < n; ++i) {
                    res.set(i, array.getRef(offset));
                    offset += m;
                }
                return res;
            }
            catch (SpecializationException e) {
                Selector.SelectorNode selIExpr = Selector.createSelectorNode(this.ast, true, this.rowExpr);
                Selector.SelectorNode selJExpr = Selector.createSelectorNode(this.ast, true, null);
                MatrixRead nn = new MatrixRead(this.ast, true, this.lhs, selIExpr, selJExpr, this.dropExpr, this.exactExpr);
                this.replace(nn, "install MatrixRead from MatrixRowSubset");
                Selector selI = selIExpr.executeSelector(rowVal);
                Selector selJ = selJExpr.executeSelector(frame);
                return nn.executeLoop(array, selI, selJ, dropVal, exactVal);
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.rowExpr == oldNode) {
                this.rowExpr = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static class MatrixColumnSubset
    extends MatrixRead {
        @RNode.Child
        RNode columnExpr;

        public MatrixColumnSubset(ASTNode ast, RNode lhs, RNode columnExpr, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, true, lhs, null, null, dropExpr, exactExpr);
            this.columnExpr = this.adoptChild(columnExpr);
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsVal = (RAny)this.lhs.execute(frame);
            RAny colVal = (RAny)this.columnExpr.execute(frame);
            boolean dropVal = this.dropExpr.executeLogical(frame) != 0;
            int exactVal = this.exactExpr.executeLogical(frame);
            if (!(lhsVal instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, lhsVal.typeOf());
            }
            RArray array = (RArray)lhsVal;
            int[] dim = array.dimensions();
            if (dim == null || dim.length != 2) {
                throw RError.getIncorrectDimensions(this.getAST());
            }
            int m = dim[0];
            int n = dim[1];
            try {
                int col;
                if (colVal instanceof ScalarIntImpl) {
                    col = ((ScalarIntImpl)colVal).getInt();
                } else if (colVal instanceof ScalarDoubleImpl) {
                    col = Convert.double2int(((ScalarDoubleImpl)colVal).getDouble());
                } else {
                    throw new SpecializationException((Object)null);
                }
                if (col > n || col <= 0) {
                    throw new SpecializationException((Object)null);
                }
                int[] ndim = dropVal ? null : new int[]{m, 1};
                RArray res = Utils.createArray(array, m, ndim, null, null);
                int offset = (col - 1) * m;
                for (int i = 0; i < m; ++i) {
                    res.set(i, array.getRef(offset + i));
                }
                return res;
            }
            catch (SpecializationException e) {
                Selector.SelectorNode selIExpr = Selector.createSelectorNode(this.ast, true, null);
                Selector.SelectorNode selJExpr = Selector.createSelectorNode(this.ast, true, this.columnExpr);
                MatrixRead mr = new MatrixRead(this.ast, true, this.lhs, selIExpr, selJExpr, this.dropExpr, this.exactExpr);
                this.replace(mr, "install MatrixRead from MatrixColumnSubset");
                Selector selI = selIExpr.executeSelector(frame);
                Selector selJ = selJExpr.executeSelector(colVal);
                return mr.executeLoop(array, selI, selJ, dropVal, exactVal);
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.columnExpr == oldNode) {
                this.columnExpr = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static class MatrixSubscript
    extends MatrixRead {
        public MatrixSubscript(ASTNode ast, RNode lhs, Selector.SelectorNode selectorIExpr, Selector.SelectorNode selectorJExpr, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, false, lhs, selectorIExpr, selectorJExpr, dropExpr, exactExpr);
        }

        @Override
        public Object execute(RArray base, Selector selectorI, Selector selectorJ, boolean drop, int exact) throws SpecializationException {
            int[] ndim = base.dimensions();
            int m = ndim[0];
            int n = ndim[1];
            selectorI.start(m, this.ast);
            selectorJ.start(n, this.ast);
            int i = selectorI.nextIndex(this.ast);
            int j = selectorJ.nextIndex(this.ast);
            assert (Utils.check(i != Integer.MIN_VALUE && j != Integer.MIN_VALUE));
            int offset = j * m + i;
            if (!(base instanceof RList)) {
                return base.boxedGet(offset);
            }
            return ((RList)base).getRAny(offset);
        }
    }

    public static class MatrixRead
    extends ReadArray {
        @RNode.Child
        Selector.SelectorNode selectorIExpr;
        @RNode.Child
        Selector.SelectorNode selectorJExpr;

        public MatrixRead(ASTNode ast, boolean subset, RNode lhs, Selector.SelectorNode selectorIExpr, Selector.SelectorNode selectorJExpr, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, subset, lhs, dropExpr, exactExpr);
            this.selectorIExpr = this.adoptChild(selectorIExpr);
            this.selectorJExpr = this.adoptChild(selectorJExpr);
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsVal = (RAny)this.lhs.execute(frame);
            Selector selectorI = this.selectorIExpr.executeSelector(frame);
            Selector selectorJ = this.selectorJExpr.executeSelector(frame);
            boolean dropVal = this.dropExpr.executeLogical(frame) != 0;
            int exactVal = this.exactExpr.executeLogical(frame);
            if (!(lhsVal instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, lhsVal.typeOf());
            }
            RArray array = (RArray)lhsVal;
            int[] dim = array.dimensions();
            if (dim == null || dim.length != 2) {
                throw RError.getIncorrectDimensions(this.getAST());
            }
            return this.executeLoop(array, selectorI, selectorJ, dropVal, exactVal);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.selectorIExpr == oldNode) {
                this.selectorIExpr = (Selector.SelectorNode)newNode;
                return this.adoptInternal(newNode);
            }
            if (this.selectorJExpr == oldNode) {
                this.selectorJExpr = (Selector.SelectorNode)newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public Object executeLoop(RArray array, Selector selectorI, Selector selectorJ, boolean dropVal, int exactVal) {
            Selector selI = selectorI;
            Selector selJ = selectorJ;
            while (true) {
                try {
                    return this.execute(array, selI, selJ, dropVal, exactVal);
                }
                catch (SpecializationException e) {
                    RAny index;
                    Selector failedSelector = (Selector)e.getResult();
                    if (failedSelector == selI) {
                        index = selI.getIndex();
                        this.selectorIExpr.replace(Selector.createSelectorNode(this.ast, this.subset, index, this.selectorIExpr.child, false, selectorI.getTransition()));
                        selI = this.selectorIExpr.executeSelector(index);
                        continue;
                    }
                    index = selJ.getIndex();
                    this.selectorJExpr.replace(Selector.createSelectorNode(this.ast, this.subset, index, this.selectorJExpr.child, false, selectorJ.getTransition()));
                    selJ = this.selectorJExpr.executeSelector(index);
                    continue;
                }
                break;
            }
        }

        public Object execute(RArray source, Selector selectorI, Selector selectorJ, boolean drop, int exact) throws SpecializationException {
            assert (Utils.check(this.subset));
            Object ndim = source.dimensions();
            int m = ndim[0];
            int n = ndim[1];
            selectorI.start(m, this.ast);
            selectorJ.start(n, this.ast);
            int nm = selectorI.size();
            int nn = selectorJ.size();
            boolean mayHaveNA = selectorI.mayHaveNA() || selectorJ.mayHaveNA();
            int nsize = nm * nn;
            ndim = nm != 1 && nn != 1 || !drop ? new int[]{nm, nn} : null;
            RArray res = Utils.createArray(source, nsize, ndim, null, null);
            if (!mayHaveNA) {
                int resoffset = 0;
                for (int nj = 0; nj < nn; ++nj) {
                    int j = selectorJ.nextIndex(this.ast);
                    int srcoffset = j * m;
                    for (int ni = 0; ni < nm; ++ni) {
                        int i = selectorI.nextIndex(this.ast);
                        Object value = source.getRef(srcoffset + i);
                        res.set(resoffset++, value);
                    }
                    selectorI.restart();
                }
            } else {
                for (int nj = 0; nj < nn; ++nj) {
                    int ni;
                    int j = selectorJ.nextIndex(this.ast);
                    if (j != Integer.MIN_VALUE) {
                        selectorI.restart();
                        for (ni = 0; ni < nm; ++ni) {
                            int offset = nj * nm + ni;
                            int i = selectorI.nextIndex(this.ast);
                            if (i != Integer.MIN_VALUE) {
                                Object value = source.getRef(j * m + i);
                                res.set(offset, value);
                                continue;
                            }
                            Utils.setNA(res, offset);
                        }
                        continue;
                    }
                    for (ni = 0; ni < nm; ++ni) {
                        Utils.setNA(res, nj * nm + ni);
                    }
                }
            }
            return res;
        }
    }

    public static class ArrayColumnSubset
    extends MatrixRead {
        @RNode.Child
        RNode columnExpr;
        final int nSelectors;

        public ArrayColumnSubset(ASTNode ast, RNode lhs, int nSelectors, RNode columnExpr, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, true, lhs, null, null, dropExpr, exactExpr);
            this.columnExpr = this.adoptChild(columnExpr);
            this.nSelectors = nSelectors;
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsVal = (RAny)this.lhs.execute(frame);
            RAny colVal = (RAny)this.columnExpr.execute(frame);
            boolean dropVal = this.dropExpr.executeLogical(frame) != 0;
            int exactVal = this.exactExpr.executeLogical(frame);
            if (!(lhsVal instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, lhsVal.typeOf());
            }
            RArray array = (RArray)lhsVal;
            int[] dim = array.dimensions();
            if (dim == null || dim.length != this.nSelectors) {
                throw RError.getIncorrectDimensions(this.getAST());
            }
            int n = dim[this.nSelectors - 1];
            try {
                int[] ndim;
                int i;
                int m;
                int col;
                if (colVal instanceof ScalarIntImpl) {
                    col = ((ScalarIntImpl)colVal).getInt();
                } else if (colVal instanceof ScalarDoubleImpl) {
                    col = Convert.double2int(((ScalarDoubleImpl)colVal).getDouble());
                } else {
                    throw new SpecializationException((Object)null);
                }
                if (col > n || col <= 0) {
                    throw new SpecializationException((Object)null);
                }
                if (dropVal) {
                    boolean hasNonTrivialDimension = false;
                    boolean resultIsVector = true;
                    m = 1;
                    for (i = 0; i < this.nSelectors - 1; ++i) {
                        int d = dim[i];
                        if (d != 1) {
                            if (hasNonTrivialDimension) {
                                resultIsVector = false;
                            } else {
                                hasNonTrivialDimension = true;
                            }
                        }
                        m *= d;
                    }
                    if (resultIsVector) {
                        ndim = null;
                    } else {
                        ndim = new int[this.nSelectors - 1];
                        System.arraycopy(dim, 0, ndim, 0, ndim.length);
                    }
                } else {
                    ndim = new int[this.nSelectors];
                    ndim[this.nSelectors - 1] = 1;
                    m = 1;
                    for (int i2 = 0; i2 < ndim.length - 1; ++i2) {
                        int d;
                        ndim[i2] = d = dim[i2];
                        m *= d;
                    }
                }
                RArray res = Utils.createArray(array, m, ndim, null, null);
                int offset = (col - 1) * m;
                for (i = 0; i < m; ++i) {
                    res.set(i, array.getRef(offset + i));
                }
                return res;
            }
            catch (SpecializationException e) {
                Selector.SelectorNode[] selectorExprs = new Selector.SelectorNode[this.nSelectors];
                for (int i = 0; i < this.nSelectors - 1; ++i) {
                    selectorExprs[i] = Selector.createSelectorNode(this.ast, true, null);
                }
                selectorExprs[this.nSelectors - 1] = Selector.createSelectorNode(this.ast, true, this.columnExpr);
                GenericRead gr = new GenericRead(this.ast, true, this.lhs, selectorExprs, this.dropExpr, this.exactExpr);
                this.replace(gr, "install GenericRead from ArrayColumnSubset");
                for (int i = 0; i < this.nSelectors - 1; ++i) {
                    gr.selectorVals[i] = selectorExprs[i].executeSelector(frame);
                }
                gr.selectorVals[this.nSelectors - 1] = selectorExprs[this.nSelectors - 1].executeSelector(colVal);
                return gr.executeLoop(array, dropVal, exactVal);
            }
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.columnExpr == oldNode) {
                this.columnExpr = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }

    public static class GenericRead
    extends ReadArray {
        final int[] offsets;
        final int[] selSizes;
        @RNode.Children
        final Selector.SelectorNode[] selectorExprs;
        final Selector[] selectorVals;

        public GenericRead(ASTNode ast, boolean subset, RNode lhs, Selector.SelectorNode[] selectorExprs, Selector.OptionNode dropExpr, Selector.OptionNode exactExpr) {
            super(ast, subset, lhs, dropExpr, exactExpr);
            this.selectorExprs = (Selector.SelectorNode[])this.adoptChildren(selectorExprs);
            this.offsets = new int[selectorExprs.length + 1];
            this.selSizes = new int[selectorExprs.length];
            this.selectorVals = new Selector[selectorExprs.length];
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsVal = (RAny)this.lhs.execute(frame);
            for (int i = 0; i < this.selectorVals.length; ++i) {
                this.selectorVals[i] = this.selectorExprs[i].executeSelector(frame);
            }
            boolean dropVal = this.dropExpr.executeLogical(frame) != 0;
            int exactVal = this.exactExpr.executeLogical(frame);
            if (!(lhsVal instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, lhsVal.typeOf());
            }
            RArray array = (RArray)lhsVal;
            int[] dim = array.dimensions();
            if (dim == null || dim.length != this.selectorExprs.length) {
                throw RError.getIncorrectDimensions(this.getAST());
            }
            return this.executeLoop(array, dropVal, exactVal);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.selectorExprs != null) {
                for (int i = 0; i < this.selectorExprs.length; ++i) {
                    if (this.selectorExprs[i] != oldNode) continue;
                    this.selectorExprs[i] = (Selector.SelectorNode)newNode;
                    return this.adoptInternal(newNode);
                }
            }
            return super.replaceChild(oldNode, newNode);
        }

        protected final Object executeLoop(RArray array, boolean dropVal, int exactVal) {
            block2: while (true) {
                try {
                    return this.execute(array, dropVal, exactVal);
                }
                catch (SpecializationException e) {
                    Selector failedSelector = (Selector)e.getResult();
                    int i = 0;
                    while (true) {
                        if (i >= this.selectorVals.length) continue block2;
                        if (this.selectorVals[i] == failedSelector) {
                            RAny index = failedSelector.getIndex();
                            Selector.SelectorNode newSelector = Selector.createSelectorNode(this.ast, this.subset, index, this.selectorExprs[i], false, failedSelector.getTransition());
                            this.selectorExprs[i] = this.adoptChild(newSelector);
                            this.selectorVals[i] = newSelector.executeSelector(index);
                        }
                        ++i;
                    }
                }
                break;
            }
        }

        public Object execute(RArray source, boolean drop, int exact) throws SpecializationException {
            int[] sourceDim = source.dimensions();
            boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, sourceDim, this.selSizes, this.ast);
            int[] destDim = Selector.calculateDestinationDimensions(this.selSizes, !this.subset || drop);
            int destSize = Selector.calculateSizeFromSelectorSizes(this.selSizes);
            RArray dest = Utils.createArray(source, destSize, destDim, null, null);
            if (destSize == 0) {
                return dest;
            }
            int offset = 0;
            while (true) {
                int sourceOffset;
                if ((sourceOffset = this.offsets[0]) == Integer.MIN_VALUE) {
                    Utils.setNA(dest, offset);
                } else {
                    dest.set(offset, source.getRef(sourceOffset));
                }
                if (++offset >= destSize) break;
                if (!mayHaveNA) {
                    Selector.advanceNoNA(this.offsets, sourceDim, this.selectorVals, this.ast);
                    continue;
                }
                Selector.advance(this.offsets, sourceDim, this.selectorVals, this.ast);
            }
            return dest;
        }
    }
}

