/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RBuiltIn;
import r.data.RDots;
import r.data.RFunction;
import r.data.RPromise;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SmallFrame;
import r.runtime.SpecializationException;

public abstract class ReadVariable
extends BaseR {
    final RSymbol symbol;
    private static final boolean DEBUG_R = false;

    public ReadVariable(ASTNode orig, RSymbol sym) {
        super(orig);
        this.symbol = sym;
    }

    public static RAny readNonVariablePerhapsBuiltin(ASTNode ast, RSymbol symbol) {
        RBuiltIn builtIn = Primitives.getBuiltIn(symbol, null);
        if (builtIn != null) {
            return builtIn;
        }
        throw RError.getUnknownVariable(ast, symbol);
    }

    public static RNode getUninitialized(ASTNode orig, RSymbol sym) {
        int ddIndex = sym.dotDotValue();
        if (ddIndex != -1) {
            return new ReadDotDotVariable(orig, ddIndex - 1);
        }
        return new ReadVariable(orig, sym){

            @Override
            public final Object execute(Frame frame) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    String reason;
                    ReadVariable node;
                    if (frame == null) {
                        node = ReadVariable.getReadOnlyFromTopLevel(this.getAST(), this.symbol);
                        reason = "installReadOnlyFromTopLevelNode";
                    } else {
                        int slot = frame.findVariable(this.symbol);
                        if (slot != -1) {
                            node = frame instanceof SmallFrame ? ReadVariable.getSimpleReadLocalSmallFrame(this.getAST(), this.symbol, slot, (SmallFrame)frame) : ReadVariable.getSimpleReadLocal(this.getAST(), this.symbol, slot);
                            reason = "installReadLocalNode";
                        } else {
                            RFunction.EnclosingSlot rse = frame.readSetEntry(this.symbol);
                            if (rse == null) {
                                node = ReadVariable.getReadTopLevel(this.getAST(), this.symbol);
                                reason = "installReadTopLevel";
                            } else {
                                node = ReadVariable.getReadEnclosing(this.getAST(), this.symbol, rse.hops, rse.slot);
                                reason = "installReadEnclosingNode";
                            }
                        }
                    }
                    this.replace(node, reason);
                    return node.execute(frame);
                }
            }
        };
    }

    private static ReadVariable getSimpleReadLocal(ASTNode orig, RSymbol sym, final int slot) {
        return new ReadVariable(orig, sym){

            @Override
            public final Object execute(Frame frame) {
                try {
                    Object value = frame.getObjectForcingPromises(slot);
                    if (value == null) {
                        throw new SpecializationException((Object)null);
                    }
                    return value;
                }
                catch (SpecializationException e) {
                    return this.replace(ReadVariable.getReadLocal(this.ast, this.symbol, slot)).execute(frame);
                }
            }
        };
    }

    private static ReadVariable getSimpleReadLocalSmallFrame(ASTNode orig, RSymbol sym, final int slot, SmallFrame frameTemplate) {
        if (frameTemplate instanceof SmallFrame.SmallFrame1Slot && slot == 0) {
            return new ReadVariable(orig, sym){

                @Override
                public final Object execute(Frame frame) {
                    SmallFrame.SmallFrame1Slot sframe = (SmallFrame.SmallFrame1Slot)Utils.cast(frame);
                    try {
                        Object value = RPromise.force(sframe.slot1);
                        if (value == null) {
                            throw new SpecializationException((Object)null);
                        }
                        return value;
                    }
                    catch (SpecializationException e) {
                        return this.replace(ReadVariable.getReadLocal(this.ast, this.symbol, slot)).execute(frame);
                    }
                }
            };
        }
        if (frameTemplate instanceof SmallFrame.SmallFrame2Slots && slot == 0) {
            return new ReadVariable(orig, sym){

                @Override
                public final Object execute(Frame frame) {
                    SmallFrame.SmallFrame2Slots sframe = (SmallFrame.SmallFrame2Slots)Utils.cast(frame);
                    try {
                        Object value = RPromise.force(sframe.slot1);
                        if (value == null) {
                            throw new SpecializationException((Object)null);
                        }
                        return value;
                    }
                    catch (SpecializationException e) {
                        return this.replace(ReadVariable.getReadLocal(this.ast, this.symbol, slot)).execute(frame);
                    }
                }
            };
        }
        if (frameTemplate instanceof SmallFrame.SmallFrame2Slots && slot == 1) {
            return new ReadVariable(orig, sym){

                @Override
                public final Object execute(Frame frame) {
                    SmallFrame.SmallFrame2Slots sframe = (SmallFrame.SmallFrame2Slots)Utils.cast(frame);
                    try {
                        Object value = RPromise.force(sframe.slot2);
                        if (value == null) {
                            throw new SpecializationException((Object)null);
                        }
                        return value;
                    }
                    catch (SpecializationException e) {
                        return this.replace(ReadVariable.getReadLocal(this.ast, this.symbol, slot)).execute(frame);
                    }
                }
            };
        }
        return ReadVariable.getSimpleReadLocal(orig, sym, slot);
    }

    private static ReadVariable getReadLocal(ASTNode orig, RSymbol sym, final int slot) {
        return new ReadVariable(orig, sym){

            @Override
            public final Object execute(Frame frame) {
                Object val = frame.readViaWriteSet(slot, this.symbol);
                if (val == null) {
                    throw RError.getUnknownVariable(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    private static ReadVariable getReadEnclosing(ASTNode orig, RSymbol sym, final int hops, final int slot) {
        return new ReadVariable(orig, sym){

            @Override
            public final Object execute(Frame frame) {
                Object val = frame.readViaReadSet(hops, slot, this.symbol);
                if (val == null) {
                    throw RError.getUnknownVariable(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    private static ReadVariable getReadTopLevel(ASTNode orig, RSymbol sym) {
        return new ReadVariable(orig, sym){

            @Override
            public final Object execute(Frame frame) {
                Object val;
                if (this.symbol.getVersion() != 0) {
                    val = frame.readFromExtensionEntry(this.symbol);
                    if (val == null) {
                        val = this.symbol.getValue();
                    }
                } else {
                    val = this.symbol.getValue();
                }
                if (val == null) {
                    return 8.readNonVariablePerhapsBuiltin(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    private static ReadVariable getReadOnlyFromTopLevel(ASTNode orig, RSymbol sym) {
        return new ReadVariable(orig, sym){

            @Override
            public final Object execute(Frame frame) {
                assert (Utils.check(frame == null));
                Object val = this.symbol.getValue();
                if (val == null) {
                    return 9.readNonVariablePerhapsBuiltin(this.ast, this.symbol);
                }
                return val;
            }
        };
    }

    private static class ReadDotDotVariable
    extends BaseR {
        final int index;
        @RNode.Child
        RNode readDots;

        public ReadDotDotVariable(ASTNode ast, int index) {
            super(ast);
            assert (Utils.check(index >= 0));
            this.index = index;
            this.readDots = this.adoptChild(ReadVariable.getUninitialized(ast, RSymbol.THREE_DOTS_SYMBOL));
        }

        @Override
        public Object execute(Frame frame) {
            RDots dotsValue = (RDots)this.readDots.execute(frame);
            Object[] values = dotsValue.values();
            int len = values.length;
            if (this.index < len) {
                Object value = values[this.index];
                if (value != null) {
                    return RPromise.force(value);
                }
                throw RError.getDotDotMissing(this.ast, this.index);
            }
            throw RError.getDotsBounds(this.ast, this.index + 1);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.readDots == oldNode) {
                this.readDots = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }
    }
}

