/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.View;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.EQ;
import r.nodes.exec.BaseR;
import r.nodes.exec.Comparison;
import r.nodes.exec.Constant;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class ReadVector
extends BaseR {
    @RNode.Child
    RNode lhs;
    @RNode.Children
    final RNode[] indexes;
    final boolean subset;
    private static final boolean DEBUG_SEL = false;

    ReadVector(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
        super(ast);
        this.lhs = this.adoptChild(lhs);
        this.indexes = this.adoptChildren(indexes);
        this.subset = subset;
    }

    @Override
    public Object execute(Frame frame) {
        if (this.getNewNode() != null) {
            System.err.println("Shit...\n");
        }
        assert (Utils.check(this.getNewNode() == null));
        RAny base = (RAny)this.lhs.execute(frame);
        if (this.getNewNode() != null) {
            return ((ReadVector)this.getNewNode()).executeWithBase(frame, base);
        }
        return this.executeWithBase(frame, base);
    }

    public Object executeWithBase(Frame frame, RAny base) {
        RAny index = (RAny)this.indexes[0].execute(frame);
        if (this.getNewNode() != null) {
            return ((ReadVector)this.getNewNode()).execute(index, base);
        }
        return this.execute(index, base);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.lhs == oldNode) {
            this.lhs = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.indexes != null) {
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i] != oldNode) continue;
                this.indexes[i] = newNode;
                return this.adoptInternal(newNode);
            }
        }
        return super.replaceChild(oldNode, newNode);
    }

    abstract RAny execute(RAny var1, RAny var2);

    private static Select createScalarSelect(boolean subset, RAny vectorTemplate) {
        if (subset) {
            return new Select(){

                @Override
                final RAny select(RAny vector, int index) throws SpecializationException {
                    if (!(vector instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                    }
                    RArray vrarr = (RArray)vector;
                    if (index > vrarr.size()) {
                        throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                    }
                    return vrarr.boxedGet(index - 1);
                }
            };
        }
        if (!(vectorTemplate instanceof RList)) {
            return new Select(){

                @Override
                final RAny select(RAny vector, int index) throws SpecializationException {
                    if (vector instanceof RList || !(vector instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.UNSPECIFIED);
                    }
                    RArray vrarr = (RArray)vector;
                    if (index > vrarr.size()) {
                        throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                    }
                    return vrarr.boxedGet(index - 1);
                }
            };
        }
        return new Select(){

            @Override
            final RAny select(RAny vector, int index) throws SpecializationException {
                if (!(vector instanceof RList)) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                RList vlist = (RList)vector;
                if (index > vlist.size()) {
                    throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                }
                return vlist.getRAny(index - 1);
            }
        };
    }

    private static RAny getWithName(RArray base, int i, boolean subset) {
        if (subset) {
            return base.boxedNamedGet(i);
        }
        if (base instanceof RList) {
            return ((RList)base).getRAny(i);
        }
        return base.boxedGet(i);
    }

    public static abstract class FieldSelection
    extends BaseR {
        @RNode.Child
        RNode lhs;
        final RSymbol index;

        protected FieldSelection(ASTNode orig, RNode lhs, RSymbol index) {
            super(orig);
            this.lhs = this.adoptChild(lhs);
            this.index = index;
        }

        @Override
        public Object execute(Frame frame) {
            assert (Utils.check(this.getNewNode() == null));
            RAny base = (RAny)this.lhs.execute(frame);
            if (this.getNewNode() != null) {
                return ((FieldSelection)this.getNewNode()).execute(base);
            }
            return this.execute(base);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.lhs == oldNode) {
                this.lhs = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        abstract RAny execute(RAny var1);

        public static class GenericSelection
        extends FieldSelection {
            int lastPosition = -1;
            RArray.Names lastNames = null;

            public GenericSelection(ASTNode parent, RNode lhs, RSymbol index) {
                super(parent, lhs, index);
            }

            @Override
            RAny execute(RAny base) {
                int pos;
                if (!(base instanceof RList)) {
                    throw RError.getDollarAtomicVectors(this.ast);
                }
                RList list = (RList)base;
                RArray.Names names = list.names();
                if (names != this.lastNames) {
                    pos = names.map(this.index);
                    if (pos == -1) {
                        pos = names.mapPartial(this.index);
                    }
                    this.lastPosition = pos;
                    this.lastNames = names;
                } else {
                    pos = this.lastPosition;
                }
                if (pos == -1) {
                    return RNull.getNull();
                }
                return list.getRAny(pos);
            }
        }

        public static class FixedPositionSelection
        extends FieldSelection {
            final int fixedPosition;
            final RArray.Names fixedNames;

            public FixedPositionSelection(ASTNode parent, RNode lhs, RSymbol index, int fixedPosition, RArray.Names fixedNames) {
                super(parent, lhs, index);
                this.fixedPosition = fixedPosition;
                this.fixedNames = fixedNames;
            }

            @Override
            RAny execute(RAny base) {
                try {
                    RList list;
                    RArray.Names names;
                    if (base instanceof RList && (names = (list = (RList)base).names()) == this.fixedNames) {
                        return list.getRAny(this.fixedPosition);
                    }
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.index);
                    this.replace(gs, "install GenericSelection from FixedPositionSelection (Field)");
                    return gs.execute(base);
                }
            }
        }

        public static class UninitializedSelection
        extends FieldSelection {
            public UninitializedSelection(ASTNode parent, RNode lhs, RSymbol index) {
                super(parent, lhs, index);
            }

            @Override
            RAny execute(RAny base) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    RList list;
                    RArray.Names names;
                    if (base instanceof RList && (names = (list = (RList)base).names()) != null) {
                        int pos = names.map(this.index);
                        if (pos == -1) {
                            pos = names.mapPartial(this.index);
                        }
                        if (pos != -1) {
                            FixedPositionSelection fp = new FixedPositionSelection(this.ast, this.lhs, this.index, pos, names);
                            this.replace(fp, "install FixedPositionSelection from UninitializedSelection (Field)");
                            return fp.execute(base);
                        }
                    }
                    GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.index);
                    this.replace(gs, "install GenericSelection from SimpleSelection (Field)");
                    return gs.execute(base);
                }
            }
        }
    }

    public static class GenericSelection
    extends ReadVector {
        public GenericSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            if (!(base instanceof RArray)) {
                throw RError.getObjectNotSubsettable(this.ast, base.typeOf());
            }
            assert (Utils.check(this.subset));
            RArray abase = (RArray)base;
            if (!(index instanceof RArray) || index instanceof RList) {
                throw RError.getInvalidSubscriptType(this.ast, index.typeOf());
            }
            RArray aindex = (RArray)index;
            int isize = aindex.size();
            if (isize == 1) {
                return GenericScalarSelection.executeScalar(abase, aindex, this.subset, this.ast);
            }
            if (aindex instanceof RInt) {
                return IntSelection.executeIntVector((RInt)aindex, abase, this.ast);
            }
            if (aindex instanceof RDouble) {
                return IntSelection.executeIntVector(aindex.asInt(), abase, this.ast);
            }
            if (aindex instanceof RLogical) {
                return LogicalSelection.executeLogicalVector((RLogical)aindex, abase);
            }
            if (aindex instanceof RString) {
                return StringSelection.executeStringVector((RString)aindex, abase, this.ast);
            }
            if (aindex instanceof RNull) {
                return Utils.createEmptyArray(abase);
            }
            throw RError.getInvalidSubscriptType(this.ast, aindex.typeOf());
        }
    }

    public static class Subscript
    extends ReadVector {
        public Subscript(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
            Utils.check(!subset);
        }

        public static int convertNegativeNonNAIndex(int indexv, int bsize, ASTNode ast) {
            int res;
            if (bsize > 2) {
                throw RError.getSelectMoreThanOne(ast);
            }
            if (bsize < 2) {
                throw RError.getSelectLessThanOne(ast);
            }
            if (indexv == -1) {
                res = 1;
            } else if (indexv == -2) {
                res = 0;
            } else {
                if (indexv == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                throw RError.getSelectMoreThanOne(ast);
            }
            return res;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int convertDereferencingIndex(int indexv, int iindex, int bsize, ASTNode ast) {
            if (indexv > 0) {
                if (indexv > bsize) throw RError.getNoSuchIndexAtLevel(ast, iindex + 1);
                return indexv - 1;
            }
            if (indexv != Integer.MIN_VALUE) return Subscript.convertNegativeNonNAIndex(indexv, bsize, ast);
            throw RError.getNoSuchIndexAtLevel(ast, iindex + 1);
        }

        public static RAny executeSubscript(RInt index, RArray base, ASTNode ast) {
            int bsize;
            int i;
            int isize = index.size();
            if (isize == 0) {
                throw RError.getSelectLessThanOne(ast);
            }
            RAny b = base;
            if (isize > 1) {
                for (i = 0; i < isize - 1; ++i) {
                    if (!(b instanceof RList)) {
                        if (base instanceof RList) {
                            throw RError.getRecursiveIndexingFailed(ast, i + 1);
                        }
                        throw RError.getSelectMoreThanOne(ast);
                    }
                    RList l = (RList)b;
                    int indexv = index.getInt(i);
                    bsize = l.size();
                    int isel = Subscript.convertDereferencingIndex(indexv, i, bsize, ast);
                    b = l.getRAny(isel);
                }
            }
            int indexv = index.getInt(i);
            if (!(b instanceof RArray)) {
                if (indexv == 1) {
                    throw RError.getInvalidTypeLength(ast, b.typeOf(), 1);
                }
                if (indexv > 1) {
                    throw RError.getSubscriptBounds(ast);
                }
                throw RError.getSelectLessThanOne(ast);
            }
            RArray a = b;
            bsize = a.size();
            boolean isList = a instanceof RList;
            if (indexv > 0) {
                if (indexv <= bsize) {
                    if (isList) {
                        return ((RList)a).getRAny(indexv - 1);
                    }
                    return a.boxedGet(indexv - 1);
                }
                throw RError.getSubscriptBounds(ast);
            }
            if (indexv == Integer.MIN_VALUE) {
                if (isList) {
                    return RList.NULL;
                }
                throw RError.getSubscriptBounds(ast);
            }
            int fromIndex = Subscript.convertNegativeNonNAIndex(indexv, bsize, ast);
            if (isList) {
                return ((RList)a).getRAny(fromIndex);
            }
            return a.boxedGet(fromIndex);
        }

        public static RAny executeSubscript(RString index, RArray base, ASTNode ast) {
            RArray.Names names;
            int i;
            int isize = index.size();
            if (isize == 0) {
                throw RError.getSelectLessThanOne(ast);
            }
            RAny b = base;
            if (isize > 1) {
                for (i = 0; i < isize - 1; ++i) {
                    if (!(b instanceof RList)) {
                        throw RError.getSelectMoreThanOne(ast);
                    }
                    RList l = (RList)b;
                    names = l.names();
                    if (names == null) {
                        throw RError.getNoSuchIndexAtLevel(ast, i + 1);
                    }
                    RSymbol s = RSymbol.getSymbol(index.getString(i));
                    int indexv = names.map(s);
                    if (indexv == -1) {
                        throw RError.getNoSuchIndexAtLevel(ast, i + 1);
                    }
                    b = l.getRAny(indexv);
                }
            }
            if (!(b instanceof RArray)) {
                throw RError.getSubscriptBounds(ast);
            }
            RArray a = b;
            names = a.names();
            int indexv = -1;
            if (names != null) {
                RSymbol s = RSymbol.getSymbol(index.getString(i));
                indexv = names.map(s);
            }
            boolean isList = a instanceof RList;
            if (indexv != -1) {
                if (isList) {
                    return ((RList)a).getRAny(indexv);
                }
                return a.boxedGet(indexv);
            }
            if (isList) {
                return RList.NULL;
            }
            throw RError.getSubscriptBounds(ast);
        }

        public static RAny executeSubscript(RAny index, RArray base, ASTNode ast) {
            if (index instanceof RInt || index instanceof RDouble || index instanceof RLogical) {
                return Subscript.executeSubscript(index.asInt(), base, ast);
            }
            if (index instanceof RString) {
                return Subscript.executeSubscript((RString)index, base, ast);
            }
            throw Subscript.invalidSubscript(index, ast);
        }

        public static RError invalidSubscript(RAny index, ASTNode ast) {
            if (index instanceof RList) {
                int lsize = ((RList)index).size();
                if (lsize == 1) {
                    throw RError.getInvalidSubscriptType(ast, index.typeOf());
                }
                if (lsize == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                throw RError.getSelectMoreThanOne(ast);
            }
            if (index instanceof RNull) {
                throw RError.getSelectLessThanOne(ast);
            }
            throw RError.getInvalidSubscriptType(ast, index.typeOf());
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                return Subscript.executeSubscript(index, abase, this.ast);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from Subscript");
                return gs.execute(index, base);
            }
        }
    }

    public static class StringSelection
    extends ReadVector {
        public StringSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
            Utils.check(subset);
        }

        public static RAny executeStringVector(RString index, RArray base, ASTNode ast) {
            int isize = index.size();
            if (isize == 0) {
                return Utils.createEmptyArray(base, base.names() != null);
            }
            RArray.Names baseNames = base.names();
            if (baseNames == null) {
                return Utils.createNAArray(base, isize);
            }
            RSymbol[] symbols = new RSymbol[isize];
            RArray res = Utils.createArray(base, isize, true);
            for (int i = 0; i < isize; ++i) {
                RSymbol symbol = RSymbol.getSymbol(index.getString(i));
                int v = baseNames.map(symbol);
                if (v != -1) {
                    res.set(i, base.get(v));
                    symbols[i] = symbol;
                    continue;
                }
                Utils.setNA(res, i);
                symbols[i] = RSymbol.NA_SYMBOL;
            }
            return res.setNames(RArray.Names.create(symbols));
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (!(index instanceof RString)) {
                    throw new SpecializationException((Object)Failure.NOT_STRING_INDEX);
                }
                return StringSelection.executeStringVector((RString)index, abase, this.ast);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from StringSelection");
                return gs.execute(index, base);
            }
        }
    }

    public static class LogicalSelection
    extends ReadVector {
        public LogicalSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
            Utils.check(subset);
        }

        public static RAny executeLogicalVector(RLogical index, RArray base) {
            int isize = index.size();
            int bsize = base.size();
            RArray.Names names = base.names();
            if (isize == 0) {
                return Utils.createEmptyArray(base, names != null);
            }
            RSymbol[] symbols = names == null ? null : names.sequence();
            RSymbol[] newSymbols = null;
            if (isize >= bsize) {
                int l;
                int i;
                int nsize = 0;
                for (int i2 = 0; i2 < isize; ++i2) {
                    if (index.getLogical(i2) == 0) continue;
                    ++nsize;
                }
                RArray res = Utils.createArray(base, nsize, symbols != null);
                if (symbols != null) {
                    newSymbols = new RSymbol[nsize];
                }
                int j = 0;
                for (i = 0; i < bsize; ++i) {
                    l = index.getLogical(i);
                    if (l == 1) {
                        res.set(j, base.get(i));
                        if (symbols != null) {
                            newSymbols[j] = symbols[i];
                        }
                        ++j;
                        continue;
                    }
                    if (l != Integer.MIN_VALUE) continue;
                    Utils.setNA(res, j);
                    if (symbols != null) {
                        newSymbols[j] = RSymbol.NA_SYMBOL;
                    }
                    ++j;
                }
                while (i < isize) {
                    l = index.getLogical(i);
                    if (l != 0) {
                        Utils.setNA(res, j);
                        if (symbols != null) {
                            newSymbols[j] = RSymbol.NA_SYMBOL;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (symbols != null) {
                    res = res.setNames(RArray.Names.create(newSymbols));
                }
                return res;
            }
            int nsize = 0;
            int j = 0;
            for (int i = 0; i < bsize; ++i) {
                if (index.getLogical(j) != 0) {
                    ++nsize;
                }
                if (++j != isize) continue;
                j = 0;
            }
            RArray res = Utils.createArray(base, nsize, symbols != null);
            if (symbols != null) {
                newSymbols = new RSymbol[nsize];
            }
            j = 0;
            int k = 0;
            for (int i = 0; i < bsize; ++i) {
                int l = index.getLogical(j);
                if (l == 1) {
                    res.set(k, base.get(i));
                    if (symbols != null) {
                        newSymbols[k] = symbols[i];
                    }
                    ++k;
                } else if (l == Integer.MIN_VALUE) {
                    Utils.setNA(res, k);
                    if (symbols != null) {
                        newSymbols[k] = RSymbol.NA_SYMBOL;
                    }
                    ++k;
                }
                if (++j != isize) continue;
                j = 0;
            }
            if (symbols != null) {
                res = res.setNames(RArray.Names.create(newSymbols));
            }
            return res;
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                if (!(index instanceof RLogical)) {
                    throw new SpecializationException((Object)Failure.NOT_LOGICAL_INDEX);
                }
                return LogicalSelection.executeLogicalVector((RLogical)index, (RArray)base);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from LogicalSelection");
                return gs.execute(index, base);
            }
        }
    }

    public static class SimpleLogicalSelection
    extends ReadVector {
        public SimpleLogicalSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
            Utils.check(subset);
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            try {
                int bsize;
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (!(index instanceof RLogical)) {
                    throw new SpecializationException((Object)Failure.NOT_LOGICAL_INDEX);
                }
                if (abase.names() != null) {
                    throw new SpecializationException((Object)Failure.BASE_HAS_NAMES);
                }
                RLogical lindex = (RLogical)index;
                int isize = lindex.size();
                if (isize != (bsize = abase.size())) {
                    throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                }
                int nsize = 0;
                for (int i = 0; i < isize; ++i) {
                    if (lindex.getLogical(i) == 0) continue;
                    ++nsize;
                }
                RArray res = Utils.createArray(base, nsize);
                int j = 0;
                for (int i = 0; i < isize; ++i) {
                    int l = lindex.getLogical(i);
                    if (l == 1) {
                        res.set(j++, abase.get(i));
                        continue;
                    }
                    if (l != Integer.MIN_VALUE) continue;
                    Utils.setNA(res, j++);
                }
                return res;
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case BASE_HAS_NAMES: 
                    case NOT_SAME_LENGTH: {
                        LogicalSelection ls = new LogicalSelection(this.ast, this.lhs, this.indexes, this.subset);
                        this.replace(ls, "install LogicalSelection from SimpleLogicalSelection");
                        return ls.execute(index, base);
                    }
                }
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from SimpleLogicalSelection");
                return gs.execute(index, base);
            }
        }
    }

    public static class LogicalEqualitySelection
    extends BaseR {
        @RNode.Child
        RNode lhs;
        @RNode.Child
        RNode xExpr;
        final double c;

        public LogicalEqualitySelection(ASTNode ast, RNode lhs, RNode xExpr, double c) {
            super(ast);
            this.lhs = this.adoptChild(lhs);
            this.xExpr = this.adoptChild(xExpr);
            assert (Utils.check(RDouble.RDoubleUtils.isFinite(c)));
            this.c = c;
        }

        @Override
        public Object execute(Frame frame) {
            assert (Utils.check(this.getNewNode() == null));
            RAny base = (RAny)this.lhs.execute(frame);
            if (this.getNewNode() != null) {
                return ((LogicalEqualitySelection)this.getNewNode()).executeWithBase(frame, base);
            }
            return this.executeWithBase(frame, base);
        }

        public Object executeWithBase(Frame frame, RAny base) {
            RAny x = (RAny)this.xExpr.execute(frame);
            if (this.getNewNode() != null) {
                return ((LogicalEqualitySelection)this.getNewNode()).executeWithBase(frame, base);
            }
            return this.execute(base, x);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.lhs == oldNode) {
                this.lhs = newNode;
                return this.adoptInternal(newNode);
            }
            if (this.xExpr == oldNode) {
                this.xExpr = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public RAny execute(RAny base, RAny xArg) {
            try {
                int size;
                if (!(base instanceof DoubleImpl) || !(xArg instanceof DoubleImpl)) {
                    throw new SpecializationException((Object)null);
                }
                DoubleImpl bdi = (DoubleImpl)base;
                double[] b = ((DoubleImpl)base).getContent();
                double[] x = ((DoubleImpl)xArg).getContent();
                if (x.length != (size = b.length) || bdi.names() != null) {
                    throw new SpecializationException((Object)null);
                }
                if (size > 1000) {
                    double[] tmp = new double[size];
                    int j = 0;
                    for (int i = 0; i < size; ++i) {
                        double d = x[i];
                        if (d == this.c) {
                            tmp[j++] = b[i];
                            continue;
                        }
                        if (!RDouble.RDoubleUtils.isNAorNaN(d)) continue;
                        tmp[j++] = RDouble.NA;
                    }
                    if (j == size) {
                        return RDouble.RDoubleFactory.getFor(tmp);
                    }
                    double[] content = new double[j];
                    System.arraycopy(tmp, 0, content, 0, j);
                    return RDouble.RDoubleFactory.getFor(content);
                }
                int nsize = 0;
                for (int i = 0; i < size; ++i) {
                    double d = x[i];
                    if (d != this.c && !RDouble.RDoubleUtils.isNAorNaN(d)) continue;
                    ++nsize;
                }
                double[] content = new double[nsize];
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    double d = x[i];
                    if (d == this.c) {
                        content[j++] = b[i];
                        continue;
                    }
                    if (!RDouble.RDoubleUtils.isNAorNaN(d)) continue;
                    content[j++] = RDouble.NA;
                }
                return RDouble.RDoubleFactory.getFor(content);
            }
            catch (SpecializationException e) {
                AccessVector av = (AccessVector)this.ast;
                EQ eq = (EQ)av.getArgs().first().getValue();
                ScalarDoubleImpl boxedC = RDouble.RDoubleFactory.getScalar(this.c);
                Comparison indexExpr = new Comparison(eq, this.xExpr, new Constant(eq.getRHS(), boxedC), Comparison.getEQ());
                LogicalSelection ls = new LogicalSelection(this.ast, this.lhs, new RNode[]{indexExpr}, true);
                this.replace(ls, "install LogicalSelection from LogicalEqualitySelection");
                return ls.execute((RAny)indexExpr.execute(xArg, boxedC), base);
            }
        }
    }

    public static class IntSelection
    extends ReadVector {
        public IntSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
            Utils.check(subset);
        }

        public static RAny executeIntVector(RInt index, RArray base, ASTNode ast) {
            int nsize;
            boolean hasZero;
            RArray.Names names = base.names();
            RSymbol[] symbols = names == null ? null : names.sequence();
            RSymbol[] newSymbols = null;
            int nzeros = 0;
            boolean hasNegative = false;
            boolean hasPositive = false;
            boolean hasNA = false;
            int bsize = base.size();
            int isize = index.size();
            boolean[] omit = null;
            int nomit = 0;
            for (int i = 0; i < isize; ++i) {
                int vi;
                int v = index.getInt(i);
                if (v == Integer.MIN_VALUE) {
                    hasNA = true;
                    continue;
                }
                if (v == 0) {
                    ++nzeros;
                    continue;
                }
                if (v > 0) {
                    hasPositive = true;
                    continue;
                }
                if (!hasNegative) {
                    hasNegative = true;
                    omit = new boolean[bsize];
                }
                if ((vi = -v - 1) >= omit.length || omit[vi]) continue;
                omit[vi] = true;
                ++nomit;
            }
            boolean bl = hasZero = nzeros > 0;
            if (!hasNegative) {
                if (!hasZero && symbols == null && !hasNA) {
                    return base.subset(index);
                }
                nsize = isize - nzeros;
                if (symbols != null) {
                    newSymbols = new RSymbol[nsize];
                }
                RArray res = Utils.createArray(base, nsize, symbols != null);
                int j = 0;
                for (int i = 0; i < isize; ++i) {
                    int v = index.getInt(i);
                    if (v > 0 && v <= bsize) {
                        res.set(j, base.get(v - 1));
                        if (symbols != null) {
                            newSymbols[j] = symbols[v - 1];
                        }
                        ++j;
                        continue;
                    }
                    if (v == 0) continue;
                    Utils.setNA(res, j);
                    if (symbols != null) {
                        newSymbols[j] = RSymbol.NA_SYMBOL;
                    }
                    ++j;
                }
                if (symbols != null) {
                    res = res.setNames(RArray.Names.create(newSymbols));
                }
                return res;
            }
            if (hasPositive || hasNA) {
                throw RError.getOnlyZeroMixed(ast);
            }
            nsize = bsize - nomit;
            RArray res = Utils.createArray(base, nsize, symbols != null);
            if (symbols != null) {
                newSymbols = new RSymbol[nsize];
            }
            int j = 0;
            for (int i = 0; i < bsize; ++i) {
                if (omit[i]) continue;
                res.set(j, base.get(i));
                if (symbols != null) {
                    newSymbols[j] = symbols[i];
                }
                ++j;
            }
            if (symbols != null) {
                res = res.setNames(RArray.Names.create(newSymbols));
            }
            return res;
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            try {
                RInt iindex;
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (index instanceof RInt) {
                    iindex = (RInt)index;
                } else if (index instanceof RDouble) {
                    iindex = index.asInt();
                } else {
                    throw new SpecializationException((Object)Failure.NOT_INT_OR_DOUBLE_INDEX);
                }
                return IntSelection.executeIntVector(iindex, abase, this.ast);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from IntSelection");
                return gs.execute(index, base);
            }
        }
    }

    public static class SimpleIntSequenceSelection
    extends ReadVector {
        public SimpleIntSequenceSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
            Utils.check(subset);
        }

        @Override
        public RAny execute(RAny index, RAny base) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (abase.names() != null) {
                    throw new SpecializationException((Object)Failure.BASE_HAS_NAMES);
                }
                if (!(index instanceof IntImpl.RIntSequence)) {
                    throw new SpecializationException((Object)Failure.NOT_INT_SEQUENCE_INDEX);
                }
                IntImpl.RIntSequence sindex = (IntImpl.RIntSequence)index;
                if (!sindex.isPositive()) {
                    throw new SpecializationException((Object)Failure.NOT_ALL_POSITIVE_INDEX);
                }
                int size = abase.size();
                if (sindex.max() > size) {
                    throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                }
                if (abase instanceof RDouble) {
                    return new RDoubleView((RDouble)abase, sindex.from(), sindex.to(), sindex.step());
                }
                if (abase instanceof RInt) {
                    return new RIntView((RInt)abase, sindex.from(), sindex.to(), sindex.step());
                }
                if (abase instanceof RLogical) {
                    return new RLogicalView((RLogical)abase, sindex.from(), sindex.to(), sindex.step());
                }
                if (abase instanceof RList) {
                    return new RListView((RList)abase, sindex.from(), sindex.to(), sindex.step());
                }
                if (abase instanceof RString) {
                    return new RStringView((RString)abase, sindex.from(), sindex.to(), sindex.step());
                }
                if (abase instanceof RRaw) {
                    return new RRawView((RRaw)abase, sindex.from(), sindex.to(), sindex.step());
                }
                assert (Utils.check(abase instanceof RComplex));
                return new RComplexView((RComplex)abase, sindex.from(), sindex.to(), sindex.step());
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case NOT_INT_SEQUENCE_INDEX: 
                    case NOT_ALL_POSITIVE_INDEX: 
                    case INDEX_OUT_OF_BOUNDS: 
                    case BASE_HAS_NAMES: {
                        IntSelection is = new IntSelection(this.ast, this.lhs, this.indexes, this.subset);
                        this.replace(is, "install IntSelection from SimpleIntSequenceSelection");
                        return is.execute(index, base);
                    }
                }
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from SimpleIntSequenceSelection");
                return gs.execute(index, base);
            }
        }

        static class RListView
        extends View.RListProxy<RList>
        implements RList {
            final int from;
            final int to;
            final int step;
            final int size;

            public RListView(RList base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public RAny getRAny(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RList)this.orig).getRAny(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }

        static class RStringView
        extends View.RStringProxy<RString>
        implements RString {
            final int from;
            final int to;
            final int step;
            final int size;

            public RStringView(RString base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public String getString(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RString)this.orig).getString(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }

        static class RComplexView
        extends View.RComplexProxy<RComplex>
        implements RComplex {
            final int from;
            final int to;
            final int step;
            final int size;

            public RComplexView(RComplex base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public double getReal(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RComplex)this.orig).getReal(this.from + i * this.step - 1);
            }

            @Override
            public double getImag(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RComplex)this.orig).getImag(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }

        static class RDoubleView
        extends View.RDoubleProxy<RDouble>
        implements RDouble {
            final int from;
            final int to;
            final int step;
            final int size;

            public RDoubleView(RDouble base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public double getDouble(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RDouble)this.orig).getDouble(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }

        static class RIntView
        extends View.RIntProxy<RInt>
        implements RInt {
            final int from;
            final int to;
            final int step;
            final int size;

            public RIntView(RInt base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public int getInt(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RInt)this.orig).getInt(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }

        static class RLogicalView
        extends View.RLogicalProxy<RLogical>
        implements RLogical {
            final int from;
            final int to;
            final int step;
            final int size;

            public RLogicalView(RLogical base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public int getLogical(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RLogical)this.orig).getLogical(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }

        static class RRawView
        extends View.RRawProxy<RRaw>
        implements RRaw {
            final int from;
            final int to;
            final int step;
            final int size;

            public RRawView(RRaw base, int from, int to, int step) {
                super(base);
                this.from = from;
                this.to = to;
                this.step = step;
                this.size = IntImpl.RIntSequence.sequenceSize(from, to, step);
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public byte getRaw(int i) {
                assert (Utils.check(i < this.size, "bounds check"));
                assert (Utils.check(i >= 0, "bounds check"));
                return ((RRaw)this.orig).getRaw(this.from + i * this.step - 1);
            }

            @Override
            public int[] dimensions() {
                return null;
            }
        }
    }

    public static class GenericScalarSelection
    extends ReadVector {
        public GenericScalarSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
        }

        public static RAny executeScalar(RArray base, RArray index, boolean subset, ASTNode ast) {
            int i = 0;
            int size = base.size();
            if (index instanceof RDouble) {
                RDouble idbl = (RDouble)index;
                i = Convert.double2int(idbl.getDouble(0));
            } else if (index instanceof RInt) {
                i = ((RInt)index).getInt(0);
            } else if (index instanceof RLogical) {
                i = ((RLogical)index).getLogical(0);
                if (subset) {
                    if (i == 1) {
                        return base;
                    }
                    if (i == 0) {
                        return Utils.createEmptyArray(base);
                    }
                }
            } else {
                if (index instanceof RString) {
                    RSymbol name = RSymbol.getSymbol(((RString)index).getString(0));
                    RArray.Names bnames = base.names();
                    if (bnames == null) {
                        return Utils.getBoxedNA(base);
                    }
                    i = bnames.map(name);
                    if (i != -1) {
                        return ReadVector.getWithName(base, i, subset);
                    }
                    return Utils.getNamedNA(base);
                }
                throw RError.getInvalidSubscriptType(ast, index.typeOf());
            }
            if (i > 0 && i <= size) {
                return ReadVector.getWithName(base, i - 1, subset);
            }
            if (size == 0) {
                return Utils.createNA(base);
            }
            if (!subset) {
                if (i == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (i > 0 || i == Integer.MIN_VALUE) {
                    throw RError.getSubscriptBounds(ast);
                }
                if (size > 2) {
                    throw RError.getSelectMoreThanOne(ast);
                }
                if (size == 1) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (i != -1 && i != -2) {
                    throw RError.getSelectMoreThanOne(ast);
                }
            }
            if (base instanceof RDouble) {
                if (i == Integer.MIN_VALUE) {
                    return RDouble.RDoubleFactory.getNAArray(size);
                }
                if (i < 0) {
                    if (-i > size) {
                        return base.stripAttributesKeepNames();
                    }
                    return RDouble.RDoubleFactory.exclude(-i - 1, (RDouble)base);
                }
                if (i == 0) {
                    return RDouble.RDoubleFactory.getEmpty(base.names() != null);
                }
                return RDouble.RDoubleFactory.getNA(base.names() != null);
            }
            if (base instanceof RInt) {
                if (i == Integer.MIN_VALUE) {
                    return RInt.RIntFactory.getNAArray(size);
                }
                if (i < 0) {
                    if (-i > size) {
                        return base.stripAttributesKeepNames();
                    }
                    return RInt.RIntFactory.exclude(-i - 1, (RInt)base);
                }
                if (i == 0) {
                    return RInt.RIntFactory.getEmpty(base.names() != null);
                }
                return RInt.RIntFactory.getNA(base.names() != null);
            }
            if (base instanceof RLogical) {
                if (i == Integer.MIN_VALUE) {
                    return RLogical.RLogicalFactory.getNAArray(size);
                }
                if (i < 0) {
                    if (-i > size) {
                        return base.stripAttributesKeepNames();
                    }
                    return RLogical.RLogicalFactory.exclude(-i - 1, (RLogical)base);
                }
                if (i == 0) {
                    return RLogical.RLogicalFactory.getEmpty(base.names() != null);
                }
                return RLogical.RLogicalFactory.getNA(base.names() != null);
            }
            if (base instanceof RList) {
                if (i == Integer.MIN_VALUE) {
                    return RList.RListFactory.getNullArray(size);
                }
                if (i < 0) {
                    if (-i > size) {
                        return base.stripAttributesKeepNames();
                    }
                    return RList.RListFactory.exclude(-i - 1, (RList)base);
                }
                if (i == 0) {
                    return RList.RListFactory.getEmpty(base.names() != null);
                }
                return RList.RListFactory.getNull(base.names() != null);
            }
            if (base instanceof RString) {
                if (i == Integer.MIN_VALUE) {
                    return RString.RStringFactory.getNAArray(size);
                }
                if (i < 0) {
                    if (-i > size) {
                        return base.stripAttributesKeepNames();
                    }
                    return RString.RStringFactory.exclude(-i - 1, (RString)base);
                }
                if (i == 0) {
                    return RString.RStringFactory.getEmpty(base.names() != null);
                }
                return RString.RStringFactory.getNA(base.names() != null);
            }
            if (base instanceof RComplex) {
                if (i == Integer.MIN_VALUE) {
                    return RComplex.RComplexFactory.getNAArray(size);
                }
                if (i < 0) {
                    if (-i > size) {
                        return base.stripAttributesKeepNames();
                    }
                    return RComplex.RComplexFactory.exclude(-i - 1, (RComplex)base);
                }
                if (i == 0) {
                    return RComplex.RComplexFactory.getEmpty(base.names() != null);
                }
                return RComplex.RComplexFactory.getNA(base.names() != null);
            }
            assert (Utils.check(base instanceof RRaw));
            if (i < 0) {
                if (-i > size) {
                    return base.stripAttributesKeepNames();
                }
                return RRaw.RRawFactory.exclude(-i - 1, (RRaw)base);
            }
            if (i == 0) {
                return RRaw.RRawFactory.getEmpty(base.names() != null);
            }
            return RRaw.RRawFactory.getZero(base.names() != null);
        }

        @Override
        public RAny execute(RAny index, RAny vector) {
            try {
                if (!(vector instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray vrarr = (RArray)vector;
                if (!(index instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_INDEX);
                }
                RArray irarr = (RArray)index;
                if (irarr.size() != 1) {
                    throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
                }
                return GenericScalarSelection.executeScalar(vrarr, irarr, this.subset, this.ast);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                if (f == Failure.NOT_ONE_ELEMENT && index instanceof RLogical && this.subset) {
                    SimpleLogicalSelection ls = new SimpleLogicalSelection(this.ast, this.lhs, this.indexes, this.subset);
                    this.replace(ls, "install SimpleLogicalSelection from GenericScalarSelection");
                    return ls.execute(index, vector);
                }
                if (!this.subset) {
                    Subscript s = new Subscript(this.ast, this.lhs, this.indexes, this.subset);
                    this.replace(s, "install Subscript from GenericScalarSelection");
                    return s.execute(index, vector);
                }
                GenericSelection gs = new GenericSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gs, "install GenericSelection from GenericScalarSelection");
                return gs.execute(index, vector);
            }
        }
    }

    public static class SimpleScalarStringSelection
    extends ReadVector {
        public SimpleScalarStringSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset, RAny vectorTemplate) {
            super(ast, lhs, indexes, subset);
        }

        @Override
        public RAny execute(RAny index, RAny vector) {
            try {
                if (!(index instanceof RString)) {
                    throw new SpecializationException((Object)Failure.NOT_STRING_INDEX);
                }
                RString irstr = (RString)index;
                if (irstr.size() != 1) {
                    throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
                }
                if (!(vector instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray vrarr = (RArray)vector;
                RArray.Names names = vrarr.names();
                if (names == null) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                RSymbol symbol = RSymbol.getSymbol(irstr.getString(0));
                int i = names.map(symbol);
                if (i == -1) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                return ReadVector.getWithName(vrarr, i, this.subset);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case NOT_ONE_ELEMENT: {
                        if (this.subset) {
                            StringSelection is = new StringSelection(this.ast, this.lhs, this.indexes, this.subset);
                            this.replace(is, "install StringSelection from SimpleScalarStringSelection");
                            return is.execute(index, vector);
                        }
                        Subscript s = new Subscript(this.ast, this.lhs, this.indexes, this.subset);
                        this.replace(s, "install Subscript from SimpleScalarStringSelection");
                        return s.execute(index, vector);
                    }
                }
                GenericScalarSelection gen = new GenericScalarSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gen, "install GenericScalarSelection from SimpleScalarStringSelection");
                return gen.execute(index, vector);
            }
        }
    }

    public static class SimpleScalarDoubleSelection
    extends ReadVector {
        public SimpleScalarDoubleSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset, RAny vectorTemplate) {
            super(ast, lhs, indexes, subset);
        }

        @Override
        public RAny execute(RAny index, RAny vector) {
            try {
                if (!(index instanceof RDouble)) {
                    throw new SpecializationException((Object)Failure.NOT_DOUBLE_INDEX);
                }
                RDouble irdbl = (RDouble)index;
                if (irdbl.size() != 1) {
                    throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
                }
                int i = Convert.double2int(irdbl.getDouble(0));
                if (!(vector instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray vrarr = (RArray)vector;
                if (i <= 0 || i > vrarr.size() || vrarr.names() != null) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                if (this.subset || !(vrarr instanceof RList)) {
                    return vrarr.boxedGet(i - 1);
                }
                return ((RList)vrarr).getRAny(i - 1);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case NOT_ONE_ELEMENT: {
                        if (this.subset) {
                            IntSelection is = new IntSelection(this.ast, this.lhs, this.indexes, this.subset);
                            this.replace(is, "install IntSelection from SimpleScalarDoubleSelection");
                            return is.execute(index, vector);
                        }
                        Subscript s = new Subscript(this.ast, this.lhs, this.indexes, this.subset);
                        this.replace(s, "install Subscript from SimpleScalarDoubleSelection");
                        return s.execute(index, vector);
                    }
                    case NOT_DOUBLE_INDEX: {
                        if (!(index instanceof RString)) break;
                        SimpleScalarStringSelection ss = new SimpleScalarStringSelection(this.ast, this.lhs, this.indexes, this.subset, vector);
                        this.replace(ss, "install SimpleScalarStringSelection from SimpleScalarDoubleSelection");
                        return ss.execute(index, vector);
                    }
                }
                GenericScalarSelection gen = new GenericScalarSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gen, "install GenericScalarSelection from SimpleScalarDoubleSelection");
                return gen.execute(index, vector);
            }
        }
    }

    public static abstract class DoubleBaseSimpleSelection
    extends ReadVector {
        public DoubleBaseSimpleSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
        }

        public static class ScalarDoubleSelection
        extends DoubleBaseSimpleSelection {
            public ScalarDoubleSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
                super(ast, lhs, indexes, subset);
            }

            @Override
            public RAny execute(RAny index, RAny vector) {
                try {
                    if (!(index instanceof ScalarDoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    int i = Convert.double2int(((ScalarDoubleImpl)index).getDouble()) - 1;
                    if (!(vector instanceof DoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    DoubleImpl dbase = (DoubleImpl)vector;
                    double[] base = dbase.getContent();
                    if (i < 0 || i >= base.length || dbase.names() != null) {
                        throw new SpecializationException((Object)null);
                    }
                    return RDouble.RDoubleFactory.getScalar(base[i]);
                }
                catch (SpecializationException e) {
                    SimpleScalarIntSelection is = new SimpleScalarIntSelection(this.ast, this.lhs, this.indexes, this.subset);
                    this.replace(is, "install SimpleScalarIntSelection from DoubleBaseSimpleSelection.ScalarIntSelection");
                    return is.execute(index, vector);
                }
            }
        }

        public static class ScalarIntSelection
        extends DoubleBaseSimpleSelection {
            public ScalarIntSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
                super(ast, lhs, indexes, subset);
            }

            @Override
            public RAny execute(RAny index, RAny vector) {
                try {
                    if (!(index instanceof ScalarIntImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    int i = ((ScalarIntImpl)index).getInt() - 1;
                    if (!(vector instanceof DoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    DoubleImpl dbase = (DoubleImpl)vector;
                    double[] base = dbase.getContent();
                    if (i < 0 || i >= base.length || dbase.names() != null) {
                        throw new SpecializationException((Object)null);
                    }
                    return RDouble.RDoubleFactory.getScalar(base[i]);
                }
                catch (SpecializationException e) {
                    ScalarDoubleSelection ns = new ScalarDoubleSelection(this.ast, this.lhs, this.indexes, this.subset);
                    this.replace(ns, "install DoubleBaseSimpleSelection.ScalarDoubleSelection from DoubleBaseSimpleSelection.ScalarIntSelection");
                    return ns.execute(index, vector);
                }
            }
        }
    }

    public static class SimpleConstantScalarIntSelection
    extends ReadVector {
        final int index;

        public SimpleConstantScalarIntSelection(ASTNode ast, RNode lhs, RNode[] indexes, int index, boolean subset) {
            super(ast, lhs, indexes, subset);
            this.index = index;
        }

        @Override
        public Object execute(Frame frame) {
            assert (Utils.check(this.getNewNode() == null));
            RAny base = (RAny)this.lhs.execute(frame);
            if (this.getNewNode() != null) {
                return ((SimpleConstantScalarIntSelection)this.getNewNode()).executeWithBase(frame, base);
            }
            return this.executeWithBase(frame, base);
        }

        @Override
        public Object executeWithBase(Frame frame, RAny base) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray vrarr = (RArray)base;
                if (this.index > vrarr.size()) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                return ReadVector.getWithName(vrarr, this.index - 1, this.subset);
            }
            catch (SpecializationException e) {
                RNode theIndex0 = this.indexes[0];
                GenericScalarSelection gen = new GenericScalarSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gen, "");
                return gen.execute((RAny)theIndex0.execute(frame), base);
            }
        }

        @Override
        public RAny execute(RAny index, RAny vector) {
            return null;
        }
    }

    public static class SimpleScalarIntSelection
    extends ReadVector {
        public SimpleScalarIntSelection(ASTNode ast, RNode lhs, RNode[] indexes, boolean subset) {
            super(ast, lhs, indexes, subset);
        }

        @Override
        public RAny execute(RAny index, RAny vector) {
            try {
                if (!(vector instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                if (!(index instanceof RInt)) {
                    throw new SpecializationException((Object)Failure.NOT_INT_INDEX);
                }
                RArray vrarr = (RArray)vector;
                if (vrarr.names() != null) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                RInt irint = (RInt)index;
                if (irint.size() != 1) {
                    throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
                }
                int i = irint.getInt(0);
                if (i <= 0 || i > vrarr.size()) {
                    throw new SpecializationException((Object)Failure.UNSPECIFIED);
                }
                if (this.subset || !(vrarr instanceof RList)) {
                    return vrarr.boxedGet(i - 1);
                }
                return ((RList)vrarr).getRAny(i - 1);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case NOT_INT_INDEX: {
                        SimpleScalarDoubleSelection dbl = new SimpleScalarDoubleSelection(this.ast, this.lhs, this.indexes, this.subset, vector);
                        this.replace(dbl, "install SimpleScalarDoubleSelection from SimpleScalarIntSelection");
                        return dbl.execute(index, vector);
                    }
                    case NOT_ONE_ELEMENT: {
                        if (this.subset) {
                            if (index instanceof IntImpl.RIntSequence) {
                                SimpleIntSequenceSelection is = new SimpleIntSequenceSelection(this.ast, this.lhs, this.indexes, this.subset);
                                this.replace(is, "install SimpleIntSequenceSelection from SimpleScalarIntSelection");
                                return is.execute(index, vector);
                            }
                            IntSelection is = new IntSelection(this.ast, this.lhs, this.indexes, this.subset);
                            this.replace(is, "install IntSelection from SimpleScalarIntSelection");
                            return is.execute(index, vector);
                        }
                        Subscript s = new Subscript(this.ast, this.lhs, this.indexes, this.subset);
                        this.replace(s, "install Subscript from SimpleScalarIntSelection");
                        return s.execute(index, vector);
                    }
                }
                GenericScalarSelection gen = new GenericScalarSelection(this.ast, this.lhs, this.indexes, this.subset);
                this.replace(gen, "install GenericScalarSelection from SimpleScalarIntSelection");
                return gen.execute(index, vector);
            }
        }
    }

    private static abstract class Select {
        private Select() {
        }

        abstract RAny select(RAny var1, int var2) throws SpecializationException;
    }

    static enum Failure {
        NOT_ARRAY_BASE,
        NOT_ARRAY_INDEX,
        NOT_INT_INDEX,
        NOT_INT_SEQUENCE_INDEX,
        NOT_DOUBLE_INDEX,
        NOT_STRING_INDEX,
        NOT_ALL_POSITIVE_INDEX,
        NOT_INT_OR_DOUBLE_INDEX,
        NOT_LOGICAL_INDEX,
        NOT_ONE_ELEMENT,
        NA_INDEX,
        NOT_POSITIVE_INDEX,
        INDEX_OUT_OF_BOUNDS,
        NOT_SAME_LENGTH,
        NOT_SUBSET,
        BASE_HAS_NAMES,
        UNSPECIFIED;

    }
}

