/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.AbstractCall;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.nodes.exec.ReadVariable;
import r.nodes.exec.SuperWriteVariable;
import r.nodes.exec.WriteVariable;
import r.runtime.Frame;

public class ReplacementCall
extends BaseR {
    @RNode.Child
    RNode forcePromiseNode;
    @RNode.Child
    AbstractCall callNode;
    @RNode.Child
    RNode assign;
    final boolean isSuper;
    Object newContent;

    public ReplacementCall(ASTNode ast, boolean isSuper, RSymbol var, AbstractCall callNode) {
        super(ast);
        this.isSuper = isSuper;
        this.callNode = this.adoptChild(callNode);
        RNode[] argExprs = callNode.argExprs;
        assert (Utils.check(argExprs.length >= 1));
        assert (Utils.check(argExprs[argExprs.length - 1] instanceof RememberLast));
        BaseR node = new BaseR(ast){

            @Override
            public final Object execute(Frame frame) {
                return ReplacementCall.this.newContent;
            }
        };
        this.assign = isSuper ? this.adoptChild(SuperWriteVariable.getUninitialized(ast, var, node)) : this.adoptChild(WriteVariable.getUninitialized(ast, var, node));
        this.forcePromiseNode = this.adoptChild(ReadVariable.getUninitialized(ast, var));
    }

    @Override
    public Object execute(Frame frame) {
        this.forcePromiseNode.execute(frame);
        this.newContent = this.callNode.execute(frame);
        this.assign.execute(frame);
        RNode[] argExprs = this.callNode.argExprs;
        return ((RememberLast)argExprs[argExprs.length - 1]).lastValue();
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.forcePromiseNode == oldNode) {
            this.forcePromiseNode = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.callNode == oldNode) {
            this.callNode = (AbstractCall)newNode;
            return this.adoptInternal(newNode);
        }
        if (this.assign == oldNode) {
            this.assign = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static final class RememberLast
    extends BaseR {
        @RNode.Child
        RNode node;
        Object lastValue;

        public RememberLast(ASTNode ast, RNode node) {
            super(ast);
            this.node = this.insert(node, "inserting RememberLast");
        }

        @Override
        public Object execute(Frame frame) {
            this.lastValue = this.node.execute(frame);
            return this.lastValue;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.node == oldNode) {
                this.node = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public Object lastValue() {
            return this.lastValue;
        }
    }
}

