/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import java.util.Arrays;
import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.RNull;
import r.data.internal.ScalarIntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.Constant;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class Selector {
    private static final boolean DEBUG_M = false;

    public static int[] calculateDestinationDimensions(int[] selSizes, boolean drop) {
        if (!drop) {
            return selSizes;
        }
        int nones = 0;
        for (int s : selSizes) {
            if (s != 1) continue;
            ++nones;
        }
        if (nones == 0) {
            return selSizes;
        }
        if (nones >= selSizes.length - 1) {
            return null;
        }
        int[] res = new int[selSizes.length - nones];
        int i = 0;
        for (int s : selSizes) {
            if (s == 1) continue;
            res[i++] = s;
        }
        return res;
    }

    public static int calculateSizeFromSelectorSizes(int[] selectorSizes) {
        int result = 1;
        for (int i : selectorSizes) {
            result *= i;
        }
        return result;
    }

    public static void partialToFullOffsets(int[] offsets, int from) {
        int add = 0;
        for (int i = from; i >= 0; --i) {
            int o = offsets[i];
            if (o == Integer.MIN_VALUE) {
                for (int k = 0; k < i; ++k) {
                    offsets[k] = Integer.MIN_VALUE;
                }
                return;
            }
            offsets[i] = add += o;
        }
    }

    public static void partialToFullOffsetsNoNA(int[] offsets, int from) {
        int add = 0;
        for (int i = from; i >= 0; --i) {
            offsets[i] = add += offsets[i];
        }
    }

    public static boolean initialize(int[] offsets, Selector[] selectors, int[] dataDimensions, int[] selSizes, ASTNode ast) throws SpecializationException {
        int mult = 1;
        boolean hasNA = false;
        boolean mayHaveNA = false;
        for (int i = 0; i < selectors.length; ++i) {
            int size;
            Selector sel = selectors[i];
            int dim = dataDimensions[i];
            sel.start(dim, ast);
            mayHaveNA = mayHaveNA || sel.mayHaveNA();
            selSizes[i] = size = sel.size();
            if (size == 0) {
                return true;
            }
            int next = sel.nextIndex(ast);
            if (next != Integer.MIN_VALUE) {
                offsets[i] = next * mult;
            } else {
                hasNA = true;
                offsets[i] = Integer.MIN_VALUE;
            }
            mult *= dim;
        }
        if (!hasNA) {
            Selector.partialToFullOffsetsNoNA(offsets, selectors.length - 1);
        } else {
            Selector.partialToFullOffsets(offsets, selectors.length - 1);
        }
        return mayHaveNA;
    }

    public static void restart(int[] offsets, Selector[] selectors, int[] dataDimensions, ASTNode ast, boolean mayHaveNA) throws SpecializationException {
        if (!mayHaveNA) {
            Selector.restartNoNA(offsets, selectors, dataDimensions, ast);
        } else {
            Selector.restart(offsets, selectors, dataDimensions, ast);
        }
    }

    public static void restart(int[] offsets, Selector[] selectors, int[] dataDimensions, ASTNode ast) throws SpecializationException {
        int mult = 1;
        for (int i = 0; i < selectors.length; ++i) {
            Selector sel = selectors[i];
            int dim = dataDimensions[i];
            sel.restart();
            int next = sel.nextIndex(ast);
            offsets[i] = next != Integer.MIN_VALUE ? next * mult : Integer.MIN_VALUE;
            mult *= dim;
        }
        Selector.partialToFullOffsets(offsets, selectors.length - 1);
    }

    public static void restartNoNA(int[] offsets, Selector[] selectors, int[] dataDimensions, ASTNode ast) throws SpecializationException {
        int mult = 1;
        for (int i = 0; i < selectors.length; ++i) {
            Selector sel = selectors[i];
            int dim = dataDimensions[i];
            sel.restart();
            int next = sel.nextIndex(ast);
            offsets[i] = next * mult;
            mult *= dim;
        }
        Selector.partialToFullOffsetsNoNA(offsets, selectors.length - 1);
    }

    public static void advance(int[] offsets, int[] dataDimensions, Selector[] selectors, ASTNode ast, boolean mayHaveNA) throws SpecializationException {
        if (!mayHaveNA) {
            Selector.advanceNoNA(offsets, dataDimensions, selectors, ast);
        } else {
            Selector.advance(offsets, dataDimensions, selectors, ast);
        }
    }

    public static void advance(int[] offsets, int[] dataDimensions, Selector[] selectors, ASTNode ast) throws SpecializationException {
        assert (Utils.check(selectors.length > 0));
        assert (Utils.check(offsets.length == selectors.length + 1));
        assert (Utils.check(offsets[offsets.length - 1] == 0));
        int mult = 1;
        int i = 0;
        while (true) {
            int next;
            Selector sel;
            if (!(sel = selectors[i]).isExhausted()) {
                next = sel.nextIndex(ast);
                if (next != Integer.MIN_VALUE) {
                    offsets[i] = next * mult;
                    break;
                }
                offsets[i] = Integer.MIN_VALUE;
                break;
            }
            sel.restart();
            next = sel.nextIndex(ast);
            offsets[i] = next != Integer.MIN_VALUE ? next * mult : Integer.MIN_VALUE;
            mult *= dataDimensions[i];
            ++i;
        }
        Selector.partialToFullOffsets(offsets, i + 1);
    }

    public static void advanceNoNA(int[] offsets, int[] dataDimensions, Selector[] selectors, ASTNode ast) throws SpecializationException {
        int next;
        Selector sel;
        assert (Utils.check(selectors.length > 0));
        assert (Utils.check(offsets.length == selectors.length + 1));
        assert (Utils.check(offsets[offsets.length - 1] == 0));
        int mult = 1;
        int i = 0;
        while (true) {
            if (!(sel = selectors[i]).isExhausted()) break;
            sel.restart();
            next = sel.nextIndex(ast);
            offsets[i] = next * mult;
            mult *= dataDimensions[i];
            ++i;
        }
        next = sel.nextIndex(ast);
        offsets[i] = next * mult;
        Selector.partialToFullOffsetsNoNA(offsets, i + 1);
    }

    public void setIndex(RAny index) {
    }

    public RAny getIndex() {
        return null;
    }

    public Transition getTransition() {
        return null;
    }

    public abstract void start(int var1, ASTNode var2) throws SpecializationException;

    public abstract void restart();

    public abstract int size();

    public abstract int nextIndex(ASTNode var1) throws SpecializationException;

    public abstract boolean isConstant();

    public abstract boolean isExhausted();

    public abstract boolean mayHaveNA();

    public static OptionNode createConstantOptionNode(ASTNode ast, final int value) {
        return new OptionNode(ast){

            @Override
            public int executeLogical(Frame frame) {
                return value;
            }
        };
    }

    public static OptionNode createOptionNode(ASTNode ast, final RNode node, int defaultValue) {
        if (node == null) {
            return Selector.createConstantOptionNode(ast, defaultValue);
        }
        if (node.getAST() instanceof Constant) {
            RAny value = (RAny)node.execute(null);
            return Selector.createConstantOptionNode(ast, value.asLogical().getLogical(0));
        }
        return new OptionNode(ast){
            @RNode.Child
            RNode child;
            {
                super(x0);
                this.child = this.adoptChild(node);
            }

            @Override
            public int executeLogical(Frame frame) {
                RAny value = (RAny)this.child.execute(frame);
                return value.asLogical().getLogical(0);
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.child == oldNode) {
                    this.child = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }
        };
    }

    public static OptionNode createDropOptionNode(ASTNode ast, RNode node) {
        return Selector.createOptionNode(ast, node, 1);
    }

    public static OptionNode createExactOptionNode(ASTNode ast, RNode node) {
        return Selector.createOptionNode(ast, node, Integer.MIN_VALUE);
    }

    public static SelectorNode createConstantSelectorNode(ASTNode ast, RNode child, final Selector selector) {
        return new SelectorNode(ast, child){

            @Override
            public Selector executeSelector(Frame frame) {
                return selector;
            }

            @Override
            public Selector executeSelector(RAny index) {
                return selector;
            }
        };
    }

    public static SelectorNode createSelectorNode(ASTNode ast, final boolean subset, RNode node) {
        if (node == null) {
            if (subset) {
                return Selector.createConstantSelectorNode(ast, node, new MissingSelector());
            }
            throw RError.getInvalidSubscriptType(ast, "symbol");
        }
        if (node.getAST() instanceof Constant) {
            RAny index = (RAny)node.execute(null);
            return Selector.createSelectorNode(ast, subset, index, node, true, null);
        }
        return new SelectorNode(ast, node){

            @Override
            public Selector executeSelector(RAny index) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    SelectorNode sn = Selector.createSelectorNode(this.ast, subset, index, this.child, false, null);
                    this.replace(sn, "install Selector from Uninitialized");
                    return sn.executeSelector(index);
                }
            }
        };
    }

    public static AnalyzedIndex analyzeIndex(RInt index) {
        boolean hasNA = false;
        boolean hasNegative = false;
        boolean hasPositive = false;
        boolean hasZero = false;
        for (int i = 0; i < index.size(); ++i) {
            int value = index.getInt(i);
            if (value > 0) {
                hasPositive = true;
                continue;
            }
            if (value == 0) {
                hasZero = true;
                continue;
            }
            if (value == Integer.MIN_VALUE) {
                hasNA = true;
                continue;
            }
            hasNegative = true;
        }
        return new AnalyzedIndex(hasNA, hasNegative, hasPositive, hasZero);
    }

    public static SelectorNode createSelectorNode(ASTNode ast, boolean subset, RAny template, RNode child, boolean isConstant, Transition transition) {
        if (transition == null && (template instanceof RDouble || template instanceof RInt)) {
            RInt index = template.asInt().materialize();
            AnalyzedIndex a = Selector.analyzeIndex(index);
            if (a.hasPositive && !a.hasNegative && !a.hasNA && !a.hasZero) {
                if (isConstant && index.size() == 1) {
                    return Selector.createConstantSelectorNode(ast, child, new SinglePositiveConstantIndexSelector(index.getInt(0) - 1));
                }
                if (subset) {
                    if (index.size() == 1) {
                        return Selector.createSimpleScalarNumericSubsetSelectorNode(ast, child);
                    }
                    return Selector.createSimpleNumericSubsetSelectorNode(ast, child);
                }
                return Selector.createSpecializedSimpleSubscriptSelectorNode(ast, child, template);
            }
        }
        if (subset) {
            return Selector.createGenericSubsetSelectorNode(ast, child);
        }
        return Selector.createGenericSubscriptSelectorNode(ast, child);
    }

    public static SelectorNode createSimpleNumericSubsetSelectorNode(ASTNode ast, RNode child) {
        final SimpleNumericSubsetSelector selector = new SimpleNumericSubsetSelector();
        return new SelectorNode(ast, child){

            @Override
            public Selector executeSelector(RAny index) {
                try {
                    if (index instanceof RInt || index instanceof RDouble) {
                        selector.setIndex(Convert.coerceToIntWarning(index, this.ast));
                        return selector;
                    }
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    SelectorNode gn = Selector.createGenericSubsetSelectorNode(this.ast, this.child);
                    this.replace(gn, "install GenericSubsetSelectorNode from SimpleNumericSubsetSelectorNode");
                    return gn.executeSelector(index);
                }
            }
        };
    }

    public static SelectorNode createSpecializedSimpleSubscriptSelectorNode(ASTNode ast, RNode child, RAny template) {
        final SimpleScalarNumericSelector selector = new SimpleScalarNumericSelector();
        if (template instanceof ScalarIntImpl) {
            return new SelectorNode(ast, child){

                @Override
                public Selector executeSelector(RAny index) {
                    try {
                        if (index instanceof ScalarIntImpl) {
                            selector.setIndex(index);
                            return selector;
                        }
                        throw new SpecializationException((Object)null);
                    }
                    catch (SpecializationException e) {
                        SelectorNode gn = Selector.createGenericSimpleSubscriptSelectorNode(this.ast, this.child);
                        this.replace(gn, "install GenericSimpleSubscriptSelectorNode from SpecializedSimpleSubscriptSelectorNode");
                        return gn.executeSelector(index);
                    }
                }
            };
        }
        return Selector.createGenericSimpleSubscriptSelectorNode(ast, child);
    }

    public static SelectorNode createGenericSimpleSubscriptSelectorNode(ASTNode ast, RNode child) {
        final SimpleScalarNumericSelector selector = new SimpleScalarNumericSelector();
        return new SelectorNode(ast, child){

            @Override
            public Selector executeSelector(RAny index) {
                try {
                    if (index instanceof RInt || index instanceof RDouble || index instanceof RLogical) {
                        selector.setIndex(Convert.coerceToIntWarning(index, this.ast));
                        return selector;
                    }
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    SelectorNode gn = Selector.createGenericSubscriptSelectorNode(this.ast, this.child);
                    this.replace(gn, "install GenericSubscriptSelectorNode from SimpleSubscriptSelectorNode");
                    return gn.executeSelector(index);
                }
            }
        };
    }

    public static SelectorNode createSimpleScalarNumericSubsetSelectorNode(ASTNode ast, RNode child) {
        final SimpleScalarNumericSelector selector = new SimpleScalarNumericSelector();
        return new SelectorNode(ast, child){

            @Override
            public Selector executeSelector(RAny index) {
                try {
                    if (index instanceof RInt || index instanceof RDouble) {
                        selector.setIndex(Convert.coerceToIntWarning(index, this.ast));
                        return selector;
                    }
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    SelectorNode gn = Selector.createSimpleNumericSubsetSelectorNode(this.ast, this.child);
                    this.replace(gn, "install SimpleNumericSubsetSelectorNode from SimpleScalarNumericSubsetSelectorNode");
                    return gn.executeSelector(index);
                }
            }
        };
    }

    public static SelectorNode createGenericSubsetSelectorNode(ASTNode ast, RNode child) {
        return new SelectorNode(ast, child){
            final GenericNumericSubsetSelector numericSelector = new GenericNumericSubsetSelector();
            final GenericLogicalSubsetSelector logicalSelector = new GenericLogicalSubsetSelector();

            @Override
            public Selector executeSelector(RAny index) {
                if (index instanceof RInt || index instanceof RDouble || index instanceof RNull) {
                    this.numericSelector.setIndex(Convert.coerceToIntWarning(index, this.ast));
                    return this.numericSelector;
                }
                if (index instanceof RLogical) {
                    this.logicalSelector.setIndex(index);
                    return this.logicalSelector;
                }
                throw RError.getInvalidSubscriptType(this.ast, index.typeOf());
            }
        };
    }

    public static SelectorNode createGenericSubscriptSelectorNode(ASTNode ast, RNode child) {
        final GenericSubscriptSelector selector = new GenericSubscriptSelector();
        return new SelectorNode(ast, child){

            @Override
            public Selector executeSelector(RAny index) {
                if (index instanceof RInt || index instanceof RDouble || index instanceof RLogical || index instanceof RNull) {
                    selector.setIndex(Convert.coerceToIntWarning(index, this.ast));
                    return selector;
                }
                throw RError.getInvalidSubscriptType(this.ast, index.typeOf());
            }
        };
    }

    public static abstract class SelectorNode
    extends BaseR {
        @RNode.Child
        RNode child;

        public SelectorNode(ASTNode ast, RNode child) {
            super(ast);
            this.child = this.adoptChild(child);
        }

        @Override
        public Object execute(Frame frame) {
            assert (Utils.check(false, "unreachable"));
            return null;
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.child == oldNode) {
                this.child = newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        public Selector executeSelector(Frame frame) {
            RAny index = (RAny)this.child.execute(frame);
            return this.executeSelector(index);
        }

        public abstract Selector executeSelector(RAny var1);
    }

    public static final class AnalyzedIndex {
        final boolean hasNA;
        final boolean hasNegative;
        final boolean hasPositive;
        final boolean hasZero;

        public AnalyzedIndex(boolean hasNA, boolean hasNegative, boolean hasPositive, boolean hasZero) {
            this.hasNA = hasNA;
            this.hasNegative = hasNegative;
            this.hasPositive = hasPositive;
            this.hasZero = hasZero;
        }
    }

    public static enum Transition {
        GENERIC_SELECTION;

    }

    public static final class GenericLogicalSubsetSelector
    extends Selector {
        RLogical index;
        int indexSize;
        int size;
        int offset;
        int indexOffset;
        boolean reuse;

        @Override
        public void setIndex(RAny index) {
            this.index = (RLogical)index;
            this.indexSize = this.index.size();
        }

        @Override
        public void start(int dataSize, ASTNode ast) {
            this.offset = 0;
            this.indexOffset = 0;
            int isize = this.indexSize;
            int nnonfalse = RLogical.RLogicalUtils.nonFalsesInRange(this.index, 0, isize);
            if (isize == dataSize) {
                this.size = nnonfalse;
                this.reuse = false;
                return;
            }
            if (isize > dataSize) {
                throw RError.getLogicalSubscriptLong(ast);
            }
            this.reuse = true;
            if (isize == 0) {
                this.size = 0;
                return;
            }
            int times = dataSize / isize;
            int extra = dataSize - times * isize;
            this.size = extra == 0 ? nnonfalse * times : nnonfalse * times + RLogical.RLogicalUtils.nonFalsesInRange(this.index, 0, extra);
        }

        @Override
        public void restart() {
            this.offset = 0;
            this.indexOffset = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public int nextIndex(ASTNode ast) {
            while (true) {
                int v = this.index.getLogical(this.indexOffset);
                if (!this.reuse) {
                    if (v == 1) {
                        return this.indexOffset++;
                    }
                    ++this.indexOffset;
                    if (v != 0) return Integer.MIN_VALUE;
                    continue;
                }
                ++this.indexOffset;
                if (this.indexOffset == this.indexSize) {
                    this.indexOffset = 0;
                }
                if (v == 1) {
                    return this.offset++;
                }
                ++this.offset;
                if (v != 0) return Integer.MIN_VALUE;
            }
        }

        @Override
        public boolean isExhausted() {
            return this.indexOffset == this.size;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean mayHaveNA() {
            return true;
        }
    }

    public static final class GenericNumericSubsetSelector
    extends Selector {
        RInt index;
        int size;
        int dataSize;
        boolean positiveSelection;
        int indexSize;
        int offset;
        boolean[] omit;
        boolean hasNA;

        @Override
        public void setIndex(RAny index) {
            this.index = (RInt)index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void start(int dataSize, ASTNode ast) {
            this.hasNA = false;
            boolean hasNegative = false;
            boolean hasPositive = false;
            int nzero = 0;
            int isize = this.index.size();
            for (int i = 0; i < isize; ++i) {
                int e;
                int value = this.index.getInt(i);
                if (value > 0) {
                    hasPositive = true;
                    if (value - 1 <= dataSize) continue;
                    throw RError.getSubscriptBounds(ast);
                }
                if (value == 0) {
                    ++nzero;
                    continue;
                }
                if (value == Integer.MIN_VALUE) {
                    this.hasNA = true;
                    continue;
                }
                if (!hasNegative) {
                    hasNegative = true;
                    this.size = dataSize;
                    if (this.omit != null) {
                        if (this.omit.length < dataSize) {
                            this.omit = new boolean[dataSize];
                        } else {
                            Arrays.fill(this.omit, false);
                        }
                    } else {
                        this.omit = new boolean[dataSize];
                    }
                }
                if ((e = -value - 1) >= dataSize || this.omit[e]) continue;
                this.omit[e] = true;
                --this.size;
            }
            if (hasPositive) {
                if (hasNegative) throw RError.getOnlyZeroMixed(ast);
                this.size = isize - nzero;
                this.positiveSelection = true;
                this.indexSize = isize;
            } else if (hasNegative) {
                if (this.hasNA) throw RError.getOnlyZeroMixed(ast);
                this.positiveSelection = false;
                this.dataSize = dataSize;
            } else {
                this.positiveSelection = true;
                this.indexSize = isize;
                this.size = this.hasNA ? isize - nzero : 0;
            }
            this.offset = 0;
        }

        @Override
        public void restart() {
            this.offset = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextIndex(ASTNode ast) {
            if (this.positiveSelection) {
                int i = this.index.getInt(this.offset++);
                while (i == 0) {
                    i = this.index.getInt(this.offset++);
                }
                if (i != Integer.MIN_VALUE) {
                    return i - 1;
                }
                return Integer.MIN_VALUE;
            }
            while (this.omit[this.offset]) {
                ++this.offset;
            }
            return this.offset++;
        }

        @Override
        public boolean isExhausted() {
            if (this.positiveSelection) {
                return this.offset == this.indexSize;
            }
            while (this.offset != this.dataSize) {
                if (!this.omit[this.offset]) {
                    return false;
                }
                ++this.offset;
            }
            return true;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean mayHaveNA() {
            return this.hasNA;
        }
    }

    public static final class GenericSubscriptSelector
    extends Selector {
        RInt index;
        int dataSize;
        int indexValue;

        @Override
        public void setIndex(RAny index) {
            this.index = (RInt)index;
        }

        @Override
        public RInt getIndex() {
            return this.index;
        }

        @Override
        public void start(int dataSize, ASTNode ast) throws SpecializationException {
            int isize = this.index.size();
            if (isize == 1) {
                int i = this.index.getInt(0);
                if (i > 0) {
                    if (--i < dataSize) {
                        this.dataSize = dataSize;
                        this.indexValue = i;
                        return;
                    }
                    throw RError.getSubscriptBounds(ast);
                }
                if (i == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (i == Integer.MIN_VALUE) {
                    throw RError.getSubscriptBounds(ast);
                }
                throw RError.getSelectMoreThanOne(ast);
            }
            if (isize > 1) {
                throw RError.getSelectMoreThanOne(ast);
            }
            throw RError.getSelectLessThanOne(ast);
        }

        @Override
        public void restart() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int nextIndex(ASTNode ast) throws SpecializationException {
            return this.indexValue;
        }

        @Override
        public boolean isExhausted() {
            return true;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean mayHaveNA() {
            return false;
        }
    }

    public static final class SimpleScalarNumericSelector
    extends Selector {
        RInt index;
        int dataSize;
        int indexValue;
        Transition transition;

        @Override
        public void setIndex(RAny index) {
            this.index = (RInt)index;
        }

        @Override
        public RInt getIndex() {
            return this.index;
        }

        @Override
        public Transition getTransition() {
            return this.transition;
        }

        @Override
        public void start(int dataSize, ASTNode ast) throws SpecializationException {
            int i;
            if (this.index.size() == 1 && (i = this.index.getInt(0)) > 0 && --i < dataSize) {
                this.dataSize = dataSize;
                this.indexValue = i;
                return;
            }
            this.transition = Transition.GENERIC_SELECTION;
            throw new SpecializationException(this);
        }

        @Override
        public void restart() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int nextIndex(ASTNode ast) throws SpecializationException {
            return this.indexValue;
        }

        @Override
        public boolean isExhausted() {
            return true;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean mayHaveNA() {
            return false;
        }
    }

    public static final class SimpleNumericSubsetSelector
    extends Selector {
        RInt index;
        int dataSize;
        int offset;
        Transition transition;

        @Override
        public void setIndex(RAny index) {
            this.index = (RInt)index;
        }

        @Override
        public RInt getIndex() {
            return this.index;
        }

        @Override
        public Transition getTransition() {
            return this.transition;
        }

        @Override
        public void start(int dataSize, ASTNode ast) {
            this.dataSize = dataSize;
            this.offset = 0;
            this.transition = null;
        }

        @Override
        public void restart() {
            this.offset = 0;
        }

        @Override
        public int size() {
            return this.index.size();
        }

        @Override
        public int nextIndex(ASTNode ast) throws SpecializationException {
            int value;
            if ((value = this.index.getInt(this.offset++)) > 0) {
                if (--value < this.dataSize) {
                    return value;
                }
                throw RError.getSubscriptBounds(ast);
            }
            this.transition = Transition.GENERIC_SELECTION;
            throw new SpecializationException(this);
        }

        @Override
        public boolean isExhausted() {
            return this.offset == this.index.size();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean mayHaveNA() {
            return false;
        }
    }

    public static final class SinglePositiveConstantIndexSelector
    extends Selector {
        private final int index;

        public SinglePositiveConstantIndexSelector(int value) {
            this.index = value;
        }

        @Override
        public void start(int dataSize, ASTNode ast) {
            if (this.index >= dataSize) {
                throw RError.getSubscriptBounds(ast);
            }
        }

        @Override
        public void restart() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int nextIndex(ASTNode ast) {
            return this.index;
        }

        @Override
        public boolean isExhausted() {
            return true;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public boolean mayHaveNA() {
            return false;
        }
    }

    public static final class MissingSelector
    extends Selector {
        private int size = -1;
        private int last = -1;

        @Override
        public void start(int dataSize, ASTNode ast) {
            this.size = dataSize;
            this.last = 0;
        }

        @Override
        public void restart() {
            this.last = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextIndex(ASTNode ast) {
            return this.last++;
        }

        @Override
        public boolean isExhausted() {
            return this.last == this.size;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public boolean mayHaveNA() {
            return false;
        }
    }

    public static abstract class OptionNode
    extends BaseR {
        public OptionNode(ASTNode ast) {
            super(ast);
        }

        @Override
        public Object execute(Frame frame) {
            assert (Utils.check(false, "unreachable"));
            return null;
        }

        public abstract int executeLogical(Frame var1);
    }
}

