/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.data.RAny;
import r.data.RFunction;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.nodes.exec.WriteVariable;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class SuperWriteVariable
extends BaseR {
    final RSymbol symbol;
    @RNode.Child
    RNode expr;

    private SuperWriteVariable(ASTNode ast, RSymbol symbol, RNode expr) {
        super(ast);
        this.symbol = symbol;
        this.expr = this.adoptChild(expr);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.expr == oldNode) {
            this.expr = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static SuperWriteVariable getUninitialized(ASTNode orig, RSymbol sym, RNode rhs) {
        return new SuperWriteVariable(orig, sym, rhs){

            private Object replaceAndExecute(RNode node, String reason, Frame frame) {
                this.replace(node, reason);
                return node.execute(frame);
            }

            @Override
            public final Object execute(Frame frame) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    Frame enclosingFrame;
                    Frame frame2 = enclosingFrame = frame != null ? frame.enclosingFrame() : null;
                    if (enclosingFrame == null) {
                        return this.replaceAndExecute(WriteVariable.getWriteTopLevel(this.ast, this.symbol, this.expr), "install WriteTopLevel from SuperWriteVariable", frame);
                    }
                    int slot = enclosingFrame.findVariable(this.symbol);
                    if (slot != -1) {
                        return this.replaceAndExecute(1.getWriteViaWriteSet(this.ast, this.symbol, this.expr, slot), "install WriteViaWriteSet from SuperWriteVariable", frame);
                    }
                    RFunction.EnclosingSlot eslot = enclosingFrame.findEnclosingVariable(this.symbol);
                    if (eslot == null) {
                        return this.replaceAndExecute(1.getWriteToTopLevel(this.ast, this.symbol, this.expr), "install WriteToTopLevel from SuperWriteVariable", frame);
                    }
                    return this.replaceAndExecute(1.getWriteViaEnclosingSlot(this.ast, this.symbol, this.expr, eslot.hops, eslot.slot), "install WriteViaReadSet from SuperWriteVariable", frame);
                }
            }
        };
    }

    public static SuperWriteVariable getWriteViaWriteSet(ASTNode ast, RSymbol symbol, RNode expr, final int slot) {
        return new SuperWriteVariable(ast, symbol, expr){

            @Override
            public Object execute(Frame frame) {
                RAny value = (RAny)this.expr.execute(frame);
                Frame enclosing = frame.enclosingFrame();
                boolean done = enclosing.superWriteViaWriteSet(slot, this.symbol, value);
                assert (Utils.check(done));
                return value;
            }
        };
    }

    public static SuperWriteVariable getWriteViaEnclosingSlot(ASTNode ast, RSymbol symbol, RNode expr, final int hops, final int slot) {
        return new SuperWriteVariable(ast, symbol, expr){

            @Override
            public final Object execute(Frame frame) {
                RAny value = (RAny)this.expr.execute(frame);
                Frame enclosing = frame.enclosingFrame();
                boolean done = enclosing.superWriteViaEnclosingSlotAndTopLevel(hops, slot, this.symbol, value);
                assert (Utils.check(done));
                return value;
            }
        };
    }

    public static SuperWriteVariable getWriteToTopLevel(ASTNode ast, RSymbol symbol, RNode expr) {
        return new SuperWriteVariable(ast, symbol, expr){

            @Override
            public final Object execute(Frame frame) {
                Frame enclosingFrame;
                RAny value = (RAny)this.expr.execute(frame);
                if (this.symbol.getVersion() != 0 && (enclosingFrame = frame.enclosingFrame()).superWriteToExtensionEntry(this.symbol, value)) {
                    return value;
                }
                Frame.superWriteToTopLevel(this.symbol, value);
                return value;
            }
        };
    }
}

