/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.data.RAny;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RLogical;
import r.data.internal.View;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class UnaryMinus
extends BaseR {
    @RNode.Child
    RNode lhs;

    UnaryMinus(ASTNode ast, RNode lhs) {
        super(ast);
        this.lhs = this.adoptChild(lhs);
    }

    @Override
    public final Object execute(Frame frame) {
        RAny value = (RAny)this.lhs.execute(frame);
        return this.execute(value);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.lhs == oldNode) {
            this.lhs = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    abstract RAny execute(RAny var1);

    public static class GenericMinus
    extends UnaryMinus {
        public GenericMinus(ASTNode ast, RNode lhs) {
            super(ast, lhs);
        }

        @Override
        RAny execute(RAny value) {
            if (value instanceof RComplex) {
                final RComplex cvalue = (RComplex)value;
                return new View.RComplexProxy<RComplex>(cvalue){

                    @Override
                    public double getReal(int i) {
                        double d = cvalue.getReal(i);
                        if (!RDouble.RDoubleUtils.isNAorNaN(d)) {
                            return -d;
                        }
                        return d;
                    }

                    @Override
                    public double getImag(int i) {
                        double d = cvalue.getImag(i);
                        if (!RDouble.RDoubleUtils.isNAorNaN(d)) {
                            return -d;
                        }
                        return d;
                    }
                };
            }
            if (value instanceof RDouble) {
                final RDouble dvalue = (RDouble)value;
                return new View.RDoubleProxy<RDouble>(dvalue){

                    @Override
                    public double getDouble(int i) {
                        double d = dvalue.getDouble(i);
                        if (RDouble.RDoubleUtils.arithIsNA(d)) {
                            return RDouble.NA;
                        }
                        return -d;
                    }
                };
            }
            if (value instanceof RInt || value instanceof RLogical) {
                final RInt ivalue = value.asInt();
                return new View.RIntProxy<RInt>(ivalue){

                    @Override
                    public int getInt(int i) {
                        int v = ivalue.getInt(i);
                        return -v;
                    }
                };
            }
            throw RError.getInvalidArgTypeUnary(this.ast);
        }
    }

    public static class NumericScalar
    extends UnaryMinus {
        public NumericScalar(ASTNode ast, RNode lhs) {
            super(ast, lhs);
        }

        private static RComplex forComplex(RComplex cvalue) throws SpecializationException {
            if (cvalue.size() != 1) {
                throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
            }
            double real = cvalue.getReal(0);
            double imag = cvalue.getImag(0);
            double nreal = !RDouble.RDoubleUtils.isNAorNaN(real) ? -real : real;
            double nimag = !RDouble.RDoubleUtils.isNAorNaN(imag) ? -imag : imag;
            return RComplex.RComplexFactory.getScalar(nreal, nimag);
        }

        private static RDouble forDouble(RDouble dvalue) throws SpecializationException {
            if (dvalue.size() != 1) {
                throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
            }
            double d = dvalue.getDouble(0);
            if (RDouble.RDoubleUtils.arithIsNA(d)) {
                return RDouble.BOXED_NA;
            }
            return RDouble.RDoubleFactory.getScalar(-d);
        }

        private static RInt forInt(RInt ivalue) throws SpecializationException {
            if (ivalue.size() != 1) {
                throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT);
            }
            int i = ivalue.getInt(0);
            return RInt.RIntFactory.getScalar(-i);
        }

        public Specialized createSimple(RAny valueTemplate) {
            if (valueTemplate instanceof RComplex) {
                Minus minus = new Minus(){

                    @Override
                    RAny minus(RAny value) throws SpecializationException {
                        if (!(value instanceof RComplex)) {
                            throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                        }
                        return NumericScalar.forComplex((RComplex)value);
                    }
                };
                return new Specialized(this.ast, this.lhs, minus, "NumericScalar<Double>");
            }
            if (valueTemplate instanceof RDouble) {
                Minus minus = new Minus(){

                    @Override
                    RAny minus(RAny value) throws SpecializationException {
                        if (!(value instanceof RDouble)) {
                            throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                        }
                        return NumericScalar.forDouble((RDouble)value);
                    }
                };
                return new Specialized(this.ast, this.lhs, minus, "NumericScalar<Double>");
            }
            if (valueTemplate instanceof RInt) {
                Minus minus = new Minus(){

                    @Override
                    RAny minus(RAny value) throws SpecializationException {
                        if (!(value instanceof RInt)) {
                            throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                        }
                        return NumericScalar.forInt((RInt)value);
                    }
                };
                return new Specialized(this.ast, this.lhs, minus, "NumericScalar<Double>");
            }
            return null;
        }

        public Specialized createGeneric() {
            Minus minus = new Minus(){

                @Override
                RAny minus(RAny value) throws SpecializationException {
                    if (value instanceof RComplex) {
                        return NumericScalar.forComplex((RComplex)value);
                    }
                    if (value instanceof RDouble) {
                        return NumericScalar.forDouble((RDouble)value);
                    }
                    if (value instanceof RInt) {
                        return NumericScalar.forInt((RInt)value);
                    }
                    if (value instanceof RLogical) {
                        return NumericScalar.forInt(value.asInt());
                    }
                    throw RError.getInvalidArgTypeUnary(NumericScalar.this.ast);
                }
            };
            return new Specialized(this.ast, this.lhs, minus, "NumericScalar<Generic>");
        }

        @Override
        public RAny execute(RAny value) {
            Specialized sn = this.createSimple(value);
            if (sn != null) {
                this.replace(sn, "specialize Scalar");
                return sn.execute(value);
            }
            sn = this.createGeneric();
            this.replace(sn, "specialize Scalar");
            return sn.execute(value);
        }

        class Specialized
        extends NumericScalar {
            final Minus minus;
            final String dbg;

            Specialized(ASTNode ast, RNode lhs, Minus minus, String dbg) {
                super(ast, lhs);
                this.minus = minus;
                this.dbg = dbg;
            }

            @Override
            public RAny execute(RAny value) {
                try {
                    return this.minus.minus(value);
                }
                catch (SpecializationException e) {
                    Failure f = (Failure)((Object)e.getResult());
                    if (f == Failure.UNEXPECTED_TYPE) {
                        Specialized sn = this.createGeneric();
                        this.replace(sn, "install Scalar.Generic from Scalar.Simple" + this.dbg);
                        return sn.execute(value);
                    }
                    GenericMinus n = new GenericMinus(this.ast, this.lhs);
                    this.replace(n, "install GenericMinus from Scalar" + this.dbg);
                    return n.execute(value);
                }
            }
        }

        abstract class Minus {
            Minus() {
            }

            abstract RAny minus(RAny var1) throws SpecializationException;
        }
    }

    static enum Failure {
        NOT_ONE_ELEMENT,
        UNEXPECTED_TYPE;

    }
}

