/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ComplexImpl;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.LogicalImpl;
import r.data.internal.ScalarComplexImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.ScalarStringImpl;
import r.data.internal.StringImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.RNode;
import r.nodes.exec.Selector;
import r.nodes.exec.UpdateArrayAssignment;
import r.nodes.exec.ValueCopy;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public class UpdateArray
extends UpdateArrayAssignment.AssignmentNode {
    static final boolean DEBUG_UP = false;
    final boolean subset;
    final boolean column;
    @RNode.Children
    final Selector.SelectorNode[] selectorExprs;
    final Selector[] selectorVals;
    final int[] selSizes;
    final int[] offsets;

    public static UpdateArrayAssignment.AssignmentNode create(ASTNode ast, Selector.SelectorNode[] selectorExprs, boolean subset, boolean column) {
        return new UpdateArray(ast, selectorExprs, subset, column);
    }

    protected UpdateArray(ASTNode ast, Selector.SelectorNode[] selectorExprs, boolean subset, boolean column) {
        super(ast);
        this.subset = subset;
        this.column = column;
        this.selectorExprs = (Selector.SelectorNode[])this.adoptChildren(selectorExprs);
        this.selectorVals = new Selector[selectorExprs.length];
        this.selSizes = new int[selectorExprs.length];
        this.offsets = new int[selectorExprs.length + 1];
    }

    protected UpdateArray(UpdateArray other) {
        this(other.ast, other.selectorExprs, other.subset, other.column);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.selectorExprs != null) {
            for (int i = 0; i < this.selectorExprs.length; ++i) {
                if (this.selectorExprs[i] != oldNode) continue;
                this.selectorExprs[i] = (Selector.SelectorNode)newNode;
                return this.adoptInternal(newNode);
            }
        }
        return super.replaceChild(oldNode, newNode);
    }

    protected static boolean isConvertible(RAny from, RAny to) {
        if (from.getClass() == to.getClass()) {
            return true;
        }
        if (to instanceof RDouble && (from instanceof RInt || from instanceof RDouble || from instanceof RLogical)) {
            return true;
        }
        if (to instanceof RInt && (from instanceof RInt || from instanceof RLogical)) {
            return true;
        }
        if (to instanceof RComplex && (from instanceof RInt || from instanceof RDouble || from instanceof RComplex || from instanceof RLogical)) {
            return true;
        }
        if (to instanceof RString && !(from instanceof RList)) {
            return true;
        }
        if (to instanceof RLogical && from instanceof RLogical) {
            return true;
        }
        if (to instanceof RRaw && from instanceof RRaw) {
            return true;
        }
        return to instanceof RList;
    }

    @Override
    public RAny execute(Frame frame, RAny lhs, RAny rhs) {
        try {
            throw new SpecializationException((Object)null);
        }
        catch (SpecializationException e) {
            if (this.subset && !this.column && !MatrixScalarIndex.isMatrixScalar(this.selectorExprs, frame) && !lhs.isShared()) {
                if (lhs instanceof IntImpl && rhs instanceof IntImpl) {
                    return this.replace(new IntToIntDirect(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof DoubleImpl) {
                    if (rhs instanceof IntImpl) {
                        return this.replace(new IntToDoubleDirect(this)).execute(frame, lhs, rhs);
                    }
                    if (rhs instanceof DoubleImpl) {
                        return this.replace(new DoubleToDoubleDirect(this)).execute(frame, lhs, rhs);
                    }
                } else if (lhs instanceof ComplexImpl) {
                    if (rhs instanceof IntImpl) {
                        return this.replace(new IntToComplexDirect(this)).execute(frame, lhs, rhs);
                    }
                    if (rhs instanceof DoubleImpl) {
                        return this.replace(new DoubleToComplexDirect(this)).execute(frame, lhs, rhs);
                    }
                    if (rhs instanceof ComplexImpl) {
                        return this.replace(new ComplexToComplexDirect(this)).execute(frame, lhs, rhs);
                    }
                }
            }
            if (!lhs.isShared() && UpdateArray.isConvertible(rhs, lhs) && rhs instanceof RArray && ((RArray)rhs).size() == 1) {
                return this.replace(new RHSCompatible(this)).execute(frame, lhs, rhs);
            }
            return this.replace(new CopyLhs(new RHSCompatible(this))).execute(frame, lhs, rhs);
        }
    }

    protected final RAny executeAndUpdateSelectors(Frame frame, RArray lhs, RArray rhs) {
        try {
            if (lhs.isShared()) {
                throw new SpecializationException((Object)null);
            }
            for (int i = 0; i < this.selectorVals.length; ++i) {
                this.selectorVals[i] = this.selectorExprs[i].executeSelector(frame);
            }
            block5: while (true) {
                try {
                    return this.update(lhs, rhs);
                }
                catch (SpecializationException e) {
                    Selector failedSelector = (Selector)e.getResult();
                    int i = 0;
                    while (true) {
                        if (i >= this.selectorVals.length) continue block5;
                        if (this.selectorVals[i] == failedSelector) {
                            RAny index = failedSelector.getIndex();
                            Selector.SelectorNode newSelector = Selector.createSelectorNode(this.ast, this.subset, index, this.selectorExprs[i].child, false, failedSelector.getTransition());
                            this.selectorExprs[i].replace(newSelector);
                            assert (Utils.check(this.selectorExprs[i] == newSelector));
                            this.selectorVals[i] = newSelector.executeSelector(index);
                        }
                        ++i;
                    }
                }
                break;
            }
        }
        catch (SpecializationException e) {
            return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
        }
    }

    protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
        block8: {
            int[] lhsDim = lhs.dimensions();
            UpdateArray.checkDimensions(lhsDim, this.selectorExprs.length, this.ast);
            boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, lhsDim, this.selSizes, this.ast);
            int itemsToReplace = Selector.calculateSizeFromSelectorSizes(this.selSizes);
            int replacementSize = rhs.size();
            UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, this.subset, this.ast);
            if (itemsToReplace > 0) {
                int rhsOffset = 0;
                if (!mayHaveNA) {
                    while (true) {
                        int lhsOffset = this.offsets[0];
                        lhs.set(lhsOffset, rhs.getRef(rhsOffset));
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break block8;
                            rhsOffset = 0;
                        }
                        Selector.advanceNoNA(this.offsets, lhsDim, this.selectorVals, this.ast);
                    }
                }
                while (true) {
                    int lhsOffset;
                    if ((lhsOffset = this.offsets[0]) == Integer.MIN_VALUE) {
                        throw RError.getNASubscripted(this.ast);
                    }
                    lhs.set(lhsOffset, rhs.getRef(rhsOffset));
                    if (++rhsOffset == replacementSize) {
                        if ((itemsToReplace -= replacementSize) == 0) break;
                        rhsOffset = 0;
                    }
                    Selector.advance(this.offsets, lhsDim, this.selectorVals, this.ast);
                }
            }
        }
        return lhs;
    }

    private static void checkCopyImplementation(RAny lhs, RAny rhs, int nSelectors, ASTNode ast) {
        if (!(lhs instanceof RArray)) {
            throw RError.getObjectNotSubsettable(ast, lhs.typeOf());
        }
        if (!(rhs instanceof RArray)) {
            UpdateArray.checkDimensions(((RArray)lhs).dimensions(), nSelectors, ast);
            throw RError.getNotMultipleReplacement(ast);
        }
    }

    private static void checkDimensions(int[] dim, int nSelectors, ASTNode ast) {
        if (dim == null || dim.length != nSelectors) {
            if (nSelectors == 2) {
                throw RError.getIncorrectSubscriptsMatrix(ast);
            }
            throw RError.getIncorrectSubscripts(ast);
        }
    }

    private static void checkReplacementSize(int itemsToReplace, int replacementSize, boolean subset, ASTNode ast) {
        if (itemsToReplace != replacementSize && replacementSize != 1) {
            if (replacementSize == 0) {
                throw RError.getReplacementZero(ast);
            }
            if (itemsToReplace % replacementSize != 0) {
                if (subset) {
                    throw RError.getNotMultipleReplacement(ast);
                }
                throw RError.getMoreElementsSupplied(ast);
            }
        }
    }

    protected static class ComplexToComplexDirect
    extends UpdateArray {
        protected ComplexToComplexDirect(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
            try {
                if (!(lhsParam instanceof ComplexImpl) || !(rhs instanceof ComplexImpl) || lhsParam.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                RAny lhs = lhsParam == rhs ? ValueCopy.COMPLEX_TO_COMPLEX_DIRECT.copy(lhsParam) : lhsParam;
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
            }
        }

        protected static RArray doUpdate(UpdateArray node, RArray lhs, RArray rhs) throws SpecializationException {
            block9: {
                int[] offsets = node.offsets;
                Selector[] selectorVals = node.selectorVals;
                int[] selSizes = node.selSizes;
                ASTNode ast = node.ast;
                assert (Utils.check(node.subset));
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, selectorVals.length, ast);
                boolean mayHaveNA = Selector.initialize(offsets, selectorVals, lhsDim, selSizes, ast);
                int itemsToReplace = Selector.calculateSizeFromSelectorSizes(selSizes);
                int replacementSize = rhs.size();
                UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
                double[] lhsVal = ((ComplexImpl)lhs).getContent();
                double[] rhsVal = ((ComplexImpl)rhs).getContent();
                if (itemsToReplace > 0) {
                    int rhsOffset = 0;
                    if (!mayHaveNA) {
                        while (true) {
                            int lhsOffset = offsets[0];
                            lhsVal[2 * lhsOffset] = rhsVal[2 * rhsOffset];
                            lhsVal[2 * lhsOffset + 1] = rhsVal[2 * rhsOffset + 1];
                            if (++rhsOffset == replacementSize) {
                                if ((itemsToReplace -= replacementSize) == 0) break block9;
                                rhsOffset = 0;
                            }
                            Selector.advanceNoNA(offsets, lhsDim, selectorVals, ast);
                        }
                    }
                    while (true) {
                        int lhsOffset;
                        if ((lhsOffset = offsets[0]) == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        lhsVal[2 * lhsOffset] = rhsVal[2 * rhsOffset];
                        lhsVal[2 * lhsOffset + 1] = rhsVal[2 * rhsOffset + 1];
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break;
                            rhsOffset = 0;
                        }
                        Selector.advance(offsets, lhsDim, selectorVals, ast);
                    }
                }
            }
            return lhs;
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return ComplexToComplexDirect.doUpdate(this, lhs, rhs);
        }
    }

    protected static class DoubleToComplexDirect
    extends UpdateArray {
        protected DoubleToComplexDirect(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
            try {
                if (!(lhsParam instanceof ComplexImpl) || !(rhs instanceof DoubleImpl) || lhsParam.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                RAny lhs = lhsParam;
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
            }
        }

        protected static RArray doUpdate(UpdateArray node, RArray lhs, RArray rhs) throws SpecializationException {
            block9: {
                int[] offsets = node.offsets;
                Selector[] selectorVals = node.selectorVals;
                int[] selSizes = node.selSizes;
                ASTNode ast = node.ast;
                assert (Utils.check(node.subset));
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, selectorVals.length, ast);
                boolean mayHaveNA = Selector.initialize(offsets, selectorVals, lhsDim, selSizes, ast);
                int itemsToReplace = Selector.calculateSizeFromSelectorSizes(selSizes);
                int replacementSize = rhs.size();
                UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
                double[] lhsVal = ((ComplexImpl)lhs).getContent();
                double[] rhsVal = ((DoubleImpl)rhs).getContent();
                if (itemsToReplace > 0) {
                    int rhsOffset = 0;
                    if (!mayHaveNA) {
                        while (true) {
                            int lhsOffset = offsets[0];
                            lhsVal[2 * lhsOffset] = rhsVal[rhsOffset];
                            lhsVal[2 * lhsOffset + 1] = 0.0;
                            if (++rhsOffset == replacementSize) {
                                if ((itemsToReplace -= replacementSize) == 0) break block9;
                                rhsOffset = 0;
                            }
                            Selector.advanceNoNA(offsets, lhsDim, selectorVals, ast);
                        }
                    }
                    while (true) {
                        int lhsOffset;
                        if ((lhsOffset = offsets[0]) == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        lhsVal[2 * lhsOffset] = rhsVal[rhsOffset];
                        lhsVal[2 * lhsOffset + 1] = 0.0;
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break;
                            rhsOffset = 0;
                        }
                        Selector.advance(offsets, lhsDim, selectorVals, ast);
                    }
                }
            }
            return lhs;
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return DoubleToComplexDirect.doUpdate(this, lhs, rhs);
        }
    }

    protected static class IntToComplexDirect
    extends UpdateArray {
        protected IntToComplexDirect(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
            try {
                if (!(lhsParam instanceof ComplexImpl) || !(rhs instanceof IntImpl) || lhsParam.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                RAny lhs = lhsParam;
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
            }
        }

        protected static RArray doUpdate(UpdateArray node, RArray lhs, RArray rhs) throws SpecializationException {
            block9: {
                int[] offsets = node.offsets;
                Selector[] selectorVals = node.selectorVals;
                int[] selSizes = node.selSizes;
                ASTNode ast = node.ast;
                assert (Utils.check(node.subset));
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, selectorVals.length, ast);
                boolean mayHaveNA = Selector.initialize(offsets, selectorVals, lhsDim, selSizes, ast);
                int itemsToReplace = Selector.calculateSizeFromSelectorSizes(selSizes);
                int replacementSize = rhs.size();
                UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
                double[] lhsVal = ((ComplexImpl)lhs).getContent();
                int[] rhsVal = ((IntImpl)rhs).getContent();
                if (itemsToReplace > 0) {
                    int rhsOffset = 0;
                    if (!mayHaveNA) {
                        while (true) {
                            int lhsOffset = offsets[0];
                            lhsVal[2 * lhsOffset] = rhsVal[rhsOffset];
                            lhsVal[2 * lhsOffset + 1] = 0.0;
                            if (++rhsOffset == replacementSize) {
                                if ((itemsToReplace -= replacementSize) == 0) break block9;
                                rhsOffset = 0;
                            }
                            Selector.advanceNoNA(offsets, lhsDim, selectorVals, ast);
                        }
                    }
                    while (true) {
                        int lhsOffset;
                        if ((lhsOffset = offsets[0]) == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        lhsVal[2 * lhsOffset] = rhsVal[rhsOffset];
                        lhsVal[2 * lhsOffset + 1] = 0.0;
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break;
                            rhsOffset = 0;
                        }
                        Selector.advance(offsets, lhsDim, selectorVals, ast);
                    }
                }
            }
            return lhs;
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return IntToComplexDirect.doUpdate(this, lhs, rhs);
        }
    }

    protected static class DoubleToDoubleDirect
    extends UpdateArray {
        protected DoubleToDoubleDirect(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
            try {
                if (!(lhsParam instanceof DoubleImpl) || !(rhs instanceof DoubleImpl) || lhsParam.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                RAny lhs = lhsParam == rhs ? ValueCopy.DOUBLE_TO_DOUBLE_DIRECT.copy(lhsParam) : lhsParam;
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
            }
        }

        protected static RArray doUpdate(UpdateArray node, RArray lhs, RArray rhs) throws SpecializationException {
            block9: {
                int[] offsets = node.offsets;
                Selector[] selectorVals = node.selectorVals;
                int[] selSizes = node.selSizes;
                ASTNode ast = node.ast;
                assert (Utils.check(node.subset));
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, selectorVals.length, ast);
                boolean mayHaveNA = Selector.initialize(offsets, selectorVals, lhsDim, selSizes, ast);
                int itemsToReplace = Selector.calculateSizeFromSelectorSizes(selSizes);
                int replacementSize = rhs.size();
                UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
                double[] lhsVal = ((DoubleImpl)lhs).getContent();
                double[] rhsVal = ((DoubleImpl)rhs).getContent();
                if (itemsToReplace > 0) {
                    int rhsOffset = 0;
                    if (!mayHaveNA) {
                        while (true) {
                            int lhsOffset = offsets[0];
                            lhsVal[lhsOffset] = rhsVal[rhsOffset];
                            if (++rhsOffset == replacementSize) {
                                if ((itemsToReplace -= replacementSize) == 0) break block9;
                                rhsOffset = 0;
                            }
                            Selector.advanceNoNA(offsets, lhsDim, selectorVals, ast);
                        }
                    }
                    while (true) {
                        int lhsOffset;
                        if ((lhsOffset = offsets[0]) == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        lhsVal[lhsOffset] = rhsVal[rhsOffset];
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break;
                            rhsOffset = 0;
                        }
                        Selector.advance(offsets, lhsDim, selectorVals, ast);
                    }
                }
            }
            return lhs;
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return DoubleToDoubleDirect.doUpdate(this, lhs, rhs);
        }
    }

    protected static class IntToDoubleDirect
    extends UpdateArray {
        protected IntToDoubleDirect(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
            try {
                if (!(lhsParam instanceof DoubleImpl) || !(rhs instanceof IntImpl) || lhsParam.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                RAny lhs = lhsParam;
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
            }
        }

        protected static RArray doUpdate(UpdateArray node, RArray lhs, RArray rhs) throws SpecializationException {
            block9: {
                int[] offsets = node.offsets;
                Selector[] selectorVals = node.selectorVals;
                int[] selSizes = node.selSizes;
                ASTNode ast = node.ast;
                assert (Utils.check(node.subset));
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, selectorVals.length, ast);
                boolean mayHaveNA = Selector.initialize(offsets, selectorVals, lhsDim, selSizes, ast);
                int itemsToReplace = Selector.calculateSizeFromSelectorSizes(selSizes);
                int replacementSize = rhs.size();
                UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
                double[] lhsVal = ((DoubleImpl)lhs).getContent();
                int[] rhsVal = ((IntImpl)rhs).getContent();
                if (itemsToReplace > 0) {
                    int rhsOffset = 0;
                    if (!mayHaveNA) {
                        while (true) {
                            int lhsOffset = offsets[0];
                            lhsVal[lhsOffset] = rhsVal[rhsOffset];
                            if (++rhsOffset == replacementSize) {
                                if ((itemsToReplace -= replacementSize) == 0) break block9;
                                rhsOffset = 0;
                            }
                            Selector.advanceNoNA(offsets, lhsDim, selectorVals, ast);
                        }
                    }
                    while (true) {
                        int lhsOffset;
                        if ((lhsOffset = offsets[0]) == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        lhsVal[lhsOffset] = rhsVal[rhsOffset];
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break;
                            rhsOffset = 0;
                        }
                        Selector.advance(offsets, lhsDim, selectorVals, ast);
                    }
                }
            }
            return lhs;
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return IntToDoubleDirect.doUpdate(this, lhs, rhs);
        }
    }

    protected static class IntToIntDirect
    extends UpdateArray {
        protected IntToIntDirect(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
            try {
                if (!(lhsParam instanceof IntImpl) || !(rhs instanceof IntImpl) || lhsParam.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                RAny lhs = lhsParam == rhs ? ValueCopy.INT_TO_INT_DIRECT.copy(lhsParam) : lhsParam;
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
            }
        }

        protected static RArray doUpdate(UpdateArray node, RArray lhs, RArray rhs) throws SpecializationException {
            block9: {
                int[] offsets = node.offsets;
                Selector[] selectorVals = node.selectorVals;
                int[] selSizes = node.selSizes;
                ASTNode ast = node.ast;
                assert (Utils.check(node.subset));
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, selectorVals.length, ast);
                boolean mayHaveNA = Selector.initialize(offsets, selectorVals, lhsDim, selSizes, ast);
                int itemsToReplace = Selector.calculateSizeFromSelectorSizes(selSizes);
                int replacementSize = rhs.size();
                UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
                int[] lhsVal = ((IntImpl)lhs).getContent();
                int[] rhsVal = ((IntImpl)rhs).getContent();
                if (itemsToReplace > 0) {
                    int rhsOffset = 0;
                    if (!mayHaveNA) {
                        while (true) {
                            int lhsOffset = offsets[0];
                            lhsVal[lhsOffset] = rhsVal[rhsOffset];
                            if (++rhsOffset == replacementSize) {
                                if ((itemsToReplace -= replacementSize) == 0) break block9;
                                rhsOffset = 0;
                            }
                            Selector.advanceNoNA(offsets, lhsDim, selectorVals, ast);
                        }
                    }
                    while (true) {
                        int lhsOffset;
                        if ((lhsOffset = offsets[0]) == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        lhsVal[lhsOffset] = rhsVal[rhsOffset];
                        if (++rhsOffset == replacementSize) {
                            if ((itemsToReplace -= replacementSize) == 0) break;
                            rhsOffset = 0;
                        }
                        Selector.advance(offsets, lhsDim, selectorVals, ast);
                    }
                }
            }
            return lhs;
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return IntToIntDirect.doUpdate(this, lhs, rhs);
        }
    }

    protected static class NonScalar
    extends UpdateArray {
        public NonScalar(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                if (lhs instanceof RLogical && rhs instanceof RLogical) {
                    return this.replace(new Logical(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof RInt && rhs instanceof RInt) {
                    return this.replace(new Integer(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof RDouble && rhs instanceof RDouble) {
                    return this.replace(new Double(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof RComplex && rhs instanceof RComplex) {
                    return this.replace(new Complex(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof RString && rhs instanceof RString) {
                    return this.replace(new String(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof RRaw && rhs instanceof RRaw) {
                    return this.replace(new Raw(this)).execute(frame, lhs, rhs);
                }
                if (lhs instanceof RList && rhs instanceof RList) {
                    return this.replace(new List(this)).execute(frame, lhs, rhs);
                }
                Utils.nyi();
                return null;
            }
        }

        protected static final class List
        extends NonScalar {
            public List(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RList) || !(rhs instanceof RList)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }

        protected static final class Raw
        extends NonScalar {
            public Raw(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RRaw) || !(rhs instanceof RRaw)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }

        protected static final class String
        extends NonScalar {
            public String(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RString) || !(rhs instanceof RString)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }

        protected static final class Complex
        extends NonScalar {
            public Complex(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RComplex) || !(rhs instanceof RComplex)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }

        protected static final class Double
        extends NonScalar {
            public Double(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RDouble) || !(rhs instanceof RDouble)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }

        protected static final class Integer
        extends NonScalar {
            public Integer(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RInt) || !(rhs instanceof RInt)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }

        protected static final class Logical
        extends NonScalar {
            public Logical(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(lhs instanceof RLogical) || !(rhs instanceof RLogical)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }
        }
    }

    public static class Scalar
    extends UpdateArray {
        public Scalar(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                if (rhs instanceof RInt) {
                    return this.replace(new Int(this)).execute(frame, lhs, rhs);
                }
                if (rhs instanceof RDouble) {
                    return this.replace(new Double(this)).execute(frame, lhs, rhs);
                }
                if (rhs instanceof RComplex) {
                    return this.replace(new Complex(this)).execute(frame, lhs, rhs);
                }
                if (rhs instanceof RLogical) {
                    return this.replace(new Logical(this)).execute(frame, lhs, rhs);
                }
                assert (Utils.check(rhs instanceof RString));
                return this.replace(new String(this)).execute(frame, lhs, rhs);
            }
        }

        public static class String
        extends Scalar {
            public String(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(rhs instanceof ScalarStringImpl) || !(lhs instanceof StringImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }

            @Override
            protected final RArray update(RArray lhs, RArray rhs) throws SpecializationException {
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, this.selectorExprs.length, this.ast);
                boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, lhsDim, this.selSizes, this.ast);
                int replacementSize = Selector.calculateSizeFromSelectorSizes(this.selSizes);
                if (replacementSize == 0) {
                    return lhs;
                }
                java.lang.String[] lhsVal = ((StringImpl)lhs).getContent();
                java.lang.String rhsVal = ((RString)rhs).getString(0);
                if (!mayHaveNA) {
                    while (true) {
                        int lhsOffset = this.offsets[0];
                        lhsVal[lhsOffset] = rhsVal;
                        if (--replacementSize == 0) {
                            return lhs;
                        }
                        Selector.advanceNoNA(this.offsets, lhsDim, this.selectorVals, this.ast);
                    }
                }
                while (true) {
                    int lhsOffset;
                    if ((lhsOffset = this.offsets[0]) != Integer.MIN_VALUE) {
                        lhsVal[lhsOffset] = rhsVal;
                    }
                    if (--replacementSize == 0) {
                        return lhs;
                    }
                    Selector.advance(this.offsets, lhsDim, this.selectorVals, this.ast);
                }
            }
        }

        public static class Complex
        extends Scalar {
            public Complex(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(rhs instanceof ScalarComplexImpl) || !(lhs instanceof ComplexImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }

            @Override
            protected final RArray update(RArray lhs, RArray rhs) throws SpecializationException {
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, this.selectorExprs.length, this.ast);
                boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, lhsDim, this.selSizes, this.ast);
                int replacementSize = Selector.calculateSizeFromSelectorSizes(this.selSizes);
                if (replacementSize == 0) {
                    return lhs;
                }
                double[] lhsVal = ((ComplexImpl)lhs).getContent();
                double re = ((RComplex)rhs).getReal(0);
                double im = ((RComplex)rhs).getImag(0);
                if (!mayHaveNA) {
                    while (true) {
                        int lhsOffset = this.offsets[0];
                        lhsVal[lhsOffset * 2] = re;
                        lhsVal[lhsOffset * 2 + 1] = im;
                        if (--replacementSize == 0) {
                            return lhs;
                        }
                        Selector.advanceNoNA(this.offsets, lhsDim, this.selectorVals, this.ast);
                    }
                }
                while (true) {
                    int lhsOffset;
                    if ((lhsOffset = this.offsets[0]) != Integer.MIN_VALUE) {
                        lhsVal[lhsOffset * 2] = re;
                        lhsVal[lhsOffset * 2 + 1] = im;
                    }
                    if (--replacementSize == 0) {
                        return lhs;
                    }
                    Selector.advance(this.offsets, lhsDim, this.selectorVals, this.ast);
                }
            }
        }

        public static class Double
        extends Scalar {
            public Double(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(rhs instanceof ScalarDoubleImpl) || !(lhs instanceof DoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }

            @Override
            protected final RArray update(RArray lhs, RArray rhs) throws SpecializationException {
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, this.selectorExprs.length, this.ast);
                boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, lhsDim, this.selSizes, this.ast);
                int replacementSize = Selector.calculateSizeFromSelectorSizes(this.selSizes);
                if (replacementSize == 0) {
                    return lhs;
                }
                double[] lhsVal = ((DoubleImpl)lhs).getContent();
                double rhsVal = ((RDouble)rhs).getDouble(0);
                if (!mayHaveNA) {
                    while (true) {
                        int lhsOffset = this.offsets[0];
                        lhsVal[lhsOffset] = rhsVal;
                        if (--replacementSize == 0) {
                            return lhs;
                        }
                        Selector.advanceNoNA(this.offsets, lhsDim, this.selectorVals, this.ast);
                    }
                }
                while (true) {
                    int lhsOffset;
                    if ((lhsOffset = this.offsets[0]) != Integer.MIN_VALUE) {
                        lhsVal[lhsOffset] = rhsVal;
                    }
                    if (--replacementSize == 0) {
                        return lhs;
                    }
                    Selector.advance(this.offsets, lhsDim, this.selectorVals, this.ast);
                }
            }
        }

        public static class Int
        extends Scalar {
            public Int(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(rhs instanceof ScalarIntImpl) || !(lhs instanceof IntImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }

            @Override
            protected final RArray update(RArray lhs, RArray rhs) throws SpecializationException {
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, this.selectorExprs.length, this.ast);
                boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, lhsDim, this.selSizes, this.ast);
                int replacementSize = Selector.calculateSizeFromSelectorSizes(this.selSizes);
                if (replacementSize == 0) {
                    return lhs;
                }
                int[] lhsVal = ((IntImpl)lhs).getContent();
                int rhsVal = ((RInt)rhs).getInt(0);
                if (!mayHaveNA) {
                    while (true) {
                        int lhsOffset = this.offsets[0];
                        lhsVal[lhsOffset] = rhsVal;
                        if (--replacementSize == 0) {
                            return lhs;
                        }
                        Selector.advanceNoNA(this.offsets, lhsDim, this.selectorVals, this.ast);
                    }
                }
                while (true) {
                    int lhsOffset;
                    if ((lhsOffset = this.offsets[0]) != Integer.MIN_VALUE) {
                        lhsVal[lhsOffset] = rhsVal;
                    }
                    if (--replacementSize == 0) {
                        return lhs;
                    }
                    Selector.advance(this.offsets, lhsDim, this.selectorVals, this.ast);
                }
            }
        }

        public static class Logical
        extends Scalar {
            public Logical(UpdateArray other) {
                super(other);
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhs) {
                try {
                    if (!(rhs instanceof ScalarLogicalImpl) || !(lhs instanceof LogicalImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
            }

            @Override
            protected final RArray update(RArray lhs, RArray rhs) throws SpecializationException {
                int[] lhsDim = lhs.dimensions();
                UpdateArray.checkDimensions(lhsDim, this.selectorExprs.length, this.ast);
                boolean mayHaveNA = Selector.initialize(this.offsets, this.selectorVals, lhsDim, this.selSizes, this.ast);
                int replacementSize = Selector.calculateSizeFromSelectorSizes(this.selSizes);
                if (replacementSize == 0) {
                    return lhs;
                }
                int[] lhsVal = ((LogicalImpl)lhs).getContent();
                int rhsVal = ((RLogical)rhs).getLogical(0);
                if (!mayHaveNA) {
                    while (true) {
                        int lhsOffset = this.offsets[0];
                        lhsVal[lhsOffset] = rhsVal;
                        if (--replacementSize == 0) {
                            return lhs;
                        }
                        Selector.advanceNoNA(this.offsets, lhsDim, this.selectorVals, this.ast);
                    }
                }
                while (true) {
                    int lhsOffset;
                    if ((lhsOffset = this.offsets[0]) != Integer.MIN_VALUE) {
                        lhsVal[lhsOffset] = rhsVal;
                    }
                    if (--replacementSize == 0) {
                        return lhs;
                    }
                    Selector.advance(this.offsets, lhsDim, this.selectorVals, this.ast);
                }
            }
        }
    }

    protected static final class MatrixScalarIndex
    extends UpdateArray {
        final BinaryTypeGuard guard;

        public MatrixScalarIndex(UpdateArray other, BinaryTypeGuard guard) {
            super(other);
            this.guard = guard;
        }

        public static MatrixScalarIndex create(UpdateArray other, RAny leftTemplate, RAny rightTemplate) {
            BinaryTypeGuard g = BinaryTypeGuard.create(leftTemplate, rightTemplate);
            return new MatrixScalarIndex(other, g);
        }

        public static boolean isMatrixScalar(Selector.SelectorNode[] selNodes, Frame frame) {
            boolean result;
            boolean replace;
            Object jval;
            Object ival;
            if (selNodes.length != 2) {
                return false;
            }
            RNode ichild = selNodes[0].child;
            RNode jchild = selNodes[1].child;
            if (ichild == null || jchild == null) {
                return false;
            }
            if (ichild instanceof RNode.PushbackNode && jchild instanceof RNode.PushbackNode) {
                ival = ((RNode.PushbackNode)ichild).nextValue;
                jval = ((RNode.PushbackNode)jchild).nextValue;
                replace = false;
            } else {
                ival = ichild.execute(frame);
                jval = jchild.execute(frame);
                replace = true;
            }
            try {
                MatrixScalarIndex.extractIndex(ival);
                MatrixScalarIndex.extractIndex(jval);
                result = true;
            }
            catch (SpecializationException e) {
                result = false;
            }
            if (replace) {
                selNodes[0].pushBack(selNodes[0].child, ival);
                selNodes[1].pushBack(selNodes[1].child, jval);
            }
            return result;
        }

        public static int extractIndex(Object val) throws SpecializationException {
            double d;
            if (val instanceof ScalarIntImpl) {
                int i = ((ScalarIntImpl)val).getInt();
                if (i > 0) {
                    return i - 1;
                }
            } else if (val instanceof ScalarDoubleImpl && (d = ((ScalarDoubleImpl)val).getDouble()) > 0.0 && d <= 2.147483647E9) {
                return (int)d - 1;
            }
            throw new SpecializationException((Object)null);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsArg, RAny rhsArg) {
            RArray lhs = (RArray)Utils.cast(lhsArg);
            RArray rhs = (RArray)Utils.cast(rhsArg);
            try {
                if (lhs.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                this.guard.check(lhs, rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
            }
            Object ival = this.selectorExprs[0].child.execute(frame);
            Object jval = this.selectorExprs[1].child.execute(frame);
            try {
                int i = MatrixScalarIndex.extractIndex(ival);
                int j = MatrixScalarIndex.extractIndex(jval);
                int[] dim = lhs.dimensions();
                if (dim == null || dim.length != 2 || rhs.size() != 1) {
                    throw new SpecializationException((Object)null);
                }
                int m = dim[0];
                int n = dim[1];
                if (i >= m || j >= n) {
                    throw new SpecializationException((Object)null);
                }
                return lhs.set(j * m + i, rhs.get(0));
            }
            catch (SpecializationException e) {
                this.selectorExprs[0].pushBack(this.selectorExprs[0].child, ival);
                this.selectorExprs[1].pushBack(this.selectorExprs[1].child, jval);
                if (rhs.size() == 1 && !(rhs instanceof RList) && !(rhs instanceof RRaw)) {
                    return this.replace(new Scalar(this)).execute(frame, lhs, rhs);
                }
                return this.replace(new NonScalar(this)).execute(frame, lhs, rhs);
            }
        }

        public static RArray doUpdate(RArray lhs, RArray rhs, Selector[] selectorVals, ASTNode ast) throws SpecializationException {
            Utils.nyi("unreachable");
            return null;
        }

        @Override
        public RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            Utils.nyi("unreachable");
            return null;
        }
    }

    protected static final class Column
    extends UpdateArray {
        final BinaryTypeGuard guard;

        public Column(UpdateArray other, BinaryTypeGuard guard) {
            super(other);
            assert (Utils.check(other.subset));
            this.guard = guard;
        }

        public static Column create(UpdateArray other, RAny leftTemplate, RAny rightTemplate) {
            BinaryTypeGuard g = BinaryTypeGuard.create(leftTemplate, rightTemplate);
            return new Column(other, g);
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                this.guard.check(lhs, rhs);
                if (lhs.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                int lastSel = this.selectorVals.length - 1;
                Selector columnSel = this.selectorExprs[lastSel].executeSelector(frame);
                while (true) {
                    try {
                        return this.update((RArray)lhs, (RArray)rhs, columnSel);
                    }
                    catch (SpecializationException e) {
                        RAny index = columnSel.getIndex();
                        Selector.SelectorNode newSelector = Selector.createSelectorNode(this.ast, this.subset, index, this.selectorExprs[lastSel].child, false, columnSel.getTransition());
                        this.selectorExprs[lastSel].replace(newSelector);
                        assert (Utils.check(this.selectorExprs[lastSel] == newSelector));
                        columnSel = newSelector.executeSelector(index);
                        continue;
                    }
                    break;
                }
            }
            catch (SpecializationException e) {
                return Generic.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
            }
        }

        public static RArray doUpdate(RArray lhs, RArray rhs, int nSelectors, Selector columnSelector, ASTNode ast) throws SpecializationException {
            int[] dim = lhs.dimensions();
            UpdateArray.checkDimensions(dim, nSelectors, ast);
            int n = dim[nSelectors - 1];
            int m = 1;
            for (int i = 0; i < nSelectors - 1; ++i) {
                m *= dim[i];
            }
            columnSelector.start(n, ast);
            int ncolumns = columnSelector.size();
            int replacementSize = rhs.size();
            int itemsToReplace = ncolumns * m;
            UpdateArray.checkReplacementSize(itemsToReplace, replacementSize, true, ast);
            if (itemsToReplace > 0) {
                int rhsOffset = 0;
                for (int j = 0; j < ncolumns; ++j) {
                    int col = columnSelector.nextIndex(ast);
                    if (col == Integer.MIN_VALUE) continue;
                    int lhsOffset = col * m;
                    for (int i = 0; i < m; ++i) {
                        lhs.set(lhsOffset + i, rhs.getRef(rhsOffset++));
                        if (rhsOffset != replacementSize) continue;
                        rhsOffset = 0;
                    }
                }
            }
            return lhs;
        }

        public RArray update(RArray lhs, RArray rhs, Selector columnSelector) throws SpecializationException {
            return Column.doUpdate(lhs, rhs, this.selectorExprs.length, columnSelector, this.ast);
        }

        @Override
        public RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            Utils.nyi("unreachable");
            return null;
        }
    }

    protected static final class Subscript
    extends UpdateArray {
        final BinaryTypeGuard guard;

        public Subscript(UpdateArray other, BinaryTypeGuard guard) {
            super(other);
            assert (Utils.check(!other.subset));
            this.guard = guard;
        }

        public static Subscript create(UpdateArray other, RAny leftTemplate, RAny rightTemplate) {
            BinaryTypeGuard g = BinaryTypeGuard.create(leftTemplate, rightTemplate);
            return new Subscript(other, g);
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                this.guard.check(lhs, rhs);
                return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
            }
            catch (SpecializationException e) {
                return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
            }
        }

        public static RArray doUpdate(RArray lhs, RArray rhs, Selector[] selectorVals, ASTNode ast) throws SpecializationException {
            int[] dim = lhs.dimensions();
            UpdateArray.checkDimensions(dim, selectorVals.length, ast);
            int mult = 1;
            int offset = 0;
            UpdateArray.checkReplacementSize(lhs.size(), rhs.size(), false, ast);
            for (int i = 0; i < selectorVals.length; ++i) {
                Selector s = selectorVals[i];
                s.start(dim[i], ast);
                int k = s.nextIndex(ast);
                assert (Utils.check(k != Integer.MIN_VALUE));
                offset += k * mult;
                mult *= dim[i];
            }
            return lhs.set(offset, rhs instanceof RList ? rhs : rhs.get(0));
        }

        @Override
        public RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return Subscript.doUpdate(lhs, rhs, this.selectorVals, this.ast);
        }
    }

    public static abstract class BinaryTypeGuard {
        abstract void check(RAny var1, RAny var2) throws SpecializationException;

        public static BinaryTypeGuard create(RAny leftTemplate, RAny rightTemplate) {
            if (leftTemplate instanceof RString && rightTemplate instanceof RString) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RString) || !(rhs instanceof RString)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (leftTemplate instanceof RComplex && rightTemplate instanceof RComplex) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RComplex) || !(rhs instanceof RComplex)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (leftTemplate instanceof RDouble && rightTemplate instanceof RDouble) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RDouble) || !(rhs instanceof RDouble)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (leftTemplate instanceof RInt && rightTemplate instanceof RInt) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RInt) || !(rhs instanceof RInt)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (leftTemplate instanceof RLogical && rightTemplate instanceof RLogical) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RLogical) || !(rhs instanceof RLogical)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (leftTemplate instanceof RRaw && rightTemplate instanceof RRaw) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RRaw) || !(rhs instanceof RRaw)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (leftTemplate instanceof RList && rightTemplate instanceof RList) {
                return new BinaryTypeGuard(){

                    @Override
                    void check(RAny lhs, RAny rhs) throws SpecializationException {
                        if (!(lhs instanceof RList) || !(rhs instanceof RList)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            assert (Utils.check(false, "unreachable"));
            return null;
        }
    }

    protected static class CopyRhs
    extends UpdateArray {
        @RNode.Child
        UpdateArray child;

        public CopyRhs(UpdateArray child) {
            super(child);
            this.child = this.adoptChild(child);
        }

        public CopyRhs(CopyRhs other) {
            super(other);
            this.child = this.adoptChild(other.child);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.child == oldNode) {
                this.child = (UpdateArray)newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        protected static ValueCopy.Impl determineCopyImplementation(RAny lhs, RAny rhs, int nSelectors, ASTNode ast) {
            UpdateArray.checkCopyImplementation(lhs, rhs, nSelectors, ast);
            RAny.Mode lhsMode = ValueCopy.valueMode(lhs);
            RAny.Mode rhsMode = ValueCopy.valueMode(rhs);
            block0 : switch (lhsMode) {
                case INT: {
                    if (rhsMode != RAny.Mode.LOGICAL) break;
                    return ValueCopy.LOGICAL_TO_INT;
                }
                case DOUBLE: {
                    switch (rhsMode) {
                        case LOGICAL: {
                            return ValueCopy.LOGICAL_TO_DOUBLE;
                        }
                        case INT: {
                            return rhs instanceof IntImpl ? ValueCopy.INT_TO_DOUBLE_DIRECT : ValueCopy.INT_TO_DOUBLE;
                        }
                    }
                    break;
                }
                case COMPLEX: {
                    switch (rhsMode) {
                        case LOGICAL: {
                            return ValueCopy.LOGICAL_TO_COMPLEX;
                        }
                        case INT: {
                            return rhs instanceof IntImpl ? ValueCopy.INT_TO_COMPLEX_DIRECT : ValueCopy.INT_TO_COMPLEX;
                        }
                        case DOUBLE: {
                            return rhs instanceof DoubleImpl ? ValueCopy.DOUBLE_TO_COMPLEX_DIRECT : ValueCopy.DOUBLE_TO_COMPLEX;
                        }
                    }
                    break;
                }
                case STRING: {
                    switch (rhsMode) {
                        case LOGICAL: {
                            return ValueCopy.LOGICAL_TO_STRING;
                        }
                        case INT: {
                            return ValueCopy.INT_TO_STRING;
                        }
                        case DOUBLE: {
                            return ValueCopy.DOUBLE_TO_STRING;
                        }
                        case COMPLEX: {
                            return ValueCopy.COMPLEX_TO_STRING;
                        }
                    }
                    break;
                }
                case LIST: {
                    switch (rhsMode) {
                        case LIST: {
                            break block0;
                        }
                    }
                    return ValueCopy.NONLIST_TO_LIST;
                }
            }
            return null;
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                ValueCopy.Impl impl = CopyRhs.determineCopyImplementation(lhs, rhs, this.selectorExprs.length, this.ast);
                if (impl == null) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
                return this.replace(new Specialized(this, impl, TypeGuard.create(lhs))).execute(frame, lhs, rhs);
            }
        }

        protected static class Specialized
        extends CopyRhs {
            final ValueCopy.Impl impl;
            final TypeGuard lhsTypeGuard;

            public Specialized(CopyRhs other, ValueCopy.Impl impl, TypeGuard lhsTypeGuard) {
                super(other);
                this.impl = impl;
                this.lhsTypeGuard = lhsTypeGuard;
            }

            @Override
            public RAny execute(Frame frame, RAny lhs, RAny rhsParam) {
                RAny rhs;
                try {
                    this.lhsTypeGuard.check(lhs);
                    rhs = this.impl.copy(rhsParam);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhsParam);
                }
                return this.child.execute(frame, lhs, rhs);
            }
        }
    }

    public static abstract class TypeGuard {
        abstract void check(RAny var1) throws SpecializationException;

        public static TypeGuard create(RAny valueTemplate) {
            if (valueTemplate instanceof RList) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RList)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RString) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RString)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RComplex) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RComplex)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RDouble) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RDouble)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RInt) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RInt)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RLogical) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RLogical)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RRaw) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RRaw)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            if (valueTemplate instanceof RNull) {
                return new TypeGuard(){

                    @Override
                    void check(RAny value) throws SpecializationException {
                        if (!(value instanceof RNull)) {
                            throw new SpecializationException((Object)null);
                        }
                    }
                };
            }
            assert (Utils.check(false, "unreachable"));
            return null;
        }
    }

    protected static class CopyLhs
    extends UpdateArray {
        @RNode.Child
        UpdateArray child;

        public CopyLhs(UpdateArray child) {
            super(child);
            this.child = this.adoptChild(child);
        }

        public CopyLhs(CopyLhs other) {
            super(other);
            this.child = this.adoptChild(other.child);
        }

        @Override
        protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
            assert (oldNode != null);
            if (this.child == oldNode) {
                this.child = (UpdateArray)newNode;
                return this.adoptInternal(newNode);
            }
            return super.replaceChild(oldNode, newNode);
        }

        protected static ValueCopy.Impl determineCopyImplementation(RAny lhs, RAny rhs, int nSelectors, boolean subset, ASTNode ast) {
            UpdateArray.checkCopyImplementation(lhs, rhs, nSelectors, ast);
            RAny.Mode rhsMode = ValueCopy.valueMode(rhs);
            RAny.Mode lhsMode = ValueCopy.valueMode(lhs);
            block0 : switch (rhsMode) {
                case RAW: {
                    switch (lhsMode) {
                        case RAW: {
                            return ValueCopy.RAW_TO_RAW;
                        }
                        case LIST: {
                            return ValueCopy.NONLIST_TO_LIST;
                        }
                    }
                    throw RError.getSubassignTypeFix(ast, rhs.typeOf(), lhs.typeOf());
                }
                case LOGICAL: {
                    break;
                }
                case INT: {
                    if (lhsMode != RAny.Mode.LOGICAL) break;
                    return ValueCopy.LOGICAL_TO_INT;
                }
                case DOUBLE: {
                    switch (lhsMode) {
                        case LOGICAL: {
                            return ValueCopy.LOGICAL_TO_DOUBLE;
                        }
                        case INT: {
                            return lhs instanceof IntImpl ? ValueCopy.INT_TO_DOUBLE_DIRECT : ValueCopy.INT_TO_DOUBLE;
                        }
                    }
                    break;
                }
                case COMPLEX: {
                    switch (lhsMode) {
                        case LOGICAL: {
                            return ValueCopy.LOGICAL_TO_COMPLEX;
                        }
                        case INT: {
                            return lhs instanceof IntImpl ? ValueCopy.INT_TO_COMPLEX_DIRECT : ValueCopy.INT_TO_COMPLEX;
                        }
                        case DOUBLE: {
                            return lhs instanceof DoubleImpl ? ValueCopy.DOUBLE_TO_COMPLEX_DIRECT : ValueCopy.DOUBLE_TO_COMPLEX;
                        }
                    }
                    break;
                }
                case STRING: {
                    switch (lhsMode) {
                        case LOGICAL: {
                            return ValueCopy.LOGICAL_TO_STRING;
                        }
                        case INT: {
                            return ValueCopy.INT_TO_STRING;
                        }
                        case DOUBLE: {
                            return ValueCopy.DOUBLE_TO_STRING;
                        }
                        case COMPLEX: {
                            return ValueCopy.COMPLEX_TO_STRING;
                        }
                    }
                    break;
                }
                case LIST: {
                    switch (lhsMode) {
                        case LIST: {
                            break block0;
                        }
                    }
                    return ValueCopy.NONLIST_TO_LIST;
                }
                case NULL: {
                    if (lhsMode == RAny.Mode.NULL) break;
                    if (subset) {
                        throw RError.getMoreElementsSupplied(ast);
                    }
                    throw RError.getNotMultipleReplacement(ast);
                }
                default: {
                    assert (Utils.check(false, "unreachable"));
                    break;
                }
            }
            switch (lhsMode) {
                case LOGICAL: {
                    return ValueCopy.LOGICAL_TO_LOGICAL;
                }
                case INT: {
                    return lhs instanceof IntImpl ? ValueCopy.INT_TO_INT_DIRECT : ValueCopy.INT_TO_INT;
                }
                case DOUBLE: {
                    return lhs instanceof DoubleImpl ? ValueCopy.DOUBLE_TO_DOUBLE_DIRECT : ValueCopy.DOUBLE_TO_DOUBLE;
                }
                case COMPLEX: {
                    return lhs instanceof ComplexImpl ? ValueCopy.COMPLEX_TO_COMPLEX_DIRECT : ValueCopy.COMPLEX_TO_COMPLEX;
                }
                case STRING: {
                    return ValueCopy.STRING_TO_STRING;
                }
                case LIST: {
                    return ValueCopy.LIST_TO_LIST;
                }
                case NULL: {
                    return ValueCopy.NULL_TO_NULL;
                }
            }
            throw RError.getSubassignTypeFix(ast, rhs.typeOf(), lhs.typeOf());
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                ValueCopy.Impl copy = CopyLhs.determineCopyImplementation(lhs, rhs, this.selectorExprs.length, !this.subset, this.ast);
                if (copy instanceof ValueCopy.Duplicate) {
                    return this.replace(new SpecializedDuplicate(this, (ValueCopy.Duplicate)copy)).execute(frame, lhs, rhs);
                }
                return this.replace(new Specialized(this, copy, TypeGuard.create(rhs))).execute(frame, lhs, rhs);
            }
        }

        protected static class SpecializedDuplicate
        extends CopyLhs {
            final ValueCopy.Duplicate impl;

            public SpecializedDuplicate(CopyLhs other, ValueCopy.Duplicate copy) {
                super(other);
                assert (Utils.check(!(this.child instanceof CopyRhs)));
                this.impl = copy;
            }

            @Override
            public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
                RAny lhs;
                if (lhsParam.isShared() || rhs.dependsOn(lhsParam)) {
                    try {
                        lhs = this.impl.copy(lhsParam);
                    }
                    catch (SpecializationException e) {
                        return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhsParam, rhs);
                    }
                } else {
                    lhs = lhsParam;
                }
                return this.child.execute(frame, lhs, rhs);
            }
        }

        protected static class Specialized
        extends CopyLhs {
            final ValueCopy.Impl impl;
            final TypeGuard rhsTypeGuard;

            public Specialized(CopyLhs other, ValueCopy.Impl copy, TypeGuard rhsTypeGuard) {
                super(other);
                this.impl = copy;
                this.rhsTypeGuard = rhsTypeGuard;
            }

            @Override
            public RAny execute(Frame frame, RAny lhsParam, RAny rhs) {
                RAny lhs = lhsParam;
                try {
                    this.rhsTypeGuard.check(rhs);
                    lhs = this.impl.copy(lhs);
                }
                catch (SpecializationException e) {
                    return GenericSubset.replaceArrayUpdateTree(this).execute(frame, lhs, rhs);
                }
                return this.child.execute(frame, lhs, rhs);
            }
        }
    }

    protected static abstract class Generic
    extends UpdateArray {
        public Generic(UpdateArray other) {
            super(other);
        }

        public static Generic replaceArrayUpdateTree(UpdateArray tree) {
            RNode root = tree;
            if (root.getParent() instanceof CopyRhs) {
                root = root.getParent();
            }
            if (root.getParent() instanceof CopyLhs) {
                root = root.getParent();
            }
            if (tree.subset) {
                return root.replace(new GenericSubset(tree));
            }
            return root.replace(new GenericSubscript(tree));
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhsParam) {
            RAny rhs;
            RAny lhs;
            block9: {
                ValueCopy.Impl lhsImpl;
                block8: {
                    lhs = lhsParam;
                    rhs = rhsParam;
                    ValueCopy.Impl rhsImpl = CopyRhs.determineCopyImplementation(lhs, rhs, this.selectorExprs.length, this.ast);
                    if (rhsImpl != null) {
                        try {
                            rhs = rhsImpl.copy(rhs);
                        }
                        catch (SpecializationException e) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)"unreachable");
                        }
                    }
                }
                if (!((lhsImpl = CopyLhs.determineCopyImplementation(lhs, rhs, this.selectorExprs.length, !this.subset, this.ast)) instanceof ValueCopy.Duplicate) || lhs.isShared() || rhs.dependsOn(lhs)) {
                    try {
                        lhs = lhsImpl.copy(lhs);
                    }
                    catch (SpecializationException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError((Object)"unreachable");
                    }
                }
            }
            assert (Utils.check(lhs instanceof RInt && rhs instanceof RInt || lhs instanceof RDouble && rhs instanceof RDouble || lhs instanceof RLogical && rhs instanceof RLogical || lhs instanceof RComplex && rhs instanceof RComplex || lhs instanceof RString && rhs instanceof RString || lhs instanceof RRaw && rhs instanceof RRaw || lhs instanceof RList && rhs instanceof RList || lhs instanceof RNull && rhs instanceof RNull, "Unable to perform the update of the array - unimplemented copy"));
            if (lhs instanceof RNull && rhs instanceof RNull) {
                return lhs;
            }
            return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
        }
    }

    protected static class GenericSubscript
    extends Generic {
        public GenericSubscript(UpdateArray other) {
            super(other);
            assert (Utils.check(!other.subset));
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            return Subscript.doUpdate(lhs, rhs, this.selectorVals, this.ast);
        }
    }

    protected static class GenericSubset
    extends Generic {
        UpdateType updateType = UpdateType.GENERALIZED;

        public GenericSubset(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhsParam, RAny rhsParam) {
            RAny lhs = lhsParam;
            RAny rhs = rhsParam;
            if (!lhs.isShared()) {
                switch (this.updateType) {
                    case INT_TO_INT_DIRECT: {
                        if (lhs == rhs || !(lhs instanceof IntImpl) || !(rhs instanceof IntImpl)) break;
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                    case INT_TO_DOUBLE_DIRECT: {
                        if (lhs == rhs || !(lhs instanceof DoubleImpl) || !(rhs instanceof IntImpl)) break;
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                    case DOUBLE_TO_DOUBLE_DIRECT: {
                        if (lhs == rhs || !(lhs instanceof DoubleImpl) || !(rhs instanceof DoubleImpl)) break;
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                    case INT_TO_COMPLEX_DIRECT: {
                        if (lhs == rhs || !(lhs instanceof ComplexImpl) || !(rhs instanceof IntImpl)) break;
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                    case DOUBLE_TO_COMPLEX_DIRECT: {
                        if (lhs == rhs || !(lhs instanceof ComplexImpl) || !(rhs instanceof DoubleImpl)) break;
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                    case COMPLEX_TO_COMPLEX_DIRECT: {
                        if (lhs == rhs || !(lhs instanceof ComplexImpl) || !(rhs instanceof ComplexImpl)) break;
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                }
                this.updateType = UpdateType.GENERALIZED;
                if (lhs != rhs) {
                    if (lhs instanceof IntImpl && rhs instanceof IntImpl) {
                        this.updateType = UpdateType.INT_TO_INT_DIRECT;
                    } else if (lhs instanceof DoubleImpl) {
                        if (rhs instanceof IntImpl) {
                            this.updateType = UpdateType.INT_TO_DOUBLE_DIRECT;
                        } else if (rhs instanceof DoubleImpl) {
                            this.updateType = UpdateType.DOUBLE_TO_DOUBLE_DIRECT;
                        }
                    } else if (lhs instanceof ComplexImpl) {
                        if (rhs instanceof IntImpl) {
                            this.updateType = UpdateType.INT_TO_COMPLEX_DIRECT;
                        } else if (rhs instanceof DoubleImpl) {
                            this.updateType = UpdateType.DOUBLE_TO_COMPLEX_DIRECT;
                        } else if (rhs instanceof ComplexImpl) {
                            this.updateType = UpdateType.COMPLEX_TO_COMPLEX_DIRECT;
                        }
                    }
                    if (this.updateType != UpdateType.GENERALIZED) {
                        return this.executeAndUpdateSelectors(frame, (RArray)lhs, (RArray)rhs);
                    }
                }
            }
            return super.execute(frame, lhs, rhs);
        }

        @Override
        protected RArray update(RArray lhs, RArray rhs) throws SpecializationException {
            switch (this.updateType) {
                case INT_TO_INT_DIRECT: {
                    return IntToIntDirect.doUpdate(this, lhs, rhs);
                }
                case INT_TO_DOUBLE_DIRECT: {
                    return IntToDoubleDirect.doUpdate(this, lhs, rhs);
                }
                case DOUBLE_TO_DOUBLE_DIRECT: {
                    return DoubleToDoubleDirect.doUpdate(this, lhs, rhs);
                }
                case INT_TO_COMPLEX_DIRECT: {
                    return IntToComplexDirect.doUpdate(this, lhs, rhs);
                }
                case DOUBLE_TO_COMPLEX_DIRECT: {
                    return DoubleToComplexDirect.doUpdate(this, lhs, rhs);
                }
                case COMPLEX_TO_COMPLEX_DIRECT: {
                    return ComplexToComplexDirect.doUpdate(this, lhs, rhs);
                }
            }
            return super.update(lhs, rhs);
        }

        static enum UpdateType {
            GENERALIZED,
            INT_TO_INT_DIRECT,
            INT_TO_DOUBLE_DIRECT,
            DOUBLE_TO_DOUBLE_DIRECT,
            INT_TO_COMPLEX_DIRECT,
            DOUBLE_TO_COMPLEX_DIRECT,
            COMPLEX_TO_COMPLEX_DIRECT;

        }
    }

    protected static class IdenticalTypes
    extends UpdateArray {
        public IdenticalTypes(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                if (!this.subset) {
                    return this.replace(Subscript.create(this, lhs, rhs)).execute(frame, lhs, rhs);
                }
                if (this.column) {
                    return this.replace(Column.create(this, lhs, rhs)).execute(frame, lhs, rhs);
                }
                if (MatrixScalarIndex.isMatrixScalar(this.selectorExprs, frame)) {
                    return this.replace(MatrixScalarIndex.create(this, lhs, rhs)).execute(frame, lhs, rhs);
                }
                assert (Utils.check(rhs instanceof RArray));
                if (((RArray)rhs).size() == 1 && !(rhs instanceof RList) && !(rhs instanceof RRaw)) {
                    return this.replace(new Scalar(this)).execute(frame, lhs, rhs);
                }
                return this.replace(new NonScalar(this)).execute(frame, lhs, rhs);
            }
        }
    }

    protected static class RHSCompatible
    extends UpdateArray {
        public RHSCompatible(UpdateArray other) {
            super(other);
        }

        @Override
        public RAny execute(Frame frame, RAny lhs, RAny rhs) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                if (lhs instanceof RDouble && rhs instanceof RDouble || lhs instanceof RInt && rhs instanceof RInt || lhs instanceof RLogical && rhs instanceof RLogical || lhs instanceof RString && rhs instanceof RString || lhs instanceof RComplex && rhs instanceof RComplex || lhs instanceof RRaw && rhs instanceof RRaw || lhs instanceof RList && rhs instanceof RList) {
                    return this.replace(new IdenticalTypes(this)).execute(frame, lhs, rhs);
                }
                return this.replace(new CopyRhs(new IdenticalTypes(this))).execute(frame, lhs, rhs);
            }
        }
    }
}

