/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.data.RAny;
import r.data.RFunction;
import r.data.RSymbol;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.Constant;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class UpdateArrayAssignment
extends BaseR {
    final RSymbol varName;
    @RNode.Child
    RNode rhs;
    @RNode.Child
    AssignmentNode assignment;

    public static UpdateArrayAssignment create(ASTNode ast, RSymbol varName, RFunction enclosingFunction, int varSlot, RNode rhs, AssignmentNode assignment) {
        boolean topLevel;
        boolean bl = topLevel = enclosingFunction == null;
        if (topLevel) {
            if (rhs instanceof Constant) {
                return new ConstTopLevel(ast, varName, rhs, assignment, ((Constant)rhs).value());
            }
            return new TopLevel(ast, varName, rhs, assignment);
        }
        if (varSlot != -1) {
            return new LocalInitial(ast, varName, varSlot, rhs, assignment);
        }
        return new Dynamic(ast, varName, rhs, assignment);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.rhs == oldNode) {
            this.rhs = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.assignment == oldNode) {
            this.assignment = (AssignmentNode)newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    protected UpdateArrayAssignment(ASTNode orig, RSymbol varName, RNode rhs, AssignmentNode assignment) {
        super(orig);
        this.varName = varName;
        this.rhs = this.adoptChild(rhs);
        this.assignment = this.adoptChild(assignment);
    }

    protected static final class Dynamic
    extends UpdateArrayAssignment {
        protected Dynamic(ASTNode orig, RSymbol varName, RNode rhs, AssignmentNode assignment) {
            super(orig, varName, rhs, assignment);
        }

        @Override
        public Object execute(Frame frame) {
            RAny rhsValue = (RAny)this.rhs.execute(frame);
            RAny lhsValue = (RAny)Utils.cast(frame.read(this.varName));
            if (lhsValue == null) {
                throw RError.getUnknownVariable(this.ast, this.varName);
            }
            lhsValue.ref();
            RAny newLhs = this.assignment.execute(frame, lhsValue, rhsValue);
            assert (Utils.check(lhsValue != newLhs));
            frame.writeToExtension(this.varName, newLhs);
            return rhsValue;
        }
    }

    protected static final class ConstTopLevel
    extends UpdateArrayAssignment {
        final RAny rhsVal;

        protected ConstTopLevel(ASTNode orig, RSymbol varName, RNode rhs, AssignmentNode assignment, RAny rhsVal) {
            super(orig, varName, rhs, assignment);
            this.rhsVal = rhsVal;
        }

        @Override
        public Object execute(Frame frame) {
            RAny lhsValue = (RAny)Utils.cast(this.varName.getValue());
            if (lhsValue == null) {
                throw RError.getUnknownVariable(this.getAST(), this.varName);
            }
            RAny newLhs = this.assignment.execute(frame, lhsValue, this.rhsVal);
            if (lhsValue != newLhs) {
                Frame.writeToTopLevelRef(this.varName, newLhs);
            }
            return this.rhsVal;
        }
    }

    protected static final class TopLevel
    extends UpdateArrayAssignment {
        protected TopLevel(ASTNode orig, RSymbol varName, RNode rhs, AssignmentNode assignment) {
            super(orig, varName, rhs, assignment);
        }

        @Override
        public Object execute(Frame frame) {
            RAny rhsValue = (RAny)this.rhs.execute(frame);
            RAny lhsValue = (RAny)Utils.cast(this.varName.getValue());
            if (lhsValue == null) {
                throw RError.getUnknownVariable(this.getAST(), this.varName);
            }
            RAny newLhs = this.assignment.execute(frame, lhsValue, rhsValue);
            if (lhsValue != newLhs) {
                Frame.writeToTopLevelRef(this.varName, newLhs);
            }
            return rhsValue;
        }
    }

    protected static class LocalGeneric
    extends UpdateArrayAssignment {
        final int varSlot;

        protected LocalGeneric(ASTNode ast, RSymbol varName, int varSlot, RNode rhs, AssignmentNode assignment) {
            super(ast, varName, rhs, assignment);
            this.varSlot = varSlot;
        }

        @Override
        public Object execute(Frame frame) {
            RAny newLhs;
            RAny rhsValue = (RAny)this.rhs.execute(frame);
            RAny lhsValue = (RAny)frame.getObjectForcingPromises(this.varSlot);
            if (lhsValue == null) {
                lhsValue = (RAny)Utils.cast(frame.readViaWriteSetSlowPath(this.varName));
                if (lhsValue == null) {
                    throw RError.getUnknownVariable(this.getAST(), this.varName);
                }
                lhsValue.ref();
            }
            if (lhsValue != (newLhs = this.assignment.execute(frame, lhsValue, rhsValue))) {
                frame.writeAtRef(this.varSlot, newLhs);
            }
            return rhsValue;
        }
    }

    protected static class LocalSimple
    extends UpdateArrayAssignment {
        final int varSlot;

        protected LocalSimple(ASTNode ast, RSymbol varName, int varSlot, RNode rhs, AssignmentNode assignment) {
            super(ast, varName, rhs, assignment);
            this.varSlot = varSlot;
        }

        @Override
        public Object execute(Frame frame) {
            RAny rhsValue = (RAny)this.rhs.execute(frame);
            RAny lhsValue = (RAny)frame.getObjectForcingPromises(this.varSlot);
            try {
                if (lhsValue == null) {
                    throw new SpecializationException((Object)null);
                }
            }
            catch (SpecializationException e) {
                return this.replace(this.rhs, rhsValue, new LocalGeneric(this.ast, this.varName, this.varSlot, this.rhs, this.assignment), frame);
            }
            RAny newLhs = this.assignment.execute(frame, lhsValue, rhsValue);
            if (lhsValue != newLhs) {
                frame.writeAtRef(this.varSlot, newLhs);
            }
            return rhsValue;
        }
    }

    protected static class LocalInitial
    extends UpdateArrayAssignment {
        final int varSlot;

        protected LocalInitial(ASTNode ast, RSymbol varName, int varSlot, RNode rhs, AssignmentNode assignment) {
            super(ast, varName, rhs, assignment);
            this.varSlot = varSlot;
        }

        @Override
        public Object execute(Frame frame) {
            RAny newLhs;
            RAny rhsValue = (RAny)this.rhs.execute(frame);
            RAny lhsValue = (RAny)frame.getObjectForcingPromises(this.varSlot);
            if (lhsValue == null) {
                lhsValue = (RAny)Utils.cast(frame.readViaWriteSetSlowPath(this.varName));
                if (lhsValue == null) {
                    throw RError.getUnknownVariable(this.getAST(), this.varName);
                }
                lhsValue.ref();
            }
            if (lhsValue != (newLhs = this.assignment.execute(frame, lhsValue, rhsValue))) {
                frame.writeAtRef(this.varSlot, newLhs);
            }
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                this.replace(new LocalSimple(this.ast, this.varName, this.varSlot, this.rhs, this.assignment));
                return rhsValue;
            }
        }
    }

    public static abstract class AssignmentNode
    extends BaseR {
        public AssignmentNode(ASTNode orig) {
            super(orig);
        }

        public abstract RAny execute(Frame var1, RAny var2, RAny var3);

        @Override
        public Object execute(Frame frame) {
            Utils.nyi("unreachable");
            return null;
        }
    }
}

