/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import java.util.Arrays;
import java.util.HashMap;
import r.Convert;
import r.RContext;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.RSymbol;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.data.internal.ListImpl;
import r.data.internal.ScalarDoubleImpl;
import r.data.internal.ScalarIntImpl;
import r.data.internal.ScalarLogicalImpl;
import r.data.internal.ScalarStringImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.EQ;
import r.nodes.exec.BaseR;
import r.nodes.exec.Comparison;
import r.nodes.exec.Constant;
import r.nodes.exec.RNode;
import r.nodes.exec.ReadVector;
import r.nodes.exec.SuperWriteVariable;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class UpdateVector
extends BaseR {
    final RSymbol var;
    @RNode.Child
    RNode lhs;
    @RNode.Children
    final RNode[] indexes;
    @RNode.Child
    RNode rhs;
    final boolean subset;
    @RNode.Child
    RNode assign;
    RAny newVector;
    final boolean isSuper;
    int frameSlot = -1;
    boolean slotInitialized = false;
    private static final boolean DEBUG_UP = false;

    protected UpdateVector(UpdateVector from) {
        this(from.ast, from.isSuper, from.var, from.lhs, from.indexes, from.rhs, from.subset);
    }

    UpdateVector(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
        super(ast);
        this.var = var;
        this.lhs = this.adoptChild(lhs);
        this.indexes = this.adoptChildren(indexes);
        this.rhs = this.adoptChild(rhs);
        this.subset = subset;
        this.isSuper = isSuper;
        if (isSuper) {
            BaseR node = new BaseR(ast){

                @Override
                public final Object execute(Frame frame) {
                    return UpdateVector.this.newVector;
                }
            };
            this.assign = this.adoptChild(SuperWriteVariable.getUninitialized(ast, var, node));
        } else {
            this.assign = null;
        }
    }

    public final Object executeSuper(Frame frame) {
        RAny value = (RAny)this.rhs.execute(frame);
        RAny index = (RAny)this.indexes[0].execute(frame);
        if (frame == null) {
            throw RError.getUnknownVariable(this.ast, this.var);
        }
        RAny base = (RAny)this.lhs.execute(frame.enclosingFrame());
        this.newVector = this.execute(base, index, value);
        this.assign.execute(frame);
        return value;
    }

    @Override
    public final Object execute(Frame frame) {
        assert (Utils.check(this.getNewNode() == null));
        if (this.isSuper) {
            return this.executeSuper(frame);
        }
        RAny value = (RAny)this.rhs.execute(frame);
        assert (Utils.check(this.getNewNode() == null));
        RAny index = (RAny)this.indexes[0].execute(frame);
        assert (Utils.check(this.getNewNode() == null));
        if (frame != null) {
            if (!this.slotInitialized) {
                this.frameSlot = frame.findVariable(this.var);
                this.slotInitialized = true;
            }
            if (this.frameSlot != -1) {
                RAny base = (RAny)Utils.cast(frame.getObjectForcingPromises(this.frameSlot));
                if (base != null) {
                    RAny newBase = this.execute(base, index, value);
                    if (newBase != base) {
                        frame.writeAtRef(this.frameSlot, newBase);
                    }
                } else {
                    base = (RAny)Utils.cast(frame.readViaWriteSetSlowPath(this.var));
                    if (base == null) {
                        throw RError.getUnknownVariable(this.getAST(), this.var);
                    }
                    base.ref();
                    RAny newBase = this.execute(base, index, value);
                    frame.writeAtRef(this.frameSlot, newBase);
                }
            } else {
                RAny base = (RAny)Utils.cast(frame.read(this.var));
                if (base == null) {
                    throw RError.getUnknownVariable(this.getAST(), this.var);
                }
                base.ref();
                RAny newBase = this.execute(base, index, value);
                assert (Utils.check(base != newBase));
                frame.writeToExtension(this.var, newBase);
            }
        } else {
            RAny base = (RAny)Utils.cast(this.var.getValue());
            if (base == null) {
                throw RError.getUnknownVariable(this.getAST(), this.var);
            }
            RAny newBase = this.execute(base, index, value);
            if (newBase != base) {
                Frame.writeToTopLevelRef(this.var, newBase);
            }
        }
        return value;
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.lhs == oldNode) {
            this.lhs = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.indexes != null) {
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i] != oldNode) continue;
                this.indexes[i] = newNode;
                return this.adoptInternal(newNode);
            }
        }
        if (this.rhs == oldNode) {
            this.rhs = newNode;
            return this.adoptInternal(newNode);
        }
        if (this.assign == oldNode) {
            this.assign = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    abstract RAny execute(RAny var1, RAny var2, RAny var3);

    public static RArray.Names expandNames(RArray.Names names, int newSize) {
        RSymbol[] oldSymbols = names.sequence();
        Object[] symbols = new RSymbol[newSize];
        System.arraycopy(oldSymbols, 0, symbols, 0, oldSymbols.length);
        Arrays.fill(symbols, oldSymbols.length, newSize, RSymbol.EMPTY_SYMBOL);
        return RArray.Names.create((RSymbol[])symbols);
    }

    public static RArray.Names removeName(RArray.Names names, int removeIndex) {
        RSymbol[] oldSymbols = names.sequence();
        int nsize = oldSymbols.length - 1;
        RSymbol[] symbols = new RSymbol[nsize];
        System.arraycopy(oldSymbols, 0, symbols, 0, removeIndex);
        if (removeIndex < nsize) {
            System.arraycopy(oldSymbols, removeIndex + 1, symbols, removeIndex, nsize - removeIndex);
        }
        return RArray.Names.create(symbols);
    }

    public static RArray.Names appendName(RArray.Names names, RSymbol newName) {
        RSymbol[] oldSymbols = names.sequence();
        int size = oldSymbols.length;
        RSymbol[] symbols = new RSymbol[size + 1];
        System.arraycopy(oldSymbols, 0, symbols, 0, size);
        symbols[size] = newName;
        return RArray.Names.create(symbols);
    }

    public static class DollarUpdate
    extends DollarUpdateBase {
        public DollarUpdate(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RSymbol index, RNode rhs) {
            super(ast, isSuper, var, lhs, index, rhs);
        }

        public DollarUpdate(DollarUpdateBase from) {
            super(from);
        }

        @Override
        RAny execute(RAny base, RAny indexDummy, RAny value) {
            RList list = base instanceof RList ? (RList)base : this.convertToList(base);
            RArray.Names names = list.names();
            int size = list.size();
            int pos = DollarUpdate.elementPos(names, this.index);
            if (value instanceof RNull) {
                if (pos != -1) {
                    return GenericScalarSelection.deleteElement(list, pos, list.size());
                }
                return base;
            }
            if (pos == -1) {
                return DollarUpdate.appendToList(list, names, size, value, this.index);
            }
            if (base.isShared()) {
                return DollarUpdate.updateList(list, names, size, value, pos);
            }
            return DollarUpdate.updateListInPlace(list, value, pos);
        }
    }

    public static class DollarListAppend
    extends DollarUpdateBase {
        public DollarListAppend(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RSymbol index, RNode rhs) {
            super(ast, isSuper, var, lhs, index, rhs);
        }

        public DollarListAppend(DollarUpdateBase from) {
            super(from);
        }

        @Override
        RAny execute(RAny base, RAny indexDummy, RAny value) {
            try {
                if (!(base instanceof RList) || value instanceof RNull) {
                    throw new SpecializationException((Object)null);
                }
                RList list = (RList)base;
                RArray.Names names = list.names();
                int size = list.size();
                int pos = DollarListAppend.elementPos(names, this.index);
                if (pos != -1) {
                    throw new SpecializationException((Object)null);
                }
                return DollarListAppend.appendToList(list, names, size, value, this.index);
            }
            catch (SpecializationException e) {
                DollarUpdate x = new DollarUpdate(this);
                this.replace(x, "not a list or not append in assignment");
                return ((UpdateVector)x).execute(base, this.index, value);
            }
        }
    }

    public static class DollarSharedListUpdate
    extends DollarUpdateBase {
        public DollarSharedListUpdate(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RSymbol index, RNode rhs) {
            super(ast, isSuper, var, lhs, index, rhs);
        }

        public DollarSharedListUpdate(DollarUpdateBase from) {
            super(from);
        }

        @Override
        RAny execute(RAny base, RAny indexDummy, RAny value) {
            try {
                if (!(base instanceof RList)) {
                    throw new SpecializationException((Object)Failure.NOT_A_LIST);
                }
                if (value instanceof RNull) {
                    throw new SpecializationException((Object)Failure.NOT_AN_UPDATE);
                }
                RList list = (RList)base;
                RArray.Names names = list.names();
                int size = list.size();
                int pos = DollarSharedListUpdate.elementPos(names, this.index);
                if (pos == -1) {
                    throw new SpecializationException((Object)Failure.NOT_AN_UPDATE);
                }
                if (list.isShared()) {
                    return DollarSharedListUpdate.updateList(list, names, size, value, pos);
                }
                return DollarSharedListUpdate.updateListInPlace(list, value, pos);
            }
            catch (SpecializationException e) {
                switch ((Failure)((Object)e.getResult())) {
                    case NOT_A_LIST: {
                        DollarUpdate x = new DollarUpdate(this);
                        this.replace(x, "not a list in assignment");
                        return ((UpdateVector)x).execute(base, this.index, value);
                    }
                    case NOT_AN_UPDATE: {
                        DollarListAppend x = new DollarListAppend(this);
                        this.replace(x, "list append");
                        return ((UpdateVector)x).execute(base, this.index, value);
                    }
                }
                assert (false);
                return null;
            }
        }

        static enum Failure {
            NOT_A_LIST,
            NOT_AN_UPDATE;

        }
    }

    public static class DollarListUpdate
    extends DollarUpdateBase {
        public DollarListUpdate(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RSymbol index, RNode rhs) {
            super(ast, isSuper, var, lhs, index, rhs);
        }

        public DollarListUpdate(DollarUpdateBase from) {
            super(from);
        }

        @Override
        RAny execute(RAny base, RAny indexDummy, RAny value) {
            try {
                if (!(base instanceof RList)) {
                    throw new SpecializationException((Object)Failure.NOT_A_LIST);
                }
                if (value instanceof RNull) {
                    throw new SpecializationException((Object)Failure.NOT_AN_UPDATE);
                }
                RList list = (RList)base;
                RArray.Names names = list.names();
                int pos = DollarListUpdate.elementPos(names, this.index);
                if (pos == -1) {
                    throw new SpecializationException((Object)Failure.NOT_AN_UPDATE);
                }
                if (list.isShared()) {
                    throw new SpecializationException((Object)Failure.SHARED_UPDATE);
                }
                return DollarListUpdate.updateListInPlace(list, value, pos);
            }
            catch (SpecializationException e) {
                switch ((Failure)((Object)e.getResult())) {
                    case NOT_A_LIST: {
                        DollarUpdate x = new DollarUpdate(this);
                        this.replace(x, "not a list in assignment");
                        return ((UpdateVector)x).execute(base, this.index, value);
                    }
                    case SHARED_UPDATE: {
                        DollarSharedListUpdate x = new DollarSharedListUpdate(this);
                        this.replace(x, "update of a shared list");
                        return ((UpdateVector)x).execute(base, this.index, value);
                    }
                    case NOT_AN_UPDATE: {
                        DollarListAppend x = new DollarListAppend(this);
                        this.replace(x, "list append");
                        return ((UpdateVector)x).execute(base, this.index, value);
                    }
                }
                assert (Utils.check(false));
                return null;
            }
        }

        static enum Failure {
            NOT_A_LIST,
            SHARED_UPDATE,
            NOT_AN_UPDATE;

        }
    }

    public static abstract class DollarUpdateBase
    extends UpdateVector {
        RSymbol index;

        DollarUpdateBase(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RSymbol index, RNode rhs) {
            super(ast, isSuper, var, lhs, new RNode[]{new BaseR(null){

                @Override
                public Object execute(Frame frame) {
                    return null;
                }
            }}, rhs, false);
            this.index = index;
        }

        DollarUpdateBase(DollarUpdateBase from) {
            super(from);
            this.index = from.index;
        }

        protected final RList convertToList(RAny base) {
            RContext.warning(this.ast, "Coercing LHS to a list");
            return base.asList();
        }

        protected static int elementPos(RArray.Names names, RSymbol idx) {
            return names == null ? -1 : names.map(idx);
        }

        protected static RAny appendToList(RArray base, RArray.Names names, int size, RAny value, RSymbol idx) {
            RArray.Names myNames = names;
            if (myNames == null) {
                myNames = RArray.Names.create(size);
            }
            RArray res = Utils.createArray(base, size + 1, base.dimensions(), UpdateVector.appendName(myNames, idx), base.attributesRef());
            for (int i = 0; i < size; ++i) {
                res.set(i, base.get(i));
            }
            res.set(size, value);
            return res;
        }

        protected static RAny updateList(RArray base, RArray.Names names, int size, RAny value, int pos) {
            int i;
            RArray res = Utils.createArray(base, size, base.dimensions(), names, base.attributesRef());
            for (i = 0; i < pos; ++i) {
                res.set(i, base.get(i));
            }
            for (i = pos + 1; i < size; ++i) {
                res.set(i, base.get(i));
            }
            return res.set(pos, value);
        }

        protected static RAny updateListInPlace(RArray base, RAny value, int pos) {
            return base.set(pos, value);
        }
    }

    public static class GenericSelection
    extends UpdateVector {
        public GenericSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (!(index instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_INDEX);
                }
                assert (Utils.check(this.subset));
                RArray aindex = (RArray)index;
                int isize = aindex.size();
                if (value instanceof RNull) {
                    if (isize == 1) {
                        return GenericScalarSelection.deleteElement(abase, aindex, this.ast, this.subset);
                    }
                    if (!(abase instanceof RList)) {
                        throw RError.getReplacementZero(this.ast);
                    }
                    RList lbase = (RList)abase;
                    if (aindex instanceof RDouble || aindex instanceof RInt) {
                        return NumericSelection.deleteElements(lbase, aindex.asInt(), this.ast, true);
                    }
                    if (aindex instanceof RLogical) {
                        return LogicalSelection.deleteElements(lbase, index.asLogical(), this.ast);
                    }
                    if (aindex instanceof RString) {
                        return StringSelection.deleteElements(lbase, (RString)index, this.ast);
                    }
                    if (aindex instanceof RNull) {
                        return lbase;
                    }
                    throw RError.getInvalidSubscriptType(this.ast, aindex.typeOf());
                }
                if (!(value instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                }
                RArray avalue = (RArray)value;
                if (aindex instanceof RDouble || aindex instanceof RInt) {
                    return NumericSelection.genericUpdate(abase, aindex.asInt(), avalue, this.ast, true);
                }
                if (aindex instanceof RLogical) {
                    return LogicalSelection.genericUpdate(abase, index.asLogical(), avalue, this.ast);
                }
                if (aindex instanceof RString) {
                    return StringSelection.genericUpdate(abase, (RString)index, avalue, this.ast);
                }
                throw RError.getInvalidSubscriptType(this.ast, aindex.typeOf());
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case NOT_ARRAY_BASE: {
                        throw RError.getObjectNotSubsettable(this.ast, base.typeOf());
                    }
                    case NOT_ARRAY_INDEX: {
                        throw RError.getInvalidSubscriptType(this.ast, index.typeOf());
                    }
                }
                assert (Utils.check(f == Failure.NOT_ARRAY_VALUE));
                throw RError.getSubassignTypeFix(this.ast, value.typeOf(), base.typeOf());
            }
        }
    }

    public static class Subscript
    extends UpdateVector {
        public Subscript(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
            assert (Utils.check(!subset));
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RAny executeSubscript(RInt index, RArray base, RArray value, ASTNode ast) {
            void var6_13;
            void var6_7;
            int i;
            int isize = index.size();
            if (isize == 0) {
                throw RError.getSelectLessThanOne(ast);
            }
            RArray rArray = base;
            RList res = null;
            RList parent = null;
            int parentIndex = -1;
            boolean onSharedPath = false;
            if (isize > 1) {
                for (i = 0; i < isize - 1; ++i) {
                    if (!(var6_7 instanceof RList)) {
                        if (!(base instanceof RList)) throw RError.getSelectMoreThanOne(ast);
                        throw RError.getRecursiveIndexingFailed(ast, i + 1);
                    }
                    RList l = (RList)var6_7;
                    int indexv = index.getInt(i);
                    int bsize = l.size();
                    int isel = ReadVector.Subscript.convertDereferencingIndex(indexv, i, bsize, ast);
                    if (l.isShared()) {
                        onSharedPath = true;
                    }
                    if (onSharedPath) {
                        int j;
                        RAny[] content = new RAny[bsize];
                        int k = 0;
                        for (j = 0; j < isel; ++j) {
                            content[k++] = l.getRAnyRef(j);
                        }
                        ++j;
                        ++k;
                        while (j < bsize) {
                            content[k++] = l.getRAnyRef(j);
                            ++j;
                        }
                        ListImpl newList = RList.RListFactory.getFor(content, l.dimensions(), l.names(), l.attributesRef());
                        if (parent != null) {
                            parent.set(parentIndex, newList);
                        } else {
                            res = newList;
                        }
                        parent = newList;
                        RAny rAny = l.getRAnyRef(isel);
                    } else {
                        if (parent == null) {
                            res = l;
                        }
                        parent = l;
                        RAny rAny = l.getRAny(isel);
                    }
                    parentIndex = isel;
                }
            }
            int indexv = index.getInt(i);
            if (!(var6_7 instanceof RArray)) {
                throw RError.getObjectNotSubsettable(ast, var6_7.typeOf());
            }
            RArray a = (RArray)var6_7;
            if (value instanceof RNull) {
                if (!(a instanceof RList)) throw RError.getMoreElementsSupplied(ast);
                RAny rAny = GenericScalarSelection.deleteElement((RList)a, indexv, ast, false);
            } else {
                if (value.size() > 1) {
                    throw RError.getMoreElementsSupplied(ast);
                }
                RAny rAny = ScalarNumericSelection.genericUpdate(a, indexv, value, false, ast);
            }
            if (parent == null) {
                return var6_13;
            }
            parent.set(parentIndex, (RAny)var6_13);
            return res;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RAny executeSubscript(RString index, RArray base, RArray value, ASTNode ast) {
            void var6_11;
            void var6_7;
            int i;
            int isize = index.size();
            if (isize == 0) {
                throw RError.getSelectLessThanOne(ast);
            }
            RArray rArray = base;
            ListImpl res = null;
            RList parent = null;
            int parentIndex = -1;
            if (isize > 1) {
                for (i = 0; i < isize - 1; ++i) {
                    int j;
                    if (!(var6_7 instanceof RList)) {
                        throw RError.getSelectMoreThanOne(ast);
                    }
                    RList l = (RList)var6_7;
                    RArray.Names names = l.names();
                    if (names == null) {
                        throw RError.getNoSuchIndexAtLevel(ast, i + 1);
                    }
                    RSymbol s = RSymbol.getSymbol(index.getString(i));
                    int indexv = names.map(s);
                    if (indexv == -1) {
                        throw RError.getNoSuchIndexAtLevel(ast, i + 1);
                    }
                    int bsize = l.size();
                    RAny[] content = new RAny[bsize];
                    int k = 0;
                    for (j = 0; j < indexv; ++j) {
                        content[k++] = l.getRAny(j);
                    }
                    ++j;
                    ++k;
                    while (j < bsize) {
                        content[k++] = l.getRAny(j);
                        ++j;
                    }
                    ListImpl newList = RList.RListFactory.getFor(content, l.dimensions(), l.names(), l.attributesRef());
                    if (parent != null) {
                        parent.set(parentIndex, newList);
                    } else {
                        res = newList;
                    }
                    parent = newList;
                    parentIndex = indexv;
                    RAny rAny = l.getRAnyRef(indexv);
                }
            }
            if (!(var6_7 instanceof RArray)) {
                throw RError.getObjectNotSubsettable(ast, var6_7.typeOf());
            }
            RArray a = (RArray)var6_7;
            if (value instanceof RNull) {
                if (!(a instanceof RList)) throw RError.getMoreElementsSupplied(ast);
                RAny rAny = GenericScalarSelection.deleteElement((RList)a, index.getString(i));
            } else {
                if (value.size() > 1) {
                    throw RError.getMoreElementsSupplied(ast);
                }
                RArray rArray2 = ScalarStringSelection.genericUpdate(a, index.getString(i), value, false, ast);
            }
            if (parent == null) {
                return var6_11;
            }
            parent.set(parentIndex, (RAny)var6_11);
            return res;
        }

        public static RAny executeSubscript(RAny index, RArray base, RArray value, ASTNode ast) {
            if (index instanceof RInt || index instanceof RDouble || index instanceof RLogical) {
                return Subscript.executeSubscript(index.asInt(), base, value, ast);
            }
            if (index instanceof RString) {
                return Subscript.executeSubscript((RString)index, base, value, ast);
            }
            throw ReadVector.Subscript.invalidSubscript(index, ast);
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (!(value instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                }
                RArray avalue = (RArray)value;
                return Subscript.executeSubscript(index, abase, avalue, this.ast);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                GenericSelection gs = new GenericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                this.replace(gs, "install GenericSelection from Subscript");
                return gs.execute(base, index, value);
            }
        }
    }

    public static class StringSelection {
        public static RAny deleteElements(RList base, RString index, ASTNode ast) {
            RArray.Names bnames = base.names();
            if (bnames == null) {
                return Utils.dropDimensions(base);
            }
            int bsize = base.size();
            int isize = index.size();
            boolean[] remove = new boolean[bsize];
            int nremove = 0;
            for (int i = 0; i < isize; ++i) {
                RSymbol s = RSymbol.getSymbol(index.getString(i));
                int v = bnames.map(s);
                if (v == -1 || remove[v]) continue;
                remove[v] = true;
                ++nremove;
            }
            if (nremove == 0) {
                return base;
            }
            int nsize = bsize - nremove;
            RSymbol[] bsymbols = bnames.sequence();
            RSymbol[] nsymbols = new RSymbol[nsize];
            RAny[] content = new RAny[nsize];
            int j = 0;
            for (int i = 0; i < bsize; ++i) {
                if (remove[i]) continue;
                content[j] = base.getRAny(i);
                nsymbols[j] = bsymbols[i];
                ++j;
            }
            return RList.RListFactory.getFor(content, null, RArray.Names.create(nsymbols), base.attributesRef());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RAny genericUpdate(RArray base, RString index, RAny value, ASTNode ast) {
            int ii;
            RArray.Names nnames;
            RSymbol[] bsymbols;
            HashMap<Object, Object> nmap;
            RArray typedBase;
            RArray typedValue;
            int isize = index.size();
            if (isize == 1) {
                return ScalarStringSelection.genericUpdate(base, index.getString(0), value, true, ast);
            }
            RList listValue = null;
            assert (Utils.check(!(value instanceof RNull)));
            if (value instanceof RList) {
                listValue = (RList)value;
                typedValue = null;
                typedBase = base instanceof RList ? base : base.asList();
            } else if (base instanceof RList) {
                typedBase = base;
                listValue = value.asList();
                typedValue = null;
            } else if (base instanceof RRaw) {
                if (!(value instanceof RRaw)) throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                typedBase = base;
                typedValue = value.asRaw();
            } else {
                if (value instanceof RRaw) {
                    throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                }
                if (base instanceof RString || value instanceof RString) {
                    typedBase = base.asString();
                    typedValue = value.asString();
                } else if (base instanceof RComplex || value instanceof RComplex) {
                    typedBase = base.asComplex();
                    typedValue = value.asComplex();
                } else if (base instanceof RDouble || value instanceof RDouble) {
                    typedBase = base.asDouble();
                    typedValue = value.asDouble();
                } else if (base instanceof RInt || value instanceof RInt) {
                    typedBase = base.asInt();
                    typedValue = value.asInt();
                } else {
                    assert (Utils.check(base instanceof RLogical || base instanceof RNull));
                    assert (Utils.check(value instanceof RLogical));
                    typedBase = base.asLogical();
                    typedValue = (RLogical)value;
                }
            }
            int bsize = base.size();
            int vsize = typedValue != null ? typedValue.size() : listValue.size();
            RArray.Names bnames = base.names();
            if (bnames == null) {
                nmap = new HashMap(bsize);
                bsymbols = null;
            } else {
                assert (Utils.check(bnames.keepsMap()));
                nmap = new HashMap<RSymbol, Integer>(bnames.getMap());
                bsymbols = bnames.sequence();
            }
            RSymbol[] addSymbols = new RSymbol[isize];
            int j = 0;
            int firstOverwrite = -1;
            int noverwrites = 0;
            int[] targetOffsets = null;
            for (int i = 0; i < isize; ++i) {
                RSymbol name = RSymbol.getSymbol(index.getString(i));
                if (name == RSymbol.EMPTY_SYMBOL || name == RSymbol.NA_SYMBOL) {
                    addSymbols[j] = name;
                    if (targetOffsets != null) {
                        targetOffsets[i - firstOverwrite] = j + bsize;
                    }
                    ++j;
                    continue;
                }
                Integer prevOffset = (Integer)nmap.get(name);
                if (prevOffset == null) {
                    nmap.put(name, j + bsize);
                    addSymbols[j] = name;
                    if (targetOffsets != null) {
                        targetOffsets[i - firstOverwrite] = j + bsize;
                    }
                    ++j;
                    continue;
                }
                if (firstOverwrite == -1) {
                    firstOverwrite = i;
                    targetOffsets = new int[isize - firstOverwrite];
                }
                ++noverwrites;
                targetOffsets[i - firstOverwrite] = prevOffset;
            }
            int addSize = isize - noverwrites;
            int nsize = bsize + addSize;
            if (addSize == 0) {
                nnames = bnames;
            } else if (bsize == 0) {
                nnames = RArray.Names.create(addSymbols, nmap);
            } else {
                Object[] nsymbols = new RSymbol[nsize];
                if (bsymbols != null) {
                    System.arraycopy(bsymbols, 0, nsymbols, 0, bsize);
                } else {
                    Arrays.fill(nsymbols, RSymbol.EMPTY_SYMBOL);
                }
                System.arraycopy(addSymbols, 0, nsymbols, bsize, addSize);
                nnames = RArray.Names.create((RSymbol[])nsymbols, nmap);
            }
            RArray res = Utils.createArray(typedBase, nsize, null, nnames, base.attributesRef());
            for (int bi = 0; bi < bsize; ++bi) {
                res.set(bi, typedBase.get(bi));
            }
            int vi = 0;
            if (noverwrites == 0) {
                for (ii = 0; ii < isize; ++ii) {
                    res.set(bsize + ii, typedValue != null ? typedValue.get(vi) : listValue.get(vi));
                    if (++vi != vsize) continue;
                    vi = 0;
                }
            } else {
                while (ii < isize) {
                    int ni = ii < firstOverwrite ? bsize + ii : targetOffsets[ii - firstOverwrite];
                    res.set(ni, typedValue != null ? typedValue.get(vi) : listValue.get(vi));
                    if (++vi == vsize) {
                        vi = 0;
                    }
                    ++ii;
                }
            }
            if (vi == 0) return res;
            RContext.warning(ast, "number of items to replace is not a multiple of replacement length");
            return res;
        }
    }

    public static class LogicalSelection
    extends UpdateVector {
        public LogicalSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
            assert (Utils.check(subset));
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                Specialized sn = this.createSimple(base, value);
                if (sn != null) {
                    this.replace(sn, "specialize LogicalSelection");
                    return sn.execute(base, index, value);
                }
                sn = this.createGeneric();
                this.replace(sn, "specialize LogicalSelection");
                return sn.execute(base, index, value);
            }
        }

        public Specialized createSimple(RAny baseTemplate, RAny valueTemplate) {
            if (baseTemplate instanceof RList) {
                if (valueTemplate instanceof RList || valueTemplate instanceof RDouble || valueTemplate instanceof RLogical || valueTemplate instanceof RInt) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, RLogical index, RAny value) throws SpecializationException {
                            RList res;
                            RList typedValue;
                            if (!(base instanceof RList)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RList typedBase = (RList)base;
                            if (value instanceof RList) {
                                typedValue = (RList)value;
                            } else if (value instanceof RDouble || value instanceof RInt || value instanceof RLogical) {
                                typedValue = value.asList();
                            } else {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            int bsize = base.size();
                            int isize = index.size();
                            if (isize > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int vsize = typedValue.size();
                            int ii = 0;
                            int vi = 0;
                            boolean hasNA = false;
                            if (isize == 0) {
                                return typedBase;
                            }
                            if (!(typedBase.isShared() || typedValue.dependsOn(typedBase) || index.dependsOn(typedBase) || typedBase.attributes() != null)) {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        typedBase.set(bi, typedValue.getRAnyRef(vi));
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v != Integer.MIN_VALUE) continue;
                                    hasNA = true;
                                }
                                res = typedBase;
                            } else {
                                RAny[] content = new RAny[bsize];
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        content[bi] = typedValue.getRAnyRef(vi);
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v == Integer.MIN_VALUE) {
                                        hasNA = true;
                                    }
                                    content[bi] = typedBase.getRAny(bi);
                                }
                                res = RList.RListFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                            }
                            if (hasNA && vsize >= 2) {
                                throw RError.getNASubscripted(LogicalSelection.this.ast);
                            }
                            if (vi != 0) {
                                RContext.warning(LogicalSelection.this.ast, "number of items to replace is not a multiple of replacement length");
                            }
                            return res;
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RDouble,RList|RDouble|RInt|RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RDouble) {
                if (valueTemplate instanceof RDouble || valueTemplate instanceof RLogical || valueTemplate instanceof RInt) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, RLogical index, RAny value) throws SpecializationException {
                            RDouble res;
                            RDouble typedValue;
                            if (!(base instanceof RDouble)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RDouble typedBase = (RDouble)base;
                            if (value instanceof RDouble) {
                                typedValue = (RDouble)value;
                            } else if (value instanceof RInt || value instanceof RLogical) {
                                typedValue = value.asDouble();
                            } else {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            int bsize = base.size();
                            int isize = index.size();
                            if (isize > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int vsize = typedValue.size();
                            int ii = 0;
                            int vi = 0;
                            boolean hasNA = false;
                            if (isize == 0) {
                                return typedBase;
                            }
                            if (!(typedBase.isShared() || typedValue.dependsOn(typedBase) || index.dependsOn(typedBase) || typedBase.attributes() != null)) {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        typedBase.set(bi, typedValue.getDouble(vi));
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v != Integer.MIN_VALUE) continue;
                                    hasNA = true;
                                }
                                res = typedBase;
                            } else {
                                double[] content = new double[bsize];
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        content[bi] = typedValue.getDouble(vi);
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v == Integer.MIN_VALUE) {
                                        hasNA = true;
                                    }
                                    content[bi] = typedBase.getDouble(bi);
                                }
                                res = RDouble.RDoubleFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                            }
                            if (hasNA && vsize >= 2) {
                                throw RError.getNASubscripted(LogicalSelection.this.ast);
                            }
                            if (vi != 0) {
                                RContext.warning(LogicalSelection.this.ast, "number of items to replace is not a multiple of replacement length");
                            }
                            return res;
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RDouble,RDouble|RInt|RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RInt) {
                if (valueTemplate instanceof RLogical || valueTemplate instanceof RInt) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, RLogical index, RAny value) throws SpecializationException {
                            RInt res;
                            RInt typedValue;
                            if (!(base instanceof RInt)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RInt typedBase = (RInt)base;
                            if (value instanceof RInt) {
                                typedValue = (RInt)value;
                            } else if (value instanceof RLogical) {
                                typedValue = value.asInt();
                            } else {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            int bsize = base.size();
                            int isize = index.size();
                            if (isize > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int vsize = typedValue.size();
                            int ii = 0;
                            int vi = 0;
                            boolean hasNA = false;
                            if (isize == 0) {
                                return typedBase;
                            }
                            if (!(typedBase.isShared() || typedValue.dependsOn(typedBase) || index.dependsOn(typedBase) || typedBase.attributes() != null)) {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        typedBase.set(bi, typedValue.getInt(vi));
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v != Integer.MIN_VALUE) continue;
                                    hasNA = true;
                                }
                                res = typedBase;
                            } else {
                                int[] content = new int[bsize];
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        content[bi] = typedValue.getInt(vi);
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v == Integer.MIN_VALUE) {
                                        hasNA = true;
                                    }
                                    content[bi] = typedBase.getInt(bi);
                                }
                                res = RInt.RIntFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                            }
                            if (hasNA && vsize >= 2) {
                                throw RError.getNASubscripted(LogicalSelection.this.ast);
                            }
                            if (vi != 0) {
                                RContext.warning(LogicalSelection.this.ast, "number of items to replace is not a multiple of replacement length");
                            }
                            return res;
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RInt,RInt|RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RLogical) {
                if (valueTemplate instanceof RLogical) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, RLogical index, RAny value) throws SpecializationException {
                            RLogical res;
                            if (!(base instanceof RLogical)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RLogical typedBase = (RLogical)base;
                            if (!(value instanceof RLogical)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RLogical typedValue = (RLogical)value;
                            int bsize = base.size();
                            int isize = index.size();
                            if (isize > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int vsize = typedValue.size();
                            int[] content = new int[bsize];
                            int ii = 0;
                            int vi = 0;
                            boolean hasNA = false;
                            if (isize == 0) {
                                return typedBase;
                            }
                            if (!(typedBase.isShared() || typedValue.dependsOn(typedBase) || index.dependsOn(typedBase) || typedBase.attributes() != null)) {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        typedBase.set(bi, typedValue.getLogical(vi));
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v != Integer.MIN_VALUE) continue;
                                    hasNA = true;
                                }
                                res = typedBase;
                            } else {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        content[bi] = typedValue.getLogical(vi);
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v == Integer.MIN_VALUE) {
                                        hasNA = true;
                                    }
                                    content[bi] = typedBase.getLogical(bi);
                                }
                                res = RLogical.RLogicalFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                            }
                            if (hasNA && vsize >= 2) {
                                throw RError.getNASubscripted(LogicalSelection.this.ast);
                            }
                            if (vi != 0) {
                                RContext.warning(LogicalSelection.this.ast, "number of items to replace is not a multiple of replacement length");
                            }
                            return res;
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RLogical,RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RString) {
                if (valueTemplate instanceof RString) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, RLogical index, RAny value) throws SpecializationException {
                            RString res;
                            if (!(base instanceof RString)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RString typedBase = (RString)base;
                            if (!(value instanceof RString)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RString typedValue = (RString)value;
                            int bsize = base.size();
                            int isize = index.size();
                            if (isize > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int vsize = typedValue.size();
                            String[] content = new String[bsize];
                            int ii = 0;
                            int vi = 0;
                            boolean hasNA = false;
                            if (isize == 0) {
                                return typedBase;
                            }
                            if (!(typedBase.isShared() || typedValue.dependsOn(typedBase) || index.dependsOn(typedBase) || typedBase.attributes() != null)) {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        typedBase.set(bi, typedValue.getString(vi));
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v != Integer.MIN_VALUE) continue;
                                    hasNA = true;
                                }
                                res = typedBase;
                            } else {
                                for (int bi = 0; bi < bsize; ++bi) {
                                    int v = index.getLogical(ii);
                                    if (++ii == isize) {
                                        ii = 0;
                                    }
                                    if (v == 1) {
                                        content[bi] = typedValue.getString(vi);
                                        if (++vi != vsize) continue;
                                        vi = 0;
                                        continue;
                                    }
                                    if (v == Integer.MIN_VALUE) {
                                        hasNA = true;
                                    }
                                    content[bi] = typedBase.getString(bi);
                                }
                                res = RString.RStringFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                            }
                            if (hasNA && vsize >= 2) {
                                throw RError.getNASubscripted(LogicalSelection.this.ast);
                            }
                            if (vi != 0) {
                                RContext.warning(LogicalSelection.this.ast, "number of items to replace is not a multiple of replacement length");
                            }
                            return res;
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RString,RString>");
                }
                return null;
            }
            return null;
        }

        public static RAny deleteElements(RList base, RLogical index, ASTNode ast) {
            RSymbol[] symbols;
            int bsize = base.size();
            int isize = index.size();
            RArray.Names names = base.names();
            RSymbol[] rSymbolArray = symbols = names == null ? null : names.sequence();
            if (isize == bsize) {
                int ntrue = RLogical.RLogicalUtils.truesInRange(index, 0, isize);
                int nsize = bsize - ntrue;
                RAny[] content = new RAny[nsize];
                RSymbol[] nsymbols = symbols == null ? null : new RSymbol[nsize];
                int j = 0;
                for (int i = 0; i < bsize; ++i) {
                    int l = index.getLogical(i);
                    if (l == 1) continue;
                    content[j] = base.getRAny(i);
                    if (symbols != null) {
                        nsymbols[j] = symbols[i];
                    }
                    ++j;
                }
                return RList.RListFactory.getFor(content, ntrue != 0 ? null : base.dimensions(), nsymbols == null ? null : RArray.Names.create(nsymbols), base.attributesRef());
            }
            if (isize > bsize) {
                int i;
                int ntrue = RLogical.RLogicalUtils.truesInRange(index, 0, bsize);
                int natrue = RLogical.RLogicalUtils.truesInRange(index, bsize, isize);
                int nullsToAdd = isize - bsize - natrue;
                int nsize = bsize - ntrue + nullsToAdd;
                RAny[] content = new RAny[nsize];
                RSymbol[] nsymbols = symbols == null ? null : new RSymbol[nsize];
                int j = 0;
                for (i = 0; i < bsize; ++i) {
                    int l = index.getLogical(i);
                    if (l == 1) continue;
                    content[j] = base.getRAny(i);
                    if (symbols != null) {
                        nsymbols[j] = symbols[i];
                    }
                    ++j;
                }
                for (i = 0; i < nullsToAdd; ++i) {
                    content[j] = RList.NULL;
                    if (symbols != null) {
                        nsymbols[j] = RSymbol.EMPTY_SYMBOL;
                    }
                    ++j;
                }
                return RList.RListFactory.getFor(content, bsize != nsize ? null : base.dimensions(), nsymbols == null ? null : RArray.Names.create(nsymbols), base.attributesRef());
            }
            if (isize == 0) {
                return base;
            }
            int rep = bsize / isize;
            int lsize = bsize - rep * isize;
            int ntrue = RLogical.RLogicalUtils.truesInRange(index, 0, isize);
            int nltrue = RLogical.RLogicalUtils.truesInRange(index, 0, lsize);
            int nsize = bsize - (ntrue * rep + nltrue);
            RAny[] content = new RAny[nsize];
            RSymbol[] nsymbols = symbols == null ? null : new RSymbol[nsize];
            int ii = 0;
            int ci = 0;
            for (int bi = 0; bi < bsize; ++bi) {
                int l = index.getLogical(ii++);
                if (ii == isize) {
                    ii = 0;
                }
                if (l == 1) continue;
                content[ci] = base.getRAny(bi);
                if (symbols != null) {
                    nsymbols[ci] = symbols[bi];
                }
                ++ci;
            }
            return RList.RListFactory.getFor(content, bsize != nsize ? null : base.dimensions(), nsymbols == null ? null : RArray.Names.create(nsymbols), base.attributesRef());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RAny genericUpdate(RArray base, RLogical index, RAny value, ASTNode ast) {
            RArray res;
            boolean expanding;
            int nsize;
            int[] dimensions;
            RArray typedBase;
            RArray typedValue;
            RList listValue = null;
            if (value instanceof RNull) {
                if (base instanceof RList) {
                    return LogicalSelection.deleteElements((RList)base, index, ast);
                }
                if (index.size() != 0) throw RError.getReplacementZero(ast);
                return base;
            }
            if (value instanceof RList) {
                listValue = (RList)value;
                typedValue = null;
                if (base instanceof RList) {
                    typedBase = base;
                    dimensions = base.dimensions();
                } else {
                    typedBase = base.asList();
                    dimensions = null;
                }
            } else {
                dimensions = base.dimensions();
                if (base instanceof RList) {
                    typedBase = base;
                    listValue = value.asList();
                    typedValue = null;
                } else if (base instanceof RRaw) {
                    if (!(value instanceof RRaw)) throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                    typedBase = base;
                    typedValue = value.asRaw();
                } else {
                    if (value instanceof RRaw) {
                        throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                    }
                    if (base instanceof RString || value instanceof RString) {
                        typedBase = base.asString();
                        typedValue = value.asString();
                    } else if (base instanceof RComplex || value instanceof RComplex) {
                        typedBase = base.asComplex();
                        typedValue = value.asComplex();
                    } else if (base instanceof RDouble || value instanceof RDouble) {
                        typedBase = base.asDouble();
                        typedValue = value.asDouble();
                    } else if (base instanceof RInt || value instanceof RInt) {
                        typedBase = base.asInt();
                        typedValue = value.asInt();
                    } else {
                        assert (Utils.check(base instanceof RLogical || base instanceof RNull));
                        assert (Utils.check(value instanceof RLogical));
                        typedBase = base.asLogical();
                        typedValue = (RLogical)value;
                    }
                }
            }
            int bsize = base.size();
            int isize = index.size();
            int vsize = typedValue != null ? typedValue.size() : listValue.size();
            RArray.Names names = base.names();
            if (isize <= bsize) {
                nsize = bsize;
                expanding = false;
                res = Utils.createArray(typedBase, nsize, dimensions, names, base.attributesRef());
            } else {
                expanding = true;
                nsize = isize;
                res = Utils.createArray(typedBase, nsize, names != null).setAttributes(base.attributesRef());
            }
            int ii = 0;
            int vi = 0;
            boolean hasNA = false;
            for (int ni = 0; ni < nsize; ++ni) {
                int v = index.getLogical(ii);
                if (++ii == isize) {
                    ii = 0;
                }
                if (v == 1) {
                    if (typedValue != null) {
                        res.set(ni, typedValue.get(vi));
                    } else {
                        res.set(ni, listValue.get(vi));
                    }
                    if (++vi != vsize) continue;
                    vi = 0;
                    continue;
                }
                if (v == Integer.MIN_VALUE) {
                    hasNA = true;
                }
                if (ni < bsize) {
                    res.set(ni, typedBase.get(ni));
                    continue;
                }
                Utils.setNA(res, ni);
            }
            if (hasNA && vsize >= 2) {
                throw RError.getNASubscripted(ast);
            }
            if (vi != 0) {
                RContext.warning(ast, "number of items to replace is not a multiple of replacement length");
            }
            if (!expanding) return res;
            if (names == null) return res;
            return res.setNames(LogicalSelection.expandNames(names, nsize));
        }

        public Specialized createGeneric() {
            ValueCopy cpy = new ValueCopy(){

                @Override
                RAny copy(RArray base, RLogical index, RAny value) {
                    return LogicalSelection.genericUpdate(base, index, value, LogicalSelection.this.ast);
                }
            };
            return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<Generic>");
        }

        class Specialized
        extends LogicalSelection {
            final ValueCopy copy;
            final String dbg;

            Specialized(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset, ValueCopy copy, String dbg) {
                super(ast, isSuper, var, lhs, indexes, rhs, subset);
                this.copy = copy;
                this.dbg = dbg;
            }

            @Override
            public RAny execute(RAny base, RAny index, RAny value) {
                try {
                    if (!(base instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                    }
                    RArray abase = (RArray)base;
                    if (!(value instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                    }
                    RArray avalue = (RArray)value;
                    if (!(index instanceof RLogical)) {
                        throw new SpecializationException((Object)Failure.NOT_LOGICAL_INDEX);
                    }
                    RLogical lindex = (RLogical)index;
                    return this.copy.copy(abase, lindex, avalue);
                }
                catch (SpecializationException e) {
                    Failure f = (Failure)((Object)e.getResult());
                    switch (f) {
                        case INDEX_OUT_OF_BOUNDS: 
                        case UNEXPECTED_TYPE: {
                            Specialized sn = this.createGeneric();
                            this.replace(sn, "specialize LogicalSelection");
                            return sn.execute(base, index, value);
                        }
                    }
                    GenericSelection gs = new GenericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                    this.replace(gs, "install GenericSelection from LogicalSelection");
                    return gs.execute(base, index, value);
                }
            }
        }

        abstract class ValueCopy {
            ValueCopy() {
            }

            abstract RAny copy(RArray var1, RLogical var2, RAny var3) throws SpecializationException;
        }
    }

    public static final class LogicalEqualitySelection
    extends UpdateVector {
        final double c;

        public LogicalEqualitySelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode xExpr, double c, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, new RNode[]{xExpr}, rhs, subset);
            assert (Utils.check(subset));
            this.c = c;
        }

        @Override
        RAny execute(RAny baseArg, RAny xArg, RAny valueArg) {
            try {
                boolean hasNA;
                if (!(baseArg instanceof DoubleImpl && xArg instanceof DoubleImpl && valueArg instanceof DoubleImpl)) {
                    throw new SpecializationException((Object)null);
                }
                RDouble base = (RDouble)baseArg;
                RDouble x = (RDouble)xArg;
                RDouble value = (RDouble)valueArg;
                int size = base.size();
                int vsize = value.size();
                if (x.size() != size) {
                    throw new SpecializationException((Object)null);
                }
                boolean bl = hasNA = vsize < 2;
                if (base.isShared()) {
                    throw new SpecializationException((Object)null);
                }
                int vi = 0;
                double[] baseArr = base.getContent();
                double[] valueArr = value.getContent();
                double[] xArr = x.getContent();
                for (int i = 0; i < size; ++i) {
                    double d = xArr[i];
                    if (d == this.c) {
                        baseArr[i] = valueArr[vi++];
                        if (vi != vsize) continue;
                        vi = 0;
                        continue;
                    }
                    hasNA = hasNA || RDouble.RDoubleUtils.isNAorNaN(d);
                }
                if (hasNA && vsize >= 2) {
                    throw RError.getNASubscripted(this.ast);
                }
                if (vi != 0) {
                    RContext.warning(this.ast, "number of items to replace is not a multiple of replacement length");
                }
                return base;
            }
            catch (SpecializationException e) {
                r.nodes.ast.UpdateVector uv = (r.nodes.ast.UpdateVector)this.ast;
                AccessVector av = uv.getVector();
                EQ eq = (EQ)av.getArgs().first().getValue();
                ScalarDoubleImpl boxedC = RDouble.RDoubleFactory.getScalar(this.c);
                Comparison indexExpr = new Comparison(eq, this.indexes[0], new Constant(eq.getRHS(), boxedC), Comparison.getEQ());
                LogicalSelection ls = new LogicalSelection(this.ast, this.isSuper, this.var, this.lhs, new RNode[]{indexExpr}, this.rhs, true);
                this.replace(ls, "install LogicalSelection from LogicalEqualitySelection");
                return ls.execute(baseArg, (RAny)indexExpr.execute(xArg, boxedC), valueArg);
            }
        }
    }

    public static class NumericSelection
    extends UpdateVector {
        public NumericSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
            assert (Utils.check(subset));
        }

        public static RArray deleteElements(RList base, RInt index, ASTNode ast, boolean subset) {
            RSymbol[] symbols;
            assert (Utils.check(subset));
            boolean hasNegative = false;
            boolean hasPositive = false;
            boolean hasNA = false;
            int bsize = base.size();
            int isize = index.size();
            boolean[] selected = new boolean[bsize];
            int maxIndex = 0;
            int ntrue = 0;
            for (int i = 0; i < isize; ++i) {
                int vi;
                int v = index.getInt(i);
                if (v > maxIndex) {
                    maxIndex = v;
                }
                if (v == Integer.MIN_VALUE) {
                    hasNA = true;
                    continue;
                }
                if (v == 0) continue;
                if (v > 0) {
                    hasPositive = true;
                    vi = v - 1;
                } else {
                    hasNegative = true;
                    vi = -v - 1;
                }
                if (vi >= selected.length || selected[vi]) continue;
                ++ntrue;
                selected[vi] = true;
            }
            RArray.Names names = base.names();
            RSymbol[] rSymbolArray = symbols = names == null ? null : names.sequence();
            if (!hasNegative) {
                int i;
                int nullsToAdd = 0;
                if (maxIndex > bsize + 1) {
                    int aboveSize = maxIndex - bsize;
                    boolean[] aboveSelected = new boolean[aboveSize];
                    int natrue = 0;
                    for (int i2 = 0; i2 < isize; ++i2) {
                        int vi;
                        int v = index.getInt(i2);
                        if (v <= bsize || aboveSelected[vi = v - bsize - 1]) continue;
                        aboveSelected[vi] = true;
                        ++natrue;
                    }
                    nullsToAdd = aboveSize - natrue;
                }
                int nsize = bsize - ntrue + nullsToAdd;
                RAny[] content = new RAny[nsize];
                RSymbol[] nsymbols = symbols == null ? null : new RSymbol[nsize];
                int j = 0;
                for (i = 0; i < bsize; ++i) {
                    if (selected[i]) continue;
                    content[j] = base.getRAny(i);
                    if (symbols != null) {
                        nsymbols[j] = symbols[i];
                    }
                    ++j;
                }
                for (i = 0; i < nullsToAdd; ++i) {
                    content[j] = RList.NULL;
                    if (symbols != null) {
                        nsymbols[j] = RSymbol.EMPTY_SYMBOL;
                    }
                    ++j;
                }
                int[] dimensions = null;
                if (nsize == bsize && maxIndex <= bsize) {
                    dimensions = base.dimensions();
                }
                return RList.RListFactory.getFor(content, dimensions, nsymbols == null ? null : RArray.Names.create(nsymbols), base.attributesRef());
            }
            if (hasPositive || hasNA) {
                throw RError.getOnlyZeroMixed(ast);
            }
            int nsize = ntrue;
            RAny[] content = new RAny[nsize];
            RSymbol[] nsymbols = symbols == null ? null : new RSymbol[nsize];
            int j = 0;
            for (int i = 0; i < bsize; ++i) {
                if (!selected[i]) continue;
                content[j] = base.getRAny(i);
                if (symbols != null) {
                    nsymbols[j] = symbols[i];
                }
                ++j;
            }
            int[] dimensions = nsize == bsize ? base.dimensions() : null;
            return RList.RListFactory.getFor(content, dimensions, nsymbols == null ? null : RArray.Names.create(nsymbols), base.attributesRef());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RArray genericUpdate(RArray base, RInt index, RArray value, ASTNode ast, boolean subset) {
            int vsize;
            int[] dimensions;
            RArray typedBase;
            RArray typedValue;
            assert (Utils.check(subset));
            boolean listBase = base instanceof RList;
            RList listValue = null;
            if (value instanceof RNull) {
                if (listBase) {
                    return NumericSelection.deleteElements((RList)base, index, ast, subset);
                }
                if (index.size() != 0) throw RError.getReplacementZero(ast);
                return base;
            }
            if (value instanceof RList) {
                listValue = (RList)value;
                typedValue = null;
                if (listBase) {
                    typedBase = base;
                    dimensions = base.dimensions();
                } else {
                    typedBase = base.asList();
                    dimensions = null;
                }
            } else {
                dimensions = base.dimensions();
                if (listBase) {
                    typedBase = base;
                    listValue = value.asList();
                    typedValue = null;
                } else if (base instanceof RRaw) {
                    if (!(value instanceof RRaw)) throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                    typedBase = base;
                    typedValue = value.asRaw();
                } else {
                    if (value instanceof RRaw) {
                        throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                    }
                    if (base instanceof RString || value instanceof RString) {
                        typedBase = base.asString();
                        typedValue = value.asString();
                    } else if (base instanceof RComplex || value instanceof RComplex) {
                        typedBase = base.asComplex();
                        typedValue = value.asComplex();
                    } else if (base instanceof RDouble || value instanceof RDouble) {
                        typedBase = base.asDouble();
                        typedValue = value.asDouble();
                    } else if (base instanceof RInt || value instanceof RInt) {
                        typedBase = base.asInt();
                        typedValue = value.asInt();
                    } else {
                        assert (Utils.check(base instanceof RLogical || base instanceof RNull));
                        assert (Utils.check(value instanceof RLogical));
                        typedBase = base.asLogical();
                        typedValue = value;
                    }
                }
            }
            boolean hasNegative = false;
            boolean hasPositive = false;
            boolean hasNA = false;
            int bsize = typedBase.size();
            int isize = index.size();
            boolean[] omit = null;
            int maxIndex = 0;
            for (int i = 0; i < isize; ++i) {
                int vi;
                int v = index.getInt(i);
                if (v > maxIndex) {
                    maxIndex = v;
                }
                if (v == Integer.MIN_VALUE) {
                    hasNA = true;
                    continue;
                }
                if (v > 0) {
                    hasPositive = true;
                    continue;
                }
                if (v >= 0) continue;
                if (!hasNegative) {
                    hasNegative = true;
                    omit = new boolean[bsize];
                }
                if ((vi = -v - 1) >= omit.length || omit[vi]) continue;
                omit[vi] = true;
            }
            int n = vsize = typedValue != null ? typedValue.size() : listValue.size();
            if (!hasNegative) {
                int i;
                RArray res;
                if (hasNA && vsize > 1) {
                    throw RError.getNASubscripted(ast);
                }
                int nsize = maxIndex;
                RArray.Names names = base.names();
                boolean expanding = false;
                if (nsize <= bsize) {
                    nsize = bsize;
                    res = Utils.createArray(typedBase, nsize, dimensions, names, base.attributesRef());
                } else {
                    expanding = true;
                    res = Utils.createArray(typedBase, nsize, names != null).setAttributes(base.attributesRef());
                }
                for (i = 0; i < bsize; ++i) {
                    res.set(i, typedBase.get(i));
                }
                while (i < nsize) {
                    Utils.setNA(res, i);
                    ++i;
                }
                int j = 0;
                for (i = 0; i < isize; ++i) {
                    int v = index.getInt(i);
                    if (v == 0 || v == Integer.MIN_VALUE) continue;
                    if (typedValue != null) {
                        res.set(v - 1, typedValue.get(j++));
                    } else {
                        res.set(v - 1, listValue.getRAnyRef(j++));
                    }
                    if (j != vsize) continue;
                    j = 0;
                }
                if (j != 0) {
                    RContext.warning(ast, "number of items to replace is not a multiple of replacement length");
                }
                if (!expanding) return res;
                if (names == null) return res;
                return res.setNames(NumericSelection.expandNames(names, nsize));
            }
            if (hasPositive) throw RError.getOnlyZeroMixed(ast);
            if (hasNA) {
                throw RError.getOnlyZeroMixed(ast);
            }
            RArray res = Utils.createArray(typedBase, bsize, dimensions, base.names(), base.attributesRef());
            int j = 0;
            int i = 0;
            while (i < bsize) {
                if (omit[i]) {
                    res.set(i, typedBase.get(i));
                } else {
                    if (typedValue != null) {
                        res.set(i, typedValue.get(j++));
                    } else {
                        res.set(i, listValue.getRAnyRef(j++));
                    }
                    if (j == vsize) {
                        j = 0;
                    }
                }
                ++i;
            }
            return res;
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                RInt iindex;
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (!(value instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                }
                RArray avalue = (RArray)value;
                if (index instanceof RInt) {
                    iindex = (RInt)index;
                } else if (index instanceof RDouble) {
                    iindex = index.asInt();
                } else {
                    throw new SpecializationException((Object)Failure.NOT_NUMERIC_INDEX);
                }
                return NumericSelection.genericUpdate(abase, iindex, avalue, this.ast, this.subset);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                GenericSelection gs = new GenericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                this.replace(gs, "install GenericSelection from NumericSelection");
                return gs.execute(base, index, value);
            }
        }
    }

    public static class IntSequenceSelection
    extends UpdateVector {
        public IntSequenceSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
            assert (Utils.check(subset));
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                Specialized sn = this.createSimple(base, value);
                if (sn != null) {
                    this.replace(sn, "specialize IntSequenceSelection");
                    return sn.execute(base, index, value);
                }
                sn = this.createExtended();
                this.replace(sn, "specialize IntSequenceSelection");
                return sn.execute(base, index, value);
            }
        }

        public Specialized createSimple(RAny baseTemplate, RAny valueTemplate) {
            if (baseTemplate instanceof RList) {
                if (valueTemplate instanceof RList || valueTemplate instanceof RDouble || valueTemplate instanceof RInt || valueTemplate instanceof RLogical) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, IntImpl.RIntSequence index, RArray value) throws SpecializationException {
                            int delta;
                            int astep;
                            int i;
                            int vsize;
                            RList typedValue;
                            if (!(base instanceof RList)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RList typedBase = (RList)base;
                            if (value instanceof RList) {
                                typedValue = (RList)value;
                            } else if (value instanceof RDouble || value instanceof RInt || value instanceof RLogical) {
                                typedValue = value.asList();
                            } else {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            int bsize = base.size();
                            int imin = index.min();
                            int imax = index.max();
                            if (imin < 1 || imax > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            --imin;
                            --imax;
                            int isize = index.size();
                            if (isize != (vsize = typedValue.size())) {
                                throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                            }
                            RAny[] content = new RAny[bsize];
                            for (i = 0; i < imin; ++i) {
                                content[i] = typedBase.getRAny(i);
                            }
                            i = index.from() - 1;
                            int step = index.step();
                            if (step > 0) {
                                astep = step;
                                delta = 1;
                            } else {
                                astep = -step;
                                delta = -1;
                            }
                            int steps = 0;
                            assert (Utils.check(steps < isize));
                            block1: while (true) {
                                content[i] = typedValue.getRAnyRef(steps);
                                i += delta;
                                if (++steps >= isize) break;
                                int j = 1;
                                while (true) {
                                    if (j >= astep) continue block1;
                                    content[i] = typedBase.getRAny(i);
                                    i += delta;
                                    ++j;
                                }
                                break;
                            }
                            for (i = imax + 1; i < bsize; ++i) {
                                content[i] = typedBase.getRAny(i);
                            }
                            return RList.RListFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RList,RList|RDouble|RInt|RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RDouble) {
                if (valueTemplate instanceof RDouble || valueTemplate instanceof RLogical || valueTemplate instanceof RInt) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, IntImpl.RIntSequence index, RArray value) throws SpecializationException {
                            int delta;
                            int astep;
                            int i;
                            int vsize;
                            RDouble typedValue;
                            if (!(base instanceof RDouble)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RDouble typedBase = (RDouble)base;
                            if (value instanceof RDouble) {
                                typedValue = (RDouble)value;
                            } else if (value instanceof RInt || value instanceof RLogical) {
                                typedValue = value.asDouble();
                            } else {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            int bsize = base.size();
                            int imin = index.min();
                            int imax = index.max();
                            if (imin < 1 || imax > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            --imin;
                            --imax;
                            int isize = index.size();
                            if (isize != (vsize = typedValue.size())) {
                                throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                            }
                            double[] content = new double[bsize];
                            for (i = 0; i < imin; ++i) {
                                content[i] = typedBase.getDouble(i);
                            }
                            i = index.from() - 1;
                            int step = index.step();
                            if (step > 0) {
                                astep = step;
                                delta = 1;
                            } else {
                                astep = -step;
                                delta = -1;
                            }
                            int steps = 0;
                            assert (Utils.check(steps < isize));
                            block1: while (true) {
                                content[i] = typedValue.getDouble(steps);
                                i += delta;
                                if (++steps >= isize) break;
                                int j = 1;
                                while (true) {
                                    if (j >= astep) continue block1;
                                    content[i] = typedBase.getDouble(i);
                                    i += delta;
                                    ++j;
                                }
                                break;
                            }
                            for (i = imax + 1; i < bsize; ++i) {
                                content[i] = typedBase.getDouble(i);
                            }
                            return RDouble.RDoubleFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RDouble,RDouble|RInt|RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RInt) {
                if (valueTemplate instanceof RInt || valueTemplate instanceof RLogical) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, IntImpl.RIntSequence index, RArray value) throws SpecializationException {
                            int delta;
                            int astep;
                            int i;
                            int vsize;
                            RInt typedValue;
                            if (!(base instanceof RInt)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RInt typedBase = (RInt)base;
                            if (value instanceof RInt) {
                                typedValue = (RInt)value;
                            } else if (value instanceof RLogical) {
                                typedValue = value.asInt();
                            } else {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            int bsize = base.size();
                            int imin = index.min();
                            int imax = index.max();
                            if (imin < 1 || imax > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            --imin;
                            --imax;
                            int isize = index.size();
                            if (isize != (vsize = typedValue.size())) {
                                throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                            }
                            int[] content = new int[bsize];
                            for (i = 0; i < imin; ++i) {
                                content[i] = typedBase.getInt(i);
                            }
                            i = index.from() - 1;
                            int step = index.step();
                            if (step > 0) {
                                astep = step;
                                delta = 1;
                            } else {
                                astep = -step;
                                delta = -1;
                            }
                            int steps = 0;
                            assert (Utils.check(steps < isize));
                            block1: while (true) {
                                content[i] = typedValue.getInt(steps);
                                i += delta;
                                if (++steps >= isize) break;
                                int j = 1;
                                while (true) {
                                    if (j >= astep) continue block1;
                                    content[i] = typedBase.getInt(i);
                                    i += delta;
                                    ++j;
                                }
                                break;
                            }
                            for (i = imax + 1; i < bsize; ++i) {
                                content[i] = typedBase.getInt(i);
                            }
                            return RInt.RIntFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RInt,RInt|RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RLogical) {
                if (valueTemplate instanceof RLogical) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, IntImpl.RIntSequence index, RArray value) throws SpecializationException {
                            int delta;
                            int astep;
                            int i;
                            int vsize;
                            if (!(base instanceof RLogical) || !(value instanceof RLogical)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RLogical typedBase = (RLogical)base;
                            RLogical typedValue = (RLogical)value;
                            int bsize = base.size();
                            int imin = index.min();
                            int imax = index.max();
                            if (imin < 1 || imax > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            --imin;
                            --imax;
                            int isize = index.size();
                            if (isize != (vsize = typedValue.size())) {
                                throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                            }
                            int[] content = new int[bsize];
                            for (i = 0; i < imin; ++i) {
                                content[i] = typedBase.getLogical(i);
                            }
                            i = index.from() - 1;
                            int step = index.step();
                            if (step > 0) {
                                astep = step;
                                delta = 1;
                            } else {
                                astep = -step;
                                delta = -1;
                            }
                            int steps = 0;
                            assert (Utils.check(steps < isize));
                            block1: while (true) {
                                content[i] = typedValue.getLogical(steps);
                                i += delta;
                                if (++steps >= isize) break;
                                int j = 1;
                                while (true) {
                                    if (j >= astep) continue block1;
                                    content[i] = typedBase.getLogical(i);
                                    i += delta;
                                    ++j;
                                }
                                break;
                            }
                            for (i = imax + 1; i < bsize; ++i) {
                                content[i] = typedBase.getLogical(i);
                            }
                            return RLogical.RLogicalFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RLogical,RLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RString) {
                if (valueTemplate instanceof RString) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, IntImpl.RIntSequence index, RArray value) throws SpecializationException {
                            int delta;
                            int astep;
                            int i;
                            int vsize;
                            if (!(base instanceof RString) || !(value instanceof RString)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RString typedBase = (RString)base;
                            RString typedValue = (RString)value;
                            int bsize = base.size();
                            int imin = index.min();
                            int imax = index.max();
                            if (imin < 1 || imax > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            --imin;
                            --imax;
                            int isize = index.size();
                            if (isize != (vsize = typedValue.size())) {
                                throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                            }
                            String[] content = new String[bsize];
                            for (i = 0; i < imin; ++i) {
                                content[i] = typedBase.getString(i);
                            }
                            i = index.from() - 1;
                            int step = index.step();
                            if (step > 0) {
                                astep = step;
                                delta = 1;
                            } else {
                                astep = -step;
                                delta = -1;
                            }
                            int steps = 0;
                            assert (Utils.check(steps < isize));
                            block1: while (true) {
                                content[i] = typedValue.getString(steps);
                                i += delta;
                                if (++steps >= isize) break;
                                int j = 1;
                                while (true) {
                                    if (j >= astep) continue block1;
                                    content[i] = typedBase.getString(i);
                                    i += delta;
                                    ++j;
                                }
                                break;
                            }
                            for (i = imax + 1; i < bsize; ++i) {
                                content[i] = typedBase.getString(i);
                            }
                            return RString.RStringFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RString,RString>");
                }
                return null;
            }
            return null;
        }

        public Specialized createExtended() {
            ValueCopy cpy = new ValueCopy(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                RAny copy(RArray base, IntImpl.RIntSequence index, RArray value) throws SpecializationException {
                    int j;
                    int steps;
                    int delta;
                    int astep;
                    int i;
                    int vsize;
                    int[] dimensions;
                    RArray typedBase;
                    RArray typedValue;
                    RList listValue = null;
                    if (value instanceof RList) {
                        typedValue = null;
                        listValue = (RList)value;
                        if (base instanceof RList) {
                            typedBase = base;
                            dimensions = base.dimensions();
                        } else {
                            typedBase = base.asList();
                            dimensions = null;
                        }
                    } else {
                        if (base instanceof RList) {
                            typedBase = base;
                            typedValue = value.asList();
                        } else if (base instanceof RRaw) {
                            if (!(value instanceof RRaw)) throw RError.getSubassignTypeFix(IntSequenceSelection.this.ast, value.typeOf(), base.typeOf());
                            typedBase = base;
                            typedValue = value.asRaw();
                        } else {
                            if (value instanceof RRaw) {
                                throw RError.getSubassignTypeFix(IntSequenceSelection.this.ast, value.typeOf(), base.typeOf());
                            }
                            if (base instanceof RString || value instanceof RString) {
                                typedBase = base.asString();
                                typedValue = value.asString();
                            } else if (base instanceof RComplex || value instanceof RComplex) {
                                typedBase = base.asComplex();
                                typedValue = value.asComplex();
                            } else if (base instanceof RDouble || value instanceof RDouble) {
                                typedBase = base.asDouble();
                                typedValue = value.asDouble();
                            } else if (base instanceof RInt || value instanceof RInt) {
                                typedBase = base.asInt();
                                typedValue = value.asInt();
                            } else {
                                assert (Utils.check(base instanceof RLogical || base instanceof RNull));
                                assert (Utils.check(value instanceof RLogical));
                                typedBase = base.asLogical();
                                typedValue = value;
                            }
                        }
                        dimensions = typedBase.dimensions();
                    }
                    int bsize = base.size();
                    int imin = index.min();
                    int imax = index.max();
                    if (imin < 1 || imax > bsize) {
                        throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                    }
                    --imin;
                    --imax;
                    int isize = index.size();
                    int n = vsize = typedValue != null ? typedValue.size() : listValue.size();
                    if (isize != vsize) {
                        throw new SpecializationException((Object)Failure.NOT_SAME_LENGTH);
                    }
                    RArray res = Utils.createArray(typedBase, bsize, dimensions, base.names(), base.attributesRef());
                    for (i = 0; i < imin; ++i) {
                        res.set(i, typedBase.get(i));
                    }
                    i = index.from() - 1;
                    int step = index.step();
                    if (step > 0) {
                        astep = step;
                        delta = 1;
                    } else {
                        astep = -step;
                        delta = -1;
                    }
                    if (typedValue != null) {
                        steps = 0;
                        assert (Utils.check(steps < isize));
                        block1: while (true) {
                            res.set(i, typedValue.get(steps));
                            i += delta;
                            if (++steps < isize) {
                                j = 1;
                                while (true) {
                                    if (j >= astep) continue block1;
                                    res.set(i, typedBase.get(i));
                                    i += delta;
                                    ++j;
                                }
                            }
                            break;
                        }
                    } else {
                        steps = 0;
                        assert (Utils.check(steps < isize));
                        block3: while (true) {
                            res.set(i, listValue.getRAnyRef(steps));
                            i += delta;
                            if (++steps >= isize) break;
                            j = 1;
                            while (true) {
                                if (j >= astep) continue block3;
                                res.set(i, typedBase.get(i));
                                i += delta;
                                ++j;
                            }
                            break;
                        }
                    }
                    for (i = imax + 1; i < bsize; ++i) {
                        res.set(i, typedBase.get(i));
                    }
                    return res;
                }
            };
            return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<Extended>");
        }

        class Specialized
        extends IntSequenceSelection {
            final ValueCopy copy;
            final String dbg;

            Specialized(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset, ValueCopy copy, String dbg) {
                super(ast, isSuper, var, lhs, indexes, rhs, subset);
                this.copy = copy;
                this.dbg = dbg;
            }

            @Override
            public RAny execute(RAny base, RAny index, RAny value) {
                try {
                    if (!(base instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                    }
                    RArray abase = (RArray)base;
                    if (!(value instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                    }
                    RArray avalue = (RArray)value;
                    if (!(index instanceof IntImpl.RIntSequence)) {
                        throw new SpecializationException((Object)Failure.NOT_INT_SEQUENCE_INDEX);
                    }
                    return this.copy.copy(abase, (IntImpl.RIntSequence)index, avalue);
                }
                catch (SpecializationException e) {
                    Failure f = (Failure)((Object)e.getResult());
                    switch (f) {
                        case UNEXPECTED_TYPE: {
                            Specialized sn = this.createExtended();
                            this.replace(sn, "specialize IntSequenceSelection");
                            return sn.execute(base, index, value);
                        }
                    }
                    NumericSelection ns = new NumericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                    this.replace(ns, "install NumericSelection from IntSequenceSelection");
                    return ns.execute(base, index, value);
                }
            }
        }

        abstract class ValueCopy {
            ValueCopy() {
            }

            abstract RAny copy(RArray var1, IntImpl.RIntSequence var2, RArray var3) throws SpecializationException;
        }
    }

    public static class GenericScalarSelection
    extends UpdateVector {
        public GenericScalarSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
        }

        public static RAny deleteElement(RList base, int i) {
            return GenericScalarSelection.deleteElement(base, i, base.size());
        }

        public static RAny deleteElement(RList base, int index, int size) {
            int j;
            int i = index;
            int nsize = size - 1;
            RAny[] content = new RAny[nsize];
            for (j = 0; j < i; ++j) {
                content[j] = base.getRAny(j);
            }
            ++i;
            while (j < nsize) {
                content[j] = base.getRAny(i++);
                ++j;
            }
            RArray.Names bnames = base.names();
            return RList.RListFactory.getFor(content, null, bnames == null ? null : GenericScalarSelection.removeName(bnames, index), base.attributesRef());
        }

        public static RAny deleteElement(RList base, int i, ASTNode ast, boolean subset) {
            int size = base.size();
            if (i > 0) {
                int zi = i - 1;
                if (i <= size) {
                    return GenericScalarSelection.deleteElement(base, zi, size);
                }
                if (subset) {
                    int j;
                    int nsize = i - 1;
                    RAny[] content = new RAny[nsize];
                    for (j = 0; j < size; ++j) {
                        content[j] = base.getRAny(j);
                    }
                    while (j < nsize) {
                        content[j] = RList.NULL;
                        ++j;
                    }
                    RArray.Names bnames = base.names();
                    return RList.RListFactory.getFor(content, null, bnames == null ? null : GenericScalarSelection.expandNames(bnames, nsize), base.attributesRef());
                }
                return base;
            }
            if (subset) {
                if (i == 0 || i == Integer.MIN_VALUE) {
                    return base;
                }
            } else {
                if (i == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (i == Integer.MIN_VALUE) {
                    throw RError.getSelectMoreThanOne(ast);
                }
            }
            if (!subset) {
                if (size <= 1) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (size > 2) {
                    throw RError.getSelectMoreThanOne(ast);
                }
                if (i != -1 && i != -2) {
                    throw RError.getSelectMoreThanOne(ast);
                }
            }
            int keep = -i - 1;
            return RList.RListFactory.getScalar(base.getRAny(keep));
        }

        public static RAny deleteElement(RList base, String index) {
            RArray.Names names = base.names();
            int deleteIndex = -1;
            if (names != null) {
                deleteIndex = names.map(RSymbol.getSymbol(index));
            }
            if (deleteIndex != -1) {
                return GenericScalarSelection.deleteElement(base, deleteIndex);
            }
            return Utils.dropDimensions(base);
        }

        public static RAny deleteElement(RArray base, RArray index, ASTNode ast, boolean subset) {
            assert (Utils.check(!(index instanceof RNull)));
            if (!(base instanceof RList)) {
                if (subset) {
                    throw RError.getReplacementZero(ast);
                }
                throw RError.getMoreElementsSupplied(ast);
            }
            RList l = (RList)base;
            if (index instanceof RInt) {
                int i = ((RInt)index).getInt(0);
                return GenericScalarSelection.deleteElement(l, i, ast, subset);
            }
            if (index instanceof RDouble) {
                int i = Convert.double2int(((RDouble)index).getDouble(0));
                return GenericScalarSelection.deleteElement(l, i, ast, subset);
            }
            if (index instanceof RLogical) {
                int i = Convert.logical2int(((RLogical)index).getLogical(0));
                if (subset) {
                    if (i == 1) {
                        return RList.EMPTY;
                    }
                    return base;
                }
                return GenericScalarSelection.deleteElement(l, i, ast, subset);
            }
            if (index instanceof RString) {
                return GenericScalarSelection.deleteElement(l, ((RString)index).getString(0));
            }
            throw RError.getInvalidSubscriptType(ast, index.typeOf());
        }

        public static RAny update(RArray base, RArray index, RArray value, ASTNode ast, boolean subset) throws SpecializationException {
            int i;
            int vsize = value.size();
            if (vsize == 0) {
                throw RError.getReplacementZero(ast);
            }
            if (index instanceof RString) {
                return ScalarStringSelection.genericUpdate(base, ((RString)index).getString(0), value, subset, ast);
            }
            if (index instanceof RLogical) {
                if (subset) {
                    throw new SpecializationException((Object)Failure.MAYBE_VECTOR_UPDATE);
                }
                if (vsize > 1 && !(base instanceof RList)) {
                    throw RError.getMoreElementsSupplied(ast);
                }
                int l = ((RLogical)index).getLogical(0);
                if (l == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (l == Integer.MIN_VALUE) {
                    throw RError.getSelectMoreThanOne(ast);
                }
                return ScalarNumericSelection.genericUpdate(base, 1, value, subset, ast);
            }
            if (index instanceof RInt) {
                i = ((RInt)index).getInt(0);
            } else if (index instanceof RDouble) {
                i = Convert.double2int(((RDouble)index).getDouble(0));
            } else {
                throw RError.getInvalidSubscriptType(ast, index.typeOf());
            }
            if (i >= 0 || i == Integer.MIN_VALUE || !subset) {
                if (vsize > 1) {
                    if (subset) {
                        if (i == Integer.MIN_VALUE) {
                            throw RError.getNASubscripted(ast);
                        }
                        RContext.warning(ast, "number of items to replace is not a multiple of replacement length");
                    } else if (!(base instanceof RList)) {
                        throw RError.getMoreElementsSupplied(ast);
                    }
                }
                return ScalarNumericSelection.genericUpdate(base, i, value, subset, ast);
            }
            if (vsize == 1) {
                return ScalarNumericSelection.genericUpdate(base, i, value, subset, ast);
            }
            throw new SpecializationException((Object)Failure.MAYBE_VECTOR_UPDATE);
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                if (!(base instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                }
                RArray abase = (RArray)base;
                if (!(index instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_INDEX);
                }
                RArray aindex = (RArray)index;
                int isize = aindex.size();
                if (isize != 1) {
                    throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT_INDEX);
                }
                if (value instanceof RNull) {
                    return GenericScalarSelection.deleteElement(abase, aindex, this.ast, this.subset);
                }
                if (!(value instanceof RArray)) {
                    throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                }
                RArray avalue = (RArray)value;
                return GenericScalarSelection.update(abase, aindex, avalue, this.ast, this.subset);
            }
            catch (SpecializationException e) {
                Failure f = (Failure)((Object)e.getResult());
                switch (f) {
                    case NOT_ONE_ELEMENT_INDEX: 
                    case MAYBE_VECTOR_UPDATE: {
                        if (this.subset) {
                            if (index instanceof IntImpl.RIntSequence) {
                                IntSequenceSelection is = new IntSequenceSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                                this.replace(is, "install IntSequenceSelection from GenericScalarSelection");
                                return is.execute(base, index, value);
                            }
                            if (index instanceof RInt || index instanceof RDouble) {
                                NumericSelection ns = new NumericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                                this.replace(ns, "install NumericSelection from GenericScalarSelection");
                                return ns.execute(base, index, value);
                            }
                            if (!(index instanceof RLogical)) break;
                            LogicalSelection ls = new LogicalSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                            this.replace(ls, "install LogicalSelection from GenericScalarSelection");
                            return ls.execute(base, index, value);
                        }
                        Subscript s = new Subscript(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                        this.replace(s, "install Subscript from GenericScalarSelection");
                        return s.execute(base, index, value);
                    }
                }
                GenericSelection gs = new GenericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                this.replace(gs, "install GenericSelection from GenericScalarSelection");
                return gs.execute(base, index, value);
            }
        }
    }

    public static class ScalarStringSelection {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RArray genericUpdate(RArray base, String index, RAny value, boolean subset, ASTNode ast) {
            Object rawValue;
            RArray typedBase;
            int[] dimensions = base.dimensions();
            RArray.Names names = base.names();
            if (value instanceof RList) {
                if (base instanceof RList) {
                    typedBase = base;
                } else {
                    typedBase = base.asList();
                    dimensions = null;
                }
                RAny v = subset ? ((RList)value).getRAny(0) : value;
                v.ref();
                rawValue = v;
            } else if (base instanceof RList) {
                typedBase = base;
                rawValue = value;
                value.ref();
            } else if (base instanceof RRaw) {
                if (!(value instanceof RRaw)) throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                typedBase = base;
                rawValue = ((RRaw)value).get(0);
            } else {
                if (value instanceof RRaw) {
                    throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                }
                if (base instanceof RString || value instanceof RString) {
                    typedBase = base.asString();
                    rawValue = value.asString().get(0);
                } else if (base instanceof RComplex || value instanceof RComplex) {
                    typedBase = base.asComplex();
                    rawValue = value.asComplex().get(0);
                } else if (base instanceof RDouble || value instanceof RDouble) {
                    typedBase = base.asDouble();
                    rawValue = value.asDouble().get(0);
                } else if (base instanceof RInt || value instanceof RInt) {
                    typedBase = base.asInt();
                    rawValue = value.asInt().get(0);
                } else {
                    assert (Utils.check(base instanceof RLogical || base instanceof RNull));
                    assert (Utils.check(value instanceof RLogical));
                    typedBase = base.asLogical();
                    rawValue = ((RLogical)value).get(0);
                }
            }
            int bsize = base.size();
            int pos = -1;
            RSymbol symbol = RSymbol.getSymbol(index);
            if (names != null) {
                pos = names.map(symbol);
            }
            if (pos != -1) {
                int i;
                if (base == typedBase && !base.isShared()) {
                    base.set(pos, rawValue);
                    return base;
                }
                RArray res = Utils.createArray(typedBase, bsize, dimensions, names, base.attributesRef());
                for (i = 0; i < pos; ++i) {
                    res.set(i, typedBase.get(i));
                }
                res.set(i++, rawValue);
                while (i < bsize) {
                    res.set(i, typedBase.get(i));
                    ++i;
                }
                return res;
            }
            if (names == null) {
                names = RArray.Names.create(bsize);
            }
            RArray res = Utils.createArray(typedBase, bsize + 1, dimensions, UpdateVector.appendName(names, symbol), base.attributesRef());
            for (int i = 0; i < bsize; ++i) {
                res.set(i, typedBase.get(i));
            }
            res.set(bsize, rawValue);
            return res;
        }
    }

    public static class ScalarNumericSelection
    extends UpdateVector {
        public ScalarNumericSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
        }

        @Override
        public RAny execute(RAny base, RAny index, RAny value) {
            try {
                throw new SpecializationException((Object)null);
            }
            catch (SpecializationException e) {
                Specialized sn = this.createSimple(base, value);
                if (sn != null) {
                    this.replace(sn, "specialize ScalarNumericSelection");
                    return sn.execute(base, index, value);
                }
                sn = this.createGeneric();
                this.replace(sn, "specialize ScalarNumericSelection");
                return sn.execute(base, index, value);
            }
        }

        public Specialized createSimple(RAny baseTemplate, RAny valueTemplate) {
            if (baseTemplate instanceof RInt) {
                if (valueTemplate instanceof ScalarIntImpl) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                            int i;
                            if (!(base instanceof RInt) || !(value instanceof ScalarIntImpl)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RInt ibase = (RInt)base;
                            int bsize = ibase.size();
                            if (pos < 1 || pos > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int zpos = pos - 1;
                            if (!ibase.isShared()) {
                                return ibase.set(zpos, ((ScalarIntImpl)value).getInt());
                            }
                            int[] content = new int[bsize];
                            for (i = 0; i < zpos; ++i) {
                                content[i] = ibase.getInt(i);
                            }
                            content[i++] = ((ScalarIntImpl)value).getInt();
                            while (i < bsize) {
                                content[i] = ibase.getInt(i);
                                ++i;
                            }
                            return RInt.RIntFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RInt,ScalarInt>");
                }
                if (valueTemplate instanceof ScalarLogicalImpl) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                            int i;
                            if (!(base instanceof RInt) || !(value instanceof ScalarLogicalImpl)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RInt ibase = (RInt)base;
                            int bsize = ibase.size();
                            if (pos < 1 || pos > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int zpos = pos - 1;
                            if (!ibase.isShared()) {
                                return ibase.set(zpos, ((ScalarLogicalImpl)value).getLogical());
                            }
                            int[] content = new int[bsize];
                            for (i = 0; i < zpos; ++i) {
                                content[i] = ibase.getInt(i);
                            }
                            content[i++] = ((ScalarLogicalImpl)value).getLogical();
                            while (i < bsize) {
                                content[i] = ibase.getInt(i);
                                ++i;
                            }
                            return RInt.RIntFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RInt,ScalarLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RDouble) {
                if (valueTemplate instanceof ScalarDoubleImpl) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                            int i;
                            if (!(base instanceof RDouble) || !(value instanceof ScalarDoubleImpl)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RDouble dbase = (RDouble)base;
                            int bsize = dbase.size();
                            if (pos < 1 || pos > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int zpos = pos - 1;
                            if (!dbase.isShared()) {
                                return dbase.set(zpos, ((ScalarDoubleImpl)value).getDouble());
                            }
                            double[] content = new double[bsize];
                            for (i = 0; i < zpos; ++i) {
                                content[i] = dbase.getDouble(i);
                            }
                            content[i++] = ((ScalarDoubleImpl)value).getDouble();
                            while (i < bsize) {
                                content[i] = dbase.getDouble(i);
                                ++i;
                            }
                            return RDouble.RDoubleFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RDouble,ScalarDouble>");
                }
                if (valueTemplate instanceof ScalarIntImpl) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                            int i;
                            if (!(base instanceof RDouble) || !(value instanceof ScalarIntImpl)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RDouble dbase = (RDouble)base;
                            int bsize = dbase.size();
                            if (pos < 1 || pos > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int zpos = pos - 1;
                            if (!dbase.isShared()) {
                                return dbase.set(zpos, Convert.int2double(((ScalarIntImpl)value).getInt()));
                            }
                            double[] content = new double[bsize];
                            for (i = 0; i < zpos; ++i) {
                                content[i] = dbase.getDouble(i);
                            }
                            content[i++] = Convert.int2double(((ScalarIntImpl)value).getInt());
                            while (i < bsize) {
                                content[i] = dbase.getDouble(i);
                                ++i;
                            }
                            return RDouble.RDoubleFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RDouble,ScalarInt>");
                }
                if (valueTemplate instanceof ScalarLogicalImpl) {
                    ValueCopy cpy = new ValueCopy(){

                        @Override
                        RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                            int i;
                            if (!(base instanceof RDouble) || !(value instanceof ScalarLogicalImpl)) {
                                throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                            }
                            RDouble dbase = (RDouble)base;
                            int bsize = dbase.size();
                            if (pos < 1 || pos > bsize) {
                                throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                            }
                            int zpos = pos - 1;
                            if (!dbase.isShared()) {
                                return dbase.set(zpos, Convert.logical2double(((ScalarLogicalImpl)value).getLogical()));
                            }
                            double[] content = new double[bsize];
                            for (i = 0; i < zpos; ++i) {
                                content[i] = dbase.getDouble(i);
                            }
                            content[i++] = Convert.logical2double(((ScalarLogicalImpl)value).getLogical());
                            while (i < bsize) {
                                content[i] = dbase.getDouble(i);
                                ++i;
                            }
                            return RDouble.RDoubleFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                        }
                    };
                    return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RDouble,ScalarLogical>");
                }
                return null;
            }
            if (baseTemplate instanceof RLogical && valueTemplate instanceof ScalarLogicalImpl) {
                ValueCopy cpy = new ValueCopy(){

                    @Override
                    RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                        int i;
                        if (!(base instanceof RLogical) || !(value instanceof ScalarLogicalImpl)) {
                            throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                        }
                        RLogical lbase = (RLogical)base;
                        int bsize = lbase.size();
                        if (pos < 1 || pos > bsize) {
                            throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                        }
                        int zpos = pos - 1;
                        if (!lbase.isShared()) {
                            return lbase.set(zpos, ((ScalarLogicalImpl)value).getLogical());
                        }
                        int[] content = new int[bsize];
                        for (i = 0; i < zpos; ++i) {
                            content[i] = lbase.getLogical(i);
                        }
                        content[i++] = ((ScalarLogicalImpl)value).getLogical();
                        while (i < bsize) {
                            content[i] = lbase.getLogical(i);
                            ++i;
                        }
                        return RLogical.RLogicalFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                    }
                };
                return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RLogical,ScalarLogical>");
            }
            if (baseTemplate instanceof RList && !this.subset && !(valueTemplate instanceof RNull)) {
                ValueCopy cpy = new ValueCopy(){

                    @Override
                    RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                        int i;
                        if (!(base instanceof RList) || value instanceof RNull) {
                            throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                        }
                        RList lbase = (RList)base;
                        int bsize = lbase.size();
                        if (pos < 1 || pos > bsize) {
                            throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                        }
                        int zpos = pos - 1;
                        value.ref();
                        if (!lbase.isShared()) {
                            return lbase.set(zpos, value);
                        }
                        RAny[] content = new RAny[bsize];
                        for (i = 0; i < zpos; ++i) {
                            content[i] = lbase.getRAny(i);
                        }
                        content[i++] = value;
                        while (i < bsize) {
                            content[i] = lbase.getRAny(i);
                            ++i;
                        }
                        return RList.RListFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                    }
                };
                return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RList,?>");
            }
            if (baseTemplate instanceof RString && valueTemplate instanceof ScalarStringImpl) {
                ValueCopy cpy = new ValueCopy(){

                    @Override
                    RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                        int i;
                        if (!(base instanceof RString) || !(value instanceof ScalarStringImpl)) {
                            throw new SpecializationException((Object)Failure.UNEXPECTED_TYPE);
                        }
                        RString sbase = (RString)base;
                        int bsize = sbase.size();
                        if (pos < 1 || pos > bsize) {
                            throw new SpecializationException((Object)Failure.INDEX_OUT_OF_BOUNDS);
                        }
                        int zpos = pos - 1;
                        if (!sbase.isShared()) {
                            return sbase.set(zpos, ((ScalarStringImpl)value).getString());
                        }
                        String[] content = new String[bsize];
                        for (i = 0; i < zpos; ++i) {
                            content[i] = sbase.getString(i);
                        }
                        content[i++] = ((ScalarStringImpl)value).getString();
                        while (i < bsize) {
                            content[i] = sbase.getString(i);
                            ++i;
                        }
                        return RString.RStringFactory.getFor(content, base.dimensions(), base.names(), base.attributesRef());
                    }
                };
                return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<RString,ScalarString>");
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RAny genericUpdate(RArray base, int pos, RAny value, boolean subset, ASTNode ast) {
            int i;
            Object rawValue;
            RArray typedBase;
            int[] dimensions = base.dimensions();
            RArray.Names names = base.names();
            if (value instanceof RList) {
                if (base instanceof RList) {
                    typedBase = base;
                } else {
                    typedBase = base.asList();
                    dimensions = null;
                }
                RAny v = subset ? ((RList)value).getRAny(0) : value;
                v.ref();
                rawValue = v;
            } else if (base instanceof RList) {
                typedBase = base;
                rawValue = value;
                value.ref();
            } else if (base instanceof RRaw) {
                if (!(value instanceof RRaw)) throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                typedBase = base;
                rawValue = ((RRaw)value).get(0);
            } else {
                if (value instanceof RRaw) {
                    throw RError.getSubassignTypeFix(ast, value.typeOf(), base.typeOf());
                }
                if (base instanceof RString || value instanceof RString) {
                    typedBase = base.asString();
                    rawValue = value.asString().get(0);
                } else if (base instanceof RComplex || value instanceof RComplex) {
                    typedBase = base.asComplex();
                    rawValue = value.asComplex().get(0);
                } else if (base instanceof RDouble || value instanceof RDouble) {
                    typedBase = base.asDouble();
                    rawValue = value.asDouble().get(0);
                } else if (base instanceof RInt || value instanceof RInt) {
                    typedBase = base.asInt();
                    rawValue = value.asInt().get(0);
                } else {
                    assert (Utils.check(base instanceof RLogical || base instanceof RNull));
                    assert (Utils.check(value instanceof RLogical));
                    typedBase = base.asLogical();
                    rawValue = ((RLogical)value).get(0);
                }
            }
            int bsize = base.size();
            if (pos > 0) {
                int i2;
                if (pos <= bsize) {
                    int i3;
                    int zpos = pos - 1;
                    if (base == typedBase && !base.isShared()) {
                        base.set(zpos, rawValue);
                        return base;
                    }
                    RArray res = Utils.createArray(typedBase, bsize, dimensions, names, base.attributesRef());
                    for (i3 = 0; i3 < zpos; ++i3) {
                        res.set(i3, typedBase.get(i3));
                    }
                    res.set(i3++, rawValue);
                    while (i3 < bsize) {
                        res.set(i3, typedBase.get(i3));
                        ++i3;
                    }
                    return res;
                }
                int zpos = pos - 1;
                int nsize = zpos + 1;
                RArray res = Utils.createArray(typedBase, nsize, names != null).setAttributes(base.attributesRef());
                for (i2 = 0; i2 < bsize; ++i2) {
                    res.set(i2, typedBase.get(i2));
                }
                while (i2 < zpos) {
                    Utils.setNA(res, i2);
                    ++i2;
                }
                res.set(i2, rawValue);
                if (names == null) return res;
                return res.setNames(ScalarNumericSelection.expandNames(names, zpos + 1));
            }
            if (pos == Integer.MIN_VALUE) {
                if (!subset) throw RError.getSelectMoreThanOne(ast);
                return typedBase;
            }
            if (!subset) {
                if (bsize <= 1) throw RError.getSelectLessThanOne(ast);
                if (pos == 0) {
                    throw RError.getSelectLessThanOne(ast);
                }
                if (bsize > 2) {
                    throw RError.getSelectMoreThanOne(ast);
                }
                if (pos != -1 && pos != -2) {
                    throw RError.getSelectMoreThanOne(ast);
                }
            }
            if (pos == 0) {
                return typedBase;
            }
            int keep = -pos - 1;
            Utils.refIfRAny(rawValue);
            RArray res = Utils.createArray(typedBase, bsize, dimensions, names, base.attributesRef());
            if (keep >= bsize) {
                while (i < bsize) {
                    res.set(i, rawValue);
                    ++i;
                }
                return res;
            }
            for (i = 0; i < keep; ++i) {
                res.set(i, rawValue);
            }
            res.set(i, typedBase.get(i));
            ++i;
            while (i < bsize) {
                res.set(i, rawValue);
                ++i;
            }
            return res;
        }

        public Specialized createGeneric() {
            ValueCopy cpy = new ValueCopy(){

                @Override
                RAny copy(RArray base, int pos, RAny value) throws SpecializationException {
                    if (!(value instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_VALUE);
                    }
                    RArray avalue = (RArray)value;
                    int vsize = avalue.size();
                    if (vsize != 1) {
                        throw new SpecializationException((Object)Failure.NOT_ONE_ELEMENT_VALUE);
                    }
                    return ScalarNumericSelection.genericUpdate(base, pos, value, ScalarNumericSelection.this.subset, ScalarNumericSelection.this.ast);
                }
            };
            return new Specialized(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset, cpy, "<Generic>");
        }

        static class Specialized
        extends ScalarNumericSelection {
            final ValueCopy copy;
            final String dbg;

            Specialized(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset, ValueCopy copy, String dbg) {
                super(ast, isSuper, var, lhs, indexes, rhs, subset);
                this.copy = copy;
                this.dbg = dbg;
            }

            @Override
            public RAny execute(RAny base, RAny index, RAny value) {
                try {
                    int pos;
                    if (!(base instanceof RArray)) {
                        throw new SpecializationException((Object)Failure.NOT_ARRAY_BASE);
                    }
                    RArray abase = (RArray)base;
                    if (index instanceof ScalarIntImpl) {
                        pos = ((ScalarIntImpl)index).getInt();
                    } else if (index instanceof ScalarDoubleImpl) {
                        pos = Convert.double2int(((ScalarDoubleImpl)index).getDouble());
                    } else {
                        throw new SpecializationException((Object)null);
                    }
                    return this.copy.copy(abase, pos, value);
                }
                catch (SpecializationException e) {
                    Failure f = (Failure)((Object)e.getResult());
                    if (f == null) {
                        f = index instanceof RArray && ((RArray)index).size() != 1 ? Failure.NOT_ONE_ELEMENT_INDEX : Failure.NOT_NUMERIC_INDEX;
                    }
                    switch (f) {
                        case INDEX_OUT_OF_BOUNDS: 
                        case UNEXPECTED_TYPE: {
                            Specialized sn = this.createGeneric();
                            this.replace(sn, "specialize ScalarNumericSelection");
                            return sn.execute(base, index, value);
                        }
                        case NOT_ONE_ELEMENT_INDEX: {
                            if (this.subset) break;
                            Subscript s = new Subscript(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                            this.replace(s, "install Subscript from ScalarNumericSelection");
                            return s.execute(base, index, value);
                        }
                    }
                    GenericScalarSelection gs = new GenericScalarSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                    this.replace(gs, "install GenericScalarSelection from ScalarNumericSelection");
                    return gs.execute(base, index, value);
                }
            }
        }

        abstract class ValueCopy {
            ValueCopy() {
            }

            abstract RAny copy(RArray var1, int var2, RAny var3) throws SpecializationException;
        }
    }

    public static abstract class DoubleBaseSimpleSelection
    extends UpdateVector {
        public DoubleBaseSimpleSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
            super(ast, isSuper, var, lhs, indexes, rhs, subset);
        }

        public static class ScalarDoubleWithAttributesSelection
        extends DoubleBaseSimpleSelection {
            public ScalarDoubleWithAttributesSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
                super(ast, isSuper, var, lhs, indexes, rhs, subset);
            }

            @Override
            public RAny execute(RAny base, RAny index, RAny value) {
                try {
                    if (!(index instanceof ScalarDoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    int i = Convert.double2int(((ScalarDoubleImpl)index).getDouble()) - 1;
                    if (!(base instanceof DoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    DoubleImpl dibase = (DoubleImpl)base;
                    if (dibase.isShared()) {
                        throw new SpecializationException((Object)null);
                    }
                    double[] dbase = dibase.getContent();
                    if (i < 0 || i >= dbase.length) {
                        throw new SpecializationException((Object)null);
                    }
                    if (!(value instanceof RDouble)) {
                        throw new SpecializationException((Object)null);
                    }
                    RDouble dblvalue = (RDouble)value;
                    if (dblvalue.size() != 1) {
                        throw new SpecializationException((Object)null);
                    }
                    dbase[i] = dblvalue.getDouble(0);
                    return dibase;
                }
                catch (SpecializationException e) {
                    ScalarNumericSelection ns = new ScalarNumericSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                    this.replace(ns, "install ScalarNumericSelection from DoubleBaseSimpleSelection.ScalarIntSelection");
                    return ns.execute(base, index, value);
                }
            }
        }

        public static class ScalarDoubleSelection
        extends DoubleBaseSimpleSelection {
            public ScalarDoubleSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
                super(ast, isSuper, var, lhs, indexes, rhs, subset);
            }

            @Override
            public RAny execute(RAny base, RAny index, RAny value) {
                try {
                    double dvalue;
                    if (!(index instanceof ScalarDoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    int i = Convert.double2int(((ScalarDoubleImpl)index).getDouble()) - 1;
                    if (!(base instanceof DoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    DoubleImpl dibase = (DoubleImpl)base;
                    if (dibase.isShared()) {
                        throw new SpecializationException((Object)null);
                    }
                    double[] dbase = dibase.getContent();
                    if (i < 0 || i >= dbase.length) {
                        throw new SpecializationException((Object)null);
                    }
                    if (!(value instanceof ScalarDoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    dbase[i] = dvalue = ((ScalarDoubleImpl)value).getDouble();
                    return dibase;
                }
                catch (SpecializationException e) {
                    ScalarDoubleWithAttributesSelection ns = new ScalarDoubleWithAttributesSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                    this.replace(ns, "install ScalarDoubleWithAttributesSelection from DoubleBaseSimpleSelection.ScalarIntSelection");
                    return ns.execute(base, index, value);
                }
            }
        }

        public static class ScalarIntSelection
        extends DoubleBaseSimpleSelection {
            public ScalarIntSelection(ASTNode ast, boolean isSuper, RSymbol var, RNode lhs, RNode[] indexes, RNode rhs, boolean subset) {
                super(ast, isSuper, var, lhs, indexes, rhs, subset);
            }

            @Override
            public RAny execute(RAny base, RAny index, RAny value) {
                try {
                    double dvalue;
                    if (!(index instanceof ScalarIntImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    int i = ((ScalarIntImpl)index).getInt() - 1;
                    if (!(base instanceof DoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    DoubleImpl dibase = (DoubleImpl)base;
                    if (dibase.isShared()) {
                        throw new SpecializationException((Object)null);
                    }
                    double[] dbase = dibase.getContent();
                    if (i < 0 || i >= dbase.length) {
                        throw new SpecializationException((Object)null);
                    }
                    if (!(value instanceof ScalarDoubleImpl)) {
                        throw new SpecializationException((Object)null);
                    }
                    dbase[i] = dvalue = ((ScalarDoubleImpl)value).getDouble();
                    return dibase;
                }
                catch (SpecializationException e) {
                    ScalarDoubleSelection ns = new ScalarDoubleSelection(this.ast, this.isSuper, this.var, this.lhs, this.indexes, this.rhs, this.subset);
                    this.replace(ns, "install DoubleBaseSimpleSelection.ScalarDoubleSelection from DoubleBaseSimpleSelection.ScalarIntSelection");
                    return ns.execute(base, index, value);
                }
            }
        }
    }

    static enum Failure {
        NOT_ARRAY_BASE,
        NOT_ONE_ELEMENT_INDEX,
        NOT_NUMERIC_INDEX,
        NOT_LOGICAL_INDEX,
        NOT_ARRAY_INDEX,
        NOT_INT_SEQUENCE_INDEX,
        INDEX_OUT_OF_BOUNDS,
        NOT_ONE_ELEMENT_VALUE,
        NOT_ARRAY_VALUE,
        UNEXPECTED_TYPE,
        NOT_SAME_LENGTH,
        MAYBE_VECTOR_UPDATE;

    }
}

