/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Convert;
import r.Utils;
import r.data.RAny;
import r.data.RArray;
import r.data.RComplex;
import r.data.RDouble;
import r.data.RInt;
import r.data.RList;
import r.data.RLogical;
import r.data.RNull;
import r.data.RRaw;
import r.data.RString;
import r.data.internal.ComplexImpl;
import r.data.internal.DoubleImpl;
import r.data.internal.IntImpl;
import r.runtime.SpecializationException;

class ValueCopy {
    public static final Duplicate LOGICAL_TO_LOGICAL = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RLogical)) {
                throw new SpecializationException((Object)null);
            }
            RLogical from = (RLogical)what;
            int[] result = new int[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.getLogical(i);
            }
            return RLogical.RLogicalFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast LOGICAL_TO_INT = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RLogical)) {
                throw new SpecializationException((Object)null);
            }
            RLogical from = (RLogical)what;
            int[] result = new int[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.logical2int(from.getLogical(i));
            }
            return RInt.RIntFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate INT_TO_INT = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RInt)) {
                throw new SpecializationException((Object)null);
            }
            RInt from = (RInt)what;
            int[] result = new int[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.getInt(i);
            }
            return RInt.RIntFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate INT_TO_INT_DIRECT = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof IntImpl)) {
                throw new SpecializationException((Object)null);
            }
            RInt old = (RInt)what;
            int[] from = ((IntImpl)what).getContent();
            int[] result = new int[from.length];
            System.arraycopy(from, 0, result, 0, result.length);
            return RInt.RIntFactory.getFor(result, old.dimensions(), old.names(), old.attributesRef());
        }
    };
    public static final Upcast LOGICAL_TO_DOUBLE = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RLogical)) {
                throw new SpecializationException((Object)null);
            }
            RLogical from = (RLogical)what;
            double[] result = new double[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.logical2double(from.getLogical(i));
            }
            return RDouble.RDoubleFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast INT_TO_DOUBLE = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RInt)) {
                throw new SpecializationException((Object)null);
            }
            RInt from = (RInt)what;
            double[] result = new double[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.int2double(from.getInt(i));
            }
            return RDouble.RDoubleFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast INT_TO_DOUBLE_DIRECT = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof IntImpl)) {
                throw new SpecializationException((Object)null);
            }
            RInt old = (RInt)what;
            int[] from = ((IntImpl)what).getContent();
            double[] result = new double[from.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.int2double(from[i]);
            }
            return RDouble.RDoubleFactory.getFor(result, old.dimensions(), old.names(), old.attributesRef());
        }
    };
    public static final Duplicate DOUBLE_TO_DOUBLE = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RDouble)) {
                throw new SpecializationException((Object)null);
            }
            RDouble from = (RDouble)what;
            double[] result = new double[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.getDouble(i);
            }
            return RDouble.RDoubleFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate DOUBLE_TO_DOUBLE_DIRECT = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof DoubleImpl)) {
                throw new SpecializationException((Object)null);
            }
            RDouble old = (RDouble)what;
            double[] from = ((DoubleImpl)what).getContent();
            double[] result = new double[from.length];
            System.arraycopy(from, 0, result, 0, result.length);
            return RDouble.RDoubleFactory.getFor(result, old.dimensions(), old.names(), old.attributesRef());
        }
    };
    public static final Upcast LOGICAL_TO_COMPLEX = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RLogical)) {
                throw new SpecializationException((Object)null);
            }
            RLogical from = (RLogical)what;
            int lsize = from.size();
            double[] result = new double[lsize * 2];
            for (int i = 0; i < lsize; ++i) {
                int val = from.getLogical(i);
                if (val == Integer.MIN_VALUE) {
                    result[2 * i] = RDouble.NA;
                    result[2 * i + 1] = RDouble.NA;
                    continue;
                }
                result[2 * i] = val;
            }
            return RComplex.RComplexFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast INT_TO_COMPLEX = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RInt)) {
                throw new SpecializationException((Object)null);
            }
            RInt from = (RInt)what;
            int isize = from.size();
            double[] result = new double[isize * 2];
            for (int i = 0; i < isize; ++i) {
                int val = from.getInt(i);
                if (val == Integer.MIN_VALUE) {
                    result[2 * i] = RDouble.NA;
                    result[2 * i + 1] = RDouble.NA;
                    continue;
                }
                result[2 * i] = val;
            }
            return RComplex.RComplexFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast INT_TO_COMPLEX_DIRECT = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof IntImpl)) {
                throw new SpecializationException((Object)null);
            }
            RInt old = (RInt)what;
            int[] from = ((IntImpl)what).getContent();
            double[] result = new double[from.length * 2];
            for (int i = 0; i < from.length; ++i) {
                int val = from[i];
                if (val == Integer.MIN_VALUE) {
                    result[2 * i] = RDouble.NA;
                    result[2 * i + 1] = RDouble.NA;
                    continue;
                }
                result[2 * i] = val;
            }
            return RComplex.RComplexFactory.getFor(result, old.dimensions(), old.names(), old.attributesRef());
        }
    };
    public static final Upcast DOUBLE_TO_COMPLEX = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RDouble)) {
                throw new SpecializationException((Object)null);
            }
            RDouble from = (RDouble)what;
            int dsize = from.size();
            double[] result = new double[dsize * 2];
            for (int i = 0; i < dsize; ++i) {
                double val = from.getDouble(i);
                if (RDouble.RDoubleUtils.isNAorNaN(val)) {
                    result[2 * i] = RDouble.NA;
                    result[2 * i + 1] = RDouble.NA;
                    continue;
                }
                result[2 * i] = val;
            }
            return RComplex.RComplexFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast DOUBLE_TO_COMPLEX_DIRECT = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof DoubleImpl)) {
                throw new SpecializationException((Object)null);
            }
            RDouble old = (RDouble)what;
            double[] from = ((DoubleImpl)what).getContent();
            double[] result = new double[from.length * 2];
            for (int i = 0; i < from.length; ++i) {
                double val = from[i];
                if (RDouble.RDoubleUtils.isNAorNaN(val)) {
                    result[2 * i] = RDouble.NA;
                    result[2 * i + 1] = RDouble.NA;
                    continue;
                }
                result[2 * i] = val;
            }
            return RComplex.RComplexFactory.getFor(result, old.dimensions(), old.names(), old.attributesRef());
        }
    };
    public static final Duplicate COMPLEX_TO_COMPLEX = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RComplex)) {
                throw new SpecializationException((Object)null);
            }
            RComplex from = (RComplex)what;
            int fsize = from.size();
            double[] result = new double[fsize * 2];
            for (int i = 0; i < fsize; ++i) {
                result[2 * i] = from.getReal(i);
                result[2 * i + 1] = from.getImag(i);
            }
            return RComplex.RComplexFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate COMPLEX_TO_COMPLEX_DIRECT = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof ComplexImpl)) {
                throw new SpecializationException((Object)null);
            }
            RComplex old = (RComplex)what;
            double[] from = ((ComplexImpl)what).getContent();
            double[] result = new double[from.length];
            System.arraycopy(from, 0, result, 0, result.length);
            return RComplex.RComplexFactory.getFor(result, old.dimensions(), old.names(), old.attributesRef());
        }
    };
    public static final Upcast LOGICAL_TO_STRING = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RLogical)) {
                throw new SpecializationException((Object)null);
            }
            RLogical from = (RLogical)what;
            String[] result = new String[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.logical2string(from.getLogical(i));
            }
            return RString.RStringFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast INT_TO_STRING = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RInt)) {
                throw new SpecializationException((Object)null);
            }
            RInt from = (RInt)what;
            String[] result = new String[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.int2string(from.getInt(i));
            }
            return RString.RStringFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast DOUBLE_TO_STRING = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RDouble)) {
                throw new SpecializationException((Object)null);
            }
            RDouble from = (RDouble)what;
            String[] result = new String[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.double2string(from.getDouble(i));
            }
            return RString.RStringFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast COMPLEX_TO_STRING = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RComplex)) {
                throw new SpecializationException((Object)null);
            }
            RComplex from = (RComplex)what;
            String[] result = new String[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Convert.complex2string(from.getReal(i), from.getImag(i));
            }
            return RString.RStringFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate STRING_TO_STRING = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RString)) {
                throw new SpecializationException((Object)null);
            }
            RString from = (RString)what;
            String[] result = new String[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.getString(i);
            }
            return RString.RStringFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Upcast NONLIST_TO_LIST = new Upcast(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RArray) || what instanceof RList) {
                throw new SpecializationException((Object)null);
            }
            RArray from = (RArray)what;
            RAny[] result = new RAny[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.boxedGet(i);
            }
            return RList.RListFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate LIST_TO_LIST = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RList)) {
                throw new SpecializationException((Object)null);
            }
            RList from = (RList)what;
            RAny[] result = new RAny[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.getRAny(i);
            }
            return RList.RListFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate RAW_TO_RAW = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            if (!(what instanceof RRaw)) {
                throw new SpecializationException((Object)null);
            }
            RRaw from = (RRaw)what;
            byte[] result = new byte[from.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = from.getRaw(i);
            }
            return RRaw.RRawFactory.getFor(result, from.dimensions(), from.names(), from.attributesRef());
        }
    };
    public static final Duplicate NULL_TO_NULL = new Duplicate(){

        @Override
        public final RAny copy(RAny what) throws SpecializationException {
            assert (Utils.check(false, "unreachable"));
            return null;
        }
    };

    ValueCopy() {
    }

    public static RAny.Mode valueMode(RAny value) {
        if (value instanceof RInt) {
            return RAny.Mode.INT;
        }
        if (value instanceof RLogical) {
            return RAny.Mode.LOGICAL;
        }
        if (value instanceof RDouble) {
            return RAny.Mode.DOUBLE;
        }
        if (value instanceof RComplex) {
            return RAny.Mode.COMPLEX;
        }
        if (value instanceof RString) {
            return RAny.Mode.STRING;
        }
        if (value instanceof RList) {
            return RAny.Mode.LIST;
        }
        if (value instanceof RNull) {
            return RAny.Mode.NULL;
        }
        assert (Utils.check(value instanceof RRaw));
        return RAny.Mode.RAW;
    }

    protected static abstract class Duplicate
    extends Impl {
        protected Duplicate() {
        }
    }

    protected static abstract class Upcast
    extends Impl {
        protected Upcast() {
        }
    }

    protected static abstract class Impl {
        protected Impl() {
        }

        public abstract RAny copy(RAny var1) throws SpecializationException;
    }
}

