/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.exec;

import r.Utils;
import r.data.RAny;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.exec.BaseR;
import r.nodes.exec.RNode;
import r.runtime.Frame;
import r.runtime.SpecializationException;

public abstract class WriteVariable
extends BaseR {
    final RSymbol symbol;
    @RNode.Child
    RNode expr;
    private static final boolean DEBUG_W = false;

    private WriteVariable(ASTNode orig, RSymbol symbol, RNode expr) {
        super(orig);
        this.setExpr(expr);
        this.symbol = symbol;
    }

    public void setExpr(RNode expr) {
        this.expr = this.adoptChild(expr);
    }

    @Override
    protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
        assert (oldNode != null);
        if (this.expr == oldNode) {
            this.expr = newNode;
            return this.adoptInternal(newNode);
        }
        return super.replaceChild(oldNode, newNode);
    }

    public static WriteVariable getUninitialized(ASTNode orig, RSymbol sym, RNode rhs) {
        return new WriteVariable(orig, sym, rhs){

            @Override
            public final Object execute(Frame frame) {
                try {
                    throw new SpecializationException((Object)null);
                }
                catch (SpecializationException e) {
                    String reason;
                    WriteVariable node;
                    if (frame == null) {
                        node = 1.getWriteTopLevel(this.getAST(), this.symbol, this.expr);
                        reason = "installWriteTopLevelNode";
                    } else {
                        int slot = frame.findVariable(this.symbol);
                        if (slot != -1) {
                            node = 1.getWriteLocal(this.getAST(), this.symbol, slot, this.expr);
                            reason = "installWriteLocalNode";
                        } else {
                            node = 1.getWriteExtension(this.getAST(), this.symbol, this.expr);
                            reason = "installWriteExtensionNode";
                        }
                    }
                    return this.replace(node, reason).execute(frame);
                }
            }
        };
    }

    public static WriteVariable getWriteLocal(ASTNode orig, RSymbol sym, final int slot, RNode rhs) {
        return new WriteVariable(orig, sym, rhs){

            @Override
            public final Object execute(Frame frame) {
                RAny val = (RAny)Utils.cast(this.expr.execute(frame));
                frame.writeAtCondRef(slot, val);
                return val;
            }
        };
    }

    public static WriteVariable getWriteTopLevel(ASTNode orig, RSymbol sym, RNode rhs) {
        return new WriteVariable(orig, sym, rhs){

            @Override
            public final Object execute(Frame frame) {
                RAny val = (RAny)Utils.cast(this.expr.execute(frame));
                Frame.writeToTopLevelCondRef(this.symbol, val);
                return val;
            }
        };
    }

    public static WriteVariable getWriteExtension(ASTNode orig, RSymbol sym, RNode rhs) {
        return new WriteVariable(orig, sym, rhs){

            @Override
            public final Object execute(Frame frame) {
                RAny val = (RAny)Utils.cast(this.expr.execute(frame));
                frame.writeToExtension(this.symbol, val);
                return val;
            }
        };
    }
}

