/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.tools;

import r.Utils;
import r.builtins.Primitives;
import r.data.RAny;
import r.data.RDouble;
import r.data.RFunction;
import r.data.RInt;
import r.data.RSymbol;
import r.data.internal.ScalarIntImpl;
import r.errors.RError;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.Add;
import r.nodes.ast.And;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.BinaryOperation;
import r.nodes.ast.Break;
import r.nodes.ast.Colon;
import r.nodes.ast.Div;
import r.nodes.ast.EQ;
import r.nodes.ast.ElementwiseAnd;
import r.nodes.ast.ElementwiseOr;
import r.nodes.ast.FieldAccess;
import r.nodes.ast.For;
import r.nodes.ast.Function;
import r.nodes.ast.GE;
import r.nodes.ast.GT;
import r.nodes.ast.If;
import r.nodes.ast.In;
import r.nodes.ast.IntegerDiv;
import r.nodes.ast.LE;
import r.nodes.ast.LT;
import r.nodes.ast.MatMult;
import r.nodes.ast.Mod;
import r.nodes.ast.Mult;
import r.nodes.ast.NE;
import r.nodes.ast.Next;
import r.nodes.ast.Not;
import r.nodes.ast.Or;
import r.nodes.ast.OuterMult;
import r.nodes.ast.Pow;
import r.nodes.ast.Repeat;
import r.nodes.ast.Sequence;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.SimpleAssignVariable;
import r.nodes.ast.Sub;
import r.nodes.ast.UnaryMinus;
import r.nodes.ast.UpdateExpression;
import r.nodes.ast.UpdateField;
import r.nodes.ast.UpdateVector;
import r.nodes.ast.Visitor;
import r.nodes.ast.While;
import r.nodes.exec.AbstractCall;
import r.nodes.exec.Arithmetic;
import r.nodes.exec.ArithmeticUpdateVariable;
import r.nodes.exec.BaseR;
import r.nodes.exec.Comparison;
import r.nodes.exec.Constant;
import r.nodes.exec.ElementwiseLogicalOperation;
import r.nodes.exec.FunctionCall;
import r.nodes.exec.If;
import r.nodes.exec.InOperation;
import r.nodes.exec.LazyBuild;
import r.nodes.exec.LogicalOperation;
import r.nodes.exec.Loop;
import r.nodes.exec.MatrixOperation;
import r.nodes.exec.Not;
import r.nodes.exec.RNode;
import r.nodes.exec.ReadArray;
import r.nodes.exec.ReadVariable;
import r.nodes.exec.ReadVector;
import r.nodes.exec.ReplacementCall;
import r.nodes.exec.Selector;
import r.nodes.exec.Sequence;
import r.nodes.exec.SuperWriteVariable;
import r.nodes.exec.UnaryMinus;
import r.nodes.exec.UpdateArray;
import r.nodes.exec.UpdateArrayAssignment;
import r.nodes.exec.UpdateArraySuperAssignment;
import r.nodes.exec.UpdateVector;
import r.nodes.exec.WriteVariable;
import r.runtime.Frame;

public class BuildExecutableTree
implements Visitor {
    RFunction rootEnclosingFunction;
    RNode result;
    public static final boolean DEBUG_SPECIAL_NODES = false;

    public RNode createLazyRootTree(ASTNode ast) {
        return new BaseR(ast){
            @RNode.Child
            RNode node;
            {
                this.node = this.adoptChild(BuildExecutableTree.this.createLazyTree(this.ast));
            }

            @Override
            public final Object execute(Frame frame) {
                try {
                    return this.node.execute(frame);
                }
                catch (Loop.ContinueException ce) {
                    throw RError.getNoLoopForBreakNext(this.ast);
                }
                catch (Loop.BreakException be) {
                    throw RError.getNoLoopForBreakNext(this.ast);
                }
            }

            @Override
            protected <N extends RNode> N replaceChild(RNode oldNode, N newNode) {
                assert (oldNode != null);
                if (this.node == oldNode) {
                    this.node = newNode;
                    return this.adoptInternal(newNode);
                }
                return super.replaceChild(oldNode, newNode);
            }
        };
    }

    public RNode createTree(ASTNode ast) {
        ast.accept(this);
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RNode createTree(ASTNode ast, RFunction enclosingFunction) {
        try {
            this.rootEnclosingFunction = enclosingFunction;
            ast.accept(this);
            RNode rNode = this.result;
            return rNode;
        }
        finally {
            this.rootEnclosingFunction = null;
        }
    }

    private RNode createLazyTree(ASTNode ast) {
        return new LazyBuild(ast);
    }

    @Override
    public void visit(If ast) {
        RNode rfalseBranch;
        ASTNode falseBranch = ast.getFalseCase();
        ASTNode cond = ast.getCond();
        RNode rcond = this.createLazyTree(cond);
        RNode rtrueBranch = this.createLazyTree(ast.getTrueCase());
        RNode rNode = rfalseBranch = falseBranch == null ? Constant.getNull() : this.createLazyTree(falseBranch);
        if (cond instanceof EQ) {
            EQ e = (EQ)cond;
            ASTNode rhs = e.getRHS();
            ASTNode lhs = e.getLHS();
            if (rhs instanceof r.nodes.ast.Constant) {
                this.result = new If.IfConst(ast, rcond, this.createTree(lhs), rtrueBranch, rfalseBranch, ((r.nodes.ast.Constant)rhs).getValue());
                return;
            }
            if (lhs instanceof r.nodes.ast.Constant) {
                this.result = new If.IfConst(ast, rcond, this.createTree(rhs), rtrueBranch, rfalseBranch, ((r.nodes.ast.Constant)lhs).getValue());
                return;
            }
        }
        this.result = falseBranch == null ? new If.IfNoElse(ast, rcond, rtrueBranch) : new If.IfElse(ast, rcond, rtrueBranch, rfalseBranch);
    }

    @Override
    public void visit(Repeat repeat) {
        this.result = new Loop.Repeat(repeat, this.createLazyTree(repeat.getBody()));
    }

    @Override
    public void visit(While n) {
        RAny value;
        int l;
        ASTNode cond = n.getCond();
        if (cond instanceof r.nodes.ast.Constant && (l = (value = ((r.nodes.ast.Constant)cond).getValue()).asLogical().getLogical(0)) == 1) {
            this.result = new Loop.Repeat(n, this.createLazyTree(n.getBody()));
            return;
        }
        this.result = new Loop.While(n, this.createTree(cond), this.createLazyTree(n.getBody()));
    }

    @Override
    public void visit(For n) {
        this.result = new Loop.For.IntSequenceRange(n, n.getCVar(), this.createTree(n.getRange()), this.createLazyTree(n.getBody()));
    }

    @Override
    public void visit(Break n) {
        this.result = new Loop.Break(n);
    }

    @Override
    public void visit(Next n) {
        this.result = new Loop.Next(n);
    }

    @Override
    public void visit(Sequence sequence) {
        ASTNode[] exprs = sequence.getExprs();
        RNode[] rexprs = new RNode[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            rexprs[i] = this.createTree(exprs[i]);
        }
        switch (exprs.length) {
            case 1: {
                this.result = rexprs[0];
                break;
            }
            case 2: {
                this.result = new Sequence.Sequence2(sequence, rexprs);
                break;
            }
            case 3: {
                this.result = new Sequence.Sequence3(sequence, rexprs);
                break;
            }
            case 4: {
                this.result = new Sequence.Sequence4(sequence, rexprs);
                break;
            }
            case 5: {
                this.result = new Sequence.Sequence5(sequence, rexprs);
                break;
            }
            case 6: {
                this.result = new Sequence.Sequence6(sequence, rexprs);
                break;
            }
            default: {
                this.result = new r.nodes.exec.Sequence(sequence, rexprs);
            }
        }
    }

    @Override
    public void visit(Not n) {
        this.result = new Not.LogicalScalar(n, this.createTree(n.getLHS()));
    }

    @Override
    public void visit(UnaryMinus m) {
        this.result = new UnaryMinus.NumericScalar(m, this.createTree(m.getLHS()));
    }

    @Override
    public void visit(r.nodes.ast.Constant constant) {
        this.result = new Constant(constant, constant.getValue());
    }

    @Override
    public void visit(SimpleAccessVariable readVariable) {
        RSymbol symbol = readVariable.getSymbol();
        this.result = ReadVariable.getUninitialized(readVariable, symbol);
    }

    @Override
    public void visit(FieldAccess fa) {
        ASTNode lhs = fa.lhs();
        RNode n = this.createTree(lhs);
        this.result = new ReadVector.FieldSelection.UninitializedSelection(fa, n, RSymbol.getSymbol(fa.fieldName()));
    }

    @Override
    public void visit(SimpleAssignVariable assign) {
        RSymbol symbol = assign.getSymbol();
        ASTNode valueNode = assign.getExpr();
        Arithmetic.ValueArithmetic arit = BuildExecutableTree.getValueArithmetic(valueNode);
        if (arit != null) {
            BinaryOperation bin = (BinaryOperation)valueNode;
            ASTNode binLHS = bin.getLHS();
            ASTNode binRHS = bin.getRHS();
            SimpleAccessVariable binVar = null;
            r.nodes.ast.Constant constNode = null;
            if (binLHS instanceof SimpleAccessVariable) {
                binVar = (SimpleAccessVariable)binLHS;
            } else if (binRHS instanceof SimpleAccessVariable) {
                binVar = (SimpleAccessVariable)binRHS;
            }
            if (binLHS instanceof r.nodes.ast.Constant) {
                constNode = (r.nodes.ast.Constant)binLHS;
            } else if (binRHS instanceof r.nodes.ast.Constant) {
                constNode = (r.nodes.ast.Constant)binRHS;
            }
            if (binVar != null && constNode != null) {
                int cValue;
                RSymbol binVarSymbol = binVar.getSymbol();
                int slot = this.getFrameSlot(assign, binVarSymbol);
                if (binVarSymbol == symbol && !assign.isSuper() && constNode.getValue() instanceof ScalarIntImpl && slot != -1 && (cValue = ((ScalarIntImpl)constNode.getValue()).getInt()) == 1) {
                    if (valueNode instanceof Add) {
                        this.result = new ArithmeticUpdateVariable.ScalarIntLocalIncrement(assign, slot);
                        return;
                    }
                    if (binLHS instanceof SimpleAccessVariable && valueNode instanceof Sub) {
                        this.result = new ArithmeticUpdateVariable.ScalarIntLocalDecrement(assign, slot);
                        return;
                    }
                }
            }
        }
        this.result = assign.isSuper() ? SuperWriteVariable.getUninitialized(assign, symbol, this.createTree(valueNode)) : WriteVariable.getUninitialized(assign, symbol, this.createTree(valueNode));
    }

    private SplitArgumentList splitArgumentList(ArgumentList alist, boolean root) {
        int args = alist.size();
        RSymbol[] names = new RSymbol[args];
        RNode[] expressions = new RNode[args];
        int i = 0;
        for (ArgumentList.Entry e : alist) {
            names[i] = e.getName();
            ASTNode exp = e.getValue();
            if (exp != null) {
                expressions[i] = root ? (exp instanceof r.nodes.ast.Constant ? this.createTree(exp) : this.createLazyRootTree(exp)) : this.createTree(exp);
            }
            ++i;
        }
        assert (Utils.check(i == args));
        return new SplitArgumentList(names, expressions);
    }

    private void detectRepeatedParameters(RSymbol[] params, ASTNode ast) {
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (params[i] != params[j]) continue;
                throw RError.getRepeatedFormal(ast, params[i].name());
            }
        }
    }

    @Override
    public void visit(Function function) {
        assert (Utils.check(function.getRFunction() == null));
        RFunction encf = this.getEnclosingFunction(function);
        SplitArgumentList a = this.splitArgumentList(function.getSignature(), true);
        this.detectRepeatedParameters(a.convertedNames, function);
        RFunction impl = function.createImpl(a.convertedNames, a.convertedExpressions, this.createLazyRootTree(function.getBody()), encf);
        r.nodes.exec.Function functionNode = new r.nodes.exec.Function(impl);
        this.result = functionNode;
    }

    private RFunction getEnclosingFunction(ASTNode node) {
        Function enfunc = BuildExecutableTree.findParent(node, Function.class);
        if (enfunc == null) {
            return this.rootEnclosingFunction;
        }
        RFunction rfunc = enfunc.getRFunction();
        Utils.check(rfunc != null, "RFunction is not yet ready - note lazy build is necessary for functions");
        return rfunc;
    }

    private int getFrameSlot(ASTNode ast, RSymbol symbol) {
        RFunction encFunction = this.getEnclosingFunction(ast);
        if (encFunction != null) {
            return encFunction.localSlot(symbol);
        }
        return -1;
    }

    private boolean hasLocalOrEnclosingFrameSlot(ASTNode ast, RSymbol symbol) {
        RFunction encFunction = this.getEnclosingFunction(ast);
        if (encFunction == null) {
            return false;
        }
        int slot = encFunction.localSlot(symbol);
        if (slot != -1) {
            return true;
        }
        return encFunction.enclosingSlot(symbol) != null;
    }

    public static ASTNode skipTrivialSequences(ASTNode astArg) {
        ASTNode ast = astArg;
        while (ast != null && ast instanceof Sequence) {
            Sequence s = (Sequence)ast;
            ASTNode[] exprs = s.getExprs();
            if (exprs.length != 1) {
                return ast;
            }
            ast = exprs[0];
        }
        return ast;
    }

    @Override
    public void visit(r.nodes.ast.FunctionCall functionCall) {
        SplitArgumentList a = this.splitArgumentList(functionCall.getArgs(), false);
        RSymbol sym = functionCall.getName();
        RNode rCall = null;
        if (!this.hasLocalOrEnclosingFrameSlot(functionCall, sym)) {
            rCall = FunctionCall.createBuiltinCall(functionCall, a.convertedNames, a.convertedExpressions);
        }
        if (rCall == null) {
            rCall = FunctionCall.FACTORY.create((ASTNode)functionCall, a.convertedNames, a.convertedExpressions);
        }
        if (!functionCall.isAssignment()) {
            this.result = rCall;
            return;
        }
        if (!(rCall instanceof AbstractCall)) {
            Utils.nyi("Currently only builtins which are abstract call children can be used with replacement call");
        }
        RNode valueExpr = a.convertedExpressions[a.convertedExpressions.length - 1];
        new ReplacementCall.RememberLast(valueExpr.getAST(), valueExpr);
        SimpleAccessVariable xAST = (SimpleAccessVariable)a.convertedExpressions[0].getAST();
        this.result = new ReplacementCall(functionCall, functionCall.isSuper(), xAST.getSymbol(), (AbstractCall)rCall);
    }

    public static boolean isArrayColumnSubset(boolean subset, RNode[] selectors, int dims) {
        if (!subset) {
            return false;
        }
        for (int i = 0; i < dims - 1; ++i) {
            if (selectors[i] == null) continue;
            return false;
        }
        return selectors[dims - 1] != null;
    }

    @Override
    public void visit(AccessVector a) {
        SplitArgumentList sa = this.splitArgumentList(a.getArgs(), false);
        if (sa.convertedExpressions.length == 1) {
            double c;
            RAny cv;
            EQ eqNode;
            ASTNode indexNode;
            if (a.isSubset() && (indexNode = a.getArgs().first().getValue()) instanceof EQ && (eqNode = (EQ)indexNode).getRHS() instanceof r.nodes.ast.Constant && (cv = ((r.nodes.ast.Constant)eqNode.getRHS()).getValue()) instanceof RDouble && ((RDouble)cv).size() == 1 && RDouble.RDoubleUtils.isFinite(c = ((RDouble)cv).getDouble(0))) {
                this.result = new ReadVector.LogicalEqualitySelection(a, this.createTree(a.getVector()), this.createTree(eqNode.getLHS()), c);
                return;
            }
            if (a.getArgs().first().getValue() instanceof Colon && a.isSubset()) {
                this.result = new ReadVector.SimpleIntSequenceSelection(a, this.createTree(a.getVector()), sa.convertedExpressions, a.isSubset());
            } else {
                int index;
                RInt iv;
                RAny v;
                RNode e = sa.convertedExpressions[0];
                if (e instanceof Constant && ((v = (RAny)e.execute(null)) instanceof RDouble || v instanceof RInt) && (iv = v.asInt()).size() == 1 && (index = v.asInt().getInt(0)) > 0) {
                    this.result = new ReadVector.SimpleConstantScalarIntSelection(a, this.createTree(a.getVector()), sa.convertedExpressions, index, a.isSubset());
                    return;
                }
                this.result = new ReadVector.DoubleBaseSimpleSelection.ScalarIntSelection(a, this.createTree(a.getVector()), sa.convertedExpressions, a.isSubset());
            }
            return;
        }
        if (sa.convertedExpressions.length >= 2) {
            RNode drop = null;
            RNode exact = null;
            RNode[] selectors = new RNode[sa.convertedExpressions.length];
            int[] nodeIndexes = new int[selectors.length];
            RNode[] nodes = sa.convertedExpressions;
            RSymbol[] names = sa.convertedNames;
            int dims = 0;
            for (int i = 0; i < nodes.length; ++i) {
                if (names[i] == RSymbol.DROP_SYMBOL) {
                    assert (Utils.check(drop == null));
                    drop = nodes[i];
                    continue;
                }
                if (names[i] == RSymbol.EXACT_SYMBOL) {
                    assert (Utils.check(exact == null));
                    exact = nodes[i];
                    continue;
                }
                selectors[dims] = nodes[i];
                nodeIndexes[dims] = i;
                ++dims;
            }
            assert (Utils.check(dims != 0));
            if (dims == 2) {
                if (a.isSubset() && selectors[0] == null && selectors[1] != null) {
                    this.result = new ReadArray.MatrixColumnSubset((ASTNode)a, this.createTree(a.getVector()), selectors[1], Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact));
                    return;
                }
                if (a.isSubset() && selectors[0] != null && selectors[1] == null) {
                    this.result = new ReadArray.MatrixRowSubset((ASTNode)a, this.createTree(a.getVector()), selectors[0], Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact));
                    return;
                }
                ASTNode node0 = a.getArgs().getNode(nodeIndexes[0]);
                ASTNode node1 = a.getArgs().getNode(nodeIndexes[1]);
                if (a.isSubset() && node0 != null && node1 != null && node0 instanceof Colon && node1 instanceof Colon) {
                    Colon rows = (Colon)node0;
                    Colon cols = (Colon)node1;
                    this.result = new ReadArray.MatrixSequenceSubset(a, this.createTree(a.getVector()), this.createTree(rows.getLHS()), this.createTree(rows.getRHS()), this.createTree(cols.getLHS()), this.createTree(cols.getRHS()), Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact));
                    return;
                }
                Selector.SelectorNode selectorIExpr = Selector.createSelectorNode(a, a.isSubset(), selectors[0]);
                Selector.SelectorNode selectorJExpr = Selector.createSelectorNode(a, a.isSubset(), selectors[1]);
                this.result = !a.isSubset() ? new ReadArray.MatrixSubscript(a, this.createTree(a.getVector()), selectorIExpr, selectorJExpr, Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact)) : new ReadArray.MatrixRead(a, a.isSubset(), this.createTree(a.getVector()), selectorIExpr, selectorJExpr, Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact));
                return;
            }
            if (BuildExecutableTree.isArrayColumnSubset(a.isSubset(), selectors, dims)) {
                this.result = new ReadArray.ArrayColumnSubset(a, this.createTree(a.getVector()), dims, selectors[dims - 1], Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact));
                return;
            }
            Selector.SelectorNode[] selNodes = new Selector.SelectorNode[dims];
            for (int i = 0; i < selNodes.length; ++i) {
                selNodes[i] = Selector.createSelectorNode(a, a.isSubset(), selectors[i]);
            }
            this.result = new ReadArray.GenericRead(a, a.isSubset(), this.createTree(a.getVector()), selNodes, Selector.createDropOptionNode(a, drop), Selector.createExactOptionNode(a, exact));
            return;
        }
        Utils.nyi("unsupported indexing style");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void visit(UpdateVector u) {
        AccessVector a = u.getVector();
        SplitArgumentList sa = this.splitArgumentList(a.getArgs(), false);
        if (sa.convertedExpressions.length == 1) {
            double c;
            RAny cv;
            EQ eqNode;
            ASTNode indexNode;
            ASTNode varAccess = a.getVector();
            if (!(varAccess instanceof SimpleAccessVariable)) {
                Utils.nyi("expecting vector name for vector update");
            }
            RSymbol var = ((SimpleAccessVariable)varAccess).getSymbol();
            if (a.isSubset() && (indexNode = a.getArgs().first().getValue()) instanceof EQ && (eqNode = (EQ)indexNode).getRHS() instanceof r.nodes.ast.Constant && (cv = ((r.nodes.ast.Constant)eqNode.getRHS()).getValue()) instanceof RDouble && ((RDouble)cv).size() == 1 && RDouble.RDoubleUtils.isFinite(c = ((RDouble)cv).getDouble(0))) {
                this.result = new UpdateVector.LogicalEqualitySelection(u, u.isSuper(), var, this.createTree(varAccess), this.createTree(eqNode.getLHS()), c, this.createTree(u.getRHS()), a.isSubset());
                return;
            }
            if (a.getArgs().first().getValue() instanceof Colon && a.isSubset()) {
                this.result = new UpdateVector.IntSequenceSelection(u, u.isSuper(), var, this.createTree(varAccess), sa.convertedExpressions, this.createTree(u.getRHS()), a.isSubset());
                return;
            }
            this.result = new UpdateVector.DoubleBaseSimpleSelection.ScalarIntSelection(u, u.isSuper(), var, this.createTree(varAccess), sa.convertedExpressions, this.createTree(u.getRHS()), a.isSubset());
            return;
        }
        if (sa.convertedExpressions.length < 2) {
            Utils.nyi("Unsupported indexing style");
            return;
        }
        RNode exact = null;
        RNode[] selectors = new RNode[sa.convertedExpressions.length];
        RNode[] nodes = sa.convertedExpressions;
        RSymbol[] names = sa.convertedNames;
        int dims = 0;
        for (int i = 0; i < nodes.length; ++i) {
            if (names[i] == RSymbol.EXACT_SYMBOL) {
                if (exact != null) {
                    throw RError.getIncorrectSubscripts(a);
                }
                exact = nodes[i];
                continue;
            }
            selectors[dims] = nodes[i];
            ++dims;
        }
        if (dims == 0) {
            Utils.nyi("unsupported indexing style");
        }
        Selector.SelectorNode[] selNodes = new Selector.SelectorNode[dims];
        for (int i = 0; i < selNodes.length; ++i) {
            selNodes[i] = Selector.createSelectorNode(a, a.isSubset(), selectors[i]);
        }
        boolean isColumn = BuildExecutableTree.isArrayColumnSubset(a.isSubset(), selectors, dims);
        ASTNode varAccess = a.getVector();
        RSymbol varName = ((SimpleAccessVariable)varAccess).getSymbol();
        if (!(varAccess instanceof SimpleAccessVariable)) {
            Utils.nyi("expecting matrix name for matrix update");
        }
        RFunction encFunction = this.getEnclosingFunction(a);
        int varSlot = this.getFrameSlot(a, varName);
        if (u.isSuper()) {
            this.result = UpdateArraySuperAssignment.create(a, varName, this.createTree(varAccess), this.createTree(u.getRHS()), UpdateArray.create(a, selNodes, a.isSubset(), isColumn));
            return;
        }
        this.result = UpdateArrayAssignment.create(a, varName, encFunction, varSlot, this.createTree(u.getRHS()), UpdateArray.create(a, selNodes, a.isSubset(), isColumn));
    }

    @Override
    public void visit(UpdateField u) {
        FieldAccess fa = u.getVector();
        ASTNode varAccess = fa.lhs();
        if (!(varAccess instanceof SimpleAccessVariable)) {
            Utils.nyi("expecting vector name for vector update");
        }
        RSymbol var = ((SimpleAccessVariable)varAccess).getSymbol();
        this.result = new UpdateVector.DollarListUpdate(u, u.isSuper(), var, this.createTree(varAccess), RSymbol.getSymbol(fa.fieldName()), this.createTree(u.getRHS()));
    }

    @Override
    public void visit(UpdateExpression u) {
        Utils.nyi("generic update expressions not implemented");
    }

    private static <T extends ASTNode> T findParent(ASTNode node, Class<T> clazz) {
        for (ASTNode n = node.getParent(); n != null; n = n.getParent()) {
            if (!clazz.isInstance(n)) continue;
            return (T)n;
        }
        return null;
    }

    @Override
    public void visit(EQ eq) {
        this.result = new Comparison(eq, this.createTree(eq.getLHS()), this.createTree(eq.getRHS()), Comparison.getEQ());
    }

    @Override
    public void visit(NE ne) {
        this.result = new Comparison(ne, this.createTree(ne.getLHS()), this.createTree(ne.getRHS()), Comparison.getNE());
    }

    @Override
    public void visit(LE le) {
        this.result = new Comparison(le, this.createTree(le.getLHS()), this.createTree(le.getRHS()), Comparison.getLE());
    }

    @Override
    public void visit(GE ge) {
        this.result = new Comparison(ge, this.createTree(ge.getLHS()), this.createTree(ge.getRHS()), Comparison.getGE());
    }

    @Override
    public void visit(LT lt) {
        this.result = new Comparison(lt, this.createTree(lt.getLHS()), this.createTree(lt.getRHS()), Comparison.getLT());
    }

    @Override
    public void visit(GT gt) {
        this.result = new Comparison(gt, this.createTree(gt.getLHS()), this.createTree(gt.getRHS()), Comparison.getGT());
    }

    public static Arithmetic.ValueArithmetic getValueArithmetic(ASTNode ast) {
        if (ast instanceof Add) {
            return Arithmetic.ADD;
        }
        if (ast instanceof Mult) {
            return Arithmetic.MULT;
        }
        if (ast instanceof IntegerDiv) {
            return Arithmetic.INTEGER_DIV;
        }
        if (ast instanceof Mod) {
            return Arithmetic.MOD;
        }
        if (ast instanceof Pow) {
            return Arithmetic.POW;
        }
        if (ast instanceof Div) {
            return Arithmetic.DIV;
        }
        if (ast instanceof Sub) {
            return Arithmetic.SUB;
        }
        return null;
    }

    private void visitArithmetic(BinaryOperation op) {
        Arithmetic.ValueArithmetic arit = BuildExecutableTree.getValueArithmetic(op);
        assert (Utils.check(arit != null));
        this.result = new Arithmetic(op, this.createTree(op.getLHS()), this.createTree(op.getRHS()), arit);
    }

    @Override
    public void visit(Add add) {
        this.visitArithmetic(add);
    }

    @Override
    public void visit(Mult mult) {
        this.visitArithmetic(mult);
    }

    @Override
    public void visit(MatMult mult) {
        this.result = new MatrixOperation.MatrixProduct(mult, this.createTree(mult.getLHS()), this.createTree(mult.getRHS()));
    }

    @Override
    public void visit(OuterMult mult) {
        this.result = new MatrixOperation.OuterProduct(mult, this.createTree(mult.getLHS()), this.createTree(mult.getRHS()));
    }

    @Override
    public void visit(IntegerDiv div) {
        this.visitArithmetic(div);
    }

    @Override
    public void visit(In in) {
        this.result = new InOperation(in, this.createTree(in.getLHS()), this.createTree(in.getRHS()));
    }

    @Override
    public void visit(Mod mod) {
        this.visitArithmetic(mod);
    }

    @Override
    public void visit(Pow pow) {
        this.visitArithmetic(pow);
    }

    @Override
    public void visit(Div div) {
        this.visitArithmetic(div);
    }

    @Override
    public void visit(Sub sub) {
        this.visitArithmetic(sub);
    }

    @Override
    public void visit(Colon col) {
        ASTNode lhs = col.getLHS();
        ASTNode rhs = col.getRHS();
        this.result = Primitives.getCallFactory(RSymbol.getSymbol(":"), null).create((ASTNode)col, this.createTree(lhs), this.createTree(rhs));
        if (lhs instanceof r.nodes.ast.Constant && rhs instanceof r.nodes.ast.Constant) {
            RAny value = (RAny)this.result.execute(null);
            value.ref();
            value.ref();
            this.result = new Constant(col, value);
        }
    }

    @Override
    public void visit(And and) {
        this.result = new LogicalOperation.And(and, this.createTree(and.getLHS()), this.createTree(and.getRHS()));
    }

    @Override
    public void visit(ElementwiseAnd and) {
        this.result = ElementwiseLogicalOperation.createUninitialized(and, this.createTree(and.getLHS()), ElementwiseLogicalOperation.AND, this.createTree(and.getRHS()));
    }

    @Override
    public void visit(Or or) {
        this.result = new LogicalOperation.Or(or, this.createTree(or.getLHS()), this.createTree(or.getRHS()));
    }

    @Override
    public void visit(ElementwiseOr or) {
        this.result = ElementwiseLogicalOperation.createUninitialized(or, this.createTree(or.getLHS()), ElementwiseLogicalOperation.OR, this.createTree(or.getRHS()));
    }

    @Override
    public void visit(ArgumentList.Default.DefaultEntry entry) {
    }

    private static class SplitArgumentList {
        RSymbol[] convertedNames;
        RNode[] convertedExpressions;

        SplitArgumentList(RSymbol[] convertedNames, RNode[] convertedExpressions) {
            this.convertedNames = convertedNames;
            this.convertedExpressions = convertedExpressions;
        }
    }
}

