/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.tools;

import r.Utils;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.Add;
import r.nodes.ast.And;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.Break;
import r.nodes.ast.Colon;
import r.nodes.ast.Constant;
import r.nodes.ast.Div;
import r.nodes.ast.EQ;
import r.nodes.ast.ElementwiseAnd;
import r.nodes.ast.ElementwiseOr;
import r.nodes.ast.FieldAccess;
import r.nodes.ast.For;
import r.nodes.ast.Function;
import r.nodes.ast.FunctionCall;
import r.nodes.ast.GE;
import r.nodes.ast.GT;
import r.nodes.ast.If;
import r.nodes.ast.In;
import r.nodes.ast.IntegerDiv;
import r.nodes.ast.LE;
import r.nodes.ast.LT;
import r.nodes.ast.MatMult;
import r.nodes.ast.Mod;
import r.nodes.ast.Mult;
import r.nodes.ast.NE;
import r.nodes.ast.Next;
import r.nodes.ast.Not;
import r.nodes.ast.Or;
import r.nodes.ast.OuterMult;
import r.nodes.ast.Pow;
import r.nodes.ast.Repeat;
import r.nodes.ast.Sequence;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.SimpleAssignVariable;
import r.nodes.ast.Sub;
import r.nodes.ast.UnaryMinus;
import r.nodes.ast.UpdateField;
import r.nodes.ast.UpdateVector;
import r.nodes.ast.Visitor;
import r.nodes.ast.While;
import r.nodes.tools.BasicVisitor;

public class DuplicateVisitor
extends BasicVisitor
implements Visitor {
    protected ASTNode result;

    public ASTNode duplicate(ASTNode orig) {
        this.result = null;
        orig.accept(this);
        return this.result;
    }

    protected ASTNode d(ASTNode n) {
        if (n == null) {
            return null;
        }
        n.accept(this);
        return this.result;
    }

    private ASTNode[] d(ASTNode[] nodes) {
        ASTNode[] newNodes = new ASTNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            newNodes[i] = this.d(nodes[i]);
        }
        return newNodes;
    }

    private AccessVector d(AccessVector n) {
        return new AccessVector(this.d(n.getVector()), this.d(n.getArgs()), n.isSubset());
    }

    protected ArgumentList d(ArgumentList l) {
        ArgumentList.Default newList = new ArgumentList.Default();
        for (ArgumentList.Entry e : l) {
            newList.add(e.getName(), this.d(e.getValue()));
        }
        return newList;
    }

    @Override
    public void visit(Sequence n) {
        this.result = Sequence.create(this.d(n.getExprs()));
    }

    @Override
    public void visit(If n) {
        this.result = If.create(this.d(n.getCond()), this.d(n.getTrueCase()), this.d(n.getFalseCase()));
    }

    @Override
    public void visit(Repeat n) {
        this.result = new Repeat(this.d(n.getBody()));
    }

    @Override
    public void visit(While n) {
        this.result = new While(this.d(n.getCond()), this.d(n.getBody()));
    }

    @Override
    public void visit(For n) {
        this.result = new For(n.getCVar(), this.d(n.getRange()), this.d(n.getBody()));
    }

    @Override
    public void visit(Next n) {
        this.result = n;
    }

    @Override
    public void visit(Break n) {
        this.result = n;
    }

    @Override
    public void visit(EQ n) {
        this.result = new EQ(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(NE n) {
        this.result = new NE(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(LE n) {
        this.result = new LE(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(GE n) {
        this.result = new GE(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(LT n) {
        this.result = new LT(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(GT n) {
        this.result = new GT(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Sub n) {
        this.result = new Sub(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(MatMult n) {
        this.result = new MatMult(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(OuterMult n) {
        this.result = new OuterMult(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(IntegerDiv n) {
        this.result = new IntegerDiv(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(In n) {
        this.result = new In(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Mod n) {
        this.result = new Mod(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Pow n) {
        this.result = new Pow(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Div n) {
        this.result = new Div(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Colon n) {
        this.result = new Colon(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(And n) {
        this.result = new And(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(ElementwiseAnd n) {
        this.result = new ElementwiseAnd(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Or n) {
        this.result = new Or(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(ElementwiseOr n) {
        this.result = new ElementwiseOr(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Add n) {
        this.result = new Add(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Mult n) {
        this.result = new Mult(this.d(n.getLHS()), this.d(n.getRHS()));
    }

    @Override
    public void visit(Not n) {
        this.result = new Not(this.d(n.getLHS()));
    }

    @Override
    public void visit(UnaryMinus n) {
        this.result = new UnaryMinus(this.d(n.getLHS()));
    }

    @Override
    public void visit(Constant n) {
        this.result = n;
    }

    @Override
    public void visit(SimpleAccessVariable n) {
        this.result = n;
    }

    @Override
    public void visit(FieldAccess n) {
        this.result = new FieldAccess(this.d(n.lhs()), n.fieldName());
    }

    @Override
    public void visit(SimpleAssignVariable n) {
        this.result = new SimpleAssignVariable(n.isSuper(), n.getSymbol(), this.d(n.getExpr()));
    }

    @Override
    public void visit(UpdateVector n) {
        this.result = new UpdateVector(n.isSuper(), this.d(n.getVector()), this.d(n.getRHS()));
    }

    @Override
    public void visit(UpdateField n) {
        this.result = new UpdateField(n.isSuper(), (FieldAccess)this.d(n.getVector()), this.d(n.getRHS()));
    }

    @Override
    public void visit(FunctionCall n) {
        this.result = new FunctionCall(n.getName(), this.d(n.getArgs()));
    }

    @Override
    public void visit(AccessVector n) {
        this.result = new AccessVector(this.d(n.getVector()), this.d(n.getArgs()), n.isSubset());
    }

    @Override
    public void visit(Function n) {
        this.result = Function.create(this.d(n.getSignature()), this.d(n.getBody()));
    }

    @Override
    public void visit(ASTNode n) {
        Utils.nyi("todo: support " + n.getClass());
    }
}

