/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import r.Utils;
import r.data.RSymbol;
import r.nodes.ast.ASTNode;
import r.nodes.ast.AccessVector;
import r.nodes.ast.ArgumentList;
import r.nodes.ast.BinaryOperation;
import r.nodes.ast.Break;
import r.nodes.ast.Constant;
import r.nodes.ast.FieldAccess;
import r.nodes.ast.For;
import r.nodes.ast.Function;
import r.nodes.ast.FunctionCall;
import r.nodes.ast.If;
import r.nodes.ast.Next;
import r.nodes.ast.Repeat;
import r.nodes.ast.Sequence;
import r.nodes.ast.SimpleAccessVariable;
import r.nodes.ast.SimpleAssignVariable;
import r.nodes.ast.UnaryOperation;
import r.nodes.ast.UpdateExpression;
import r.nodes.ast.UpdateField;
import r.nodes.ast.UpdateVector;
import r.nodes.ast.While;
import r.nodes.tools.BasicVisitor;

public class PrettyPrinter
extends BasicVisitor {
    public static final boolean PARENTHESIS = Utils.getProperty("RPrettyPrint.surroundpar", false);
    int level = 0;
    final PrintStream out;
    StringBuilder buff = new StringBuilder();
    private static PrettyPrinter pp = PrettyPrinter.getStringPrettyPrinter();

    public PrettyPrinter(PrintStream stream) {
        this.out = stream;
    }

    public static String prettyPrint(ASTNode n) {
        pp.print(n);
        return pp.toString();
    }

    public void print(ASTNode n) {
        n.accept(this);
        this.flush();
    }

    public void println(ASTNode n) {
        n.accept(this);
        this.println("");
    }

    private static PrettyPrinter getStringPrettyPrinter() {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();
        return new PrettyPrinter(new PrintStream(os)){

            public String toString() {
                String str = os.toString();
                os.reset();
                return str;
            }
        };
    }

    private void inc() {
        ++this.level;
    }

    private void dec() {
        if (this.level == 0) {
            throw new RuntimeException("Unbalanced stack for indentation");
        }
        --this.level;
    }

    private void indent() {
        for (int i = 0; i < this.level; ++i) {
            this.out.append('\t');
        }
    }

    private void print(String arg) {
        this.buff.append(arg);
    }

    private void println(String arg) {
        this.print(arg);
        this.buff.append('\n');
        this.flush();
    }

    private void flush() {
        this.out.print(this.buff);
        this.out.flush();
        this.buff.setLength(0);
    }

    @Override
    public void visit(ASTNode n) {
        this.print("##(TODO: " + n + ")##");
        System.err.println("TODO: " + n);
    }

    @Override
    public void visit(Next n) {
        this.print("next");
    }

    @Override
    public void visit(Break n) {
        this.print("break");
    }

    @Override
    public void visit(Sequence n) {
        ASTNode[] exprs = n.getExprs();
        switch (exprs.length) {
            case 0: {
                this.print("{}");
                break;
            }
            case 1: {
                this.print("{ ");
                exprs[0].accept(this);
                this.print(" }");
                break;
            }
            default: {
                this.println("{");
                this.inc();
                for (ASTNode e : exprs) {
                    this.indent();
                    e.accept(this);
                    this.println("");
                }
                this.dec();
                this.indent();
                this.print("}");
            }
        }
    }

    @Override
    public void visit(If n) {
        this.print("if(");
        n.getCond().accept(this);
        this.print(") ");
        n.getTrueCase().accept(this);
        ASTNode f = n.getFalseCase();
        if (f != null) {
            this.print(" else ");
            f.accept(this);
        }
    }

    @Override
    public void visit(BinaryOperation op) {
        ASTNode left = op.getLHS();
        ASTNode right = op.getRHS();
        if (PARENTHESIS) {
            this.print("(");
        }
        int precedence = op.getPrecedence();
        if (left.getPrecedence() < precedence && !PARENTHESIS) {
            this.print("(");
            left.accept(this);
            this.print(")");
        } else {
            left.accept(this);
        }
        this.print(" ");
        this.print(op.getPrettyOperator());
        this.print(" ");
        if (right.getPrecedence() < precedence && !PARENTHESIS) {
            this.print("(");
            right.accept(this);
            this.print(")");
        } else {
            right.accept(this);
        }
        if (PARENTHESIS) {
            this.print(")");
        }
    }

    @Override
    public void visit(UnaryOperation op) {
        if (PARENTHESIS) {
            this.print("(");
        }
        this.print(op.getPrettyOperator());
        op.getLHS().accept(this);
        if (PARENTHESIS) {
            this.print(")");
        }
    }

    @Override
    public void visit(Constant n) {
        this.print(n.prettyValue());
    }

    @Override
    public void visit(Repeat n) {
        this.print("repeat ");
        n.getBody().accept(this);
    }

    @Override
    public void visit(While n) {
        this.print("while(");
        n.getCond().accept(this);
        this.print(") ");
        n.getBody().accept(this);
    }

    @Override
    public void visit(For n) {
        this.print("for(");
        this.print(n.getCVar().pretty());
        this.print(" in ");
        n.getRange().accept(this);
        this.print(") ");
        n.getBody().accept(this);
    }

    @Override
    public void visit(SimpleAssignVariable n) {
        this.print(n.getSymbol().pretty());
        this.print(" <- ");
        n.getExpr().accept(this);
    }

    @Override
    public void visit(AccessVector n) {
        this.print(n.getVector());
        this.print(n.isSubset() ? "[" : "[[");
        this.print(n.getArgs(), true);
        this.print(n.isSubset() ? "]" : "]]");
    }

    @Override
    public void visit(UpdateVector n) {
        this.print(n.getVector());
        this.print(" <- ");
        this.print(n.getRHS());
    }

    @Override
    public void visit(UpdateExpression n) {
        this.print(n.getLHS());
        this.print(" <- ");
        this.print(n.getRHS());
    }

    @Override
    public void visit(FunctionCall n) {
        if (n.isAssignment()) {
            String str = n.getName().name();
            assert (Utils.check(str.endsWith("<-")));
            this.print(str.substring(0, str.length() - 2));
            this.print("(");
            int nargs = n.getArgs().size();
            assert (Utils.check(nargs > 0));
            ArgumentList.Entry[] args = n.getArgs().toArray(new ArgumentList.Entry[nargs]);
            for (int i = 0; i < nargs - 1; ++i) {
                if (i > 0) {
                    this.print(", ");
                }
                this.print(args[i], true);
            }
            this.print(")");
            this.print(" <- ");
            this.print(args[nargs - 1].getValue());
        } else {
            this.print(n.getName().pretty() + "(");
            this.print(n.getArgs(), true);
            this.print(")");
        }
    }

    @Override
    public void visit(Function n) {
        this.print("function(");
        this.print(n.getSignature(), false);
        this.print(") ");
        n.visit_all(this);
    }

    @Override
    public void visit(SimpleAccessVariable n) {
        this.print(n.getSymbol().pretty());
    }

    @Override
    public void visit(FieldAccess n) {
        this.print(n.lhs());
        this.print("$");
        this.print(n.fieldName());
    }

    @Override
    public void visit(UpdateField n) {
        n.getVector().accept(this);
        this.print(" <- ");
        n.getRHS().accept(this);
    }

    private void print(ArgumentList alist, boolean isCall) {
        boolean f = true;
        for (ArgumentList.Entry arg : alist) {
            if (!f) {
                this.print(", ");
            } else {
                f = false;
            }
            this.print(arg, isCall);
        }
    }

    private void print(ArgumentList.Entry arg, boolean isCall) {
        RSymbol n = arg.getName();
        ASTNode v = arg.getValue();
        if (n != null) {
            this.print(n.pretty());
            if (isCall || v != null) {
                this.print("=");
            }
        }
        if (v != null) {
            v.accept(this);
        }
    }
}

