/*
 * Decompiled with CFR 0.152.
 */
package r.nodes.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import r.nodes.ast.ASTNode;

public class TreeViewer
extends JTree {
    private static final long serialVersionUID = 1L;
    private static Map<Class, Field[]> fieldsForClass = new LinkedHashMap<Class, Field[]>();
    private static TreeViewer treeViewer;
    ASTNode root;
    JFrame frame;

    public static void showTree(ASTNode root) {
        if (treeViewer == null) {
            treeViewer = new TreeViewer("Basic Tree viewer (using reflection)", root);
        } else {
            treeViewer.setRoot(root);
        }
    }

    private static Field[] getFieldsFor(Class clazz) {
        if (fieldsForClass.containsKey(clazz)) {
            return fieldsForClass.get(clazz);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class current = clazz; current != ASTNode.class; current = current.getSuperclass()) {
            Field[] f = current.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                if (!ASTNode.class.isAssignableFrom(f[i].getType())) continue;
                f[i].setAccessible(true);
                fields.add(f[i]);
            }
        }
        Field[] res = fields.toArray(new Field[fields.size()]);
        fieldsForClass.put(clazz, res);
        return res;
    }

    void setRoot(ASTNode newRoot) {
        this.root = newRoot;
        this.setModel(this.newModel());
        this.treeDidChange();
        this.frame.setVisible(true);
    }

    public TreeViewer(String title, ASTNode node) {
        this.frame = new JFrame(title);
        JScrollPane scrollPane = new JScrollPane(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(scrollPane);
        Container content = this.frame.getContentPane();
        content.add((Component)panel, "Center");
        this.frame.setAlwaysOnTop(true);
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.setRoot(node);
        this.frame.setVisible(true);
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ASTNode parent;
        StringBuffer res = new StringBuffer();
        if (hasFocus && (parent = ((ASTNode)value).getParent()) != null) {
            for (Field f : TreeViewer.getFieldsFor(parent.getClass())) {
                try {
                    if (f.get(parent) != value) continue;
                    res.append('[');
                    res.append(f.getName());
                    res.append("] ");
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        res.append(value.getClass().getSimpleName());
        res.append(": ");
        res.append(value.toString());
        if (!hasFocus) {
            res.append("                        ");
        }
        return res.toString();
    }

    private TreeModel newModel() {
        return new TreeModel(){

            @Override
            public Object getRoot() {
                return TreeViewer.this.root;
            }

            @Override
            public Object getChild(Object parent, int index) {
                try {
                    return TreeViewer.getFieldsFor(parent.getClass())[index].get(parent);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public int getChildCount(Object parent) {
                return TreeViewer.getFieldsFor(parent.getClass()).length;
            }

            @Override
            public boolean isLeaf(Object node) {
                return this.getChildCount(node) == 0;
            }

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
            }

            @Override
            public int getIndexOfChild(Object parent, Object child) {
                Field[] fields;
                int i = 0;
                for (Field field : fields = TreeViewer.getFieldsFor(parent.getClass())) {
                    if (field == child) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public void addTreeModelListener(TreeModelListener l) {
            }

            @Override
            public void removeTreeModelListener(TreeModelListener l) {
            }
        };
    }
}

