/*
 * Decompiled with CFR 0.152.
 */
package r.runtime;

import r.Utils;
import r.data.RAny;
import r.data.RCallable;
import r.data.REnvironment;
import r.data.RFunction;
import r.data.RPromise;
import r.data.RSymbol;
import r.data.internal.EnvironmentImpl;
import r.runtime.FrameDescriptor;
import r.runtime.FrameExtension;

public abstract class Frame {
    Object returnValue;
    boolean isDirty;
    final Frame enclosingFrame;
    final RFunction function;
    FrameExtension extension;
    REnvironment environment;

    public Frame(RFunction function, Frame enclosingFrame) {
        this.function = function;
        this.enclosingFrame = enclosingFrame;
    }

    public abstract FrameDescriptor descriptor();

    public abstract Object get(int var1);

    public abstract void set(int var1, Object var2);

    public Frame enclosingFrame() {
        return this.enclosingFrame;
    }

    public RFunction function() {
        return this.function;
    }

    private FrameExtension extension() {
        return this.extension;
    }

    public Object returnValue() {
        assert (Utils.check(this.returnValue instanceof RAny));
        return this.returnValue;
    }

    private REnvironment rootEnvironment() {
        if (this.returnValue != null) {
            return (REnvironment)this.returnValue;
        }
        return REnvironment.GLOBAL;
    }

    private boolean isDirty() {
        return this.isDirty;
    }

    public REnvironment environment() {
        if (this.environment == null) {
            this.environment = new EnvironmentImpl(this);
        }
        return this.environment;
    }

    public void returnValue(RAny value) {
        this.returnValue = value;
    }

    public void rootEnvironment(REnvironment rootEnvironment) {
        this.returnValue = rootEnvironment;
    }

    public FrameExtension installExtension() {
        this.extension = new FrameExtension();
        return this.extension;
    }

    public FrameExtension installHashedExtension(int size) {
        this.extension = new FrameExtension.Hashed(size);
        return this.extension;
    }

    public boolean hasVariable(RSymbol sym) {
        return this.function().isInWriteSet(sym);
    }

    public int findVariable(RSymbol symbol) {
        return this.descriptor().findFrameSlot(symbol);
    }

    private void markDirty() {
        this.isDirty = true;
    }

    public Object readViaWriteSet(int slot, RSymbol symbol) {
        Object value = this.get(slot);
        if (value != null) {
            return value;
        }
        return this.readViaWriteSetSlowPath(symbol);
    }

    public Object readViaWriteSetSlowPath(RSymbol symbol) {
        RFunction.EnclosingSlot rse = this.readSetEntry(symbol);
        if (rse == null) {
            return this.readFromExtensionsAndRootLevelEntry(symbol);
        }
        return this.enclosingFrame.readViaEnclosingSlot(rse.hops - 1, rse.slot, symbol, this.enclosingFrame);
    }

    public Object readFromExtensionsAndRootLevelEntry(RSymbol symbol) {
        Object value;
        if (this.enclosingFrame == null) {
            return this.readFromRootLevel(symbol);
        }
        FrameExtension ext = this.enclosingFrame.extension();
        if (ext != null && (value = ext.getForcingPromises(symbol)) != null) {
            return value;
        }
        return this.enclosingFrame.readFromExtensionsAndRootLevel(symbol);
    }

    public Object readFromExtensionsAndRootLevel(RSymbol symbol) {
        Object value;
        Frame enclosing;
        FrameExtension ext;
        Frame f = this;
        do {
            if ((enclosing = f.enclosingFrame()) != null) continue;
            return f.readFromRootLevel(symbol);
        } while ((ext = (f = enclosing).extension()) == null || (value = ext.getForcingPromises(symbol)) == null);
        return value;
    }

    public Object readFromExtensionsAndRootLevelInclusive(RSymbol symbol) {
        Frame f = this;
        Object value;
        FrameExtension ext;
        while ((ext = f.extension()) == null || (value = ext.getForcingPromises(symbol)) == null) {
            Frame enclosing = f.enclosingFrame();
            if (enclosing == null) {
                return f.readFromRootLevel(symbol);
            }
            f = enclosing;
        }
        return value;
    }

    public Object readViaReadSet(int hops, int slot, RSymbol symbol) {
        assert (Utils.check(hops != 0));
        return this.enclosingFrame.readViaEnclosingSlot(hops - 1, slot, symbol, this);
    }

    private Object readViaEnclosingSlot(int frameHops, int frameSlot, RSymbol symbol, Frame firstFrame) {
        Frame f = this;
        int hops = frameHops;
        int slot = frameSlot;
        Frame first = firstFrame;
        while (true) {
            Object res;
            for (int i = 0; i < hops; ++i) {
                f = f.enclosingFrame();
            }
            if (f.isDirty() && (res = first.readFromExtensionEntry(symbol, f)) != null) {
                return Utils.cast(res);
            }
            res = f.getObjectForcingPromises(slot);
            if (res != null) {
                return Utils.cast(res);
            }
            RFunction.EnclosingSlot eslot = f.findEnclosingVariable(symbol);
            if (eslot == null) {
                return f.readFromExtensionsAndRootLevel(symbol);
            }
            first = f = f.enclosingFrame();
            hops = eslot.hops - 1;
            slot = eslot.slot;
        }
    }

    private Object readFromExtension(RSymbol symbol, Frame stopFrame) {
        for (Frame f = this; f != stopFrame; f = f.enclosingFrame()) {
            Object res;
            FrameExtension ext = f.extension();
            if (ext == null || (res = ext.getForcingPromises(symbol)) == null) continue;
            return res;
        }
        return null;
    }

    public Object readFromExtensionEntry(RSymbol symbol) {
        Object res;
        if (this.extension != null && (res = this.extension.getForcingPromises(symbol)) != null) {
            return res;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.readFromExtension(symbol, null);
        }
        return null;
    }

    public Object readFromExtensionEntry(RSymbol symbol, Frame stopFrame) {
        Object res;
        if (this == stopFrame) {
            return null;
        }
        if (this.extension != null && (res = this.extension.getForcingPromises(symbol)) != null) {
            return res;
        }
        return this.enclosingFrame.readFromExtension(symbol, stopFrame);
    }

    public RAny readFromRootLevel(RSymbol symbol) {
        return this.rootEnvironment().get(symbol, true);
    }

    public boolean existsFromRootLevel(RSymbol symbol) {
        return this.rootEnvironment().exists(symbol, true);
    }

    public RCallable matchViaWriteSet(int slot, RSymbol symbol) {
        Object value = this.getObjectForcingPromises(slot);
        if (value != null && value instanceof RCallable) {
            return (RCallable)Utils.cast(value);
        }
        return this.matchViaWriteSetSlowPath(symbol);
    }

    public RCallable matchViaWriteSetSlowPath(RSymbol symbol) {
        RFunction.EnclosingSlot rse = this.readSetEntry(symbol);
        if (rse == null) {
            return this.matchFromExtensionsAndRootLevelEntry(symbol);
        }
        return this.enclosingFrame.matchViaEnclosingSlot(rse.hops - 1, rse.slot, symbol, this.enclosingFrame);
    }

    public RCallable matchFromExtensionEntry(RSymbol symbol) {
        Object res;
        if (this.extension != null && (res = this.extension.getForcingPromises(symbol)) != null && res instanceof RCallable) {
            return (RCallable)res;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.matchFromExtension(symbol, null);
        }
        return null;
    }

    public RCallable matchFromExtensionEntry(RSymbol symbol, Frame stopFrame) {
        Object res;
        if (this == stopFrame) {
            return null;
        }
        if (this.extension != null && (res = this.extension.getForcingPromises(symbol)) != null && res instanceof RCallable) {
            return (RCallable)res;
        }
        if (this.enclosingFrame != null) {
            this.enclosingFrame.matchFromExtension(symbol, stopFrame);
        }
        return null;
    }

    public RCallable matchFromExtensionsAndRootLevelEntry(RSymbol symbol) {
        Object value;
        if (this.enclosingFrame == null) {
            return this.matchFromRootLevel(symbol);
        }
        FrameExtension ext = this.enclosingFrame.extension();
        if (ext != null && (value = ext.getForcingPromises(symbol)) != null && value instanceof RCallable) {
            return (RCallable)value;
        }
        return this.enclosingFrame.matchFromExtensionsAndRootLevel(symbol);
    }

    public RCallable matchFromExtensionsAndRootLevelInclusiveEntry(RSymbol symbol) {
        Object value;
        Object value2;
        if (this.extension != null && (value2 = this.extension.getForcingPromises(symbol)) != null && value2 instanceof RCallable) {
            return (RCallable)value2;
        }
        if (this.enclosingFrame == null) {
            return this.matchFromRootLevel(symbol);
        }
        FrameExtension ext = this.enclosingFrame.extension();
        if (ext != null && (value = ext.getForcingPromises(symbol)) != null && value instanceof RCallable) {
            return (RCallable)value;
        }
        return this.enclosingFrame.matchFromExtensionsAndRootLevel(symbol);
    }

    private RCallable matchFromExtensionsAndRootLevel(RSymbol symbol) {
        Object value;
        Frame enclosing;
        FrameExtension ext;
        Frame f = this;
        do {
            if ((enclosing = f.enclosingFrame()) != null) continue;
            return f.matchFromRootLevel(symbol);
        } while ((ext = (f = enclosing).extension()) == null || (value = ext.getForcingPromises(symbol)) == null || !(value instanceof RCallable));
        return (RCallable)value;
    }

    private RCallable matchFromRootLevel(RSymbol symbol) {
        return this.rootEnvironment().match(symbol);
    }

    private RCallable matchViaEnclosingSlot(int frameHops, int frameSlot, RSymbol symbol, Frame firstFrame) {
        Frame f = this;
        int hops = frameHops;
        int slot = frameSlot;
        Frame first = firstFrame;
        while (true) {
            RCallable res;
            for (int i = 0; i < hops; ++i) {
                f = f.enclosingFrame();
            }
            if (f.isDirty() && (res = first.matchFromExtensionEntry(symbol, f)) != null) {
                return (RCallable)Utils.cast(res);
            }
            Object res2 = f.getObjectForcingPromises(slot);
            if (res2 != null && res2 instanceof RCallable) {
                return (RCallable)Utils.cast(res2);
            }
            RFunction.EnclosingSlot eslot = f.findEnclosingVariable(symbol);
            if (eslot == null) {
                return f.matchFromExtensionsAndRootLevel(symbol);
            }
            first = f = f.enclosingFrame();
            hops = eslot.hops - 1;
            slot = eslot.slot;
        }
    }

    public RCallable matchFromExtension(RSymbol symbol, Frame stopFrame) {
        for (Frame f = this; f != stopFrame; f = f.enclosingFrame()) {
            Object res;
            FrameExtension ext = f.extension();
            if (ext == null || (res = ext.getForcingPromises(symbol)) == null || !(res instanceof RCallable)) continue;
            return (RCallable)res;
        }
        return null;
    }

    public RCallable matchViaReadSet(int hops, int slot, RSymbol symbol) {
        assert (Utils.check(hops != 0));
        return this.enclosingFrame.matchViaEnclosingSlot(hops - 1, slot, symbol, this);
    }

    public static RCallable match(Frame frame, RSymbol symbol) {
        if (frame == null) {
            return REnvironment.GLOBAL.match(symbol);
        }
        int slot = frame.findVariable(symbol);
        if (slot != -1) {
            return frame.matchViaWriteSet(slot, symbol);
        }
        RFunction.EnclosingSlot eslot = frame.findEnclosingVariable(symbol);
        if (eslot != null) {
            return frame.enclosingFrame().matchViaEnclosingSlot(eslot.hops - 1, eslot.slot, symbol, frame);
        }
        return frame.matchFromExtensionsAndRootLevelInclusiveEntry(symbol);
    }

    public RFunction.EnclosingSlot readSetEntry(RSymbol symbol) {
        return this.function.getLocalReadSetEntry(symbol);
    }

    public RFunction.EnclosingSlot findEnclosingVariable(RSymbol symbol) {
        return this.function.enclosingSlot(symbol);
    }

    public Object localRead(RSymbol symbol) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            return this.getObjectForcingPromises(slot);
        }
        if (this.extension != null) {
            return this.extension.getForcingPromises(symbol);
        }
        return null;
    }

    public Object localReadNotForcing(RSymbol symbol) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            return this.get(slot);
        }
        if (this.extension != null) {
            return this.extension.getNotForcing(symbol);
        }
        return null;
    }

    public Object customLocalRead(RSymbol symbol) {
        return this.extension.getForcingPromises(symbol);
    }

    public Object customLocalReadNoForcing(RSymbol symbol) {
        return this.extension.getNotForcing(symbol);
    }

    public Object customRead(RSymbol symbol) {
        RAny value = (RAny)Utils.cast(this.extension.getForcingPromises(symbol));
        if (value != null) {
            return value;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.read(symbol);
        }
        value = this.readFromRootLevel(symbol);
        return value;
    }

    public Object read(RSymbol symbol) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            return this.readViaWriteSet(slot, symbol);
        }
        RFunction.EnclosingSlot eslot = this.findEnclosingVariable(symbol);
        if (eslot != null) {
            return this.enclosingFrame.readViaEnclosingSlot(eslot.hops - 1, eslot.slot, symbol, this);
        }
        return this.readFromExtensionsAndRootLevelInclusive(symbol);
    }

    public boolean localExists(RSymbol symbol) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            return this.getObjectForcingPromises(slot) != null;
        }
        if (this.extension != null) {
            return this.extension.exists(symbol);
        }
        return false;
    }

    public boolean customLocalExists(RSymbol symbol) {
        return this.extension.exists(symbol);
    }

    public boolean customExists(RSymbol symbol) {
        if (this.extension.getForcingPromises(symbol) != null) {
            return true;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.exists(symbol);
        }
        return this.existsFromRootLevel(symbol);
    }

    public boolean exists(RSymbol symbol) {
        int slot = this.findVariable(symbol);
        if (slot != -1 && this.get(slot) != null) {
            return true;
        }
        RFunction.EnclosingSlot eslot = this.findEnclosingVariable(symbol);
        if (eslot != null) {
            return this.enclosingFrame.existsViaEnclosingSlot(eslot.hops - 1, eslot.slot, symbol, this);
        }
        return this.existsFromExtensionsAndRootLevelInclusive(symbol);
    }

    public boolean existsFromExtensionsAndRootLevelInclusive(RSymbol symbol) {
        Frame f = this;
        FrameExtension ext;
        while ((ext = f.extension()) == null || !ext.exists(symbol)) {
            Frame enclosing = f.enclosingFrame();
            if (enclosing == null) {
                return f.existsFromRootLevel(symbol);
            }
            f = enclosing;
        }
        return true;
    }

    public boolean existsFromExtensionsAndRootLevel(RSymbol symbol) {
        Frame enclosing;
        FrameExtension ext;
        Frame f = this;
        do {
            if ((enclosing = f.enclosingFrame()) != null) continue;
            return f.existsFromRootLevel(symbol);
        } while ((ext = (f = enclosing).extension()) == null || !ext.exists(symbol));
        return true;
    }

    private boolean existsViaEnclosingSlot(int frameHops, int frameSlot, RSymbol symbol, Frame firstFrame) {
        Frame f = this;
        int hops = frameHops;
        int slot = frameSlot;
        Frame first = firstFrame;
        while (true) {
            for (int i = 0; i < hops; ++i) {
                f = f.enclosingFrame();
            }
            if (f.isDirty() && first.existsFromExtensionEntry(symbol, f)) {
                return true;
            }
            if (f.get(slot) != null) {
                return true;
            }
            RFunction.EnclosingSlot eslot = f.findEnclosingVariable(symbol);
            if (eslot == null) {
                return f.existsFromExtensionsAndRootLevel(symbol);
            }
            first = f = f.enclosingFrame();
            hops = eslot.hops - 1;
            slot = eslot.slot;
        }
    }

    public boolean existsFromExtensionEntry(RSymbol symbol, Frame stopFrame) {
        if (this == stopFrame) {
            return false;
        }
        if (this.extension != null && this.extension.exists(symbol)) {
            return true;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.existsFromExtension(symbol, stopFrame);
        }
        return false;
    }

    private boolean existsFromExtension(RSymbol symbol, Frame stopFrame) {
        for (Frame f = this; f != stopFrame; f = f.enclosingFrame()) {
            FrameExtension ext = f.extension();
            if (ext == null || !ext.exists(symbol)) continue;
            return true;
        }
        return false;
    }

    public static void writeToTopLevelCondRef(RSymbol sym, RAny value) {
        Object oldValue = sym.getValueNoForce();
        if (oldValue != value) {
            sym.setValue(value);
            value.ref();
        }
    }

    public static void writeToTopLevelNoRef(RSymbol symbol, Object value) {
        symbol.setValue(value);
    }

    public static void writeToTopLevelRef(RSymbol sym, RAny value) {
        sym.setValue(value);
        value.ref();
    }

    public void writeToExtension(RSymbol sym, RAny value) {
        if (this.extension == null) {
            this.installExtension();
            this.extension.putRef(this, sym, value);
        } else {
            int pos = this.extension.getPosition(sym);
            if (pos >= 0) {
                this.extension.writeAtRef(pos, value);
            } else {
                this.extension.putRef(this, sym, value);
            }
        }
    }

    public void writeToExtensionNoRef(RSymbol sym, Object value) {
        if (this.extension == null) {
            this.installExtension();
            this.extension.putNoRef(this, sym, value);
        } else {
            int pos = this.extension.getPosition(sym);
            if (pos >= 0) {
                this.extension.writeAtNoRef(pos, value);
            } else {
                this.extension.putNoRef(this, sym, value);
            }
        }
    }

    public void writeAtCondRef(int slot, RAny value) {
        Object oldContent = this.get(slot);
        if (value != oldContent) {
            this.set(slot, value);
            value.ref();
        }
    }

    public void writeAtNoRef(int slot, Object value) {
        this.set(slot, value);
    }

    public void writeAtRef(int slot, Object value) {
        this.set(slot, value);
        ((RAny)value).ref();
    }

    public void writeAtRef(int slot, RAny value) {
        this.set(slot, value);
        value.ref();
    }

    public boolean superWriteViaWriteSet(int slot, RSymbol symbol, RAny value) {
        Object oldVal = this.get(slot);
        if (oldVal != null) {
            if (oldVal != value) {
                this.writeAtRef(slot, value);
            }
            return true;
        }
        return this.superWriteViaWriteSetSlowPath(symbol, value);
    }

    public boolean superWriteViaWriteSetSlowPath(RSymbol symbol, RAny value) {
        RFunction.EnclosingSlot eslot = this.findEnclosingVariable(symbol);
        if (eslot != null) {
            return this.enclosingFrame.superWriteViaEnclosingSlot(eslot.hops - 1, eslot.slot, symbol, value, this);
        }
        if (this.enclosingFrame != null) {
            this.enclosingFrame.superWriteToExtensionsAndTopLevel(symbol, value);
        }
        return Frame.superWriteToTopLevel(symbol, value);
    }

    public boolean superWriteToExtensionsAndTopLevel(RSymbol symbol, RAny value) {
        if (this.superWriteToExtensionEntry(symbol, value)) {
            return true;
        }
        return Frame.superWriteToTopLevel(symbol, value);
    }

    public static boolean superWriteToTopLevel(RSymbol symbol, RAny value) {
        Frame.writeToTopLevelCondRef(symbol, value);
        return true;
    }

    public boolean superWriteToExtensionEntry(RSymbol symbol, RAny value) {
        int epos;
        if (this.extension != null && (epos = this.extension.getPosition(symbol)) != -1) {
            this.extension.writeAtRef(epos, value);
            return true;
        }
        if (this.enclosingFrame != null) {
            return this.superWriteToExtension(symbol, value, null);
        }
        return false;
    }

    public boolean superWriteToExtensionEntry(RSymbol symbol, RAny value, Frame stopFrame) {
        int epos;
        if (this == stopFrame) {
            return false;
        }
        if (this.extension != null && (epos = this.extension.getPosition(symbol)) != -1) {
            this.extension.writeAtRef(epos, value);
            return true;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.superWriteToExtension(symbol, value, stopFrame);
        }
        return false;
    }

    private boolean superWriteToExtension(RSymbol symbol, RAny value, Frame stopFrame) {
        for (Frame f = this; f != stopFrame; f = f.enclosingFrame()) {
            int epos;
            FrameExtension ext = f.extension();
            if (ext == null || (epos = ext.getPosition(symbol)) == -1) continue;
            ext.writeAtRef(epos, value);
            return true;
        }
        return false;
    }

    public boolean superWriteViaEnclosingSlotAndTopLevel(int hops, int slot, RSymbol symbol, RAny value) {
        return this.enclosingFrame.superWriteViaEnclosingSlot(hops - 1, slot, symbol, value, this);
    }

    private boolean superWriteViaEnclosingSlot(int frameHops, int frameSlot, RSymbol symbol, RAny value, Frame firstFrame) {
        Frame f = this;
        int hops = frameHops;
        int slot = frameSlot;
        Frame first = firstFrame;
        while (true) {
            for (int i = 0; i < hops; ++i) {
                f = f.enclosingFrame();
            }
            if (f.isDirty() && first.superWriteToExtensionEntry(symbol, value, f)) {
                return true;
            }
            Object val = f.get(slot);
            if (val != null) {
                f.writeAtRef(slot, value);
                return true;
            }
            RFunction.EnclosingSlot eslot = f.findEnclosingVariable(symbol);
            if (eslot == null) {
                return f.superWriteToExtensionsAndTopLevel(symbol, value);
            }
            first = f = f.enclosingFrame();
            hops = eslot.hops - 1;
            slot = eslot.slot;
        }
    }

    public void localWrite(RSymbol symbol, RAny value) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            this.writeAtRef(slot, value);
        } else {
            this.writeToExtension(symbol, value);
        }
    }

    public void localWriteNoRef(RSymbol symbol, Object value) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            this.writeAtNoRef(slot, value);
        } else {
            this.writeToExtensionNoRef(symbol, value);
        }
    }

    public void reflectiveInheritsWrite(RSymbol symbol, RAny value) {
        int slot = this.findVariable(symbol);
        if (slot != -1) {
            this.superWriteViaWriteSet(slot, symbol, value);
            return;
        }
        RFunction.EnclosingSlot eslot = this.findEnclosingVariable(symbol);
        if (eslot != null) {
            this.superWriteViaEnclosingSlotAndTopLevel(eslot.hops, eslot.slot, symbol, value);
            return;
        }
        this.superWriteToExtensionsAndTopLevel(symbol, value);
    }

    public void customLocalWrite(RSymbol symbol, RAny value) {
        int pos = this.extension.getPosition(symbol);
        if (pos >= 0) {
            this.extension.writeAtRef(pos, value);
        } else {
            this.extension.putRef(this, symbol, value);
        }
    }

    public void customLocalWriteNoRef(RSymbol symbol, Object value) {
        int pos = this.extension.getPosition(symbol);
        if (pos >= 0) {
            this.extension.writeAtNoRef(pos, value);
        } else {
            this.extension.putNoRef(this, symbol, value);
        }
    }

    public void customReflectiveInheritsWrite(RSymbol symbol, RAny value) {
        int epos = this.extension.getPosition(symbol);
        if (epos != -1) {
            this.extension.writeAtRef(epos, value);
            return;
        }
        if (this.enclosingFrame != null) {
            this.enclosingFrame.reflectiveInheritsWrite(symbol, value);
        } else {
            Frame.superWriteToTopLevel(symbol, value);
        }
    }

    public static void markDirty(Frame frame, RSymbol symbol) {
        for (Frame current = frame; current != null; current = current.enclosingFrame()) {
            if (!current.hasVariable(symbol)) continue;
            current.markDirty();
            return;
        }
        symbol.markDirty();
    }

    public RSymbol[] validWriteSet() {
        RSymbol[] ws = this.function.localWriteSet();
        if (ws.length == 0) {
            return ws;
        }
        FrameDescriptor frameDescriptor = this.descriptor();
        int nnull = 0;
        int nslots = frameDescriptor.numberOfSlots();
        for (int i = 0; i < nslots; ++i) {
            if (this.get(i) != null) continue;
            ++nnull;
        }
        if (nnull == 0) {
            return ws;
        }
        int size = ws.length - nnull;
        RSymbol[] res = new RSymbol[size];
        int i = 0;
        RSymbol[] slotNames = frameDescriptor.names();
        for (int j = 0; j < nslots; ++j) {
            if (this.get(j) == null) continue;
            res[i++] = slotNames[j];
        }
        return res;
    }

    public RSymbol[] listSymbols() {
        RSymbol[] ws = this.validWriteSet();
        if (this.extension != null) {
            RSymbol[] es = this.extension.validNames();
            if (ws.length == 0) {
                return es;
            }
            int size = ws.length + es.length;
            RSymbol[] res = new RSymbol[size];
            System.arraycopy(ws, 0, res, 0, ws.length);
            System.arraycopy(es, 0, res, ws.length, es.length);
            return res;
        }
        return ws;
    }

    public Object getObjectForcingPromises(int slot) {
        return RPromise.force(this.get(slot));
    }
}

