/*
 * Decompiled with CFR 0.152.
 */
package r.runtime;

import java.util.HashMap;
import r.Utils;
import r.data.RAny;
import r.data.RPromise;
import r.data.RSymbol;
import r.data.internal.FunctionImpl;
import r.runtime.Frame;

public class FrameExtension {
    protected int used = 0;
    private int capacity = 10;
    private int bloom;
    private RSymbol[] names = new RSymbol[this.capacity];
    private Object[] values = new Object[this.capacity];

    protected Object getForcingPromises(RSymbol name) {
        int pos = this.getPosition(name);
        if (pos >= 0) {
            return RPromise.force(this.values[pos]);
        }
        return null;
    }

    protected Object getNotForcing(RSymbol name) {
        int pos = this.getPosition(name);
        if (pos >= 0) {
            return this.values[pos];
        }
        return null;
    }

    protected boolean exists(RSymbol name) {
        return this.getPosition(name) >= 0;
    }

    protected int getPosition(RSymbol name) {
        if (FunctionImpl.isIn(name.hash(), this.bloom)) {
            RSymbol[] n = this.names;
            for (int i = 0; i < this.used; ++i) {
                if (n[i] != name) continue;
                return i;
            }
        }
        return -1;
    }

    final void putRef(Frame enclosing, RSymbol sym, RAny val) {
        this.putNoRef(enclosing, sym, val);
        val.ref();
    }

    protected void putNoRef(Frame enclosing, RSymbol sym, Object val) {
        int pos = this.used;
        if (pos == this.capacity) {
            this.expand(this.capacity * 2);
        }
        ++this.used;
        this.names[pos] = sym;
        this.values[pos] = val;
        Frame.markDirty(enclosing.enclosingFrame(), sym);
        this.bloom |= sym.id();
    }

    void writeAtRef(int pos, RAny value) {
        assert (Utils.check(pos < this.used));
        if (this.values[pos] != value) {
            this.values[pos] = value;
            value.ref();
        }
    }

    void writeAtNoRef(int pos, Object value) {
        assert (Utils.check(pos < this.used));
        this.values[pos] = value;
    }

    protected void expand(int newCap) {
        assert (Utils.check(newCap > this.capacity));
        RSymbol[] newNames = new RSymbol[newCap];
        RAny[] newValues = new RAny[newCap];
        System.arraycopy(this.names, 0, newNames, 0, this.used);
        System.arraycopy(this.values, 0, newValues, 0, this.used);
        this.names = newNames;
        this.values = newValues;
        this.capacity = newCap;
    }

    protected RSymbol[] validNames() {
        int nremoved = 0;
        for (int i = 0; i < this.used; ++i) {
            if (this.values[i] != null) continue;
            ++nremoved;
        }
        if (nremoved == 0 && this.used == this.names.length) {
            return this.names;
        }
        int size = this.used - nremoved;
        RSymbol[] vnames = new RSymbol[size];
        int j = 0;
        for (int i = 0; i < this.used; ++i) {
            if (this.values[i] == null) continue;
            vnames[j++] = this.names[i];
        }
        return vnames;
    }

    public static final class Hashed
    extends FrameExtension {
        private HashMap<RSymbol, Integer> map;

        public Hashed(int size) {
            this.map = new HashMap(size);
        }

        @Override
        protected int getPosition(RSymbol name) {
            Integer pos = this.map.get(name);
            if (pos != null) {
                return pos;
            }
            return -1;
        }

        @Override
        protected void putNoRef(Frame enclosing, RSymbol sym, Object val) {
            this.map.put(sym, this.used);
            super.putNoRef(enclosing, sym, val);
        }
    }
}

