/*
 * Decompiled with CFR 0.152.
 */
package r.runtime;

import r.Utils;
import r.data.RFunction;
import r.runtime.Frame;
import r.runtime.FrameDescriptor;

public abstract class SmallFrame
extends Frame {
    FrameDescriptor descriptor;

    @Override
    public FrameDescriptor descriptor() {
        return this.descriptor;
    }

    protected SmallFrame(RFunction function, Frame enclosingFrame, FrameDescriptor descriptor) {
        super(function, enclosingFrame);
        this.descriptor = descriptor;
    }

    public static class SmallFrame4Slots
    extends SmallFrame {
        public Object slot1;
        public Object slot2;
        public Object slot3;
        public Object slot4;

        public SmallFrame4Slots(RFunction function, Frame enclosingFrame, FrameDescriptor descriptor) {
            super(function, enclosingFrame, descriptor);
        }

        @Override
        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.slot1;
                }
                case 1: {
                    return this.slot2;
                }
                case 2: {
                    return this.slot3;
                }
            }
            assert (Utils.check(i == 3));
            return this.slot4;
        }

        @Override
        public void set(int i, Object value) {
            switch (i) {
                case 0: {
                    this.slot1 = value;
                    break;
                }
                case 1: {
                    this.slot2 = value;
                    break;
                }
                case 2: {
                    this.slot3 = value;
                    break;
                }
                default: {
                    assert (Utils.check(i == 3));
                    this.slot4 = value;
                }
            }
        }
    }

    public static class SmallFrame3Slots
    extends SmallFrame {
        public Object slot1;
        public Object slot2;
        public Object slot3;

        public SmallFrame3Slots(RFunction function, Frame enclosingFrame, FrameDescriptor descriptor) {
            super(function, enclosingFrame, descriptor);
        }

        @Override
        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.slot1;
                }
                case 1: {
                    return this.slot2;
                }
            }
            assert (Utils.check(i == 2));
            return this.slot3;
        }

        @Override
        public void set(int i, Object value) {
            switch (i) {
                case 0: {
                    this.slot1 = value;
                    break;
                }
                case 1: {
                    this.slot2 = value;
                    break;
                }
                default: {
                    assert (Utils.check(i == 2));
                    this.slot3 = value;
                }
            }
        }
    }

    public static class SmallFrame2Slots
    extends SmallFrame {
        public Object slot1;
        public Object slot2;

        public SmallFrame2Slots(RFunction function, Frame enclosingFrame, FrameDescriptor descriptor) {
            super(function, enclosingFrame, descriptor);
        }

        @Override
        public Object get(int i) {
            if (i == 0) {
                return this.slot1;
            }
            assert (Utils.check(i == 1));
            return this.slot2;
        }

        @Override
        public void set(int i, Object value) {
            if (i == 0) {
                this.slot1 = value;
            } else {
                assert (Utils.check(i == 1));
                this.slot2 = value;
            }
        }
    }

    public static class SmallFrame1Slot
    extends SmallFrame {
        public Object slot1;

        public SmallFrame1Slot(RFunction function, Frame enclosingFrame, FrameDescriptor descriptor) {
            super(function, enclosingFrame, descriptor);
        }

        @Override
        public Object get(int i) {
            assert (Utils.check(i == 0));
            return this.slot1;
        }

        @Override
        public void set(int i, Object value) {
            assert (Utils.check(i == 0));
            this.slot1 = value;
        }
    }
}

