/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.ClassifyTrees;
import fr.labri.gumtree.actions.Delete;
import fr.labri.gumtree.actions.Insert;
import fr.labri.gumtree.actions.Move;
import fr.labri.gumtree.actions.Permute;
import fr.labri.gumtree.actions.Update;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassifyRootsAndLeaves
extends ClassifyTrees {
    private Set<Action> skipped;

    public ClassifyRootsAndLeaves(Tree src, Tree dst, Set<Mapping> rawMappings, List<Action> actions) {
        super(src, dst, rawMappings, actions);
    }

    public ClassifyRootsAndLeaves(Tree src, Tree dst, Matcher m) {
        super(src, dst, m);
    }

    @Override
    public void classify() {
        this.skipped = new HashSet<Action>();
        this.srcDelTrees.addAll(this.getRootDeletions());
        this.dstAddTrees.addAll(this.getRootInsertions());
        for (Action a : this.actions) {
            if (this.skipped.contains(a)) continue;
            if (a instanceof Delete && a.getNode().isLeaf()) {
                this.srcDelTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Insert && a.getNode().isLeaf()) {
                this.dstAddTrees.add(a.getNode());
                continue;
            }
            if (!(a instanceof Update) || !a.getNode().isLeaf() || !this.mappings.getDst(a.getNode()).isLeaf()) continue;
            this.srcUpdTrees.add(a.getNode());
            this.dstUpdTrees.add(this.mappings.getDst(a.getNode()));
        }
        for (Action a : this.actions) {
            if (!(a instanceof Move) && !(a instanceof Permute)) continue;
            for (Tree c : a.getNode().getTrees()) {
                if (!c.isLeaf() || this.srcUpdTrees.contains(c) || this.srcDelTrees.contains(c) || this.mappings.getDst(c) == null || !this.mappings.getDst(c).isLeaf() || this.dstUpdTrees.contains(this.mappings.getDst(c)) || this.dstAddTrees.contains(this.mappings.getDst(c))) continue;
                this.srcMvTrees.add(c);
                this.dstMvTrees.add(this.mappings.getDst(c));
            }
        }
    }

    private List<Tree> getRootInsertions() {
        ArrayList<Tree> roots = new ArrayList<Tree>();
        for (Action a : this.actions) {
            Tree t;
            if (!(a instanceof Insert) || !this.mappings.hasDst((t = a.getNode()).getParent())) continue;
            boolean root = true;
            for (Tree d : t.getDescendants()) {
                if (!this.mappings.hasDst(d)) continue;
                root = false;
            }
            if (!root) continue;
            roots.add(a.getNode());
            HashSet<Tree> descendants = new HashSet<Tree>(t.getDescendants());
            for (Action s : this.actions) {
                if (!descendants.contains(s.getNode())) continue;
                this.skipped.add(s);
            }
        }
        return roots;
    }

    private List<Tree> getRootDeletions() {
        ArrayList<Tree> roots = new ArrayList<Tree>();
        for (Action a : this.actions) {
            Tree t;
            if (!(a instanceof Delete) || !this.mappings.hasSrc((t = a.getNode()).getParent())) continue;
            boolean root = true;
            for (Tree d : t.getDescendants()) {
                if (!this.mappings.hasSrc(d)) continue;
                root = false;
            }
            if (!root) continue;
            roots.add(a.getNode());
            HashSet<Tree> descendants = new HashSet<Tree>(t.getDescendants());
            for (Action s : this.actions) {
                if (!descendants.contains(s.getNode())) continue;
                this.skipped.add(s);
            }
        }
        return roots;
    }
}

