/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.io;

import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MappingIoUtils {
    public static String writeXML(Tree tree, MappingStore store) {
        XMLOutputFactory fact = XMLOutputFactory.newInstance();
        StringWriter s = new StringWriter();
        String result = null;
        try {
            XMLStreamWriter w = fact.createXMLStreamWriter(s);
            w.writeStartDocument();
            MappingIoUtils.writeCompactTree(tree, store, w);
            w.writeEndDocument();
            w.close();
            result = s.toString();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void writeCompactTree(Tree t, MappingStore store, XMLStreamWriter w) throws XMLStreamException {
        w.writeStartElement(t.getTypeLabel());
        if (!"".equals(t.getLabel())) {
            w.writeAttribute("label", t.getLabel());
        }
        if (!store.hasDst(t)) {
            w.writeAttribute("added", "1");
        }
        for (Tree c : t.getChildren()) {
            MappingIoUtils.writeCompactTree(c, store, w);
        }
        w.writeEndElement();
    }
}

