/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.composite;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.heuristic.ChangeDistillerLeavesMatcher;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.List;

public class ChangeDistillerMatcher
extends Matcher {
    public static final double STRUCT_SIM_THRESHOLD_1 = 0.6;
    public static final double STRUCT_SIM_THRESHOLD_2 = 0.4;

    public ChangeDistillerMatcher(Tree src, Tree dst) {
        super(ChangeDistillerMatcher.prepare(src), ChangeDistillerMatcher.prepare(dst));
        this.match();
    }

    @Override
    public void match() {
        ChangeDistillerLeavesMatcher m = new ChangeDistillerLeavesMatcher(this.src, this.dst, this.getMappings());
        ((Matcher)m).match();
        List<Tree> poSrc = TreeUtils.postOrder(this.src);
        List<Tree> poDst = TreeUtils.postOrder(this.dst);
        block0: for (Tree src : poSrc) {
            int l = this.numberOfLeafs(src);
            for (Tree dst : poDst) {
                if (!src.isMappable(dst) || src.isLeaf() || dst.isLeaf()) continue;
                double sim = this.chawatheSimilarity(src, dst);
                if (!(l > 4 && sim >= 0.6) && (l > 4 || !(sim >= 0.4))) continue;
                this.addMapping(src, dst);
                continue block0;
            }
        }
    }

    private static Tree prepare(Tree tree) {
        TreeUtils.postOrderNumbering(tree);
        TreeUtils.computeHeight(tree);
        TreeUtils.computeDigest(tree);
        return tree;
    }

    private int numberOfLeafs(Tree root) {
        int l = 0;
        for (Tree t : root.getDescendants()) {
            if (!t.isLeaf()) continue;
            ++l;
        }
        return l;
    }
}

