/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.composite;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.heuristic.GreedyBottomUpMatcher;
import fr.labri.gumtree.matchers.heuristic.GreedySubTreeMatcher;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;

public class GumTreeMatcher
extends Matcher {
    public GumTreeMatcher(Tree src, Tree dst) {
        super(GumTreeMatcher.prepare(src), GumTreeMatcher.prepare(dst));
        this.match();
    }

    @Override
    public void match() {
        long tic = System.currentTimeMillis();
        new GreedySubTreeMatcher(this.src, this.dst, this.getMappings());
        long toc = System.currentTimeMillis();
        long t1 = toc - tic;
        tic = System.currentTimeMillis();
        new GreedyBottomUpMatcher(this.src, this.dst, this.getMappings());
        toc = System.currentTimeMillis();
        long t2 = toc - tic;
        LOGGER.fine(String.format("GumTree matching performed. SubTreeMatcher: %d ms, BottumUpMatcher: %d ms", t1, t2));
    }

    public static Tree prepare(Tree tree) {
        TreeUtils.postOrderNumbering(tree);
        TreeUtils.computeHeight(tree);
        TreeUtils.computeDigest(tree);
        return tree;
    }
}

