/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import fr.labri.gumtree.tree.WeightedMapping;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class ChangeDistillerLeavesMatcher
extends Matcher {
    public static final double LABEL_SIM_THRESHOLD = 0.5;
    private QGramsDistance qgram = new QGramsDistance();

    public ChangeDistillerLeavesMatcher(Tree srcRoot, Tree dstRoot, MappingStore mappings) {
        super(srcRoot, dstRoot, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> poSrcLeaves = this.retainLeaves(TreeUtils.postOrder(this.src));
        List<Tree> poDstLeaves = this.retainLeaves(TreeUtils.postOrder(this.dst));
        LinkedList<WeightedMapping> wMappings = new LinkedList<WeightedMapping>();
        for (Tree srcLeaf : poSrcLeaves) {
            for (Tree dstLeaf : poDstLeaves) {
                double sim;
                if (!srcLeaf.isMappable(dstLeaf) || !((sim = (double)this.qgram.getSimilarity(srcLeaf.getLabel(), dstLeaf.getLabel())) > 0.5)) continue;
                wMappings.add(new WeightedMapping(srcLeaf, dstLeaf, sim));
            }
        }
        Collections.sort(wMappings);
        while (wMappings.size() > 0) {
            WeightedMapping best = (WeightedMapping)wMappings.remove(0);
            this.addMapping((Tree)best.getFirst(), (Tree)best.getSecond());
            TreeUtils.removeMapped(wMappings);
        }
    }

    public List<Tree> retainLeaves(List<Tree> trees) {
        Iterator<Tree> tIt = trees.iterator();
        while (tIt.hasNext()) {
            Tree t = tIt.next();
            if (t.isLeaf()) continue;
            tIt.remove();
        }
        return trees;
    }
}

