/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.optimal.rted.RtedMatcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompleteBottomUpMatcher
extends Matcher {
    private static final double SIM_THRESHOLD = 0.5;
    private static final int SIZE_THESHOLD = 10000;
    private Map<Integer, Tree> srcs = new HashMap<Integer, Tree>();
    private Map<Integer, Tree> dsts = new HashMap<Integer, Tree>();

    public CompleteBottomUpMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> poSrc = TreeUtils.postOrder(this.src);
        List<Tree> poDst = TreeUtils.postOrder(this.dst);
        for (Tree t : poSrc) {
            this.srcs.put(t.getId(), t);
        }
        for (Tree t : poDst) {
            this.dsts.put(t.getId(), t);
        }
        this.match(poSrc, poDst);
        this.clean();
    }

    private void match(List<Tree> poSrc, List<Tree> poDst) {
        for (Tree src : poSrc) {
            if (src.isRoot()) {
                this.addMapping(src, this.dst);
                this.lastChanceMatch(src, this.dst);
                continue;
            }
            if (src.isMapped() || src.isLeaf()) continue;
            Set<Tree> candidates = this.getDstCandidates(src);
            Tree best = null;
            double max = -1.0;
            for (Tree cand : candidates) {
                double sim = this.jaccardSimilarity(src, cand);
                if (!(sim > max) || !(sim >= 0.5)) continue;
                max = sim;
                best = cand;
            }
            if (best == null) continue;
            this.lastChanceMatch(src, best);
            this.addMapping(src, best);
        }
    }

    private Set<Tree> getDstCandidates(Tree src) {
        HashSet<Tree> seeds = new HashSet<Tree>();
        for (Tree c : src.getDescendants()) {
            Tree m = this.mappings.getDst(c);
            if (m == null) continue;
            seeds.add(m);
        }
        HashSet<Tree> candidates = new HashSet<Tree>();
        HashSet<Tree> visited = new HashSet<Tree>();
        for (Tree seed : seeds) {
            Tree parent;
            while (seed.getParent() != null && !visited.contains(parent = seed.getParent())) {
                visited.add(parent);
                if (parent.getType() == src.getType() && !parent.isMapped()) {
                    candidates.add(parent);
                }
                seed = parent;
            }
        }
        return candidates;
    }

    private void lastChanceMatch(Tree src, Tree dst) {
        Tree cSrc = src.deepCopy();
        Tree cDst = dst.deepCopy();
        TreeUtils.removeMapped(cSrc);
        TreeUtils.removeMapped(cDst);
        if (cSrc.getSize() < 10000 || cDst.getSize() < 10000) {
            RtedMatcher m = new RtedMatcher(cSrc, cDst);
            for (Mapping candidate : m.getMappings()) {
                Tree left = this.srcs.get(((Tree)candidate.getFirst()).getId());
                Tree right = this.dsts.get(((Tree)candidate.getSecond()).getId());
                if (left.getId() == src.getId() || right.getId() == dst.getId() || !left.isMappable(right)) continue;
                this.addMapping(left, right);
            }
        }
        for (Tree t : src.getTrees()) {
            t.setMapped(true);
        }
        for (Tree t : dst.getTrees()) {
            t.setMapped(true);
        }
    }
}

