/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.optimal.rted.RtedMatcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GreedyBottomUpMatcher
extends Matcher {
    private static final double SIM_THRESHOLD = 0.5;
    private static final int SIZE_THESHOLD = 100;
    private Map<Integer, Tree> srcs = new HashMap<Integer, Tree>();
    private Map<Integer, Tree> dsts = new HashMap<Integer, Tree>();

    public GreedyBottomUpMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> poSrc = TreeUtils.postOrder(this.src);
        List<Tree> poDst = TreeUtils.postOrder(this.dst);
        for (Tree t : poSrc) {
            this.srcs.put(t.getId(), t);
        }
        for (Tree t : poDst) {
            this.dsts.put(t.getId(), t);
        }
        this.match(TreeUtils.removeMapped(poSrc), TreeUtils.removeMapped(poDst));
        this.clean();
    }

    private void match(List<Tree> poSrc, List<Tree> poDst) {
        block0: for (Tree src : poSrc) {
            for (Tree dst : poDst) {
                double sim;
                if (!src.isMappable(dst) || src.isLeaf() || dst.isLeaf() || !((sim = this.jaccardSimilarity(src, dst)) >= 0.5) && (!src.isRoot() || !dst.isRoot())) continue;
                if (!src.areDescendantsMapped() && !dst.areDescendantsMapped()) {
                    this.lastChanceMatch(src, dst);
                }
                this.addMapping(src, dst);
                continue block0;
            }
        }
    }

    private void lastChanceMatch(Tree src, Tree dst) {
        Tree cSrc = src.deepCopy();
        Tree cDst = dst.deepCopy();
        TreeUtils.removeMapped(cSrc);
        TreeUtils.removeMapped(cDst);
        if (cSrc.getSize() < 100 && cDst.getSize() < 100) {
            RtedMatcher m = new RtedMatcher(cSrc, cDst);
            for (Mapping candidate : m.getMappings()) {
                Tree left = this.srcs.get(((Tree)candidate.getFirst()).getId());
                Tree right = this.dsts.get(((Tree)candidate.getSecond()).getId());
                if (left.getId() == src.getId() || right.getId() == dst.getId() || left.isMapped() && right.isMapped() || !left.isMappable(right) || left.getParent().getType() != right.getParent().getType()) continue;
                this.addMapping(left, right);
            }
        }
    }
}

