/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import fr.labri.gumtree.tree.WeightedMapping;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GreedySubTreeMatcher
extends Matcher {
    private static final int MIN_HEIGHT = 1;

    public GreedySubTreeMatcher(Tree srcRoot, Tree dstRoot, MappingStore mappings) {
        super(srcRoot, dstRoot, mappings);
        this.match();
    }

    public GreedySubTreeMatcher(Tree srcRoot, Tree dstRoot) {
        this(srcRoot, dstRoot, new MappingStore());
    }

    @Override
    public void match() {
        LinkedList<WeightedMapping> ambiguous = new LinkedList<WeightedMapping>();
        int height = Math.min(this.src.getHeight(), this.dst.getHeight());
        Map<Integer, List<Tree>> srcMap = GreedySubTreeMatcher.sortTrees(TreeUtils.removeMapped(this.src.getTrees()));
        Map<Integer, List<Tree>> dstMap = GreedySubTreeMatcher.sortTrees(TreeUtils.removeMapped(this.dst.getTrees()));
        for (int d = height; d >= 1; --d) {
            int j;
            int i;
            if (!srcMap.containsKey(d) || !dstMap.containsKey(d)) continue;
            List<Tree> ssrc = srcMap.get(d);
            List<Tree> sdst = dstMap.get(d);
            Tree[] asrc = new Tree[ssrc.size()];
            Tree[] adst = new Tree[sdst.size()];
            ssrc.toArray(asrc);
            sdst.toArray(adst);
            boolean[][] sim = new boolean[asrc.length][adst.length];
            int[] srceq = new int[asrc.length];
            int[] dsteq = new int[adst.length];
            for (i = 0; i < asrc.length; ++i) {
                for (j = 0; j < adst.length; ++j) {
                    if (asrc[i].isClone(adst[j])) {
                        sim[i][j] = true;
                        int n = i;
                        srceq[n] = srceq[n] + 1;
                        int n2 = j;
                        dsteq[n2] = dsteq[n2] + 1;
                        continue;
                    }
                    sim[i][j] = false;
                }
            }
            for (i = 0; i < asrc.length; ++i) {
                for (j = 0; j < adst.length; ++j) {
                    if (!sim[i][j]) continue;
                    if (asrc[i].isMappable(adst[j])) {
                        if (srceq[i] == 1 && dsteq[j] == 1) {
                            this.addFullMapping(asrc[i], adst[j]);
                        } else {
                            ambiguous.add(new WeightedMapping(asrc[i], adst[j]));
                        }
                    }
                    for (Tree t : asrc[i].getTrees()) {
                        srcMap.get(t.getHeight()).remove(t);
                    }
                    for (Tree t : adst[j].getTrees()) {
                        dstMap.get(t.getHeight()).remove(t);
                    }
                }
            }
        }
        for (WeightedMapping sm : ambiguous) {
            sm.setWeight(this.jaccardSimilarity(((Tree)sm.getFirst()).getParent(), ((Tree)sm.getSecond()).getParent()));
        }
        Collections.sort(ambiguous);
        while (ambiguous.size() > 0) {
            WeightedMapping sm = (WeightedMapping)ambiguous.remove(0);
            this.addFullMapping((Tree)sm.getFirst(), (Tree)sm.getSecond());
            TreeUtils.removeMapped(ambiguous);
        }
    }

    private static Map<Integer, List<Tree>> sortTrees(List<Tree> trees) {
        HashMap<Integer, List<Tree>> treeMap = new HashMap<Integer, List<Tree>>();
        for (Tree t : trees) {
            if (!treeMap.containsKey(t.getHeight())) {
                treeMap.put(t.getHeight(), new LinkedList());
            }
            ((List)treeMap.get(t.getHeight())).add(t);
        }
        return treeMap;
    }
}

