/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LcsMatcher
extends Matcher {
    public LcsMatcher(Tree src, Tree dst) {
        super(src, dst);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> srcSeq = TreeUtils.preOrder(this.src);
        List<Tree> dstSeq = TreeUtils.preOrder(this.dst);
        List<int[]> lcs = LcsMatcher.lcs(srcSeq, dstSeq);
        for (int[] x : lcs) {
            Tree t1 = srcSeq.get(x[0]);
            Tree t2 = dstSeq.get(x[1]);
            this.addMapping(t1, t2);
        }
    }

    public static List<int[]> lcs(List<Tree> s0, List<Tree> s1) {
        int[][] lengths = new int[s0.size() + 1][s1.size() + 1];
        for (int i = 0; i < s0.size(); ++i) {
            for (int j = 0; j < s1.size(); ++j) {
                lengths[i + 1][j + 1] = s0.get(i).isSimilar(s1.get(j)) ? lengths[i][j] + 1 : Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        ArrayList<int[]> indexes = new ArrayList<int[]>();
        int x = s0.size();
        int y = s1.size();
        while (x != 0 && y != 0) {
            if (lengths[x][y] == lengths[x - 1][y]) {
                --x;
                continue;
            }
            if (lengths[x][y] == lengths[x][y - 1]) {
                --y;
                continue;
            }
            indexes.add(new int[]{x - 1, y - 1});
            --x;
            --y;
        }
        Collections.reverse(indexes);
        return indexes;
    }
}

