/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.optimal.rted;

import fr.labri.gumtree.matchers.optimal.rted.LabelDictionary;
import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class InfoTree {
    private Tree inputTree;
    private static final byte LEFT = 0;
    private static final byte RIGHT = 1;
    private static final byte HEAVY = 2;
    private static final byte BOTH = 3;
    public static final byte POST2_SIZE = 0;
    public static final byte POST2_KR_SUM = 1;
    public static final byte POST2_REV_KR_SUM = 2;
    public static final byte POST2_DESC_SUM = 3;
    public static final byte POST2_PRE = 4;
    public static final byte POST2_PARENT = 5;
    public static final byte POST2_LABEL = 6;
    public static final byte KR = 7;
    public static final byte POST2_LLD = 8;
    public static final byte POST2_MIN_KR = 9;
    public static final byte RKR = 10;
    public static final byte RPOST2_RLD = 11;
    public static final byte RPOST2_MIN_RKR = 12;
    public static final byte RPOST2_POST = 13;
    public static final byte POST2_STRATEGY = 14;
    public static final byte PRE2_POST = 15;
    public int[][] info;
    private LabelDictionary ld;
    public boolean[][] nodeType;
    private int[][] paths;
    private int[][][] relSubtrees;
    private int sizeTmp = 0;
    private int descSizesTmp = 0;
    private int krSizesSumTmp = 0;
    private int revkrSizesSumTmp = 0;
    private int preorderTmp = 0;
    private int currentNode = -1;
    private boolean switched = false;
    private int leafCount = 0;
    private int treeSize = 0;

    public static void main(String[] args) {
    }

    public InfoTree(Tree aInputTree, LabelDictionary aLd) {
        this.inputTree = aInputTree;
        this.treeSize = this.inputTree.getSize();
        this.info = new int[16][this.treeSize];
        Arrays.fill(this.info[5], -1);
        Arrays.fill(this.info[9], -1);
        Arrays.fill(this.info[12], -1);
        Arrays.fill(this.info[14], -1);
        this.paths = new int[3][this.treeSize];
        Arrays.fill(this.paths[0], -1);
        Arrays.fill(this.paths[1], -1);
        Arrays.fill(this.paths[2], -1);
        this.relSubtrees = new int[3][this.treeSize][];
        this.nodeType = new boolean[3][this.treeSize];
        this.ld = aLd;
        this.currentNode = this.treeSize - 1;
        this.gatherInfo(this.inputTree, -1);
        this.postTraversalProcessing();
    }

    public int getSize() {
        return this.treeSize;
    }

    public boolean ifNodeOfType(int postorder, int type) {
        return this.nodeType[type][postorder];
    }

    public boolean[] getNodeTypeArray(int type) {
        return this.nodeType[type];
    }

    public int getInfo(int infoCode, int nodesPostorder) {
        return this.info[infoCode][nodesPostorder];
    }

    public int[] getInfoArray(int infoCode) {
        return this.info[infoCode];
    }

    public int[] getNodeRelSubtrees(int pathType, int nodePostorder) {
        return this.relSubtrees[pathType][nodePostorder];
    }

    public int[] getPath(int pathType) {
        return this.paths[pathType];
    }

    public int getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(int postorder) {
        this.currentNode = postorder;
    }

    private int gatherInfo(Tree aT, int postorder) {
        int currentSize = 0;
        int childrenCount = 0;
        int descSizes = 0;
        int krSizesSum = 0;
        int revkrSizesSum = 0;
        int preorder = this.preorderTmp++;
        int heavyChild = -1;
        int leftChild = -1;
        int rightChild = -1;
        int weight = -1;
        int maxWeight = -1;
        int currentPostorder = -1;
        int oldHeavyChild = -1;
        ArrayList<Integer> heavyRelSubtreesTmp = new ArrayList<Integer>();
        ArrayList<Integer> leftRelSubtreesTmp = new ArrayList<Integer>();
        ArrayList<Integer> rightRelSubtreesTmp = new ArrayList<Integer>();
        ArrayList<Integer> childrenPostorders = new ArrayList<Integer>();
        Enumeration<Tree> e = Collections.enumeration(aT.getChildren());
        while (e.hasMoreElements()) {
            ++childrenCount;
            postorder = this.gatherInfo(e.nextElement(), postorder);
            childrenPostorders.add(postorder);
            currentPostorder = postorder;
            weight = this.sizeTmp + 1;
            if (weight >= maxWeight) {
                maxWeight = weight;
                oldHeavyChild = heavyChild;
                heavyChild = currentPostorder;
            } else {
                heavyRelSubtreesTmp.add(currentPostorder);
            }
            if (oldHeavyChild != -1) {
                heavyRelSubtreesTmp.add(oldHeavyChild);
                oldHeavyChild = -1;
            }
            if (childrenCount == 1) {
                leftChild = currentPostorder;
            } else {
                leftRelSubtreesTmp.add(currentPostorder);
            }
            rightChild = currentPostorder;
            if (e.hasMoreElements()) {
                rightRelSubtreesTmp.add(currentPostorder);
            }
            currentSize += 1 + this.sizeTmp;
            descSizes += this.descSizesTmp;
            if (childrenCount > 1) {
                krSizesSum += this.krSizesSumTmp + this.sizeTmp + 1;
            } else {
                krSizesSum += this.krSizesSumTmp;
                this.nodeType[0][currentPostorder] = true;
            }
            if (e.hasMoreElements()) {
                revkrSizesSum += this.revkrSizesSumTmp + this.sizeTmp + 1;
                continue;
            }
            revkrSizesSum += this.revkrSizesSumTmp;
            this.nodeType[1][currentPostorder] = true;
        }
        aT.setTmpData(++postorder);
        int currentDescSizes = descSizes + currentSize + 1;
        this.info[3][postorder] = (currentSize + 1) * (currentSize + 1 + 3) / 2 - currentDescSizes;
        this.info[1][postorder] = krSizesSum + currentSize + 1;
        this.info[2][postorder] = revkrSizesSum + currentSize + 1;
        this.info[6][postorder] = this.ld.store(aT.getLabel());
        for (Integer i : childrenPostorders) {
            this.info[5][i.intValue()] = postorder;
        }
        this.info[0][postorder] = currentSize + 1;
        if (currentSize == 0) {
            ++this.leafCount;
        }
        this.info[4][postorder] = preorder;
        this.info[15][preorder] = postorder;
        this.info[13][this.treeSize - 1 - preorder] = postorder;
        if (heavyChild != -1) {
            this.paths[2][postorder] = heavyChild;
            this.nodeType[2][heavyChild] = true;
            if (leftChild < heavyChild && heavyChild < rightChild) {
                this.info[14][postorder] = 3;
            } else if (heavyChild == leftChild) {
                this.info[14][postorder] = 1;
            } else if (heavyChild == rightChild) {
                this.info[14][postorder] = 0;
            }
        } else {
            this.info[14][postorder] = 1;
        }
        if (leftChild != -1) {
            this.paths[0][postorder] = leftChild;
        }
        if (rightChild != -1) {
            this.paths[1][postorder] = rightChild;
        }
        this.relSubtrees[2][postorder] = InfoTree.toIntArray(heavyRelSubtreesTmp);
        this.relSubtrees[1][postorder] = InfoTree.toIntArray(rightRelSubtreesTmp);
        this.relSubtrees[0][postorder] = InfoTree.toIntArray(leftRelSubtreesTmp);
        this.descSizesTmp = currentDescSizes;
        this.sizeTmp = currentSize;
        this.krSizesSumTmp = krSizesSum;
        this.revkrSizesSumTmp = revkrSizesSum;
        return postorder;
    }

    private void postTraversalProcessing() {
        int nc1 = this.treeSize;
        this.info[7] = new int[this.leafCount];
        this.info[10] = new int[this.leafCount];
        int nc = nc1;
        int lc = this.leafCount;
        int i = 0;
        for (i = 0; i < this.treeSize; ++i) {
            this.info[8][i] = this.paths[0][i] == -1 ? i : this.info[8][this.paths[0][i]];
            this.info[11][this.treeSize - 1 - this.info[4][i]] = this.paths[1][i] == -1 ? this.treeSize - 1 - this.info[4][i] : this.info[11][this.treeSize - 1 - this.info[4][this.paths[1][i]]];
        }
        boolean[] visited = new boolean[nc];
        boolean[] visitedR = new boolean[nc];
        Arrays.fill(visited, false);
        int k = lc - 1;
        int kR = lc - 1;
        for (i = nc - 1; i >= 0; --i) {
            if (!visited[this.info[8][i]]) {
                this.info[7][k] = i;
                visited[this.info[8][i]] = true;
                --k;
            }
            if (visitedR[this.info[11][i]]) continue;
            this.info[10][kR] = i;
            visitedR[this.info[11][i]] = true;
            --kR;
        }
        int parent = -1;
        int parentR = -1;
        for (i = 0; i < this.leafCount; ++i) {
            parent = this.info[7][i];
            while (parent > -1 && this.info[9][parent] == -1) {
                this.info[9][parent] = i;
                parent = this.info[5][parent];
            }
            parentR = this.info[10][i];
            while (parentR > -1 && this.info[12][parentR] == -1) {
                this.info[12][parentR] = i;
                if ((parentR = this.info[5][this.info[13][parentR]]) <= -1) continue;
                parentR = this.treeSize - 1 - this.info[4][parentR];
            }
        }
    }

    public static int[] toIntArray(List<Integer> integers) {
        int[] ints = new int[integers.size()];
        int i = 0;
        for (Integer n : integers) {
            ints[i++] = n;
        }
        return ints;
    }

    public void setSwitched(boolean value) {
        this.switched = value;
    }

    public boolean isSwitched() {
        return this.switched;
    }
}

