/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.tree;

import fr.labri.gumtree.tree.DigestGenerator;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void computeAllMetrics(Tree tree) {
        TreeUtils.computeSize(tree);
        TreeUtils.computeDepth(tree);
        TreeUtils.computeHeight(tree);
        TreeUtils.computeDigest(tree);
    }

    public static void computeSize(Tree tree) {
        List<Tree> trees = TreeUtils.postOrder(tree);
        for (Tree t : trees) {
            int size = 1;
            if (!t.isLeaf()) {
                for (Tree c : t.getChildren()) {
                    size += c.getSize();
                }
            }
            t.setSize(size);
        }
    }

    public static void computeDigest(Tree tree) {
        DigestGenerator.StdHashGenerator g = new DigestGenerator.StdHashGenerator();
        g.computeDigest(tree);
    }

    public static void computeDigest(Tree tree, DigestGenerator g) {
        g.computeDigest(tree);
    }

    public static void computeDepth(Tree tree) {
        List<Tree> trees = TreeUtils.preOrder(tree);
        for (Tree t : trees) {
            int depth = 0;
            if (!t.isRoot()) {
                depth = t.getParent().getDepth() + 1;
            }
            t.setDepth(depth);
        }
    }

    public static void computeHeight(Tree tree) {
        List<Tree> trees = TreeUtils.postOrder(tree);
        for (Tree t : trees) {
            int height = 0;
            if (!t.isLeaf()) {
                for (Tree c : tree.getChildren()) {
                    int cHeight = c.getHeight();
                    if (cHeight <= height) continue;
                    height = cHeight;
                }
                ++height;
            }
            t.setHeight(height);
        }
    }

    public static List<Tree> preOrder(Tree tree) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        TreeUtils.preOrder(tree, trees);
        return trees;
    }

    private static void preOrder(Tree tree, List<Tree> trees) {
        trees.add(tree);
        if (!tree.isLeaf()) {
            for (Tree c : tree.getChildren()) {
                TreeUtils.preOrder(c, trees);
            }
        }
    }

    public static void preOrderNumbering(Tree tree) {
        List<Tree> trees = TreeUtils.preOrder(tree);
        for (int i = 0; i < trees.size(); ++i) {
            trees.get(i).setId(i);
        }
    }

    public static List<Tree> bfsOrder(Tree tree) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        ArrayList<Tree> currents = new ArrayList<Tree>();
        currents.add(tree);
        while (currents.size() > 0) {
            Tree c = (Tree)currents.remove(0);
            trees.add(c);
            currents.addAll(c.getChildren());
        }
        return trees;
    }

    public static void bfsOrderNumbering(Tree tree) {
        List<Tree> trees = TreeUtils.bfsOrder(tree);
        for (int i = 0; i < trees.size(); ++i) {
            trees.get(i).setId(i);
        }
    }

    public static List<Tree> postOrder(Tree tree) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        TreeUtils.postOrder(tree, trees);
        return trees;
    }

    private static void postOrder(Tree tree, List<Tree> trees) {
        if (!tree.isLeaf()) {
            for (Tree c : tree.getChildren()) {
                TreeUtils.postOrder(c, trees);
            }
        }
        trees.add(tree);
    }

    public static void postOrderNumbering(Tree tree) {
        List<Tree> trees = TreeUtils.postOrder(tree);
        for (int i = 0; i < trees.size(); ++i) {
            trees.get(i).setId(i);
        }
    }

    public static void removeMapped(Collection<? extends Mapping> mappings) {
        Iterator<? extends Mapping> trIt = mappings.iterator();
        while (trIt.hasNext()) {
            Mapping t = trIt.next();
            if (!((Tree)t.getFirst()).isMapped() && !((Tree)t.getSecond()).isMapped()) continue;
            trIt.remove();
        }
    }

    public static List<Tree> removeMapped(List<Tree> trees) {
        Iterator<Tree> trIt = trees.iterator();
        while (trIt.hasNext()) {
            Tree t = trIt.next();
            if (!t.isMapped()) continue;
            trIt.remove();
        }
        return trees;
    }

    public static Tree removeMapped(Tree tree) {
        for (Tree t : tree.getTrees()) {
            if (!t.isMapped() || tree.isRoot()) continue;
            t.getParent().getChildren().remove(t);
            t.setParent(null);
        }
        return tree;
    }

    public static Tree removeCompletelyMapped(Tree tree) {
        for (Tree t : tree.getTrees()) {
            if (!t.isMapped() || !t.areDescendantsMapped()) continue;
            t.getParent().getChildren().remove(t);
            t.setParent(null);
        }
        return tree;
    }
}

