/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.ClassifyTrees;
import fr.labri.gumtree.actions.Delete;
import fr.labri.gumtree.actions.Insert;
import fr.labri.gumtree.actions.Move;
import fr.labri.gumtree.actions.Update;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.List;
import java.util.Set;

public class ClassifyLeaves
extends ClassifyTrees {
    public ClassifyLeaves(Tree src, Tree dst, Set<Mapping> rawMappings, List<Action> actions) {
        super(src, dst, rawMappings, actions);
    }

    public ClassifyLeaves(Tree src, Tree dst, Matcher m) {
        super(src, dst, m);
    }

    @Override
    public void classify() {
        for (Action a : this.actions) {
            if (a instanceof Delete && this.isLeafAction(a)) {
                this.srcDelTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Insert && this.isLeafAction(a)) {
                this.dstAddTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Update && this.isLeafAction(a)) {
                this.srcUpdTrees.add(a.getNode());
                this.dstUpdTrees.add(this.mappings.getDst(a.getNode()));
                continue;
            }
            if (!(a instanceof Move) || !this.isLeafAction(a)) continue;
            this.srcMvTrees.add(a.getNode());
            this.dstMvTrees.add(this.mappings.getDst(a.getNode()));
        }
    }

    private boolean isLeafAction(Action a) {
        for (Tree d : a.getNode().getDescendants()) {
            for (Action c : this.actions) {
                if (a == c || d != c.getNode()) continue;
                return false;
            }
        }
        return true;
    }
}

