/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.algo;

import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.List;

public class PriorityTreeList {
    private List<Tree>[] trees;
    private int maxHeight;
    private int minHeight;
    private int currentIdx;

    public PriorityTreeList(Tree tree, int minHeight) {
        this.minHeight = minHeight;
        this.trees = new ArrayList[tree.getHeight() - minHeight + 1];
        this.maxHeight = tree.getHeight();
        this.addTree(tree);
    }

    private int idx(Tree tree) {
        return this.idx(tree.getHeight());
    }

    private int idx(int height) {
        return this.maxHeight - height;
    }

    private int height(int idx) {
        return this.maxHeight - idx;
    }

    private void addTree(Tree tree) {
        if (tree.getHeight() >= this.minHeight) {
            int idx = this.idx(tree);
            if (this.trees[idx] == null) {
                this.trees[idx] = new ArrayList<Tree>();
            }
            this.trees[idx].add(tree);
        }
    }

    public List<Tree> open() {
        List<Tree> pop = this.pop();
        if (pop != null) {
            for (Tree tree : pop) {
                this.open(tree);
            }
            this.updateHeight();
            return pop;
        }
        return null;
    }

    public List<Tree> pop() {
        if (this.currentIdx == -1) {
            return null;
        }
        List<Tree> pop = this.trees[this.currentIdx];
        this.trees[this.currentIdx] = null;
        return pop;
    }

    public void open(Tree tree) {
        for (Tree c : tree.getChildren()) {
            this.addTree(c);
        }
    }

    public List<Tree> peek() {
        return this.currentIdx == -1 ? null : this.trees[this.currentIdx];
    }

    public int peekHeight() {
        return this.currentIdx == -1 ? -1 : this.height(this.currentIdx);
    }

    public void updateHeight() {
        this.currentIdx = -1;
        int i = 0;
        while (i < this.trees.length) {
            if (this.trees[i] != null) {
                this.currentIdx = i;
                break;
            }
            ++i;
        }
    }
}

