/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.composite;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.heuristic.CompleteBottomUpMatcher;
import fr.labri.gumtree.matchers.heuristic.GreedySubtreeMatcher;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;

public class GumtreeMatcher
extends Matcher {
    public GumtreeMatcher(Tree src, Tree dst) {
        super(GumtreeMatcher.prepare(src), GumtreeMatcher.prepare(dst));
        this.match();
    }

    @Override
    public void match() {
        long tic = System.currentTimeMillis();
        new GreedySubtreeMatcher(this.src, this.dst, this.getMappings());
        long toc = System.currentTimeMillis();
        long t1 = toc - tic;
        tic = System.currentTimeMillis();
        new CompleteBottomUpMatcher(this.src, this.dst, this.getMappings());
        toc = System.currentTimeMillis();
        long t2 = toc - tic;
        LOGGER.info(String.format("GumTree matching performed. SubtreeMatcher: %d ms, BottumUpMatcher: %d ms", t1, t2));
    }

    public static Tree prepare(Tree tree) {
        TreeUtils.postOrderNumbering(tree);
        TreeUtils.computeHeight(tree);
        TreeUtils.computeDigest(tree);
        return tree;
    }
}

