/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.algo.PriorityTreeList;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.MultiMappingStore;
import fr.labri.gumtree.tree.Tree;

public abstract class AbstractSubtreeMatcher
extends Matcher {
    protected int minHeight = 2;
    protected int maxSize;

    public AbstractSubtreeMatcher(Tree src, Tree dst) {
        this(src, dst, new MappingStore());
    }

    public AbstractSubtreeMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.maxSize = Math.max(src.getSize(), dst.getSize());
    }

    @Override
    public void match() {
        this.filterRawMappings(this.getRawMappings());
    }

    /*
     * Unable to fully structure code
     */
    protected MultiMappingStore getRawMappings() {
        rawMappings = new MultiMappingStore();
        srcs = new PriorityTreeList(this.src, this.minHeight);
        dsts = new PriorityTreeList(this.dst, this.minHeight);
        ** GOTO lbl39
        {
            this.popLarger(srcs, dsts);
            do {
                if (srcs.peekHeight() != dsts.peekHeight()) continue block0;
                hSrcs = srcs.pop();
                hDsts = dsts.pop();
                srcMarks = new boolean[hSrcs.size()];
                dstMarks = new boolean[hDsts.size()];
                i = 0;
                while (i < hSrcs.size()) {
                    j = 0;
                    while (j < hDsts.size()) {
                        src = hSrcs.get(i);
                        if (src.isClone(dst = hDsts.get(j))) {
                            rawMappings.link(src, dst);
                            srcMarks[i] = true;
                            dstMarks[j] = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < srcMarks.length) {
                    if (!srcMarks[i]) {
                        srcs.open(hSrcs.get(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < dstMarks.length) {
                    if (!dstMarks[i]) {
                        dsts.open(hDsts.get(i));
                    }
                    ++i;
                }
                srcs.updateHeight();
                dsts.updateHeight();
lbl39:
                // 2 sources

            } while (srcs.peekHeight() != -1 && dsts.peekHeight() != -1);
        }
        return rawMappings;
    }

    protected abstract void filterRawMappings(MultiMappingStore var1);

    protected double subtreeSim(Tree src, Tree dst) {
        double jaccard = this.jaccardSimilarity(src.getParent(), dst.getParent());
        int posSrc = src.isRoot() ? 0 : src.getParent().getChildPosition(src);
        int posDst = dst.isRoot() ? 0 : dst.getParent().getChildPosition(dst);
        int maxSrcPos = src.isRoot() ? 1 : src.getParent().getChildren().size();
        int maxDstPos = dst.isRoot() ? 1 : dst.getParent().getChildren().size();
        int maxPosDiff = Math.max(maxSrcPos, maxDstPos);
        double pos = 1.0 - (double)Math.abs(posSrc - posDst) / (double)maxPosDiff;
        double po = 1.0 - (double)Math.abs(src.getId() - dst.getId()) / (double)this.maxSize;
        return 100.0 * jaccard + 10.0 * pos + po;
    }

    private void popLarger(PriorityTreeList srcs, PriorityTreeList dsts) {
        if (srcs.peekHeight() > dsts.peekHeight()) {
            srcs.open();
        } else {
            dsts.open();
        }
    }
}

