/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.tree;

import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public abstract class DigestGenerator {
    public abstract void computeDigest(Tree var1);

    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static int fpow(int a, int b) {
        int result = 1;
        while (b > 0) {
            if ((b & 1) != 0) {
                result *= a;
            }
            b >>= 1;
            a *= a;
        }
        return result;
    }

    public static int md5digest(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(s.getBytes());
            return DigestGenerator.byteArrayToInt(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static class Md5HashGenerator
    extends DigestGenerator {
        @Override
        public void computeDigest(Tree tree) {
            for (Tree t : tree.getTrees()) {
                t.setDigest(Md5HashGenerator.md5digest(t.toDigestTreeString()));
            }
        }
    }

    public static class RollingMd5HashGenerator
    extends DigestGenerator {
        private static final int B = 33;

        @Override
        public void computeDigest(Tree tree) {
            for (Tree t : TreeUtils.postOrder(tree)) {
                if (t.isLeaf()) {
                    t.setDigest(RollingMd5HashGenerator.md5digest(t.toDigestString()));
                    continue;
                }
                int digest = 0;
                int n = t.getChildren().size();
                int i = 0;
                while (i < n) {
                    Tree child = t.getChildren().get(i);
                    digest = 33 * digest + t.getChildren().get(i).getDigest() * RollingMd5HashGenerator.fpow(33, child.getSize());
                    ++i;
                }
                digest = 33 * digest + RollingMd5HashGenerator.md5digest(t.toDigestString());
                t.setDigest(digest);
            }
        }
    }

    public static class RollingRdmHashGenerator
    extends DigestGenerator {
        private static final int B = 33;
        private static final Map<String, Integer> digests = new HashMap<String, Integer>();

        @Override
        public void computeDigest(Tree tree) {
            for (Tree t : TreeUtils.postOrder(tree)) {
                if (t.isLeaf()) {
                    t.setDigest(RollingRdmHashGenerator.rdmDigest(t.toDigestString()));
                    continue;
                }
                int digest = 0;
                int n = t.getChildren().size();
                int i = 0;
                while (i < n) {
                    Tree child = t.getChildren().get(i);
                    digest = 33 * digest + t.getChildren().get(i).getDigest() * RollingRdmHashGenerator.fpow(33, child.getSize());
                    ++i;
                }
                digest = 33 * digest + RollingRdmHashGenerator.rdmDigest(t.toDigestString());
                t.setDigest(digest);
            }
        }

        public static int rdmDigest(String s) {
            if (!digests.containsKey(s)) {
                int digest = (int)(Math.random() * 2.147483646E9);
                digests.put(s, digest);
                return digest;
            }
            return digests.get(s);
        }
    }

    public static class RollingStdHashGenerator
    extends DigestGenerator {
        private static final int B = 33;

        @Override
        public void computeDigest(Tree tree) {
            for (Tree t : TreeUtils.postOrder(tree)) {
                if (t.isLeaf()) {
                    t.setDigest(t.toDigestString().hashCode());
                    continue;
                }
                int digest = 0;
                int n = t.getChildren().size();
                int i = 0;
                while (i < n) {
                    Tree child = t.getChildren().get(i);
                    digest = 33 * digest + t.getChildren().get(i).getDigest() * RollingStdHashGenerator.fpow(33, child.getSize());
                    ++i;
                }
                digest = 33 * digest + t.toDigestString().hashCode();
                t.setDigest(digest);
            }
        }
    }

    public static class StdHashGenerator
    extends DigestGenerator {
        @Override
        public void computeDigest(Tree tree) {
            for (Tree t : tree.getTrees()) {
                t.setDigest(t.toDigestTreeString().hashCode());
            }
        }
    }
}

