/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.ClassifyTrees;
import fr.labri.gumtree.actions.Delete;
import fr.labri.gumtree.actions.Insert;
import fr.labri.gumtree.actions.Move;
import fr.labri.gumtree.actions.Permute;
import fr.labri.gumtree.actions.Update;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.List;
import java.util.Set;

public class ClassifyRoots
extends ClassifyTrees {
    public ClassifyRoots(Tree src, Tree dst, Set<Mapping> rawMappings, List<Action> script) {
        super(src, dst, rawMappings, script);
    }

    public ClassifyRoots(Tree src, Tree dst, Matcher m) {
        super(src, dst, m);
    }

    @Override
    public void classify() {
        for (Action a : this.actions) {
            if (a instanceof Delete) {
                this.srcDelTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Insert) {
                this.dstAddTrees.add(a.getNode());
                continue;
            }
            if (a instanceof Update) {
                this.srcUpdTrees.add(a.getNode());
                this.dstUpdTrees.add(this.mappings.getDst(a.getNode()));
                continue;
            }
            if (!(a instanceof Move) && !(a instanceof Permute)) continue;
            this.srcMvTrees.add(a.getNode());
            this.dstMvTrees.add(this.mappings.getDst(a.getNode()));
        }
    }
}

