/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.actions.Action;
import fr.labri.gumtree.actions.Delete;
import fr.labri.gumtree.actions.Insert;
import fr.labri.gumtree.actions.Move;
import fr.labri.gumtree.actions.Update;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenerateActions {
    private Tree origSrc;
    private Set<Mapping> origMappings;
    private Set<Mapping> cpyMappings;
    private Tree cpySrc;
    private Tree dst;
    private MappingStore mappings;
    private Set<Tree> dstInOrder;
    private Set<Tree> srcInOrder;
    private int lastId;
    private List<Action> actions;
    private Map<Integer, Tree> origSrcTrees;
    private Map<Integer, Tree> cpySrcTrees;

    public GenerateActions(Tree src, Tree dst, Set<Mapping> mappings) {
        this.origSrc = src;
        this.cpySrc = this.origSrc.deepCopy();
        this.dst = dst;
        this.origMappings = mappings;
        this.origSrcTrees = new HashMap<Integer, Tree>();
        for (Tree t : this.origSrc.getTrees()) {
            this.origSrcTrees.put(t.getId(), t);
        }
        this.cpySrcTrees = new HashMap<Integer, Tree>();
        for (Tree t : this.cpySrc.getTrees()) {
            this.cpySrcTrees.put(t.getId(), t);
        }
        this.cpyMappings = new HashSet<Mapping>();
        for (Mapping m : this.origMappings) {
            this.cpyMappings.add(new Mapping(this.cpySrcTrees.get(((Tree)m.getFirst()).getId()), (Tree)m.getSecond()));
        }
        this.generate();
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void generate() {
        Tree vsrc = new Tree(-1, "");
        Tree vdst = new Tree(-1, "");
        vsrc.setId(-1);
        vdst.setId(-1);
        vsrc.addChild(this.cpySrc);
        vdst.addChild(this.dst);
        this.actions = new ArrayList<Action>();
        this.mappings = new MappingStore(this.cpyMappings);
        this.dstInOrder = new HashSet<Tree>();
        this.srcInOrder = new HashSet<Tree>();
        this.lastId = this.cpySrc.getSize() + 1;
        this.mappings.link(vsrc, vdst);
        List<Tree> bfsDst = TreeUtils.bfsOrder(this.dst);
        for (Tree x : bfsDst) {
            Tree w = null;
            Tree y = x.getParent();
            Tree z = this.mappings.getSrc(y);
            if (!this.mappings.hasDst(x)) {
                int k = this.findPos(x);
                int wId = this.newId();
                w = new Tree(x.getType(), x.getLabel());
                w.setTypeLabel(x.getTypeLabel());
                w.setPos(x.getPos());
                w.setLength(x.getLength());
                w.setId(wId);
                this.actions.add(new Insert(x, this.origSrcTrees.get(z.getId()), k));
                this.origSrcTrees.put(w.getId(), x);
                this.mappings.link(w, x);
                z.getChildren().add(k, w);
                w.setParent(z);
                this.srcInOrder.add(w);
                this.dstInOrder.add(x);
            } else {
                w = this.mappings.getSrc(x);
                if (!x.equals(this.dst)) {
                    Tree v = w.getParent();
                    if (!w.getLabel().equals(x.getLabel())) {
                        this.actions.add(new Update(this.origSrcTrees.get(w.getId()), x.getLabel()));
                        w.setLabel(x.getLabel());
                    }
                    if (!this.mappings.getSrc(y).equals(v)) {
                        int k = this.findPos(x);
                        this.actions.add(new Move(this.origSrcTrees.get(w.getId()), this.origSrcTrees.get(z.getId()), k));
                        w.getParent().getChildren().remove(w);
                        z.getChildren().add(k, w);
                        w.setParent(z);
                    }
                }
            }
            this.alignChildren(w, x);
        }
        List<Tree> poSrc = TreeUtils.postOrder(this.cpySrc);
        for (Tree w : poSrc) {
            if (this.mappings.hasSrc(w)) continue;
            this.actions.add(new Delete(this.origSrcTrees.get(w.getId())));
            w.getParent().getChildren().remove(w);
        }
    }

    private void alignChildren(Tree w, Tree x) {
        this.srcInOrder.removeAll(w.getChildren());
        this.dstInOrder.removeAll(x.getChildren());
        ArrayList<Tree> s1 = new ArrayList<Tree>();
        for (Tree c : w.getChildren()) {
            if (!this.mappings.hasSrc(c) || !x.getChildren().contains(this.mappings.getDst(c))) continue;
            s1.add(c);
        }
        ArrayList<Tree> s2 = new ArrayList<Tree>();
        for (Tree c : x.getChildren()) {
            if (!this.mappings.hasDst(c) || !w.getChildren().contains(this.mappings.getSrc(c))) continue;
            s2.add(c);
        }
        List<Mapping> lcs = this.lcs(s1, s2);
        for (Mapping m : lcs) {
            this.srcInOrder.add((Tree)m.getFirst());
            this.dstInOrder.add((Tree)m.getSecond());
        }
        for (Tree a : s1) {
            for (Tree b : s2) {
                Mapping m = new Mapping(a, b);
                if (!this.cpyMappings.contains(m) || lcs.contains(m)) continue;
                int k = this.findPos(b);
                this.actions.add(new Move(this.origSrcTrees.get(a.getId()), this.origSrcTrees.get(w.getId()), k));
                a.getParent().getChildren().remove(a);
                w.getChildren().add(k, a);
                a.setParent(w);
                this.srcInOrder.add(a);
                this.dstInOrder.add(b);
            }
        }
    }

    private int findPos(Tree x) {
        Tree y = x.getParent();
        List<Tree> siblings = y.getChildren();
        for (Tree c : siblings) {
            if (!this.dstInOrder.contains(c)) continue;
            if (!c.equals(x)) break;
            return 0;
        }
        int xpos = siblings.indexOf(x);
        Tree v = null;
        for (int i = 0; i < xpos; ++i) {
            Tree c = siblings.get(i);
            if (!this.dstInOrder.contains(c)) continue;
            v = c;
        }
        if (v == null) {
            return 0;
        }
        Tree u = this.mappings.getSrc(v);
        siblings = u.getParent().getChildren();
        int upos = siblings.indexOf(u);
        int r = 0;
        for (int i = 0; i <= upos; ++i) {
            if (!this.srcInOrder.contains(siblings.get(i))) continue;
            ++r;
        }
        return r;
    }

    private int newId() {
        return ++this.lastId;
    }

    private List<Mapping> lcs(List<Tree> x, List<Tree> y) {
        int j;
        int i;
        int m = x.size();
        int n = y.size();
        ArrayList<Mapping> lcs = new ArrayList<Mapping>();
        int[][] opt = new int[m + 1][n + 1];
        for (i = m - 1; i >= 0; --i) {
            for (j = n - 1; j >= 0; --j) {
                opt[i][j] = this.mappings.getSrc(y.get(j)).equals(x.get(i)) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < m && j < n) {
            if (this.mappings.getSrc(y.get(j)).equals(x.get(i))) {
                lcs.add(new Mapping(x.get(i), y.get(j)));
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
        return lcs;
    }
}

