/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.actions;

import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import java.util.HashSet;
import java.util.Set;

public class ProcessMappings {
    private Set<Mapping> rawMappings;
    private MappingStore mappings;
    private Tree src;
    private Tree dst;
    private Set<Tree> srcDelRoots;
    private Set<Tree> srcUpd;
    private Set<Tree> srcMv;
    private Set<Tree> srcMvRoots;
    private Set<Tree> srcMis;
    private Set<Tree> dstAddRoots;
    private Set<Tree> dstUpd;
    private Set<Tree> dstMv;
    private Set<Tree> dstMvRoots;
    private Set<Tree> dstMis;

    public ProcessMappings(Tree src, Tree dst, Set<Mapping> mappings) {
        this.src = src;
        this.dst = dst;
        this.rawMappings = mappings;
        this.mappings = new MappingStore(mappings);
        this.detectAddAndDel();
        this.detectUpd();
        this.detectMvTrees();
        this.detectMvRoots();
        this.detectMisRoots();
    }

    private void detectMvTrees() {
        this.srcMv = new HashSet<Tree>();
        this.dstMv = new HashSet<Tree>();
        for (Tree t1 : this.src.getDescendants()) {
            Tree p2;
            if (!this.mappings.hasSrc(t1)) continue;
            Tree t2 = this.mappings.getDst(t1);
            Tree p1 = t1.getParent();
            if (this.mappings.has(p1, p2 = t2.getParent())) continue;
            this.srcMv.add(t1);
            this.dstMv.add(t2);
        }
    }

    private void detectMvRoots() {
        this.srcMvRoots = new HashSet<Tree>();
        this.dstMvRoots = new HashSet<Tree>();
        for (Tree t1 : this.srcMv) {
            Tree p2;
            Tree t2 = this.mappings.getDst(t1);
            Tree p1 = this.mappings.firstMappedSrcParent(t1);
            if (this.mappings.has(p1, p2 = this.mappings.firstMappedDstParent(t2))) continue;
            this.srcMvRoots.add(t1);
            this.dstMvRoots.add(t2);
        }
    }

    private void detectMisRoots() {
        this.srcMis = new HashSet<Tree>();
        this.dstMis = new HashSet<Tree>();
        for (Tree t1 : this.srcMv) {
            int pos2;
            int pos1;
            Tree p2;
            Tree t2 = this.mappings.getDst(t1);
            Tree p1 = this.mappings.firstMappedSrcParent(t1);
            if (!this.mappings.has(p1, p2 = this.mappings.firstMappedDstParent(t2)) || !(p1 != null & p2 != null) || (pos1 = p1.getChildPosition(t1)) == (pos2 = p2.getChildPosition(t2))) continue;
            this.srcMis.add(t1);
            this.dstMis.add(t2);
        }
    }

    private void detectAddAndDel() {
        this.srcDelRoots = new HashSet<Tree>();
        this.dstAddRoots = new HashSet<Tree>();
        for (Tree t : this.src.getDescendants()) {
            if (this.mappings.hasSrc(t) || !this.mappings.hasSrc(t.getParent())) continue;
            this.srcDelRoots.add(t);
        }
        for (Tree t : this.dst.getDescendants()) {
            if (this.mappings.hasDst(t) || !this.mappings.hasDst(t.getParent())) continue;
            this.dstAddRoots.add(t);
        }
    }

    private void detectUpd() {
        this.srcUpd = new HashSet<Tree>();
        this.dstUpd = new HashSet<Tree>();
        for (Mapping m : this.rawMappings) {
            if (((Tree)m.getFirst()).getLabel().equals(((Tree)m.getSecond()).getLabel()) || "".equals(((Tree)m.getFirst()).getLabel())) continue;
            this.srcUpd.add((Tree)m.getFirst());
            this.dstUpd.add((Tree)m.getSecond());
        }
    }

    public Set<Tree> getSrcDelRoots() {
        return this.srcDelRoots;
    }

    public void setSrcDelRoots(Set<Tree> srcDelRoots) {
        this.srcDelRoots = srcDelRoots;
    }

    public Set<Tree> getSrcUpd() {
        return this.srcUpd;
    }

    public void setSrcUpd(Set<Tree> srcUpd) {
        this.srcUpd = srcUpd;
    }

    public Set<Tree> getSrcMvRoots() {
        return this.srcMvRoots;
    }

    public void setSrcMvRoots(Set<Tree> srcMvRoots) {
        this.srcMvRoots = srcMvRoots;
    }

    public Set<Tree> getSrcMis() {
        return this.srcMis;
    }

    public void setSrcMis(Set<Tree> srcMis) {
        this.srcMis = srcMis;
    }

    public Set<Tree> getDstAddRoots() {
        return this.dstAddRoots;
    }

    public void setDstAddRoots(Set<Tree> dstAddRoots) {
        this.dstAddRoots = dstAddRoots;
    }

    public Set<Tree> getDstUpd() {
        return this.dstUpd;
    }

    public void setDstUpd(Set<Tree> dstUpd) {
        this.dstUpd = dstUpd;
    }

    public Set<Tree> getDstMvRoots() {
        return this.dstMvRoots;
    }

    public void setDstMvRoots(Set<Tree> dstMvRoots) {
        this.dstMvRoots = dstMvRoots;
    }

    public Set<Tree> getDstMis() {
        return this.dstMis;
    }

    public void setDstMis(Set<Tree> dstMis) {
        this.dstMis = dstMis;
    }
}

