/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.composite;

import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Matcher {
    public static final Logger LOGGER = Logger.getLogger("fr.labri.gumtree.matchers");
    protected Tree src;
    protected Tree dst;
    protected MappingStore mappings;

    public Matcher(Tree src, Tree dst, MappingStore mappings) {
        this.src = src;
        this.dst = dst;
        this.mappings = mappings;
    }

    public Matcher(Tree src, Tree dst) {
        this(src, dst, new MappingStore());
    }

    public abstract void match();

    public MappingStore getMappings() {
        return this.mappings;
    }

    public Set<Mapping> getMappingSet() {
        return this.mappings.getMappings();
    }

    public Tree getSrc() {
        return this.src;
    }

    public void setSrc(Tree src) {
        this.src = src;
    }

    public Tree getDst() {
        return this.dst;
    }

    public void setDst(Tree dst) {
        this.dst = dst;
    }

    protected void addMapping(Tree src, Tree dst) {
        src.setMatched(true);
        dst.setMatched(true);
        this.mappings.link(src, dst);
    }

    protected void addFullMapping(Tree src, Tree dst) {
        List<Tree> csrcs = src.getTrees();
        List<Tree> cdsts = dst.getTrees();
        for (int i = 0; i < csrcs.size(); ++i) {
            Tree csrc = csrcs.get(i);
            Tree cdst = cdsts.get(i);
            this.addMapping(csrc, cdst);
        }
    }

    protected double chawatheSimilarity(Tree src, Tree dst) {
        int max = Math.max(src.getDescendants().size(), dst.getDescendants().size());
        return (double)this.numberOfCommonDescendants(src, dst) / (double)max;
    }

    protected double diceSimilarity(Tree src, Tree dst) {
        double c = this.numberOfCommonDescendants(src, dst);
        return 2.0 * c / ((double)src.getDescendants().size() + (double)dst.getDescendants().size());
    }

    protected double jaccardSimilarity(Tree src, Tree dst) {
        double num = this.numberOfCommonDescendants(src, dst);
        double den = (double)src.getDescendants().size() + (double)dst.getDescendants().size() - num;
        return num / den;
    }

    protected int numberOfCommonDescendants(Tree src, Tree dst) {
        HashSet<Tree> dstDescs = new HashSet<Tree>(dst.getDescendants());
        int common = 0;
        for (Tree t : src.getDescendants()) {
            Tree m = this.mappings.getDst(t);
            if (m == null || !dstDescs.contains(m)) continue;
            ++common;
        }
        return common;
    }

    protected void clean() {
        for (Tree t : this.src.getTrees()) {
            if (this.mappings.hasSrc(t)) continue;
            t.setMatched(false);
        }
        for (Tree t : this.dst.getTrees()) {
            if (this.mappings.hasDst(t)) continue;
            t.setMatched(false);
        }
    }
}

