/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.algo.PriorityTreeList;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.MultiMappingStore;
import fr.labri.gumtree.tree.Tree;
import java.util.List;

public abstract class AbstractSubtreeMatcher
extends Matcher {
    protected int minHeight = 2;
    protected int maxSize;

    public AbstractSubtreeMatcher(Tree src, Tree dst) {
        this(src, dst, new MappingStore());
    }

    public AbstractSubtreeMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.maxSize = Math.max(src.getSize(), dst.getSize());
    }

    @Override
    public void match() {
        this.filterRawMappings(this.getRawMappings());
    }

    protected MultiMappingStore getRawMappings() {
        MultiMappingStore rawMappings = new MultiMappingStore();
        PriorityTreeList srcs = new PriorityTreeList(this.src, this.minHeight);
        PriorityTreeList dsts = new PriorityTreeList(this.dst, this.minHeight);
        while (srcs.peekHeight() != -1 && dsts.peekHeight() != -1) {
            int i;
            while (srcs.peekHeight() != dsts.peekHeight()) {
                this.popLarger(srcs, dsts);
            }
            List<Tree> hSrcs = srcs.pop();
            List<Tree> hDsts = dsts.pop();
            boolean[] srcMarks = new boolean[hSrcs.size()];
            boolean[] dstMarks = new boolean[hDsts.size()];
            for (i = 0; i < hSrcs.size(); ++i) {
                for (int j = 0; j < hDsts.size(); ++j) {
                    Tree dst;
                    Tree src = hSrcs.get(i);
                    if (!src.isClone(dst = hDsts.get(j))) continue;
                    rawMappings.link(src, dst);
                    srcMarks[i] = true;
                    dstMarks[j] = true;
                }
            }
            for (i = 0; i < srcMarks.length; ++i) {
                if (srcMarks[i]) continue;
                srcs.open(hSrcs.get(i));
            }
            for (i = 0; i < dstMarks.length; ++i) {
                if (dstMarks[i]) continue;
                dsts.open(hDsts.get(i));
            }
            srcs.updateHeight();
            dsts.updateHeight();
        }
        return rawMappings;
    }

    protected abstract void filterRawMappings(MultiMappingStore var1);

    protected double subtreeSim(Tree src, Tree dst) {
        double jaccard = this.jaccardSimilarity(src.getParent(), dst.getParent());
        int posSrc = src.isRoot() ? 0 : src.getParent().getChildPosition(src);
        int posDst = dst.isRoot() ? 0 : dst.getParent().getChildPosition(dst);
        int maxSrcPos = src.isRoot() ? 1 : src.getParent().getChildren().size();
        int maxDstPos = dst.isRoot() ? 1 : dst.getParent().getChildren().size();
        int maxPosDiff = Math.max(maxSrcPos, maxDstPos);
        double pos = 1.0 - (double)Math.abs(posSrc - posDst) / (double)maxPosDiff;
        double po = 1.0 - (double)Math.abs(src.getId() - dst.getId()) / (double)this.maxSize;
        return 100.0 * jaccard + 10.0 * pos + po;
    }

    private void popLarger(PriorityTreeList srcs, PriorityTreeList dsts) {
        if (srcs.peekHeight() > dsts.peekHeight()) {
            srcs.open();
        } else {
            dsts.open();
        }
    }
}

