/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class ChangeDistillerLeavesMatcher
extends Matcher {
    public static final double LABEL_SIM_THRESHOLD = 0.5;
    private static final QGramsDistance QGRAM = new QGramsDistance();

    public ChangeDistillerLeavesMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> srcLeaves = this.retainLeaves(TreeUtils.postOrder(this.src));
        List<Tree> dstLeaves = this.retainLeaves(TreeUtils.postOrder(this.dst));
        LinkedList<Mapping> leafMappings = new LinkedList<Mapping>();
        for (Tree srcLeaf : srcLeaves) {
            for (Tree dstLeaf : dstLeaves) {
                double sim;
                if (!srcLeaf.isMatchable(dstLeaf) || !((sim = (double)QGRAM.getSimilarity(srcLeaf.getLabel(), dstLeaf.getLabel())) > 0.5)) continue;
                leafMappings.add(new Mapping(srcLeaf, dstLeaf));
            }
        }
        HashSet srcIgnored = new HashSet();
        HashSet dstIgnored = new HashSet();
        Collections.sort(leafMappings, new LeafMappingComparator());
        while (leafMappings.size() > 0) {
            Mapping best = (Mapping)leafMappings.remove(0);
            if (srcIgnored.contains(best.getFirst()) || dstIgnored.contains(best.getSecond())) continue;
            this.addMapping((Tree)best.getFirst(), (Tree)best.getSecond());
            srcIgnored.add(best.getFirst());
            dstIgnored.add(best.getSecond());
        }
    }

    public List<Tree> retainLeaves(List<Tree> trees) {
        Iterator<Tree> tIt = trees.iterator();
        while (tIt.hasNext()) {
            Tree t = tIt.next();
            if (t.isLeaf()) continue;
            tIt.remove();
        }
        return trees;
    }

    private class LeafMappingComparator
    implements Comparator<Mapping> {
        private LeafMappingComparator() {
        }

        @Override
        public int compare(Mapping m1, Mapping m2) {
            return Double.compare(this.sim(m1), this.sim(m2));
        }

        public double sim(Mapping m) {
            return QGRAM.getSimilarity(((Tree)m.getFirst()).getLabel(), ((Tree)m.getSecond()).getLabel());
        }
    }
}

