/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.optimal.rted.RtedMatcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeMap;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CompleteBottomUpMatcher
extends Matcher {
    private static final double SIM_THRESHOLD = 0.5;
    private static final int SIZE_THESHOLD = 100;
    private TreeMap srcIds;
    private TreeMap dstIds;

    public CompleteBottomUpMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        this.srcIds = new TreeMap(this.src);
        this.dstIds = new TreeMap(this.dst);
        this.match(TreeUtils.postOrder(this.src), TreeUtils.postOrder(this.dst));
        this.clean();
    }

    private void match(List<Tree> srcs, List<Tree> dsts) {
        for (Tree src : srcs) {
            if (src.isRoot()) {
                this.addMapping(src, this.dst);
                this.lastChanceMatch(src, this.dst);
                break;
            }
            if (src.isMatched() || src.isLeaf()) continue;
            List<Tree> candidates = this.getDstCandidates(src);
            Tree best = null;
            double max = -1.0;
            for (Tree cand : candidates) {
                double sim = this.jaccardSimilarity(src, cand);
                if (!(sim > max) || !(sim >= 0.5)) continue;
                max = sim;
                best = cand;
            }
            if (best == null) continue;
            this.lastChanceMatch(src, best);
            this.addMapping(src, best);
        }
    }

    private List<Tree> getDstCandidates(Tree src) {
        ArrayList<Tree> seeds = new ArrayList<Tree>();
        for (Tree c : src.getDescendants()) {
            Tree m = this.mappings.getDst(c);
            if (m == null) continue;
            seeds.add(m);
        }
        ArrayList<Tree> candidates = new ArrayList<Tree>();
        HashSet<Tree> visited = new HashSet<Tree>();
        for (Tree seed : seeds) {
            Tree parent;
            while (seed.getParent() != null && !visited.contains(parent = seed.getParent())) {
                visited.add(parent);
                if (parent.getType() == src.getType() && !parent.isMatched() && !parent.isRoot()) {
                    candidates.add(parent);
                }
                seed = parent;
            }
        }
        return candidates;
    }

    private void lastChanceMatch(Tree src, Tree dst) {
        Tree cSrc = src.deepCopy();
        Tree cDst = dst.deepCopy();
        TreeUtils.removeMapped(cSrc);
        TreeUtils.removeMapped(cDst);
        if (cSrc.getSize() < 100 || cDst.getSize() < 100) {
            RtedMatcher m = new RtedMatcher(cSrc, cDst);
            for (Mapping candidate : m.getMappings()) {
                Tree left = this.srcIds.getTree(((Tree)candidate.getFirst()).getId());
                Tree right = this.dstIds.getTree(((Tree)candidate.getSecond()).getId());
                if (left.getId() == src.getId() || right.getId() == dst.getId() || !left.isMatchable(right)) continue;
                this.addMapping(left, right);
            }
        }
        for (Tree t : src.getTrees()) {
            t.setMatched(true);
        }
        for (Tree t : dst.getTrees()) {
            t.setMatched(true);
        }
    }
}

