/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.optimal.rted.RtedMatcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GreedyBottomUpMatcher
extends Matcher {
    private static final double SIM_THRESHOLD = 0.5;
    private static final int SIZE_THESHOLD = 200;
    private Map<Integer, Tree> srcIds = new HashMap<Integer, Tree>();
    private Map<Integer, Tree> dstIds = new HashMap<Integer, Tree>();

    public GreedyBottomUpMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> srcs = TreeUtils.postOrder(this.src);
        List<Tree> dsts = TreeUtils.postOrder(this.dst);
        for (Tree t : srcs) {
            this.srcIds.put(t.getId(), t);
        }
        for (Tree t : dsts) {
            this.dstIds.put(t.getId(), t);
        }
        this.match(TreeUtils.removeMapped(srcs), TreeUtils.removeMapped(dsts));
        this.clean();
    }

    private void match(List<Tree> poSrc, List<Tree> poDst) {
        block0: for (Tree src : poSrc) {
            for (Tree dst : poDst) {
                double sim;
                if (!src.isMatchable(dst) || src.isLeaf() || dst.isLeaf() || !((sim = this.jaccardSimilarity(src, dst)) >= 0.5) && (!src.isRoot() || !dst.isRoot())) continue;
                if (!src.areDescendantsMatched() && !dst.areDescendantsMatched()) {
                    this.lastChanceMatch(src, dst);
                }
                this.addMapping(src, dst);
                continue block0;
            }
        }
    }

    private void lastChanceMatch(Tree src, Tree dst) {
        Tree cSrc = TreeUtils.removeMapped(src.deepCopy());
        Tree cDst = TreeUtils.removeMapped(dst.deepCopy());
        if (cSrc.getSize() < 200 && cDst.getSize() < 200) {
            RtedMatcher m = new RtedMatcher(cSrc, cDst);
            for (Mapping candidate : m.getMappings()) {
                Tree left = this.srcIds.get(((Tree)candidate.getFirst()).getId());
                Tree right = this.dstIds.get(((Tree)candidate.getSecond()).getId());
                if (left.getId() == src.getId() || right.getId() == dst.getId() || left.isMatched() && right.isMatched() || !left.isMatchable(right) || left.getParent().getType() != right.getParent().getType()) continue;
                this.addMapping(left, right);
            }
            for (Tree t : cSrc.getTrees()) {
                this.srcIds.get(t.getId()).setMatched(true);
            }
            for (Tree t : cDst.getTrees()) {
                this.dstIds.get(t.getId()).setMatched(true);
            }
        }
    }
}

