/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.algo.HungarianAlgorithm;
import fr.labri.gumtree.matchers.composite.Matcher;
import fr.labri.gumtree.matchers.optimal.rted.RtedMatcher;
import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.MultiMappingStore;
import fr.labri.gumtree.tree.Tree;
import fr.labri.gumtree.tree.TreeMap;
import fr.labri.gumtree.tree.TreeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class HungarianBottomUpMatcher
extends Matcher {
    private static final double MIN_SIM = 0.1;
    private static final int SIZE_THESHOLD = 100;

    public HungarianBottomUpMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
        this.match();
    }

    @Override
    public void match() {
        List<Tree> aDsts;
        MultiMappingStore store = new MultiMappingStore();
        for (Tree src : TreeUtils.postOrder(this.src)) {
            if (src.isRoot() || src.isMatched() || src.isLeaf()) continue;
            List<Tree> dsts = this.getDstCandidates(src);
            for (Tree dst : dsts) {
                if (!(this.jaccardSimilarity(src, dst) >= 0.1)) continue;
                store.link(src, dst);
            }
        }
        ArrayList<MultiMappingStore> ambiguousList = new ArrayList<MultiMappingStore>();
        HashSet<Tree> ignored = new HashSet<Tree>();
        for (Tree src : store.getSrcs()) {
            if (store.isSrcUnique(src)) {
                Tree dst;
                System.out.println("unique");
                dst = store.getDst(src).get(0);
                this.lastChanceMatch(src, src);
                this.addMapping(src, dst);
                continue;
            }
            if (ignored.contains(src)) continue;
            System.out.println("ambiguous");
            MultiMappingStore ambiguous = new MultiMappingStore();
            aDsts = store.getDst(src);
            List<Tree> aSrcs = store.getSrc(store.getDst(src).get(0));
            for (Tree asrc : aSrcs) {
                for (Tree adst : aDsts) {
                    ambiguous.link(asrc, adst);
                }
            }
            ambiguousList.add(ambiguous);
            ignored.addAll(aSrcs);
        }
        Collections.sort(ambiguousList, new MultiMappingComparator());
        for (MultiMappingStore ambiguous : ambiguousList) {
            ArrayList<Tree> aSrcs = new ArrayList<Tree>(ambiguous.getSrcs());
            aDsts = new ArrayList<Tree>(ambiguous.getDsts());
            double[][] matrix = new double[aSrcs.size()][aDsts.size()];
            for (int i = 0; i < aSrcs.size(); ++i) {
                for (int j = 0; j < aDsts.size(); ++j) {
                    matrix[i][j] = 1.0 - this.jaccardSimilarity((Tree)aSrcs.get(i), aDsts.get(j));
                }
            }
            HungarianAlgorithm hgAlg = new HungarianAlgorithm(matrix);
            int[] solutions = hgAlg.execute();
            for (int i = 0; i < solutions.length; ++i) {
                int dstIdx = solutions[i];
                if (dstIdx == -1) continue;
                this.lastChanceMatch((Tree)aSrcs.get(i), aDsts.get(dstIdx));
                this.addMapping((Tree)aSrcs.get(i), aDsts.get(dstIdx));
            }
        }
        this.lastChanceMatch(this.src, this.dst);
        this.addMapping(this.src, this.dst);
        this.clean();
    }

    private List<Tree> getDstCandidates(Tree src) {
        ArrayList<Tree> seeds = new ArrayList<Tree>();
        for (Tree c : src.getDescendants()) {
            Tree m = this.mappings.getDst(c);
            if (m == null) continue;
            seeds.add(m);
        }
        ArrayList<Tree> candidates = new ArrayList<Tree>();
        HashSet<Tree> visited = new HashSet<Tree>();
        for (Tree seed : seeds) {
            Tree parent;
            while (seed.getParent() != null && !visited.contains(parent = seed.getParent())) {
                visited.add(parent);
                if (parent.getType() == src.getType() && !parent.isMatched() && !parent.isRoot()) {
                    candidates.add(parent);
                }
                seed = parent;
            }
        }
        return candidates;
    }

    private void lastChanceMatch(Tree src, Tree dst) {
        Tree cSrc = src.deepCopy();
        Tree cDst = dst.deepCopy();
        TreeUtils.removeMapped(cSrc);
        TreeUtils.removeMapped(cDst);
        if (cSrc.getSize() < 100 || cDst.getSize() < 100) {
            TreeMap srcIds = new TreeMap(src);
            TreeMap dstIds = new TreeMap(dst);
            RtedMatcher m = new RtedMatcher(cSrc, cDst);
            for (Mapping candidate : m.getMappings()) {
                Tree left = srcIds.getTree(((Tree)candidate.getFirst()).getId());
                Tree right = dstIds.getTree(((Tree)candidate.getSecond()).getId());
                if (left.getId() == src.getId() || right.getId() == dst.getId() || !left.isMatchable(right)) continue;
                this.addMapping(left, right);
            }
        }
        for (Tree t : src.getTrees()) {
            t.setMatched(true);
        }
        for (Tree t : dst.getTrees()) {
            t.setMatched(true);
        }
    }

    private class MultiMappingComparator
    implements Comparator<MultiMappingStore> {
        private MultiMappingComparator() {
        }

        @Override
        public int compare(MultiMappingStore m1, MultiMappingStore m2) {
            return Integer.compare(this.impact(m2), this.impact(m1));
        }

        public int impact(MultiMappingStore m) {
            int impact = 0;
            for (Tree t : m.getSrcs()) {
                impact += t.getParents().size();
            }
            for (Tree t : m.getDsts()) {
                impact += t.getParents().size();
            }
            return impact;
        }
    }
}

