/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.matchers.heuristic;

import fr.labri.gumtree.algo.HungarianAlgorithm;
import fr.labri.gumtree.matchers.heuristic.AbstractSubtreeMatcher;
import fr.labri.gumtree.tree.MappingStore;
import fr.labri.gumtree.tree.MultiMappingStore;
import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class HungarianSubtreeMatcher
extends AbstractSubtreeMatcher {
    public HungarianSubtreeMatcher(Tree src, Tree dst) {
        super(src, dst);
    }

    public HungarianSubtreeMatcher(Tree src, Tree dst, MappingStore mappings) {
        super(src, dst, mappings);
    }

    @Override
    protected void filterRawMappings(MultiMappingStore rawMappings) {
        List<Tree> aDsts;
        ArrayList<MultiMappingStore> stores = new ArrayList<MultiMappingStore>();
        HashSet<Tree> ignored = new HashSet<Tree>();
        for (Tree src : rawMappings.getSrcs()) {
            if (rawMappings.isSrcUnique(src)) {
                this.addFullMapping(src, rawMappings.getDst(src).get(0));
                continue;
            }
            if (ignored.contains(src)) continue;
            MultiMappingStore ambiguous = new MultiMappingStore();
            aDsts = rawMappings.getDst(src);
            List<Tree> aSrcs = rawMappings.getSrc(rawMappings.getDst(src).get(0));
            for (Tree aSrc : aSrcs) {
                for (Tree aDst : aDsts) {
                    ambiguous.link(aSrc, aDst);
                }
            }
            stores.add(ambiguous);
            ignored.addAll(aSrcs);
        }
        Collections.sort(stores, new MultiMappingComparator());
        for (MultiMappingStore ambiguous : stores) {
            ArrayList<Tree> aSrcs = new ArrayList<Tree>(ambiguous.getSrcs());
            aDsts = new ArrayList<Tree>(ambiguous.getDsts());
            double[][] matrix = new double[aSrcs.size()][aDsts.size()];
            for (int i = 0; i < aSrcs.size(); ++i) {
                for (int j = 0; j < aDsts.size(); ++j) {
                    matrix[i][j] = this.subtreeCost((Tree)aSrcs.get(i), aDsts.get(j));
                }
            }
            HungarianAlgorithm hgAlg = new HungarianAlgorithm(matrix);
            int[] solutions = hgAlg.execute();
            for (int i = 0; i < solutions.length; ++i) {
                int dstIdx = solutions[i];
                if (dstIdx == -1) continue;
                this.addFullMapping((Tree)aSrcs.get(i), aDsts.get(dstIdx));
            }
        }
    }

    protected double subtreeCost(Tree src, Tree dst) {
        return 111.0 - this.subtreeSim(src, dst);
    }

    private class MultiMappingComparator
    implements Comparator<MultiMappingStore> {
        private MultiMappingComparator() {
        }

        @Override
        public int compare(MultiMappingStore m1, MultiMappingStore m2) {
            return Integer.compare(this.impact(m1), this.impact(m2));
        }

        public int impact(MultiMappingStore m) {
            int impact = 0;
            for (Tree t : m.getSrcs()) {
                impact += t.getDepth();
            }
            for (Tree t : m.getDsts()) {
                impact += t.getDepth();
            }
            return impact;
        }
    }
}

