/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.tree;

import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MappingStore
implements Iterable<Mapping> {
    private Map<Tree, Tree> srcs;
    private Map<Tree, Tree> dsts;

    public MappingStore(Set<Mapping> mappings) {
        this.srcs = new HashMap<Tree, Tree>();
        this.dsts = new HashMap<Tree, Tree>();
        for (Mapping m : mappings) {
            this.link((Tree)m.getFirst(), (Tree)m.getSecond());
        }
    }

    public MappingStore() {
        this.srcs = new HashMap<Tree, Tree>();
        this.dsts = new HashMap<Tree, Tree>();
    }

    public MappingStore(int size) {
        this.srcs = new HashMap<Tree, Tree>(size);
        this.dsts = new HashMap<Tree, Tree>(size);
    }

    public Set<Mapping> getMappings() {
        HashSet<Mapping> mappings = new HashSet<Mapping>();
        for (Tree src : this.srcs.keySet()) {
            mappings.add(new Mapping(src, this.srcs.get(src)));
        }
        return mappings;
    }

    public void link(Tree src, Tree dst) {
        this.srcs.put(src, dst);
        this.dsts.put(dst, src);
    }

    public void unlink(Tree src, Tree dst) {
        this.srcs.remove(src);
        this.dsts.remove(dst);
    }

    public Tree firstMappedSrcParent(Tree src) {
        Tree p = src.getParent();
        if (p == null) {
            return null;
        }
        while (!this.hasSrc(p)) {
            if ((p = p.getParent()) != null) continue;
            return p;
        }
        return p;
    }

    public Tree firstMappedDstParent(Tree dst) {
        Tree p = dst.getParent();
        if (p == null) {
            return null;
        }
        while (!this.hasDst(p)) {
            if ((p = p.getParent()) != null) continue;
            return p;
        }
        return p;
    }

    public Tree getDst(Tree src) {
        return this.srcs.get(src);
    }

    public Tree getSrc(Tree dst) {
        return this.dsts.get(dst);
    }

    public boolean hasSrc(Tree src) {
        return this.srcs.containsKey(src);
    }

    public boolean hasDst(Tree dst) {
        return this.dsts.containsKey(dst);
    }

    public boolean has(Tree src, Tree dst) {
        return this.srcs.get(src) == dst;
    }

    @Override
    public Iterator<Mapping> iterator() {
        return this.getMappings().iterator();
    }
}

