/*
 * Decompiled with CFR 0.152.
 */
package fr.labri.gumtree.tree;

import fr.labri.gumtree.tree.Mapping;
import fr.labri.gumtree.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiMappingStore
implements Iterable<Mapping> {
    private Map<Tree, List<Tree>> srcs = new HashMap<Tree, List<Tree>>();
    private Map<Tree, List<Tree>> dsts = new HashMap<Tree, List<Tree>>();

    public MultiMappingStore(Set<Mapping> mappings) {
        this();
        for (Mapping m : mappings) {
            this.link((Tree)m.getFirst(), (Tree)m.getSecond());
        }
    }

    public MultiMappingStore() {
    }

    public Set<Mapping> getMappings() {
        HashSet<Mapping> mappings = new HashSet<Mapping>();
        for (Tree src : this.srcs.keySet()) {
            for (Tree dst : this.srcs.get(src)) {
                mappings.add(new Mapping(src, dst));
            }
        }
        return mappings;
    }

    public void link(Tree src, Tree dst) {
        if (!this.srcs.containsKey(src)) {
            this.srcs.put(src, new ArrayList());
        }
        this.srcs.get(src).add(dst);
        if (!this.dsts.containsKey(dst)) {
            this.dsts.put(dst, new ArrayList());
        }
        this.dsts.get(dst).add(src);
    }

    public void unlink(Tree src, Tree dst) {
        this.srcs.get(src).remove(dst);
        this.dsts.get(dst).remove(src);
    }

    public List<Tree> getDst(Tree src) {
        return this.srcs.get(src);
    }

    public Set<Tree> getSrcs() {
        return this.srcs.keySet();
    }

    public Set<Tree> getDsts() {
        return this.dsts.keySet();
    }

    public List<Tree> getSrc(Tree dst) {
        return this.dsts.get(dst);
    }

    public boolean hasSrc(Tree src) {
        return this.srcs.containsKey(src);
    }

    public boolean hasDst(Tree dst) {
        return this.dsts.containsKey(dst);
    }

    public boolean has(Tree src, Tree dst) {
        return this.srcs.get(src).contains(dst);
    }

    public boolean isSrcUnique(Tree src) {
        return this.srcs.get(src).size() == 1 && this.dsts.get(this.srcs.get(src).get(0)).size() == 1;
    }

    @Override
    public Iterator<Mapping> iterator() {
        return this.getMappings().iterator();
    }
}

